/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db;

import java.io.IOException;
import java.util.Date;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclEntryTableImpl;
import jet.server.db.security2.AclTableImpl;
import jet.server.db.security2.AclsWithResourceRecord;
import jet.server.db.security2.AclsWithResourceTable;
import jet.server.db.security2.AclsWithResourceTableImpl;
import jet.server.db.security2.ExtendAclEntryRecord;
import jet.server.db.security2.ExtendAclEntryTable;
import jet.server.db.security2.ExtendAclEntryTableImpl;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.GUProfileTableImpl;
import jet.server.db.security2.GroupProfileTable;
import jet.server.db.security2.GroupProfileTableImpl;
import jet.server.db.security2.GroupTable;
import jet.server.db.security2.GroupTableImpl;
import jet.server.db.security2.OrganizationTable;
import jet.server.db.security2.RGProfileTable;
import jet.server.db.security2.RGProfileTableImpl;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleProfileTableImpl;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.RoleTableImpl;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserProfileTableImpl;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.db.security2.UserTableImpl;
import jet.server.jrc.JRDataService;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.util.ServerUtil;
import jet.util.Base64;

public class SecurityDBBasic {
    public static final String NULL_PASSWORD = "NullPassword.jinfonet";
    private OrganizationTable SEDU = null;
    private UserTable addRecord = null;
    private UserProfileTable createAclName = null;
    private RoleTable currentTimeMillis = null;
    private AclsWithResourceTable decode;
    private AclEntryTable encode;
    private RoleProfileTable equals = null;
    private GroupTable getAclEntryTable = null;
    private GroupProfileTable getAclID = null;
    private RGProfileTable getAclsWithResourceTable = null;
    private GUProfileTable getAdminUser = null;
    private ExtendAclEntryTable getAdminUserNameAndPS = null;
    private String[] getBytes = new String[2];
    public int defaultAclID;
    private String getExtendAclEntryRecord;

    public int getDefaultAclID() {
        return this.defaultAclID;
    }

    public SecurityDBBasic(JRDataService jRDataService, String string) {
        this.getExtendAclEntryRecord = string;
        this.addRecord(jRDataService);
        this.createAclName();
        this.currentTimeMillis();
        this.decode();
    }

    public SecurityDBBasic(Database database, String string) {
        this.getExtendAclEntryRecord = string;
        this.SEDU(database);
        this.createAclName();
        this.currentTimeMillis();
        this.initSystemBuildAcl();
        this.decode();
    }

    private void SEDU(Database database) {
        UpdateDetailsTableImpl updateDetailsTableImpl = UpdateDetailsTableImpl.newInstance(database);
        this.addRecord = UserTableImpl.newInstance(database, updateDetailsTableImpl);
        this.createAclName = UserProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.currentTimeMillis = RoleTableImpl.newInstance(database, updateDetailsTableImpl);
        this.decode = AclsWithResourceTableImpl.newInstance(database, updateDetailsTableImpl, AclTableImpl.newInstance(database, updateDetailsTableImpl));
        this.encode = AclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAclEntryTable = GroupTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAclID = GroupProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAclsWithResourceTable = RGProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAdminUser = GUProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.equals = RoleProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAdminUserNameAndPS = ExtendAclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
    }

    private void addRecord(JRDataService jRDataService) {
        this.SEDU = jRDataService.getOrganizationTable();
        this.addRecord = jRDataService.getUserTable();
        this.createAclName = jRDataService.getUserProfileTable();
        this.currentTimeMillis = jRDataService.getRoleTable();
        this.decode = jRDataService.getAclsWithResourceTable();
        this.encode = jRDataService.getAclEntryTable();
        this.getAclEntryTable = jRDataService.getGroupTable();
        this.getAclID = jRDataService.getGroupProfileTable();
        this.getAclsWithResourceTable = jRDataService.getRGProfileTable();
        this.getAdminUser = jRDataService.getGUProfileTable();
        this.equals = jRDataService.getRoleProfileTable();
        this.getAdminUserNameAndPS = jRDataService.getExtendAclEntryTable();
    }

    private void createAclName() {
        UserRecord userRecord;
        String string = this.getAdminUserNameAndPS();
        if (string != null) {
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string2 == null || string2.length() == 0) {
                string2 = "admin";
            }
            string3 = string3 == null || string3.length() == 0 ? ServerUtil.encode(NULL_PASSWORD) : ServerUtil.encode(string3);
            UserRecord userRecord2 = this.addRecord.getUserRecordbyUN(string2);
            UserRecord userRecord3 = this.addRecord.getAdminUser();
            boolean bl = false;
            if (userRecord3 == null) {
                bl = true;
            } else {
                String string4 = userRecord3.getName();
                if (string4.equals("guest")) {
                    bl = true;
                } else {
                    this.getBytes[0] = string4;
                    String string5 = ServerUtil.decode(userRecord3.getPassword());
                    if (string5.equals(NULL_PASSWORD)) {
                        string5 = "";
                    }
                    this.getBytes[1] = string5;
                }
            }
            if (userRecord2 == null && bl) {
                this.addRecord.addRecord(string2, "JReport Administrator", "SystemBuild", "", new Date(System.currentTimeMillis()), string3, true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
                this.getBytes[0] = string2;
                this.getBytes[1] = string3;
            }
        } else {
            UserRecord userRecord4 = this.addRecord.getAdminUser();
            boolean bl = false;
            if (userRecord4 == null) {
                bl = true;
            } else {
                String string6 = userRecord4.getName();
                if (string6.equals("guest")) {
                    bl = true;
                }
            }
            if (bl) {
                this.addRecord.addRecord("admin", "JReport Administrator", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode("admin"), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
            }
        }
        if (this.getBytes[0] == null) {
            this.getBytes[0] = "admin";
            this.getBytes[1] = "admin";
        }
        if ((userRecord = this.addRecord.getUserRecordbyUN("guest")) == null) {
            this.addRecord.addRecord("guest", "guest", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode(NULL_PASSWORD), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
    }

    public String getAdminUserNameAndPS() {
        String string;
        ExProperties exProperties = ServerEnv.getInstallProps();
        if (exProperties == null) {
            return "admin:admin";
        }
        String string2 = exProperties.getProperty("server.securityInfo");
        if (string2 == null || string2.length() == 0) {
            return "admin:admin";
        }
        try {
            byte[] byArray = Base64.decode((byte[])string2.getBytes());
            string = new String(byArray, "UTF8");
        }
        catch (IOException iOException) {
            string = "admin:admin";
        }
        return string;
    }

    private void currentTimeMillis() {
        UserProfileRecord userProfileRecord;
        RoleRecord roleRecord;
        UserRecord userRecord = this.addRecord.getAdminUser();
        String string = userRecord.getName();
        RoleRecord roleRecord2 = this.currentTimeMillis.getRole("administrators");
        if (roleRecord2 == null) {
            this.currentTimeMillis.addRecord("administrators", true, "SystemBuild", 0);
        }
        if ((roleRecord = this.currentTimeMillis.getRole("everyone")) == null) {
            this.currentTimeMillis.addRecord("everyone", true, "SystemBuild", 0);
            userProfileRecord = this.createAclName.getRecord("guest", "everyone");
            if (userProfileRecord == null) {
                this.createAclName.addRecord("guest", "everyone");
            }
            if (string != null && string.length() != 0 && (userProfileRecord = this.createAclName.getRecord(string, "everyone")) == null) {
                this.createAclName.addRecord(string, "everyone");
            }
        }
        if (string != null && string.length() != 0 && (userProfileRecord = this.createAclName.getRecord(string, "administrators")) == null) {
            this.createAclName.addRecord(string, "administrators");
        }
    }

    void initSystemBuildAcl() {
        int n = this.decode.getRecordIDByResourcePath("/", -1);
        if (n >= 0) {
            return;
        }
        String string = SecurityUtil.createAclName("/", -1);
        AclsWithResourceRecord aclsWithResourceRecord = this.decode.addRecord("/", -1, string, "System", new Date(System.currentTimeMillis()));
        this.defaultAclID = aclsWithResourceRecord.getAclID();
        byte by = 2;
        this.encode.addRecord(this.defaultAclID, by, "everyone", true, 3);
    }

    private void decode() {
        ExtendAclEntryRecord extendAclEntryRecord = this.getAdminUserNameAndPS.getExtendAclEntryRecord("administrators", (byte)2);
        if (extendAclEntryRecord == null) {
            this.getAdminUserNameAndPS.addRecord("administrators", (byte)2, 15);
        }
    }

    public AclsWithResourceTable getAclsWithResourceTable() {
        return this.decode;
    }

    public AclEntryTable getAclEntryTable() {
        return this.encode;
    }

    public ExtendAclEntryTable getExAclEntrTable() {
        return this.getAdminUserNameAndPS;
    }

    public GroupProfileTable getGroupProfileTable() {
        return this.getAclID;
    }

    public GroupTable getGroupTable() {
        return this.getAclEntryTable;
    }

    public GUProfileTable getGuProfileTable() {
        return this.getAdminUser;
    }

    public RGProfileTable getRgProfileTable() {
        return this.getAclsWithResourceTable;
    }

    public RoleProfileTable getRoleProfileTable() {
        return this.equals;
    }

    public RoleTable getRoleTable() {
        return this.currentTimeMillis;
    }

    public UserProfileTable getUserProfileTable() {
        return this.createAclName;
    }

    public OrganizationTable getOrganizationTable() {
        return this.SEDU;
    }

    public UserTable getUserTable() {
        return this.addRecord;
    }

    public String[] getBuiltinAdminUserPwd() {
        return this.getBytes;
    }

    public String getRealmName() {
        return this.getExtendAclEntryRecord;
    }
}

