/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db.group;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.group.GroupPermissionProvider;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.db.security2.AclEntryRecord;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclsWithResourceRecord;
import jet.server.db.security2.AclsWithResourceTable;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;

public class GroupPermissionProviderDBImpl
implements GroupPermissionProvider {
    @Override
    public Hashtable getGroupPermissions(String string, String string2, int n) throws JRCustomerException {
        SecurityDBBasic securityDBBasic = this.SEDU(string);
        if (string2 == null) {
            throw new JRCustomerException(630045);
        }
        AclsWithResourceTable aclsWithResourceTable = securityDBBasic.getAclsWithResourceTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        int n2 = aclsWithResourceTable.getRecordIDByResourcePath(string2, n);
        if (n2 < 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        byte by = 3;
        Vector vector = aclEntryTable.getAclEntryRecords(n2);
        for (int i = 0; i < vector.size(); ++i) {
            AclEntryRecord aclEntryRecord = (AclEntryRecord)vector.elementAt(i);
            String string3 = aclEntryRecord.getPrincipalName();
            byte by2 = aclEntryRecord.getPrincipalType();
            if (by2 != by) continue;
            int n3 = aclEntryRecord.getPermissions();
            String string4 = SecurityUtil.getStringFromPermissionCode(n3);
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    @Override
    public void setGroupPermissions(String string, String string2, String string3, int n, String string4) throws NoSuchGroupException, JRCustomerException {
        boolean bl;
        Object object;
        SecurityDBBasic securityDBBasic = this.SEDU(string);
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630069);
        }
        AclsWithResourceTable aclsWithResourceTable = securityDBBasic.getAclsWithResourceTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        String string5 = SecurityUtil.createAclName(string3, n);
        byte by = 3;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = aclsWithResourceTable.getRecordIDByResourcePath(string3, n);
        if (n2 >= 0) {
            bl2 = true;
            AclEntryRecord aclEntryRecord = aclEntryTable.getAclEntryRecord(n2, string2, by, true);
            if (aclEntryRecord != null) {
                bl3 = true;
            }
        }
        if (string4 == null && bl3) {
            if (string2 == null) {
                boolean bl4 = aclEntryTable.deleteRecord(n2);
                if (!bl4) {
                    throw new JRCustomerException(630066);
                }
                bl4 = aclsWithResourceTable.deleteRecord(string3, n);
                if (!bl4) {
                    throw new JRCustomerException(630066);
                }
            } else {
                boolean bl5 = aclEntryTable.deleteRecord(n2, string2, by);
                if (!bl5) {
                    throw new JRCustomerException(630065, (Object[])new String[]{"JAclEntry[" + string2 + ":" + by + "]"}, null);
                }
            }
            return;
        }
        int n3 = 0;
        try {
            n3 = SecurityUtil.getPermissionCodeFromString(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630068, (Object[])new String[]{string4}, null);
        }
        if (!bl2) {
            object = aclsWithResourceTable.addRecord(string3, n, string5, "System", new Date(System.currentTimeMillis()));
            if (object == null) {
                throw new JRCustomerException(630067);
            }
            n2 = ((AclsWithResourceRecord)object).getAclID();
        }
        if (!bl3 ? (object = aclEntryTable.addRecord(n2, by, string2, true, n3)) == null : !(bl = aclEntryTable.updatePosPermissions(n2, string2, by, n3))) {
            throw new JRCustomerException(630067);
        }
    }

    @Override
    public boolean isEnableEdit() {
        return true;
    }

    public void clearPermissions(String string, String string2, int n) throws JRCustomerException {
        SecurityDBBasic securityDBBasic = this.SEDU(string);
        AclsWithResourceTable aclsWithResourceTable = securityDBBasic.getAclsWithResourceTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        int n2 = aclsWithResourceTable.getRecordIDByResourcePath(string2, n);
        if (n2 < 0) {
            return;
        }
        boolean bl = aclEntryTable.deleteRecord(n2);
        if (!bl) {
            throw new JRCustomerException(630066);
        }
        bl = aclsWithResourceTable.deleteRecord(string2, n);
        if (!bl) {
            throw new JRCustomerException(630066);
        }
    }

    private SecurityDBBasic SEDU(String string) throws JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        return securityDBBasic;
    }
}

