/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db.user;

import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import jet.JSvrResource;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.log.ServiceLogger;
import jet.server.userman.JReportImplementation;
import jet.server.util.ServerUtil;
import jet.util.MiscTools;

public class UserProviderDBImpl
implements UserProvider,
JReportImplementation {
    public static final String NULL_PASSWORD = "NullPassword.jinfonet";
    public static final String TAG_USER_DB_BUILDIN = "user_db_buildin";
    public static final String TAG_USER_DB_ACCESSED_EVENT_SUC = "user_db_access_event_suc";
    public static final String TAG_USER_DB_ACCESSED_EVENT_FAIL = "user_db_access_event_fail";
    public static final String TAG_USER_DB_MANAGEMENT_EVENT_SUC = "user_db_management_event_suc";
    public static final String TAG_USER_DB_MANAGEMENT_EVNET_FAIL = "user_db_management_event_fail";
    public static final String TAG_USER_DB_NOAUDIT = "user_db_noAudit";
    public static final String TAG_USER_DB_AUTHTYPE = "user_db_authType";
    public static final String TAG_USER_DB_LDAPTYPE = "user_db_ldapType";
    private static final char[] SEDU = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '!', '@', '#', '$', '%', '&', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~', '\'', ',', '.', ' '};

    @Override
    public Iterator getAllUsers(String string) throws JRCustomerException {
        SecurityDBBasic securityDBBasic = this.deleteRecordByUserName(string, null, false);
        Iterator iterator = securityDBBasic.getUserTable().getAllUsersName().iterator();
        return iterator;
    }

    @Override
    public Properties getUserProperties(String string, String string2) throws NoSuchUserException, JRCustomerException {
        Properties properties = new Properties();
        if (!SecurityDBEnv.isBuiltinAPI && !string2.equals(SecurityDBEnv.getBuiltinAdminUserPwd(string)[0])) {
            properties.put("user_name", string2);
            return properties;
        }
        SecurityDBBasic securityDBBasic = this.deleteRecordByUserName(string, string2, true);
        UserTable userTable = securityDBBasic.getUserTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        properties.put("user_name", string2);
        properties.put("user_fullname", userRecord.getFullName().trim());
        properties.put("user_description", userRecord.getDescription().trim());
        properties.put("user_email", userRecord.getEmail().trim());
        properties.put("user_create_time", userRecord.getCreateTime());
        String string3 = userRecord.getPassword();
        String string4 = ServerUtil.decode(string3);
        if (string4.equals(NULL_PASSWORD)) {
            string4 = "";
        }
        properties.put("user_password", string4);
        properties.put("user_enable_null_pwd", String.valueOf(userRecord.isEnableNullPS()));
        properties.put("user_last_modify_time", userRecord.getLastModifyTime());
        properties.put("user_never_expire", String.valueOf(userRecord.isNeverExpire()));
        properties.put("user_expire_time", String.valueOf(userRecord.getExpireTime()));
        properties.put("user_min_pwd_length", String.valueOf(userRecord.getMinPSLength()));
        properties.put("user_disabled_account", String.valueOf(userRecord.isAccountDisable()));
        properties.put(TAG_USER_DB_BUILDIN, String.valueOf(userRecord.isBuiltin()));
        properties.put(TAG_USER_DB_ACCESSED_EVENT_SUC, String.valueOf(userRecord.isAccessedEventSuc()));
        properties.put(TAG_USER_DB_ACCESSED_EVENT_FAIL, String.valueOf(userRecord.isAccessedEventFail()));
        properties.put(TAG_USER_DB_MANAGEMENT_EVENT_SUC, String.valueOf(userRecord.isManagementEventSuc()));
        properties.put(TAG_USER_DB_MANAGEMENT_EVNET_FAIL, String.valueOf(userRecord.isManagementEventFail()));
        properties.put(TAG_USER_DB_NOAUDIT, String.valueOf(userRecord.isNoAudit()));
        String string5 = "false";
        if (userRecord.getAuthType() == 1) {
            string5 = "true";
        }
        properties.put(TAG_USER_DB_AUTHTYPE, string5);
        properties.put(TAG_USER_DB_LDAPTYPE, string5);
        return properties;
    }

    @Override
    public void addUser(String string, Properties properties) throws UserExistsException, JRCustomerException {
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630048);
        }
        String string2 = properties.getProperty("user_name");
        SecurityDBBasic securityDBBasic = this.deleteRecordByUserName(string, string2, true);
        UserTable userTable = securityDBBasic.getUserTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord != null) {
            throw new UserExistsException(630083, (Object[])new String[]{string2}, null);
        }
        String string3 = properties.getProperty("user_password", "");
        int n = this.SEDU(properties);
        int n2 = 0;
        if (n == 1) {
            n2 = 1;
        }
        String string4 = properties.getProperty("user_fullname");
        String string5 = properties.getProperty("user_description", "");
        String string6 = properties.getProperty("user_email", "");
        Date date = (Date)properties.get("user_create_time");
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        boolean bl = this.Z(properties);
        int n3 = this.addRecord(properties);
        Date date2 = (Date)properties.get("user_last_modify_time");
        if (date2 == null) {
            date2 = new Date(System.currentTimeMillis());
        }
        boolean bl2 = this.append(properties);
        int n4 = this.charAt(properties);
        boolean bl3 = this.containChar(properties);
        this.currentTimeMillis(string2, string4, string5, string6, bl2, n4, bl, n3, string3);
        string3 = this.decode(string3);
        UserRecord userRecord2 = userTable.addRecord(string2, string4, string5, string6, date, string3, false, bl, n3, date2, bl2, n4, bl3, true, true, true, true, false, n, n2);
        if (userRecord2 == null) {
            throw new JRCustomerException(630051);
        }
    }

    @Override
    public void setUser(String string, Properties properties) throws NoSuchUserException, JRCustomerException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630048);
        }
        String string2 = properties.getProperty("user_name");
        SecurityDBBasic securityDBBasic = this.deleteRecordByUserName(string, string2, true);
        UserTable userTable = securityDBBasic.getUserTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        String string3 = userRecord.getPassword();
        if (string3 == null) {
            string3 = "";
        }
        int n = this.SEDU(properties);
        int n2 = 0;
        if (n == 1) {
            n2 = 1;
        }
        String string4 = properties.getProperty("user_fullname");
        String string5 = properties.getProperty("user_description");
        String string6 = properties.getProperty("user_email");
        boolean bl5 = this.Z(properties);
        int n3 = this.addRecord(properties);
        Date date = (Date)properties.get("user_last_modify_time");
        boolean bl6 = this.append(properties);
        int n4 = this.charAt(properties);
        boolean bl7 = this.containChar(properties);
        this.currentTimeMillis(string2, string4, string5, string6, bl6, n4, bl5, n3, string3);
        string3 = this.decode(string3);
        boolean bl8 = userTable.updateAttibutes(string2, string4, string5, string6, bl5, n3, date, bl6, n4, bl7, n, n2);
        if (!bl8) {
            throw new JRCustomerException(630052);
        }
        boolean bl9 = this.deleteRecord(properties, TAG_USER_DB_ACCESSED_EVENT_SUC, false);
        boolean bl10 = userTable.updataEvent(string2, bl9, bl4 = this.deleteRecord(properties, TAG_USER_DB_ACCESSED_EVENT_FAIL, false), bl3 = this.deleteRecord(properties, TAG_USER_DB_MANAGEMENT_EVENT_SUC, false), bl2 = this.deleteRecord(properties, TAG_USER_DB_MANAGEMENT_EVNET_FAIL, false), bl = this.deleteRecord(properties, TAG_USER_DB_NOAUDIT, false));
        if (!bl10) {
            throw new JRCustomerException(630053, (Object[])new String[]{string2}, null);
        }
    }

    private int SEDU(Properties properties) {
        int n = 0;
        String string = properties.getProperty(TAG_USER_DB_LDAPTYPE);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
        }
        return n;
    }

    private boolean Z(Properties properties) {
        return this.deleteRecord(properties, "user_enable_null_pwd", false);
    }

    private int addRecord(Properties properties) throws JRCustomerException {
        int n = 6;
        String string = properties.getProperty("user_min_pwd_length");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630049);
        }
        return n;
    }

    private boolean append(Properties properties) {
        return this.deleteRecord(properties, "user_never_expire", false);
    }

    private int charAt(Properties properties) throws JRCustomerException {
        int n = 30;
        String string = properties.getProperty("user_expire_time");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRCustomerException(630050);
        }
        return n;
    }

    private boolean containChar(Properties properties) {
        return this.deleteRecord(properties, "user_disabled_account", false);
    }

    private void currentTimeMillis(String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5) throws JRCustomerException {
        String string6 = null;
        if (string == null || string.trim().length() == 0) {
            string6 = JSvrResource.getMessage("SVR_21");
        } else if (MiscTools.containChar((String)string2, (String)":")) {
            string6 = JSvrResource.getMessage("SVR_23", "\":\"");
        } else if (MiscTools.containChar((String)string3, (String)":")) {
            string6 = JSvrResource.getMessage("SVR_24", "\":\"");
        } else if (MiscTools.containChar((String)string4, (String)":")) {
            string6 = JSvrResource.getMessage("SVR_73", "\":\"");
        } else if (!bl && n < 0) {
            string6 = JSvrResource.getMessage("SVR_29");
        } else if (!bl2) {
            if (string5 == null || string5.length() == 0) {
                string6 = JSvrResource.getMessage("SVR_27");
            }
            if (n2 < 0) {
                string6 = JSvrResource.getMessage("SVR_31");
            }
            if (string5.length() < n2) {
                string6 = JSvrResource.getMessage("SVR_32", "" + n2);
            }
        }
        if (string6 != null) {
            throw new JRCustomerException(string6);
        }
    }

    private String decode(String string) {
        String string2 = string == null || string.length() == 0 ? ServerUtil.encode(NULL_PASSWORD) : ServerUtil.encode(string);
        return string2;
    }

    private boolean deleteRecord(Properties properties, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    @Override
    public void removeUser(String string, String string2) throws NoSuchUserException, JRCustomerException {
        byte by;
        SecurityDBBasic securityDBBasic = this.deleteRecordByUserName(string, string2, true);
        UserTable userTable = securityDBBasic.getUserTable();
        UserProfileTable userProfileTable = securityDBBasic.getUserProfileTable();
        GUProfileTable gUProfileTable = securityDBBasic.getGuProfileTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        UserRecord userRecord = userTable.getUserRecordbyUN(string2);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        if (!userTable.deleteRecord(string2)) {
            throw new JRCustomerException(630054, (Object[])new String[]{string2}, null);
        }
        if (!userProfileTable.deleteRecord(string2)) {
            ServiceLogger.logError(3630076, string2, 3);
        }
        if (!gUProfileTable.deleteRecordByUserName(string2)) {
            ServiceLogger.logError(3630077, string2, 3);
        }
        if (!aclEntryTable.deleteRecord(string2, by = 1)) {
            ServiceLogger.logError(3630078, string2, 3);
        }
    }

    private SecurityDBBasic deleteRecordByUserName(String string, String string2, boolean bl) throws JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (bl && (string2 == null || string2.length() == 0)) {
            throw new JRCustomerException(630046);
        }
        return securityDBBasic;
    }

    @Override
    public boolean isEnableEdit() {
        return true;
    }

    private boolean encode(String string) {
        return UserProviderDBImpl.isValidPrincipalName(string);
    }

    public static boolean isValidPrincipalName(String string) {
        if (string.length() != string.trim().length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '&' || c == '*' || c == '+' || c == '-' || c == '/' || c == '=' || c == '?' || c == '^' || c == '_' || c == '`' || c == '{' || c == '|' || c == '}' || c == '~' || c == '\'' || c == ',' || c == '.' || c == ' ') continue;
            return false;
        }
        return true;
    }
}

