/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.ServerEnv;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.LDAPXMLReader;
import jet.server.jrc.security.ldap.LDAPXMLWriter;
import jet.server.jrc.security.ldap.NoSuchRoleMapException;
import jet.server.jrc.security.ldap.RoleMapImpl;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.RoleMap;
import jet.server.log.ServiceLogger;
import org.xml.sax.SAXException;

public class LDAPData {
    public static final String ENV_ENABLE_NONE_IMPORTED_LDAP_SUPPORT = "enableNoneImportedLDAPSupport";
    public static final String ENV_ENABLE_SUPPORT = "enableLDAPSupport";
    public static final String ENV_LDAP_VERSION = "ldapVersion";
    public static final String ENV_ENABLE_AUTO_IMPORT_LDAP_USER = "enableAutoImportLDAPUser";
    public static final String ENV_URL = "url";
    public static final String ENV_PASSWORD = "password";
    public static final String ENV_PORT = "serverPort";
    public static final String ENV_DIRECTORY_MANAGER_DN = "directoryManagerDN";
    public static final String ENV_ROOT = "rootEntry";
    public static final String ENV_SSL = "isUsingSSL";
    public static final String ENV_SOCKETTIME = "socketTime";
    public static final String ENV_IMPORT_GROUP_TYPE = "importGroupType";
    public static final String ENV_USER_SCHEME_USERID = "userAN";
    public static final String ENV_USER_SCHEME_COMMONNAME = "userCN";
    public static final String ENV_USER_SCHEME_ENABLESPECIALATTRIBUTENAME = "userEnableSAN";
    public static final String ENV_USER_SCHEME_SPECIALATTRIBUTENAME = "userSAN";
    public static final String ENV_USER_SCHEME_PASSWROD = "userPassword";
    public static final String ENV_USER_SCHEME_DN = "userDN";
    public static final String ENV_USER_SCHEME_FILTER = "userFilter";
    public static final String ENV_GROUP_SCHEME_COMMONNAME = "groupCN";
    public static final String ENV_GROUP_SCHEME_MEMBERTYPE = "groupMemberType";
    public static final String ENV_GROUP_SCHEME_DN = "groupDN";
    public static final String ENV_GROUP_SCHEME_FILTER = "groupFilter";
    public static final String ENV_GROUP_SCHEME_ADMINGROUP = "groupAdminGroup";
    public static final String ENV_GROUP_SCHEME_ENABLESPECIALATTRIBUTENAME = "groupEnableSAN";
    public static final String ENV_GROUP_SCHEME_SPECIALATTRIBUTENAME = "groupSAN";
    public static final String OPT_USER_SETTING = "Current Settings";
    public static final String OPT_NDS_SETTING = "Novell Directory Server";
    public static final String OPT_IPLANET_SETTING = "iPlanet Directory Server";
    public static final String OPT_MS_SITE_SETTING = "Microsoft Site Server";
    public static final String OPT_OPENLDAP_SETTING = "OpenLDAP Directory Server";
    public static final String OPT_WIN2000AD_SETTING = "Win2000 Active Directory";
    public static final String OPT_LOTUSDOMINO_SETTING = "Lotus Domino on NT";
    private static Hashtable LDAP_DATA = new Hashtable();
    private static Hashtable SEDU = new Hashtable();
    private static String add = "";
    private static String addListener = "";
    private static PropsTable addNewRoleMap;
    private static ClusterMap append;

    public static void setPath(String string) {
        LDAPXMLWriter.setPath(string);
        LDAPXMLReader.setPath(string);
        try {
            if (ServerEnv.isClusterEnabled()) {
                addNewRoleMap = GlobalDataService.getInstance().getPropsTable();
            }
            append = MapFactory.getMap(MapAttr.LDAP_DATA);
            append.addListener(new MapListenerAdapter(){

                public void afterPut(String string, int n, String string2, Serializable serializable, Serializable serializable2, MapFlags mapFlags) {
                    if (1.isLocalEvent(n)) {
                        return;
                    }
                    LDAPManager lDAPManager = UserDataToolkit.getLdapManager();
                    if (string2.equals("ldap_properties")) {
                        lDAPManager.refreshLDAPPro();
                    } else if (string2.equals("ldap_task_id")) {
                        String string3 = (String)((Object)serializable);
                        lDAPManager.setTaskId(string3);
                    }
                }
            });
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        LDAPData.LDAP_DATA();
    }

    private static void LDAP_DATA() {
        Object object;
        block18: {
            if (ServerEnv.isClusterEnabled()) {
                try {
                    object = addNewRoleMap.queryProp("ldap_configuration");
                    if (object != null && ((Properties)object).size() > 0) {
                        String string;
                        String string2 = (String)((Properties)object).remove("LDAP-scheduleTaskID");
                        if (string2 != null) {
                            add = string2;
                        }
                        if ((string = (String)((Properties)object).remove("LDAP-encode")) != null && string.length() > 0 && !string.equals(" ")) {
                            addListener = string;
                        }
                        Object object2 = ((Properties)object).keys();
                        while (object2.hasMoreElements()) {
                            String string3 = (String)object2.nextElement();
                            if (!string3.startsWith("roleMap-name")) continue;
                            String string4 = (String)((Properties)object).remove(string3);
                            String string5 = (String)((Properties)object).remove("roleMap-searchFilter" + string4);
                            String string6 = (String)((Properties)object).remove("roleMap-bindingRoleName" + string4);
                            SEDU.put(string4, new RoleMapImpl(string4, string5, string6));
                        }
                        object2 = ((Properties)object).getProperty(ENV_ROOT);
                        if (null == object2) {
                            ((Properties)object).put(ENV_ROOT, "");
                        }
                        LDAP_DATA = object;
                        break block18;
                    }
                    LDAPXMLReader.read();
                    LDAP_DATA = LDAPXMLReader.getLDAPConfig();
                    add = LDAPXMLReader.getTaskID();
                    addListener = LDAPXMLReader.getEncode();
                    SEDU = LDAPXMLReader.getRoleMaps();
                    Properties properties = new Properties();
                    properties.putAll((Map<?, ?>)LDAP_DATA);
                    properties.put("LDAP-scheduleTaskID", add);
                    properties.put("LDAP-encode", addListener);
                    Enumeration enumeration = SEDU.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        RoleMap roleMap = (RoleMap)SEDU.get(string);
                        String string7 = roleMap.getSearchFilter();
                        String string8 = roleMap.getRoleName();
                        properties.put("roleMap-name" + string, string);
                        properties.put("roleMap-searchFilter" + string, string7);
                        properties.put("roleMap-bindingRoleName" + string, string8);
                    }
                    addNewRoleMap.doUpdateProp("ldap_configuration", properties, false);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            } else {
                try {
                    LDAPXMLReader.read();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    ServiceLogger.logError(parserConfigurationException);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
                catch (SAXException sAXException) {
                    ServiceLogger.logError(sAXException);
                }
                LDAP_DATA = LDAPXMLReader.getLDAPConfig();
                add = LDAPXMLReader.getTaskID();
                addListener = LDAPXMLReader.getEncode();
                SEDU = LDAPXMLReader.getRoleMaps();
            }
        }
        object = (String)LDAP_DATA.get(ENV_ENABLE_SUPPORT);
        if (null == object || !((String)object).equals("true")) {
            LDAP_DATA.put(ENV_ENABLE_NONE_IMPORTED_LDAP_SUPPORT, "false");
            LDAP_DATA.put(ENV_ENABLE_AUTO_IMPORT_LDAP_USER, "false");
        }
        if (LDAP_DATA.containsKey("groupMemeberType") && !LDAP_DATA.containsKey(ENV_GROUP_SCHEME_MEMBERTYPE)) {
            LDAP_DATA.put(ENV_GROUP_SCHEME_MEMBERTYPE, LDAP_DATA.remove("groupMemeberType"));
        }
        append.put("ldap_properties", LDAP_DATA);
        if (add != null) {
            append.put("ldap_task_id", add);
        }
        if (addListener != null) {
            append.put("ldap_encode", addListener);
        }
        append.put("ldap_role_maps", SEDU);
    }

    public static Hashtable getLDAPProperties() {
        return (Hashtable)append.get("ldap_properties");
    }

    public static String getProperty(String string) {
        Hashtable hashtable = (Hashtable)append.get("ldap_properties");
        return (String)hashtable.get(string);
    }

    public static boolean editLDAPProperties(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.setLDAPProperties(string, string2)) {
                bl = true;
            }
        } else {
            Properties properties = new Properties();
            properties.put(string, string2);
            bl = LDAPData.SEDU(properties);
        }
        if (bl) {
            LDAP_DATA.put(string, string2);
            append.put("ldap_properties", LDAP_DATA);
        }
        return bl;
    }

    public static boolean replaceProperties(Hashtable hashtable) {
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.writeLDAPConfigInfo(hashtable)) {
                bl = true;
            }
        } else {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)hashtable);
            bl = LDAPData.SEDU(properties);
        }
        if (bl) {
            LDAP_DATA = hashtable;
            append.put("ldap_properties", LDAP_DATA);
        }
        return bl;
    }

    public static String getTaskID() {
        return (String)append.get("ldap_task_id");
    }

    public static boolean editTaskID(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.editTaskID(string)) {
                bl = true;
            }
        } else {
            Properties properties = new Properties();
            properties.put("LDAP-scheduleTaskID", string);
            bl = LDAPData.SEDU(properties);
        }
        if (bl) {
            add = string;
            append.put("ldap_task_id", add);
        }
        return bl;
    }

    public static String getEncode() {
        return (String)append.get("ldap_encode");
    }

    public static boolean editEncode(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.editEncode(string)) {
                bl = true;
            }
        } else {
            Properties properties = new Properties();
            properties.put("LDAP-encode", string);
            bl = LDAPData.SEDU(properties);
        }
        if (bl) {
            addListener = string;
            append.put("ldap_encode", addListener);
        }
        return bl;
    }

    public static Vector getRoleMaps() {
        Vector<RoleMap> vector = new Vector<RoleMap>();
        Enumeration enumeration = ((Hashtable)append.get("ldap_role_maps")).elements();
        while (enumeration.hasMoreElements()) {
            RoleMap roleMap = (RoleMap)enumeration.nextElement();
            if (vector.contains(roleMap)) continue;
            vector.add(roleMap);
        }
        return vector;
    }

    public static RoleMap getRoleMap(String string) throws NoSuchRoleMapException {
        Hashtable hashtable = (Hashtable)append.get("ldap_role_maps");
        if (!hashtable.containsKey(string)) {
            throw new NoSuchRoleMapException(630081, (Object[])new String[]{string}, null);
        }
        RoleMap roleMap = (RoleMap)hashtable.get(string);
        return roleMap;
    }

    public static boolean addRoleMap(String string, String string2, String string3) {
        RoleMapImpl roleMapImpl = new RoleMapImpl(string, string2, string3);
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.addNewRoleMap(roleMapImpl)) {
                bl = true;
            }
        } else {
            Properties properties = new Properties();
            properties.put("roleMap-name" + string, string);
            properties.put("roleMap-searchFilter" + string, string2);
            properties.put("roleMap-bindingRoleName" + string, string3);
            bl = LDAPData.SEDU(properties);
        }
        if (bl) {
            SEDU.put(roleMapImpl.getName(), roleMapImpl);
            append.put("ldap_role_maps", SEDU);
        }
        return bl;
    }

    public static boolean eidtRoleMap(String string, String string2, String string3) throws NoSuchRoleMapException {
        Hashtable hashtable = (Hashtable)append.get("ldap_role_maps");
        if (!hashtable.containsKey(string)) {
            throw new NoSuchRoleMapException(630081, (Object[])new String[]{string}, null);
        }
        RoleMap roleMap = (RoleMap)hashtable.get(string);
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.editRoleMap(string, string2, string3)) {
                bl = true;
            }
        } else {
            Properties properties = new Properties();
            properties.put("roleMap-name" + string, string);
            properties.put("roleMap-searchFilter" + string, string2);
            properties.put("roleMap-bindingRoleName" + string, string3);
            bl = LDAPData.SEDU(properties);
        }
        if (bl) {
            roleMap.setRoleName(string3);
            roleMap.setSearchFilter(string2);
        }
        return bl;
    }

    public static boolean removeRoleMap(String string) throws NoSuchRoleMapException {
        if (!((Hashtable)append.get("ldap_role_maps")).containsKey(string)) {
            throw new NoSuchRoleMapException(630081, (Object[])new String[]{string}, null);
        }
        boolean bl = false;
        if (!ServerEnv.isClusterEnabled()) {
            if (LDAPXMLWriter.removeRoleMap(string)) {
                bl = true;
            }
        } else {
            try {
                Properties properties = addNewRoleMap.queryProp("ldap_configuration");
                properties.remove("roleMap-name" + string);
                properties.remove("roleMap-searchFilter" + string);
                properties.remove("roleMap-bindingRoleName" + string);
                addNewRoleMap.doUpdateProp("ldap_configuration", properties, true);
                bl = true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
        if (bl) {
            SEDU.remove(string);
            append.put("ldap_role_maps", SEDU);
        }
        return bl;
    }

    public static void refresh() {
        LDAPData.LDAP_DATA();
    }

    private static boolean SEDU(Properties properties) {
        boolean bl = false;
        try {
            addNewRoleMap.doUpdateProp("ldap_configuration", properties, false);
            bl = true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return bl;
    }
}

