/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.admin.cfg.SynchronizationResult;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.security.ldap.LDAPConnectionImpl;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.LDAPSynResultXMLReader;
import jet.server.jrc.security.ldap.LDAPSynResultXMLWriter;
import jet.server.jrc.security.ldap.LDAPSynchronizeTask;
import jet.server.jrc.security.ldap.NoSuchRoleMapException;
import jet.server.jrc.security.ldap.RoleMapExistException;
import jet.server.jrc.security.ldap.SynchronizationResultImpl;
import jet.server.jrc.security.ldap.intf.LDAPConnection;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.jrc.security.ldap.intf.RoleMap;
import jet.server.log.ServiceLogger;
import org.xml.sax.SAXException;

public class LDAPManagerImpl
implements LDAPManager {
    private LDAPEnvironments ReaderFile = new LDAPEnvironments();
    private LDAPConnection SEDU;
    private SynchronizationResult add;
    String taskID = "";
    boolean isLDAPEnable = this.SEDU();
    boolean isEnableLDAPProviders = false;
    String importGroupType = "role";

    public LDAPManagerImpl() {
        String string = this.ReaderFile.getProperty("enableNoneImportedLDAPSupport");
        if (string != null) {
            this.isEnableLDAPProviders = string.equals("true");
        }
        this.SEDU = new LDAPConnectionImpl(this.ReaderFile);
        this.taskID = LDAPData.getTaskID();
        String string2 = this.ReaderFile.getProperty("importGroupType");
        this.importGroupType = string2 == null || string2.length() == 0 ? "role" : string2;
        if (this.isLDAPEnable) {
            this.SEDU.connect();
        }
        String string3 = ServerEnv.propertiesPath + "LDAPSynResult.xml";
        this.add = this.ReaderFile(string3);
    }

    @Override
    public void refreshLDAPPro() {
        this.ReaderFile.refresh();
        this.isLDAPEnable = this.SEDU();
        String string = this.ReaderFile.getProperty("importGroupType");
        this.importGroupType = string == null || string.length() == 0 ? "role" : string;
        if (this.isLDAPEnable) {
            this.SEDU.reconnect(this.ReaderFile);
        } else {
            this.SEDU.disconnect();
        }
    }

    @Override
    public boolean editProperty(String string, String string2) {
        if (LDAPData.editLDAPProperties(string, string2)) {
            this.refreshLDAPPro();
            return true;
        }
        return false;
    }

    @Override
    public Hashtable getLDAPProperties() {
        return this.ReaderFile.getLDAPProperties();
    }

    @Override
    public boolean isImportToRole() {
        return this.importGroupType.equalsIgnoreCase("role");
    }

    @Override
    public boolean isLDAPEnable() {
        return this.isLDAPEnable;
    }

    @Override
    public boolean isEnableNoneImportedLDAPSupport() {
        return this.isEnableLDAPProviders;
    }

    public boolean isConnect() {
        if (!this.isLDAPEnable) {
            return false;
        }
        return this.SEDU.connect();
    }

    public boolean isConnect(LDAPEnvironments lDAPEnvironments) {
        this.ReaderFile = lDAPEnvironments;
        boolean bl = this.SEDU();
        if (!bl) {
            return false;
        }
        return this.SEDU.reconnect(lDAPEnvironments);
    }

    @Override
    public boolean savePropertiese(Hashtable hashtable) {
        if (this.ReaderFile.replaceProperties(hashtable)) {
            this.refreshLDAPPro();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidLdapUser(String string, String string2) {
        if (!this.isLDAPEnable) {
            return false;
        }
        return this.SEDU.isValidLDAPUser(string, string2);
    }

    @Override
    public boolean isValidLdapUserByDN(String string, String string2, String string3) {
        if (!this.isLDAPEnable) {
            return false;
        }
        return this.SEDU.isValidLDAPUserByDN(string, string2, string3);
    }

    @Override
    public LDAPUser getLDAPUser(String string) throws NamingException {
        if (!this.isLDAPEnable) {
            throw new NamingException("LDAP support disable!");
        }
        return this.SEDU.getLDAPUser(string);
    }

    @Override
    public Vector[] getLDAPGroup(String string) throws NamingException {
        if (!this.isLDAPEnable) {
            throw new NamingException("LDAP support disable!");
        }
        return this.SEDU.getLDAPGroup(string);
    }

    @Override
    public Vector getAllLDAPUsers() throws NamingException {
        Vector<LDAPUser> vector = new Vector<LDAPUser>();
        if (!this.isLDAPEnable) {
            throw new NamingException("LDAP support disable!");
        }
        Enumeration enumeration = this.SEDU.getAllLDAPUsers().elements();
        while (enumeration.hasMoreElements()) {
            LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
            vector.addElement(lDAPUser);
        }
        return vector;
    }

    @Override
    public Vector getAllLDAPGroups() throws NamingException {
        Vector vector = new Vector();
        if (!this.isLDAPEnable) {
            throw new NamingException("LDAP support disable!");
        }
        Enumeration enumeration = this.SEDU.getAllLDAPGroups().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public Hashtable getAllLDAPUsersHT() throws NamingException {
        if (!this.isLDAPEnable) {
            throw new NamingException("LDAP support disable!");
        }
        return this.SEDU.getAllLDAPUsers();
    }

    @Override
    public Hashtable getAllLDAPGroupsHT() throws NamingException {
        if (!this.isLDAPEnable) {
            throw new NamingException("LDAP support disable!");
        }
        return this.SEDU.getAllLDAPGroups();
    }

    @Override
    public Vector getRoleMaps() {
        return LDAPData.getRoleMaps();
    }

    @Override
    public RoleMap getRoleMap(String string) throws NoSuchRoleMapException {
        return LDAPData.getRoleMap(string);
    }

    @Override
    public boolean editRoleMap(String string, String string2, String string3) throws NoSuchRoleMapException {
        return LDAPData.eidtRoleMap(string, string2, string3);
    }

    @Override
    public boolean removeRoleMap(String string) throws NoSuchRoleMapException {
        return LDAPData.removeRoleMap(string);
    }

    @Override
    public boolean addRoleMap(String string, String string2) throws RoleMapExistException {
        String string3 = "RoleMap: [" + string.hashCode() + string2.hashCode() + "]";
        return LDAPData.addRoleMap(string3, string, string2);
    }

    @Override
    public String addNewRoleMap(String string, String string2) throws RoleMapExistException {
        String string3 = "RoleMap: [" + string.hashCode() + string2.hashCode() + "]";
        boolean bl = LDAPData.addRoleMap(string3, string, string2);
        if (bl) {
            return string3;
        }
        return null;
    }

    @Override
    public Vector getRoleNamsByFilter(String string) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getRoleMaps();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            RoleMap roleMap = (RoleMap)enumeration.nextElement();
            String string2 = roleMap.getSearchFilter();
            String string3 = roleMap.getRoleName();
            boolean bl = this.isInFilter(string2, string);
            if (!bl) continue;
            vector.add(string3);
        }
        return vector;
    }

    @Override
    public String testFilter(String string) {
        if (!this.isLDAPEnable) {
            return "LDAP support is disabled.";
        }
        try {
            return this.SEDU.testFilter(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return "SECURITY_ERR_57_LDAP_ROLEMAP_TEST_FAILED";
        }
    }

    @Override
    public boolean isInFilter(String string, String string2) {
        if (!this.isLDAPEnable) {
            ServiceLogger.logError(3630055, 3);
            return false;
        }
        try {
            return this.SEDU.isInFilter(string, string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    @Override
    public boolean isLDAPScheduleEnable() {
        if (this.taskID == null || this.taskID.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        Properties properties = httpRptServer.getScheduledTask(this.taskID);
        if (properties == null) {
            return false;
        }
        String string = (String)properties.get("jrs.is_enabled");
        return string.equals("true");
    }

    @Override
    public Properties getSynchronizeSchedule() {
        if (this.taskID == null || this.taskID.trim().length() == 0) {
            return null;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        Properties properties = httpRptServer.getScheduledTask(this.taskID);
        return properties;
    }

    @Override
    public boolean disableSynSchedule() {
        if (this.taskID == null || this.taskID.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        return httpRptServer.disableScheduledTask(this.taskID);
    }

    @Override
    public boolean enableSynSchedule() {
        if (this.taskID == null || this.taskID.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        return httpRptServer.enableScheduledTask(this.taskID);
    }

    @Override
    public boolean deleteSynSchedule() {
        if (this.taskID == null || this.taskID.length() == 0) {
            return false;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        if (httpRptServer.removeScheduledTask(this.taskID)) {
            if (LDAPData.editTaskID("")) {
                this.taskID = null;
                return true;
            }
            ServiceLogger.logDebug(6630056, 6);
        } else {
            ServiceLogger.logDebug(6630057, 6);
        }
        return false;
    }

    @Override
    public boolean exportSynResultToXMLFile(String string, SynchronizationResult synchronizationResult) {
        LDAPSynResultXMLWriter lDAPSynResultXMLWriter = new LDAPSynResultXMLWriter(synchronizationResult);
        try {
            lDAPSynResultXMLWriter.writeSynInfo();
            lDAPSynResultXMLWriter.writeXMLToFile(string);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            return false;
        }
        this.add = synchronizationResult;
        return true;
    }

    private SynchronizationResult ReaderFile(String string) {
        LDAPSynResultXMLReader lDAPSynResultXMLReader = new LDAPSynResultXMLReader();
        File file = new File(string);
        if (file.exists()) {
            try {
                return lDAPSynResultXMLReader.ReaderFile(string);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            catch (SAXException sAXException) {
                ServiceLogger.logError(sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException);
            }
        }
        return new SynchronizationResultImpl();
    }

    @Override
    public boolean submitSynchronizeSchedule(Properties properties, String string) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        properties.put("jrs.task_class", LDAPSynchronizeTask.class.getName());
        if (this.taskID == null || this.taskID.length() == 0) {
            try {
                this.taskID = httpRptServer.submitScheduledTask(string, properties);
                return LDAPData.editTaskID(this.taskID);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError((Throwable)((Object)rptServerException));
                return false;
            }
        }
        properties.put("jrs.task_id", this.taskID);
        try {
            httpRptServer.submitScheduledTask(string, properties);
            return true;
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
            return false;
        }
    }

    @Override
    public SynchronizationResult getLastSynScheduleResult() {
        return this.add;
    }

    @Override
    public Vector getLDAPGroupsNameByUser(String string) throws NamingException {
        return this.SEDU.getLDAPUserParentGroupNames(string);
    }

    @Override
    public String getSocketTimeStr() {
        String string = this.ReaderFile.getProperty("socketTime");
        if (string == null || string.length() == 0) {
            return "10";
        }
        return string;
    }

    @Override
    public String getAdminGroupName() {
        String string = this.ReaderFile.getProperty("groupAdminGroup");
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public void setTaskId(String string) {
        this.taskID = string;
    }

    private boolean SEDU() {
        boolean bl = false;
        String string = this.ReaderFile.getProperty("enableLDAPSupport");
        if (string != null) {
            bl = string.equals("true");
        }
        return bl;
    }
}

