/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.track;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.track.TaskStatus;
import jet.server.jrc.track.TrackerMBean;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.Queue;
import jet.server.util.ThreadQueueController;

public class Tracker
implements TrackerMBean,
Runnable {
    private static volatile boolean SEDU = true;
    private static volatile long append = 10000L;
    private static long dump = 0L;
    private static Tracker equals = null;
    private TaskStatus getAcceleratedRunningReportsCount = null;
    private Map getActiveAndWaiting = Collections.synchronizedMap(new HashMap());
    private ThreadQueueController getActiveReportsCount;
    private Queue getAllMembers;
    private boolean getHost;
    private ClusterService getLocalMember;
    private int getLong = 0;
    private int getNormalRunningReportsCount = 0;
    private int getNormalWaitingReportsCount = 0;

    @Override
    public long getDumpInterval() {
        return append;
    }

    @Override
    public void setDumpInterval(long l) {
        if (l < 1000L) {
            l = 1000L;
        }
        append = l;
    }

    @Override
    public void setDump(boolean bl) {
        if (bl && !SEDU && equals != null) {
            new Thread((Runnable)equals, "DumpThread").start();
        }
        SEDU = bl;
    }

    @Override
    public boolean isDump() {
        return SEDU;
    }

    public Tracker() {
        this.getAcceleratedRunningReportsCount = new TaskStatus();
        long l = Long.getLong("jreport.dump_interval", 60000L);
        this.setDumpInterval(l);
    }

    public void dump() {
        if (ServiceLogger.isLoggable(6, 6)) {
            if (this.getActiveReportsCount != null) {
                int n = this.getActiveReportsCount.getActiveReportsCount();
                int n2 = this.getAllMembers.size();
                int n3 = this.getActiveReportsCount.getWaitReportsCount();
                this.getLong = n;
                this.getNormalRunningReportsCount = n2;
                this.getNormalWaitingReportsCount = n3;
                if (this.getHost) {
                    this.SEDU();
                    ServiceLogger.logDump(5600161, new Object[]{String.valueOf(this.getLong), String.valueOf(this.getNormalWaitingReportsCount), String.valueOf(this.getNormalRunningReportsCount), n + "(normalRunning:" + this.getActiveReportsCount.getNormalRunningReportsCount() + ", acceleratedRunning:" + this.getActiveReportsCount.getAcceleratedRunningReportsCount() + ")", n3 + "(normalWaiting:" + this.getActiveReportsCount.getNormalWaitingReportsCount() + ", readyWaiting:" + this.getActiveReportsCount.getReadyWaitingReportsCount() + ")", String.valueOf(n2), "" + this.getAcceleratedRunningReportsCount.getRunningOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getQueuingOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getWaitingOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getRunningScheduleReports(), "" + this.getAcceleratedRunningReportsCount.getQueuingScheduleReports(), "" + n2}, 6);
                } else {
                    ServiceLogger.logDump(5600160, new Object[]{n + "(normalRunning:" + this.getActiveReportsCount.getNormalRunningReportsCount() + ", acceleratedRunning:" + this.getActiveReportsCount.getAcceleratedRunningReportsCount() + ")", n3 + "(normalWaiting:" + this.getActiveReportsCount.getNormalWaitingReportsCount() + ", readyWaiting:" + this.getActiveReportsCount.getReadyWaitingReportsCount() + ")", String.valueOf(n2), "" + this.getAcceleratedRunningReportsCount.getRunningOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getQueuingOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getWaitingOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getRunningScheduleReports(), "" + this.getAcceleratedRunningReportsCount.getQueuingScheduleReports(), "" + n2}, 6);
                }
            } else {
                ServiceLogger.logDump(5600159, new Object[]{"" + this.getAcceleratedRunningReportsCount.getRunningOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getQueuingOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getWaitingOnDemandReports(), "" + this.getAcceleratedRunningReportsCount.getRunningScheduleReports(), "" + this.getAcceleratedRunningReportsCount.getQueuingScheduleReports(), "" + this.getAcceleratedRunningReportsCount.getWaitingScheduleReports()}, 6);
            }
        }
    }

    private void SEDU() {
        Member[] memberArray;
        try {
            memberArray = this.getLocalMember.getAllMembers();
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException), 2);
            return;
        }
        boolean bl = true;
        for (int i = 0; i < memberArray.length; ++i) {
            if (memberArray[i].equals(this.getLocalMember.getLocalMember())) continue;
            try {
                MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(memberArray[i].getHost(), Integer.parseInt(memberArray[i].getPort()), "MemberMonitor");
                int[] nArray = memberMonitor.getActiveAndWaiting();
                if (nArray[0] < 0) {
                    bl = false;
                } else {
                    this.getLong += nArray[0];
                }
                this.getNormalRunningReportsCount += nArray[1];
                if (nArray[2] < 0) {
                    bl = false;
                    continue;
                }
                this.getNormalWaitingReportsCount += nArray[2];
                continue;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        if (!bl && ServiceLogger.isLoggable(6, 6)) {
            ServiceLogger.logDump(6600240, 6);
        }
    }

    public void init(ThreadQueueController threadQueueController, Queue queue, boolean bl, ClusterService clusterService) {
        this.getActiveReportsCount = threadQueueController;
        this.getAllMembers = queue;
        this.getHost = bl;
        this.getLocalMember = clusterService;
    }

    public void release() {
        this.setDump(false);
        this.getAcceleratedRunningReportsCount.release();
        this.getAcceleratedRunningReportsCount = null;
        equals = null;
        this.getActiveReportsCount = null;
        this.getAllMembers = null;
        this.getLocalMember = null;
    }

    @Override
    public void run() {
        while (SEDU) {
            this.dump();
            try {
                Thread.sleep(append);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
        }
    }

    public TaskStatus getTaskStatus() {
        return this.getAcceleratedRunningReportsCount;
    }

    public void registerToMBeanServer() {
    }

    public static synchronized Tracker getInstance() {
        if (equals == null) {
            equals = new Tracker();
            Thread thread = new Thread((Runnable)equals, "DumpThread");
            thread.setDaemon(true);
            thread.start();
        }
        return equals;
    }

    public static synchronized long getSequenceId() {
        return ++dump;
    }

    public static void dump(String string) {
        ServiceLogger.logDump(string);
    }

    public static void dump(String string, int n) {
        ServiceLogger.logDump(string, n);
    }

    public static void dump(int n, Object[] objectArray, int n2) {
        ServiceLogger.logDump(n, objectArray, n2);
    }
}

