/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.version;

import java.io.File;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.db.version.AbstractVersionRecord;
import jet.server.db.version.CatalogVersionRecord;
import jet.server.db.version.DynamicResultDetailRecord;
import jet.server.db.version.DynamicResultDetailTable;
import jet.server.db.version.DynamicResultVersionTableImpl;
import jet.server.db.version.LCVersionRecord;
import jet.server.db.version.ReportVersionRecord;
import jet.server.db.version.ResultDetailRecord;
import jet.server.db.version.ResultDetailTable;
import jet.server.db.version.ResultDetailedInfo;
import jet.server.db.version.ResultVersionRecord;
import jet.server.db.version.ResultVersionTableImpl;
import jet.server.intf.jrs.DataService;
import jet.server.intf.jrs.SchedulingService;
import jet.server.intf.resource.CatalogInfo;
import jet.server.intf.resource.LCInfo;
import jet.server.intf.resource.ReportInfo;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.ResourceTreeManager;
import jet.server.intf.resource.ResultInfo;
import jet.server.intf.version.AbstractVersionTable;
import jet.server.intf.version.CatalogVersionTable;
import jet.server.intf.version.DynamicResultVersionTable;
import jet.server.intf.version.LCVersionTable;
import jet.server.intf.version.ReportVersionTable;
import jet.server.intf.version.ResultVersionTableNew;
import jet.server.intf.version.VersionController;
import jet.server.jrc.JRDataService;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.jrc.resource.CatalogInfoImpl;
import jet.server.jrc.resource.LCInfoImpl;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ResultInfoImpl;
import jet.server.jrc.version.SimpleVersionInfo;
import jet.server.jrc.version.VersionFolderManager;
import jet.server.log.ServiceLogger;
import jet.server.resstore.SpaceAllocatorExt;
import jet.server.resstore.impl.JRServerResourceStore;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.SchdTools;
import jet.util.IntKeyHashtable;

public class VersionControllerImpl
implements VersionController {
    JRDataService dataSrv = null;
    SchedulingService schdServ = null;
    ResourceTreeManager rscMan = null;
    private VersionFolderManager SEDU = null;
    private String VersionOccupyDisk = null;
    private ClusterMap add;
    private JRServerResourceStoreFactory addRecord;

    public VersionControllerImpl(DataService dataService) {
        this.dataSrv = (JRDataService)dataService;
        this.VersionOccupyDisk = System.getProperty("history_dir") != null ? System.getProperty("history_dir") : ServerEnv.homePath + "history";
        String string = this.VersionOccupyDisk = ServerEnv.isSharedHistDir() ? ServerEnv.getSharedHistDir() : this.VersionOccupyDisk;
        if (!this.VersionOccupyDisk.endsWith(File.separator)) {
            this.VersionOccupyDisk = this.VersionOccupyDisk + File.separator;
        }
        if (this.dataSrv.getRealmName().equals(ServerEnv.getActiveRealm())) {
            this.addRecord = JRServerResourceStoreFactory.getInstance();
            try {
                this.add = MapFactory.getMapForRealm(this.dataSrv.getRealmName(), MapAttr.VersionOccupyDisk);
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException), 1);
            }
        }
    }

    public void initDiskUsageMap() {
        Object object;
        Object object2;
        Object object3;
        if (this.add == null) {
            return;
        }
        try {
            if (!ClusterInitLocker.hasInited(MapFactory.makeRealmMapName(this.getClass().getName(), this.dataSrv.getRealmName()))) {
                if (this.add.isEmpty()) {
                    Serializable serializable;
                    Serializable serializable2;
                    object3 = this.dataSrv.getCatalogVersionTable();
                    Iterator iterator = object3.getAllRecords();
                    Object object4 = ((Vector)((Object)iterator)).iterator();
                    while (object4.hasNext()) {
                        object2 = (CatalogVersionRecord)object4.next();
                        this.SEDU((AbstractVersionRecord)object2, (AbstractVersionTable)object3, ((CatalogVersionRecord)object2).getCatalogFile());
                    }
                    object4 = this.dataSrv.getReportVersionTable();
                    object2 = object4.getAllRecords();
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        serializable2 = (ReportVersionRecord)object.next();
                        this.SEDU((AbstractVersionRecord)serializable2, (AbstractVersionTable)object4, ((ReportVersionRecord)serializable2).getReportFile());
                    }
                    object = this.dataSrv.getLcVersionTable();
                    serializable2 = object.getAllRecords();
                    Object object5 = ((Vector)serializable2).iterator();
                    while (object5.hasNext()) {
                        serializable = (LCVersionRecord)object5.next();
                        this.SEDU((AbstractVersionRecord)serializable, (AbstractVersionTable)object, ((LCVersionRecord)serializable).getLcFile());
                    }
                    object5 = this.dataSrv.getResultVersionTableNew();
                    serializable = object5.getAllRecords();
                    Iterator iterator2 = ((Vector)serializable).iterator();
                    while (iterator2.hasNext()) {
                        ResultVersionRecord resultVersionRecord = (ResultVersionRecord)iterator2.next();
                        this.SEDU(resultVersionRecord, (AbstractVersionTable)object5, resultVersionRecord.getResultFile());
                    }
                }
                ClusterInitLocker.setInited(MapFactory.makeRealmMapName(this.getClass().getName(), this.dataSrv.getRealmName()));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 1);
        }
        object3 = new HashMap();
        for (Object object4 : this.add.values()) {
            object2 = ((SimpleVersionInfo)object4).getOrganization();
            if (object2 == null) continue;
            object = (Long)((HashMap)object3).get(object2);
            if (object == null) {
                object = new Long(0L);
            }
            object = (Long)object + ((SimpleVersionInfo)object4).getDiskSize();
            ((HashMap)object3).put(object2, object);
        }
        for (Object object4 : ((HashMap)object3).keySet()) {
            object2 = this.addRecord.getResourceStore((String)object4);
            ((SpaceAllocatorExt)object2.getDiskStore().getSpaceAllocator()).allocateForce((Long)((HashMap)object3).get(object4));
        }
    }

    private void SEDU(AbstractVersionRecord abstractVersionRecord, AbstractVersionTable abstractVersionTable, String string) {
        Object object;
        if (abstractVersionRecord.getDiskSize() == 0L) {
            object = new File(this.getFileWithHistory(string)).getParentFile();
            long l = SchdTools.calcDiskSize((File)object);
            abstractVersionRecord.setDiskSize(l);
            abstractVersionTable.updateRecord(abstractVersionRecord);
        }
        object = this.rscMan.getNodeByID(abstractVersionRecord.getResourceID()).getAbsolutePath();
        String string2 = string;
        String string3 = File.separator;
        int n = string2.lastIndexOf(string3);
        if (n == -1) {
            string3 = "/";
            n = string2.lastIndexOf(string3);
        }
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        this.add.put(string2, new SimpleVersionInfo(abstractVersionRecord.getResourceID(), abstractVersionRecord.getVersionID(), (String)object, string2, abstractVersionRecord.getDiskSize()));
    }

    @Override
    public int addVersion(ResourceInfo resourceInfo, Resource resource, String string) {
        int n = -1;
        SimpleVersionInfo simpleVersionInfo = null;
        if (resourceInfo == null) {
            return -1;
        }
        switch (resourceInfo.getResourceType()) {
            case 1: {
                CatalogInfoImpl catalogInfoImpl = (CatalogInfoImpl)resourceInfo;
                simpleVersionInfo = this.allocateForce(catalogInfoImpl, resource, string);
                break;
            }
            case 2: {
                ReportInfo reportInfo = (ReportInfo)resourceInfo;
                simpleVersionInfo = this.clearMem(reportInfo, resource, string);
                break;
            }
            case 3: {
                ResultInfoImpl resultInfoImpl = (ResultInfoImpl)resourceInfo;
                if (resource.getID() == -1) {
                    n = this.delEarliestVersion(resultInfoImpl, string);
                    break;
                }
                simpleVersionInfo = this.dataSrv(resultInfoImpl, resource, string);
                break;
            }
            case 4: {
                simpleVersionInfo = this.append((LCInfo)resourceInfo, resource, string);
                break;
            }
        }
        if (simpleVersionInfo != null && simpleVersionInfo.getVersionNumber() != -1) {
            if (this.add != null) {
                this.add.put(simpleVersionInfo.getDiskPath(), simpleVersionInfo);
            }
            n = simpleVersionInfo.getVersionNumber();
        }
        return n;
    }

    @Override
    public void updateVersion(ResourceInfo resourceInfo, int n, int n2, String string) {
        switch (resourceInfo.getResourceType()) {
            case 1: {
                CatalogInfoImpl catalogInfoImpl = (CatalogInfoImpl)resourceInfo;
                this.calcDiskSize(catalogInfoImpl, n, n2, string);
                break;
            }
            case 2: {
                ReportInfo reportInfo = (ReportInfo)resourceInfo;
                this.currentTimeMillis(reportInfo, n, n2, string);
                break;
            }
            case 3: {
                ResultInfoImpl resultInfoImpl = (ResultInfoImpl)resourceInfo;
                this.delRecord(resultInfoImpl, n, n2, string);
                break;
            }
            case 4: {
                this.changeVersionFolderAmount((LCInfo)resourceInfo, n, n2, string);
                break;
            }
        }
    }

    @Override
    public ResourceInfo getVersion(int n, int n2, int n3) {
        ResourceInfo resourceInfo = null;
        switch (n3) {
            case 1: {
                resourceInfo = this.delRecords(n, n2);
                break;
            }
            case 2: {
                resourceInfo = this.delVersionArchiveFolder(n, n2);
                break;
            }
            case 3: {
                resourceInfo = this.delete(n, n2);
                break;
            }
            case 4: {
                resourceInfo = this.delVersionArchive(n, n2);
                break;
            }
        }
        return resourceInfo;
    }

    @Override
    public ResourceInfo getVersionByID(int n, int n2) {
        ResourceInfo resourceInfo = null;
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                resourceInfo = this.deleteDir(n);
                break;
            }
            case 4: {
                break;
            }
        }
        return resourceInfo;
    }

    @Override
    public ResourceInfo getLatestVersion(int n, int n2) {
        ResourceInfo resourceInfo = null;
        switch (n2) {
            case 1: {
                resourceInfo = this.deleteRecord(n);
                break;
            }
            case 2: {
                resourceInfo = this.endsWith(n);
                break;
            }
            case 3: {
                resourceInfo = this.equalsIgnoreCase(n);
                break;
            }
            case 4: {
                resourceInfo = this.deleteRecords(n);
                break;
            }
        }
        return resourceInfo;
    }

    @Override
    public IntKeyHashtable getVersions(int n, int n2) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        switch (n2) {
            case 1: {
                intKeyHashtable = this.getActiveRealm(n);
                break;
            }
            case 2: {
                intKeyHashtable = this.getArchivePath(n);
                break;
            }
            case 3: {
                intKeyHashtable = this.getAuthor(n);
                break;
            }
            case 4: {
                intKeyHashtable = this.getAllRecords(n);
                break;
            }
        }
        return intKeyHashtable;
    }

    @Override
    public boolean removeVersion(int n, int n2, int n3) {
        boolean bl = false;
        String string = this.rscMan.getNodeByID(n).getAbsolutePath();
        switch (n3) {
            case 1: {
                CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
                try {
                    CatalogInfo catalogInfo = (CatalogInfo)this.getVersion(n, n2, 1);
                    this.SEDU.delVersionArchive(catalogInfo.getCatalog());
                    catalogVersionTable.delRecord(n2, n);
                    this.addRecord(string, catalogInfo.getDiskSize(), catalogInfo.getCatalog());
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 2: {
                ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
                try {
                    ReportInfo reportInfo = (ReportInfo)this.getVersion(n, n2, 2);
                    this.addRecord(string, reportInfo.getDiskSize(), reportInfo.getReportFile());
                    this.SEDU.delVersionArchive(reportInfo.getReportFile());
                    reportVersionTable.delRecord(n2, n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 3: {
                ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
                try {
                    Enumeration enumeration;
                    Hashtable hashtable;
                    ResultInfo resultInfo = (ResultInfo)this.getVersion(n, n2, 3);
                    String string2 = resultInfo.getResultFile();
                    if ((string2 == null || string2.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        string2 = ((ResultDetailedInfo)hashtable.get(string3)).getResult();
                    }
                    this.addRecord(string, resultInfo.getDiskSize(), resultInfo.getResultFile());
                    this.SEDU.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string2);
                    resultVersionTableNew.delRecord(n2, n);
                    this.VersionOccupyDisk(resultInfo);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 4: {
                LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
                try {
                    LCInfo lCInfo = (LCInfo)this.getVersion(n, n2, 4);
                    this.addRecord(string, lCInfo.getDiskSize(), lCInfo.getLc());
                    this.SEDU.delVersionArchive(lCInfo.getLc());
                    lCVersionTable.delRecord(n2, n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean removeVersionByID(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (n >= -1) break;
                DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
                try {
                    Enumeration enumeration;
                    Hashtable hashtable;
                    ResultInfo resultInfo = (ResultInfo)this.getVersionByID(n, n2);
                    if (resultInfo == null) break;
                    String string = resultInfo.getResultFile();
                    if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        string = ((ResultDetailedInfo)hashtable.get(string2)).getResult();
                    }
                    this.SEDU.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                    dynamicResultVersionTable.deleteRecord(resultInfo.getName(), resultInfo.getVersionNumber());
                    this.VersionOccupyDisk(resultInfo);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 4: {
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean removeVersions(int n, int n2) {
        boolean bl = false;
        String string = this.rscMan.getNodeByID(n).getAbsolutePath();
        switch (n2) {
            case 1: {
                CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
                try {
                    Vector vector = this.getVersions(n, 1).elements();
                    for (int i = 0; i < vector.size(); ++i) {
                        CatalogInfo catalogInfo = (CatalogInfo)vector.elementAt(i);
                        this.SEDU.delVersionArchive(catalogInfo.getCatalog());
                        this.addRecord(string, catalogInfo.getDiskSize(), catalogInfo.getCatalog());
                    }
                    catalogVersionTable.delRecords(n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 2: {
                ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
                try {
                    Vector vector = this.getVersions(n, 2).elements();
                    for (int i = 0; i < vector.size(); ++i) {
                        ReportInfo reportInfo = (ReportInfo)vector.elementAt(i);
                        this.addRecord(string, reportInfo.getDiskSize(), reportInfo.getReportFile());
                        this.SEDU.delVersionArchive(reportInfo.getReportFile());
                    }
                    reportVersionTable.delRecords(n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 3: {
                ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
                try {
                    ResultInfo resultInfo;
                    int n3;
                    Vector vector = this.getVersions(n, 3).elements();
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        Enumeration enumeration;
                        Hashtable hashtable;
                        resultInfo = (ResultInfo)vector.elementAt(n3);
                        String string2 = resultInfo.getResultFile();
                        if ((string2 == null || string2.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            string2 = ((ResultDetailedInfo)hashtable.get(string3)).getResult();
                        }
                        this.addRecord(string, resultInfo.getDiskSize(), resultInfo.getResultFile());
                        this.SEDU.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string2);
                    }
                    if (n < -1) {
                        this.dataSrv.getDynamicResultVersionTable().deleteRecords(this.dataSrv.getResourceMapTable().getResource(n));
                    } else {
                        resultVersionTableNew.delRecords(n);
                    }
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        resultInfo = (ResultInfo)vector.elementAt(n3);
                        this.VersionOccupyDisk(resultInfo);
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 4: {
                LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
                try {
                    Vector vector = this.getVersions(n, 4).elements();
                    for (LCInfo lCInfo : vector) {
                        this.addRecord(string, lCInfo.getDiskSize(), lCInfo.getLc());
                        this.SEDU.delVersionArchive(lCInfo.getLc());
                    }
                    lCVersionTable.delRecords(n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    private void VersionOccupyDisk(ResultInfo resultInfo) {
        if (resultInfo.getParamFile() == null || resultInfo.getParamFile().trim().length() == 0) {
            return;
        }
        try {
            ParameterFileManager.getInstance().delete(resultInfo.getParamFile());
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
        }
    }

    @Override
    public boolean adjustVersions(int n, int n2, int n3) {
        int n4 = 0;
        switch (n2) {
            case 1: {
                CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
                for (n4 = catalogVersionTable.getVersionAmount(n); n4 > n3; --n4) {
                    CatalogInfo catalogInfo = (CatalogInfo)this.elementAt(n);
                    this.SEDU.delVersionArchive(catalogInfo.getCatalog());
                    catalogVersionTable.delEarliestVersion(n);
                }
                break;
            }
            case 2: {
                ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
                for (n4 = reportVersionTable.getVersionAmount(n); n4 > n3; --n4) {
                    ReportInfo reportInfo = (ReportInfo)this.equals(n);
                    this.SEDU.delVersionArchive(reportInfo.getReportFile());
                    reportVersionTable.delEarliestVersion(n);
                }
                break;
            }
            case 3: {
                if (n < -1) {
                    String string = this.dataSrv.getResourceMapTable().getResource(n);
                    DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
                    for (n4 = dynamicResultVersionTable.getVersionAmount(string); n4 > n3; --n4) {
                        Enumeration enumeration;
                        Hashtable hashtable;
                        ResultInfo resultInfo = (ResultInfo)this.getAbsolutePath(n);
                        String string2 = resultInfo.getResultFile();
                        if ((string2 == null || string2.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            string2 = ((ResultDetailedInfo)hashtable.get(string3)).getResult();
                        }
                        this.SEDU.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string2);
                        dynamicResultVersionTable.delEarliestVersion(string);
                    }
                } else {
                    ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
                    for (n4 = resultVersionTableNew.getVersionAmount(n); n4 > n3; --n4) {
                        Enumeration enumeration;
                        Hashtable hashtable;
                        ResultInfo resultInfo = (ResultInfo)this.getAbsolutePath(n);
                        String string = resultInfo.getResultFile();
                        if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            string = ((ResultDetailedInfo)hashtable.get(string4)).getResult();
                        }
                        this.SEDU.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                        resultVersionTableNew.delEarliestVersion(n);
                    }
                }
                break;
            }
            case 4: {
                LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
                for (n4 = lCVersionTable.getVersionAmount(n); n4 > n3; --n4) {
                    LCInfo lCInfo = this.elements(n);
                    this.SEDU.delVersionArchive(lCInfo.getLc());
                    lCVersionTable.delEarliestVersion(n);
                }
                break;
            }
        }
        return false;
    }

    private boolean add(String string, long l) {
        if (this.addRecord == null) {
            return true;
        }
        JRServerResourceStore jRServerResourceStore = this.addRecord.getResourceStore(CSUtil.parseVirtualResourcePath(string)[0]);
        return jRServerResourceStore.getDiskStore().getSpaceAllocator().allocate(l);
    }

    private void addRecord(String string, long l, String string2) {
        if (this.addRecord != null) {
            JRServerResourceStore jRServerResourceStore = this.addRecord.getResourceStore(CSUtil.parseVirtualResourcePath(string)[0]);
            jRServerResourceStore.getDiskStore().getSpaceAllocator().deallocate(l);
            String string3 = this.getFileWithoutHistDir(string2);
            string3 = string3.substring(0, string3.lastIndexOf(File.separator));
            this.add.remove(string3);
        }
    }

    private void allocate(int n, int n2, long l, long l2, String string, String string2) {
        if (this.addRecord != null) {
            String string3 = this.rscMan.getNodeByID(n).getAbsolutePath();
            JRServerResourceStore jRServerResourceStore = this.addRecord.getResourceStore(CSUtil.parseVirtualResourcePath(string3)[0]);
            ((SpaceAllocatorExt)jRServerResourceStore.getDiskStore().getSpaceAllocator()).allocateForce(l - l2);
            String string4 = this.getFileWithoutHistDir(string);
            string4 = string4.substring(0, string4.lastIndexOf(File.separator));
            SimpleVersionInfo simpleVersionInfo = new SimpleVersionInfo(n, n2, string3, string4, l);
            this.add.put(string4, simpleVersionInfo);
            if (!string.equals(string2)) {
                String string5 = this.getFileWithoutHistDir(string2);
                string5 = string5.substring(0, string5.lastIndexOf(File.separator));
                this.add.remove(string5);
            }
        }
    }

    private SimpleVersionInfo allocateForce(CatalogInfo catalogInfo, Resource resource, String string) {
        CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
        int n = -1;
        File file = new File(catalogInfo.getCatalog()).getParentFile();
        long l = SchdTools.calcDiskSize(file);
        String string2 = resource.getAbsolutePath();
        String string3 = this.getFileWithoutHistDir(catalogInfo.getCatalog());
        String string4 = string3.substring(0, string3.lastIndexOf(File.separator));
        if (this.add(string2, l)) {
            try {
                n = catalogVersionTable.addRecord("", resource.getID(), string, System.currentTimeMillis(), "", 0L, string3, l);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            SchdTools.deleteDir(file.getAbsolutePath());
        }
        return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
    }

    private SimpleVersionInfo append(LCInfo lCInfo, Resource resource, String string) {
        LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
        int n = -1;
        File file = new File(lCInfo.getLc()).getParentFile();
        long l = SchdTools.calcDiskSize(file);
        String string2 = resource.getAbsolutePath();
        String string3 = this.getFileWithoutHistDir(lCInfo.getLc());
        String string4 = string3.substring(0, string3.lastIndexOf(File.separator));
        if (this.add(string2, l)) {
            try {
                n = lCVersionTable.addRecord("", resource.getID(), string, System.currentTimeMillis(), this.getFileWithoutHistDir(lCInfo.getLc()), l);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            SchdTools.deleteDir(file.getAbsolutePath());
        }
        return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
    }

    private void calcDiskSize(CatalogInfo catalogInfo, int n, int n2, String string) {
        CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
        CatalogInfo catalogInfo2 = (CatalogInfo)this.delRecords(n, n2);
        String string2 = catalogInfo2.getCatalog();
        String string3 = catalogInfo.getCatalog();
        long l = catalogInfo2.getDiskSize();
        if (!string2.trim().equalsIgnoreCase(string3.trim())) {
            this.SEDU.delVersionArchive(catalogInfo2.getCatalog());
        }
        CatalogVersionRecord catalogVersionRecord = new CatalogVersionRecord(n2, catalogInfo.getName(), n, catalogInfo.getCreator(), catalogInfo.getCreatedTime(), string, System.currentTimeMillis(), this.getFileWithoutHistDir(catalogInfo.getCatalog()), catalogInfo.getDiskSize());
        catalogVersionTable.updateRecord(catalogVersionRecord);
        this.allocate(n, n2, catalogInfo.getDiskSize(), l, string3, string2);
    }

    private void changeVersionFolderAmount(LCInfo lCInfo, int n, int n2, String string) {
        LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
        LCInfo lCInfo2 = (LCInfo)this.delVersionArchive(n, n2);
        String string2 = lCInfo.getLc();
        String string3 = lCInfo2.getLc();
        if (!string3.trim().equalsIgnoreCase(string2.trim())) {
            this.SEDU.delVersionArchive(lCInfo2.getLc());
        }
        LCVersionRecord lCVersionRecord = new LCVersionRecord(n2, lCInfo.getName(), n, lCInfo.getCreator(), lCInfo.getCreatedTime(), string, System.currentTimeMillis(), this.getFileWithoutHistDir(lCInfo.getLc()), lCInfo.getAuthor(), lCInfo.getAuthorEmail(), lCInfo.getBuildinDescription(), lCInfo.getDiskSize());
        lCVersionTable.updateRecord(lCVersionRecord);
        this.allocate(n, n2, lCInfo.getDiskSize(), lCInfo2.getDiskSize(), string2, string3);
    }

    private SimpleVersionInfo clearMem(ReportInfo reportInfo, Resource resource, String string) {
        ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
        int n = -1;
        File file = new File(reportInfo.getReportFile()).getParentFile();
        long l = SchdTools.calcDiskSize(file);
        String string2 = resource.getAbsolutePath();
        String string3 = this.getFileWithoutHistDir(reportInfo.getReportFile());
        String string4 = string3.substring(0, string3.lastIndexOf(File.separator));
        if (this.add(string2, l)) {
            try {
                n = reportVersionTable.addRecord(reportInfo.getName(), resource.getID(), string, System.currentTimeMillis(), "", 0L, string3, l);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            SchdTools.deleteDir(file.getAbsolutePath());
        }
        return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
    }

    private void currentTimeMillis(ReportInfo reportInfo, int n, int n2, String string) {
        ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
        ReportInfo reportInfo2 = (ReportInfo)this.delVersionArchiveFolder(n, n2);
        String string2 = reportInfo.getReportFile();
        String string3 = reportInfo2.getReportFile();
        if (!string3.trim().equalsIgnoreCase(string2.trim())) {
            this.SEDU.delVersionArchive(reportInfo2.getReportFile());
        }
        ReportVersionRecord reportVersionRecord = new ReportVersionRecord(n2, reportInfo.getName(), n, reportInfo.getCreator(), reportInfo.getCreatedTime(), string, System.currentTimeMillis(), this.getFileWithoutHistDir(reportInfo.getReportFile()), reportInfo.getDiskSize());
        reportVersionTable.updateRecord(reportVersionRecord);
        this.allocate(n, n2, reportInfo.getDiskSize(), reportInfo2.getDiskSize(), string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SimpleVersionInfo dataSrv(ResultInfo resultInfo, Resource resource, String string) {
        ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
        int n = -1;
        File file = new File(this.VersionOccupyDisk + resultInfo.getResultFile()).getParentFile();
        long l = SchdTools.calcDiskSize(file);
        String string2 = resource.getAbsolutePath();
        String string3 = this.VersionOccupyDisk + resultInfo.getResultFile();
        String string4 = string3.substring(0, string3.lastIndexOf(File.separator));
        if (this.add(string2, l)) {
            try {
                long l2 = 0L;
                if (resultInfo.getExpireationTime() != null) {
                    l2 = resultInfo.getExpireationTime().getTime();
                }
                n = resultVersionTableNew.addRecord(resultInfo.getName(), resource.getID(), string, System.currentTimeMillis(), "", 0L, resultInfo.getCatalogVerNum(), resultInfo.getCatalogResourceId(), resultInfo.getReportVerNum(), resultInfo.getReportResourceId(), resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getResultFormats(), resultInfo.getLaunchType(), resultInfo.getTaskId(), l2, resultInfo.getExpire(), resultInfo.getExpireationMethod(), resultInfo.getSpecifiedFolder(), resultInfo.getReportAmount(), SchdTools.calcDiskSize(new File(this.VersionOccupyDisk + resultInfo.getResultFile()).getParentFile()));
                Hashtable hashtable = resultInfo.getSheetsResultDetails();
                if (hashtable == null || hashtable.size() <= 0) return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
                ResultDetailTable resultDetailTable = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string5);
                    String string6 = resultDetailedInfo.getResult();
                    if (string6 == null) continue;
                    resultDetailTable.addRecord(resource.getID(), n, string5, this.deallocate(resultDetailedInfo, string5), string6, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                }
                return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
            }
        } else {
            SchdTools.deleteDir(file.getAbsolutePath());
        }
        return new SimpleVersionInfo(resource.getID(), n, string2, string4, l);
    }

    private String deallocate(ResultDetailedInfo resultDetailedInfo, String string) {
        String string2 = resultDetailedInfo.getReportDisplayname();
        if (string2 == null && !string.equalsIgnoreCase("jrs.rst_result") && !string.equalsIgnoreCase("jrs.rsd_result")) {
            string2 = string;
        }
        return string2;
    }

    private int delEarliestVersion(ResultInfo resultInfo, String string) {
        DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
        int n = -1;
        long l = 0L;
        if (resultInfo.getExpireationTime() != null) {
            l = resultInfo.getExpireationTime().getTime();
        }
        n = dynamicResultVersionTable.addRecord(resultInfo.getName(), string, System.currentTimeMillis(), resultInfo.getCatalogVerNum(), resultInfo.getCatalogResourceId(), resultInfo.getReportVerNum(), resultInfo.getReportResourceId(), resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getResultFormats(), resultInfo.getLaunchType(), resultInfo.getTaskId(), l, resultInfo.getExpire(), resultInfo.getExpireationMethod(), resultInfo.getReportAmount());
        Hashtable hashtable = resultInfo.getSheetsResultDetails();
        if (hashtable != null && hashtable.size() > 0) {
            DynamicResultDetailTable dynamicResultDetailTable = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string2);
                String string3 = resultDetailedInfo.getResult();
                if (string3 == null) continue;
                try {
                    dynamicResultDetailTable.addRecord(resultInfo.getName(), n, string2, this.deallocate(resultDetailedInfo, string2), string3, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException.getMessage());
                }
            }
        }
        return n;
    }

    private void delRecord(ResultInfo resultInfo, int n, int n2, String string) {
        ResultInfo resultInfo2 = (ResultInfo)this.delete(n, n2);
        String string2 = resultInfo.getResultFile();
        String string3 = resultInfo2.getResultFile();
        if (!string3.trim().equalsIgnoreCase(string2.trim())) {
            this.SEDU.delVersionArchive(resultInfo2.getResultFile());
        }
        ResultVersionRecord resultVersionRecord = new ResultVersionRecord(n2, resultInfo.getName(), n, resultInfo.getCreator(), resultInfo.getCreatedTime(), string, System.currentTimeMillis(), resultInfo.getCatalogVerNum(), resultInfo.getCatalogResourceId(), resultInfo.getReportVerNum(), resultInfo.getReportResourceId(), resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getResultFormats(), resultInfo.getLaunchType(), resultInfo.getTaskId(), resultInfo.getExpireationTime().getTime(), resultInfo.getExpire(), resultInfo.getExpireationMethod(), resultInfo.getSpecifiedFolder());
        resultVersionRecord.setReportAmount(resultInfo.getReportAmount());
        if (n >= 0) {
            try {
                ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
                resultVersionTableNew.updateRecord(resultVersionRecord);
                Hashtable hashtable = resultInfo.getSheetsResultDetails();
                if (hashtable != null && hashtable.size() > 0) {
                    ResultDetailTable resultDetailTable = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable();
                    resultDetailTable.delRecord(n2, n);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string4);
                        String string5 = resultDetailedInfo.getResult();
                        if (string5 == null) continue;
                        resultDetailTable.addRecord(n, n2, string4, this.deallocate(resultDetailedInfo, string4), string5, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                    }
                }
                this.allocate(n, n2, resultInfo.getDiskSize(), resultInfo2.getDiskSize(), string2, string3);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
            dynamicResultVersionTable.updateRecord(resultVersionRecord);
            Hashtable hashtable = resultInfo.getSheetsResultDetails();
            if (hashtable != null && hashtable.size() > 0) {
                DynamicResultDetailTable dynamicResultDetailTable = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable();
                dynamicResultDetailTable.delRecord(resultInfo.getName(), n2);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string6 = (String)enumeration.nextElement();
                    ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string6);
                    String string7 = resultDetailedInfo.getResult();
                    if (string7 == null) continue;
                    try {
                        dynamicResultDetailTable.addRecord(resultInfo.getName(), n2, string6, this.deallocate(resultDetailedInfo, string6), string7, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException.getMessage());
                    }
                }
            }
        }
    }

    private ResourceInfo delRecords(int n, int n2) {
        CatalogInfo catalogInfo = new CatalogInfoImpl();
        CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
        CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)catalogVersionTable.getRecord(n2, n);
        if (catalogVersionRecord != null) {
            catalogInfo = this.getCatalog(catalogVersionRecord);
        }
        return catalogInfo;
    }

    private ResourceInfo delVersionArchive(int n, int n2) {
        LCInfo lCInfo = new LCInfoImpl();
        LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
        LCVersionRecord lCVersionRecord = (LCVersionRecord)lCVersionTable.getRecord(n2, n);
        if (lCVersionRecord != null) {
            lCInfo = this.getCatalogFile(lCVersionRecord);
        }
        return lCInfo;
    }

    private ResourceInfo delVersionArchiveFolder(int n, int n2) {
        ReportInfo reportInfo = new ReportInfoImpl();
        ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)reportVersionTable.getRecord(n2, n);
        if (reportVersionRecord != null) {
            reportInfo = this.getBuildinDescription(reportVersionRecord);
        }
        return reportInfo;
    }

    private ResourceInfo delete(int n, int n2) {
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
            ResultVersionRecord resultVersionRecord = dynamicResultVersionTable.getRecord(this.dataSrv.getResourceMapTable().getResource(n), n2);
            resultInfo = this.getAuthorEmail(resultVersionRecord);
            resultInfo = this.get(resultInfo, dynamicResultVersionTable);
        } else {
            ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
            ResultVersionRecord resultVersionRecord = (ResultVersionRecord)resultVersionTableNew.getRecord(n2, n);
            resultInfo = this.getAuthorEmail(resultVersionRecord);
            resultInfo = this.exists(resultInfo, resultVersionTableNew);
        }
        return resultInfo;
    }

    private ResourceInfo deleteDir(int n) {
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
            ResultVersionRecord resultVersionRecord = dynamicResultVersionTable.getRecordByID(n);
            if (resultVersionRecord != null) {
                resultInfo = this.getAuthorEmail(resultVersionRecord);
                resultInfo = this.get(resultInfo, dynamicResultVersionTable);
            }
        } else {
            ResultVersionRecord resultVersionRecord = new ResultVersionRecord();
        }
        return resultInfo;
    }

    public int getDynamicResultVersionId(String string, int n) {
        int n2 = -1;
        DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
        n2 = dynamicResultVersionTable.getVersionRecordId(string, n);
        return n2;
    }

    private ResourceInfo deleteRecord(int n) {
        CatalogInfo catalogInfo = new CatalogInfoImpl();
        CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
        CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)catalogVersionTable.getLatestVerRec(n);
        if (catalogVersionRecord != null) {
            catalogInfo = this.getCatalog(catalogVersionRecord);
            return catalogInfo;
        }
        return null;
    }

    private ResourceInfo deleteRecords(int n) {
        LCInfo lCInfo = new LCInfoImpl();
        LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
        LCVersionRecord lCVersionRecord = (LCVersionRecord)lCVersionTable.getLatestVerRec(n);
        if (lCVersionRecord != null) {
            lCInfo = this.getCatalogFile(lCVersionRecord);
            return lCInfo;
        }
        return null;
    }

    private ResourceInfo elementAt(int n) {
        CatalogInfo catalogInfo = new CatalogInfoImpl();
        CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
        CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)catalogVersionTable.getEarliestVerRec(n);
        if (catalogVersionRecord != null) {
            catalogInfo = this.getCatalog(catalogVersionRecord);
            return catalogInfo;
        }
        return null;
    }

    private LCInfo elements(int n) {
        LCInfo lCInfo = new LCInfoImpl();
        LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
        LCVersionRecord lCVersionRecord = (LCVersionRecord)lCVersionTable.getEarliestVerRec(n);
        if (lCVersionRecord != null) {
            lCInfo = this.getCatalogFile(lCVersionRecord);
            return lCInfo;
        }
        return null;
    }

    private ResourceInfo endsWith(int n) {
        ReportInfo reportInfo = new ReportInfoImpl();
        ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)reportVersionTable.getLatestVerRec(n);
        if (reportVersionRecord != null) {
            reportInfo = this.getBuildinDescription(reportVersionRecord);
            return reportInfo;
        }
        return null;
    }

    private ResourceInfo equals(int n) {
        ReportInfo reportInfo = new ReportInfoImpl();
        ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)reportVersionTable.getEarliestVerRec(n);
        if (reportVersionRecord != null) {
            reportInfo = this.getBuildinDescription(reportVersionRecord);
            return reportInfo;
        }
        return null;
    }

    private ResourceInfo equalsIgnoreCase(int n) {
        ResultInfo resultInfo = new ResultInfoImpl();
        ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
        ResultVersionRecord resultVersionRecord = (ResultVersionRecord)resultVersionTableNew.getLatestVerRec(n);
        if (resultVersionRecord != null) {
            resultInfo = this.getAuthorEmail(resultVersionRecord);
            resultInfo = this.exists(resultInfo, resultVersionTableNew);
            return resultInfo;
        }
        return null;
    }

    private ResultInfo exists(ResultInfo resultInfo, ResultVersionTableNew resultVersionTableNew) {
        Vector vector = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable().getResultFiles(resultInfo.getResID(), resultInfo.getVersionNumber());
        if (vector != null && vector.size() > 0) {
            Hashtable<String, ResultDetailRecord> hashtable = resultInfo.getSheetsResultDetails();
            if (hashtable == null) {
                hashtable = new Hashtable<String, ResultDetailRecord>();
            }
            for (int i = 0; i < vector.size(); ++i) {
                ResultDetailRecord resultDetailRecord = (ResultDetailRecord)vector.elementAt(i);
                String string = resultDetailRecord.getReport();
                hashtable.put(string, resultDetailRecord);
            }
            resultInfo.setSheetsResultDetails(hashtable);
        }
        return resultInfo;
    }

    private ResultInfo get(ResultInfo resultInfo, DynamicResultVersionTable dynamicResultVersionTable) {
        Vector vector = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable().getResultFiles(resultInfo.getName(), resultInfo.getVersionNumber());
        if (vector != null && vector.size() > 0) {
            Hashtable<String, DynamicResultDetailRecord> hashtable = resultInfo.getSheetsResultDetails();
            if (hashtable == null) {
                hashtable = new Hashtable<String, DynamicResultDetailRecord>();
            }
            for (int i = 0; i < vector.size(); ++i) {
                DynamicResultDetailRecord dynamicResultDetailRecord = (DynamicResultDetailRecord)vector.elementAt(i);
                String string = dynamicResultDetailRecord.getReport();
                hashtable.put(string, dynamicResultDetailRecord);
            }
            resultInfo.setSheetsResultDetails(hashtable);
        }
        return resultInfo;
    }

    private ResourceInfo getAbsolutePath(int n) {
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
            ResultVersionRecord resultVersionRecord = dynamicResultVersionTable.getEarliestVerRec(this.dataSrv.getResourceMapTable().getResource(n));
            if (resultVersionRecord != null) {
                resultInfo = this.getAuthorEmail(resultVersionRecord);
                resultInfo = this.get(resultInfo, dynamicResultVersionTable);
            }
        } else {
            ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
            ResultVersionRecord resultVersionRecord = (ResultVersionRecord)resultVersionTableNew.getEarliestVerRec(n);
            if (resultVersionRecord != null) {
                resultInfo = this.getAuthorEmail(resultVersionRecord);
                resultInfo = this.exists(resultInfo, resultVersionTableNew);
            }
        }
        return resultInfo;
    }

    private IntKeyHashtable getActiveRealm(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        CatalogVersionTable catalogVersionTable = this.dataSrv.getCatalogVersionTable();
        try {
            vector = catalogVersionTable.getAllRecords(n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        for (int i = 0; i < vector.size(); ++i) {
            CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)vector.elementAt(i);
            CatalogInfo catalogInfo = this.getCatalog(catalogVersionRecord);
            intKeyHashtable.put(catalogInfo.getVersionNumber(), (Object)catalogInfo);
        }
        return intKeyHashtable;
    }

    private IntKeyHashtable getAllRecords(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        LCVersionTable lCVersionTable = this.dataSrv.getLcVersionTable();
        try {
            vector = lCVersionTable.getAllRecords(n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        for (int i = 0; i < vector.size(); ++i) {
            LCVersionRecord lCVersionRecord = (LCVersionRecord)vector.elementAt(i);
            LCInfo lCInfo = this.getCatalogFile(lCVersionRecord);
            intKeyHashtable.put(lCInfo.getVersionNumber(), (Object)lCInfo);
        }
        return intKeyHashtable;
    }

    private IntKeyHashtable getArchivePath(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        ReportInfo reportInfo = null;
        ReportVersionTable reportVersionTable = this.dataSrv.getReportVersionTable();
        try {
            vector = reportVersionTable.getAllRecords(n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        for (int i = 0; i < vector.size(); ++i) {
            ReportVersionRecord reportVersionRecord = (ReportVersionRecord)vector.elementAt(i);
            if (reportVersionRecord == null) continue;
            reportInfo = this.getBuildinDescription(reportVersionRecord);
            intKeyHashtable.put(reportInfo.getVersionNumber(), (Object)reportInfo);
        }
        return intKeyHashtable;
    }

    private IntKeyHashtable getAuthor(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
            String string = this.dataSrv.getResourceMapTable().getResource(n);
            vector = dynamicResultVersionTable.getAllRecords(string);
            for (int i = 0; i < vector.size(); ++i) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(i);
                resultInfo = this.getAuthorEmail(resultVersionRecord);
                resultInfo = this.get(resultInfo, dynamicResultVersionTable);
                intKeyHashtable.put(resultInfo.getVersionNumber(), (Object)resultInfo);
            }
        } else {
            ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
            try {
                vector = resultVersionTableNew.getAllRecords(n);
                for (int i = 0; i < vector.size(); ++i) {
                    ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(i);
                    resultInfo = this.getAuthorEmail(resultVersionRecord);
                    resultInfo = this.exists(resultInfo, resultVersionTableNew);
                    intKeyHashtable.put(resultInfo.getVersionNumber(), (Object)resultInfo);
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return intKeyHashtable;
    }

    @Override
    public void setVersionFolderManager(String string) {
        this.SEDU = new VersionFolderManager(string);
    }

    @Override
    public VersionFolderManager getVersionFolderManager() {
        return this.SEDU;
    }

    @Override
    public void chgVerFldNum(int n) {
        this.SEDU.changeVersionFolderAmount(n);
    }

    @Override
    public String getArchivePath(String string) {
        return this.SEDU.getArchivePath(string);
    }

    @Override
    public void setSchedulingService(SchedulingService schedulingService) {
        this.schdServ = schedulingService;
    }

    public void setResourceTreeManager(ResourceTreeManager resourceTreeManager) {
        this.rscMan = resourceTreeManager;
    }

    @Override
    public boolean hasResultWithTaskID(String string) {
        return this.dataSrv.getResultVersionTableNew().hasResultWithTaskID(string);
    }

    public void clearMem() {
        this.SEDU.clearMem();
        this.SEDU = null;
        this.schdServ = null;
        this.rscMan = null;
    }

    public String getFileWithHistory(String string) {
        String string2 = string;
        string2 = this.VersionOccupyDisk + string2;
        return string2;
    }

    public String getFileWithoutHistDir(String string) {
        String string2 = string;
        int n = this.VersionOccupyDisk.length();
        if (string2.startsWith(this.VersionOccupyDisk)) {
            string2 = string2.substring(n);
        }
        return string2;
    }

    @Override
    public void removeResultsByCatalog(int n) {
        DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
        Vector vector = null;
        vector = dynamicResultVersionTable.getRecordsByCatalog(n);
        if (vector != null && vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(i);
                this.SEDU.delVersionArchive(this.getFileWithHistory(resultVersionRecord.getResultFile()));
                dynamicResultVersionTable.deleteRecord(resultVersionRecord.getVersionName(), resultVersionRecord.getVersionID());
            }
        }
    }

    @Override
    public Vector getResultByReport(int n) {
        Vector<ResultInfo> vector = new Vector<ResultInfo>();
        ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
        Vector vector2 = resultVersionTableNew.getRecordsByReport(n);
        ResultInfo resultInfo = null;
        if (vector2 != null && vector2.size() != 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector2.elementAt(i);
                resultInfo = this.getAuthorEmail(resultVersionRecord);
                vector.add(resultInfo);
            }
        }
        return vector;
    }

    @Override
    public Vector getResultByCatalog(int n) {
        Vector<ResultInfo> vector = new Vector<ResultInfo>();
        ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
        Vector vector2 = resultVersionTableNew.getRecordsByCatalog(n);
        ResultInfo resultInfo = null;
        if (vector2 != null && vector2.size() != 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector2.elementAt(i);
                resultInfo = this.getAuthorEmail(resultVersionRecord);
                vector.add(resultInfo);
            }
        }
        return vector;
    }

    @Override
    public void expireDynamicResultDelete() {
        DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
        Vector vector = dynamicResultVersionTable.getExpiredVersions();
        if (vector != null && vector.size() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Enumeration enumeration;
                Hashtable hashtable;
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(i);
                ResultInfo resultInfo = this.getAuthorEmail(resultVersionRecord);
                String string = resultInfo.getResultFile();
                if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    string = ((ResultDetailedInfo)hashtable.get(string2)).getResult();
                }
                this.SEDU.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                this.VersionOccupyDisk(resultInfo);
                dynamicResultVersionTable.deleteRecord(resultVersionRecord.getReportName(), resultVersionRecord.getVersionID());
            }
        }
    }

    private ResultInfo getAuthorEmail(ResultVersionRecord resultVersionRecord) {
        if (resultVersionRecord == null) {
            return null;
        }
        ResultInfoImpl resultInfoImpl = new ResultInfoImpl();
        resultInfoImpl.setVersionNumber(resultVersionRecord.getVersionID());
        resultInfoImpl.setName(resultVersionRecord.getVersionName());
        resultInfoImpl.setCreator(resultVersionRecord.getCreator());
        resultInfoImpl.setCreatedTime(resultVersionRecord.getCreatedTime());
        resultInfoImpl.setCatalogVerNum(resultVersionRecord.getCatalogVerNum());
        resultInfoImpl.setCatalogReourceId(resultVersionRecord.getCatalogResNum());
        resultInfoImpl.setReportVerNum(resultVersionRecord.getReportVerNum());
        resultInfoImpl.setReportResourceId(resultVersionRecord.getReportResNum());
        resultInfoImpl.setParamFile(resultVersionRecord.getParamFile());
        resultInfoImpl.setResultFile(resultVersionRecord.getResultFile());
        resultInfoImpl.setResultFormats(resultVersionRecord.getResultFmts());
        resultInfoImpl.setLaunchType(resultVersionRecord.getLaunchType());
        resultInfoImpl.setTaskId(resultVersionRecord.getTaskID());
        resultInfoImpl.setExpireationTime(new Date(resultVersionRecord.getExpirationTime()));
        resultInfoImpl.setExpire(resultVersionRecord.getExpire());
        resultInfoImpl.setExpireationMethod(resultVersionRecord.getExpireationMethod());
        resultInfoImpl.setSpecifiedFolder(resultVersionRecord.getSpecifiedFolder());
        resultInfoImpl.setReportAmount(resultVersionRecord.getReportAmount());
        resultInfoImpl.setResID(resultVersionRecord.getResourceID());
        resultInfoImpl.setDiskSize(resultVersionRecord.getDiskSize());
        return resultInfoImpl;
    }

    private ReportInfo getBuildinDescription(ReportVersionRecord reportVersionRecord) {
        ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
        reportInfoImpl.setVersionNumber(reportVersionRecord.getVersionID());
        reportInfoImpl.setName(reportVersionRecord.getVersionName());
        reportInfoImpl.setCreator(reportVersionRecord.getCreator());
        reportInfoImpl.setCreatedTime(reportVersionRecord.getCreatedTime());
        reportInfoImpl.setReportFile(this.getFileWithHistory(reportVersionRecord.getReportFile()));
        reportInfoImpl.setDiskSize(reportVersionRecord.getDiskSize());
        return reportInfoImpl;
    }

    private CatalogInfo getCatalog(CatalogVersionRecord catalogVersionRecord) {
        CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
        catalogInfoImpl.setVersionNumber(catalogVersionRecord.getVersionID());
        catalogInfoImpl.setName(catalogVersionRecord.getVersionName());
        catalogInfoImpl.setCreator(catalogVersionRecord.getCreator());
        catalogInfoImpl.setCreatedTime(catalogVersionRecord.getCreatedTime());
        catalogInfoImpl.setCatalog(this.getFileWithHistory(catalogVersionRecord.getCatalogFile()));
        catalogInfoImpl.setDiskSize(catalogVersionRecord.getDiskSize());
        return catalogInfoImpl;
    }

    private LCInfo getCatalogFile(LCVersionRecord lCVersionRecord) {
        LCInfoImpl lCInfoImpl = new LCInfoImpl();
        lCInfoImpl.setVersionNumber(lCVersionRecord.getVersionID());
        lCInfoImpl.setName(lCVersionRecord.getVersionName());
        lCInfoImpl.setCreator(lCVersionRecord.getCreator());
        lCInfoImpl.setCreatedTime(lCVersionRecord.getCreatedTime());
        lCInfoImpl.setLc(this.getFileWithHistory(lCVersionRecord.getLcFile()));
        lCInfoImpl.setAuthor(lCVersionRecord.getAuthor());
        lCInfoImpl.setAuthorEmail(lCVersionRecord.getAuthorEmail());
        lCInfoImpl.setBuildinDescription(lCVersionRecord.getBuildinDescription());
        lCInfoImpl.setDiskSize(lCVersionRecord.getDiskSize());
        return lCInfoImpl;
    }

    @Override
    public void updateViewedFormats(int n, String string, int n2, String string2, long l) {
        if (n == -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.dataSrv.getDynamicResultVersionTable();
            DynamicResultDetailTable dynamicResultDetailTable = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable();
            dynamicResultDetailTable.updateViewedFormats(string, n2, string2, l);
        } else {
            ResultVersionTableNew resultVersionTableNew = this.dataSrv.getResultVersionTableNew();
            ResultDetailTable resultDetailTable = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable();
            resultDetailTable.updateViewedFormats(n, n2, string2, l);
        }
    }

    public SimpleVersionInfo getResourceVersionByDiskPath(String string) {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (!string.startsWith(this.VersionOccupyDisk)) {
            return null;
        }
        if (file.isDirectory()) {
            string2 = string;
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else {
            string2 = string.substring(0, string.lastIndexOf(File.separator));
        }
        string2 = string2.substring(this.VersionOccupyDisk.length());
        return (SimpleVersionInfo)this.add.get(string2);
    }
}

