/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import jet.JSRuntimeException;
import jet.server.api.Authenticator;
import jet.server.api.ExpiryListener;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.api.rmi.RemoteUserSessionManager;
import jet.server.jrrmisvr.JRAuthenticator;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrserver.rmi.JRRemoteAuthenticator;

public class JRUserSessionManager
implements UserSessionManager {
    private RemoteUserSessionManager SEDU = null;
    protected Authenticator authenticator = null;
    protected Hashtable htHttpSessions = new Hashtable(4);
    protected Hashtable htSessions = new Hashtable(4);
    private List add = new ArrayList();

    public JRUserSessionManager(RemoteUserSessionManager remoteUserSessionManager) {
        this.SEDU = remoteUserSessionManager;
    }

    @Override
    public void setAuthenticator(Authenticator authenticator) {
        try {
            this.SEDU.setAuthenticator(new JRRemoteAuthenticator(authenticator));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public Authenticator getAuthenticator() {
        try {
            if (this.authenticator == null) {
                this.authenticator = new JRAuthenticator(this.SEDU.getAuthenticator());
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return this.authenticator;
    }

    @Override
    public void setDefaultMaxInactiveInterval(int n) {
        try {
            this.SEDU.setDefaultMaxInactiveInterval(n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public int getDefaultMaxInactiveInterval() {
        try {
            return this.SEDU.getDefaultMaxInactiveInterval();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0;
        }
    }

    @Override
    public UserSession login(String string, String string2, String string3, Object object) throws TooManyUsersException {
        try {
            UserSession userSession = null;
            userSession = !this.needSecurity() ? this.SEDU.login(string, "", "") : this.SEDU.login(string, string2, string3);
            if (userSession != null && this.needSecurity()) {
                this.htHttpSessions.put(userSession.getID(), object);
                this.htSessions.put(userSession.getID(), new Long(System.currentTimeMillis()));
            }
            return userSession;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new JSRuntimeException(remoteException.getMessage());
        }
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl, boolean bl2) throws TooManyUsersException {
        try {
            UserSession userSession = null;
            userSession = !this.needSecurity() ? this.SEDU.login(string, "", "", false, false) : this.SEDU.login(string, string2, string3, bl, bl2);
            if (userSession != null && this.needSecurity()) {
                this.htHttpSessions.put(userSession.getID(), object);
                this.htSessions.put(userSession.getID(), new Long(System.currentTimeMillis()));
            }
            return userSession;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new JSRuntimeException(remoteException.getMessage());
        }
    }

    @Override
    public UserSession loginExternalAuthorized(String string, String string2, Object object) throws TooManyUsersException {
        try {
            UserSession userSession = this.SEDU.loginExternalAuthorized(string, string2);
            if (userSession != null) {
                this.htHttpSessions.put(userSession.getID(), object);
                this.htSessions.put(userSession.getID(), new Long(System.currentTimeMillis()));
            }
            return userSession;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new JSRuntimeException(remoteException.getMessage());
        }
    }

    @Override
    public void logout(UserSession userSession) {
        try {
            String string = userSession.getID();
            this.SEDU.logout(string);
            this.htHttpSessions.remove(string);
            this.htSessions.remove(string);
            for (ExpiryListener expiryListener : this.add) {
                try {
                    expiryListener.expire(userSession);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public UserSession getUserSession(String string) {
        try {
            return this.SEDU.getUserSession(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public Enumeration getAllUserSessions() {
        try {
            return this.SEDU.getAllUserSessions().elements();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public Enumeration getAllWaitUserSessions() {
        try {
            return this.SEDU.getAllWaitUserSessions().elements();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void refreshLastAccessTime(String string) throws InvalidUserSessionException {
        try {
            this.SEDU.refreshLastAccessTime(string);
            this.htSessions.put(string, new Long(System.currentTimeMillis()));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new InvalidUserSessionException(remoteException);
        }
    }

    @Override
    public boolean isWait(String string) {
        try {
            return this.SEDU.isWait(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public void putSessions(UserSession userSession) {
        try {
            String string = userSession.getID();
            this.SEDU.putSessions(string);
            Object object = this.getExtObj(userSession.getID());
            if (object != null) {
                this.htHttpSessions.put(string, object);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public boolean needSecurity() {
        try {
            return this.SEDU.needSecurity();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return true;
        }
    }

    protected Object getExtObj(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.htHttpSessions.get(string);
        }
        return var2_2;
    }

    protected long getLastAccessTime(String string) {
        Long l = (Long)this.htSessions.get(string);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    @Override
    public long getLastLoginTime(String string) {
        try {
            return this.SEDU.getLastLoginTime(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0L;
        }
    }

    @Override
    public long getLastLogoutTime(String string) {
        try {
            return this.SEDU.getLastLogoutTime(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0L;
        }
    }

    @Override
    public boolean addSessionExpiryListener(ExpiryListener expiryListener) {
        if (expiryListener != null && !this.add.contains(expiryListener)) {
            return this.add.add(expiryListener);
        }
        return false;
    }

    @Override
    public boolean removeSessionExpiryListener(ExpiryListener expiryListener) {
        return this.add.remove(expiryListener);
    }

    @Override
    public void updateUserSession(UserSession userSession) throws InvalidUserSessionException {
        try {
            this.SEDU.updateUserSession(userSession);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }
}

