/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr.crd;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.server.api.crd.CRDInfo;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDManageException;
import jet.server.api.crd.CRDManager;
import jet.server.api.crd.CompletedCRDInfo;
import jet.server.api.crd.CompletedCubeInfo;
import jet.server.api.crd.CubeInfo;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.crd.CubeManager;
import jet.server.api.rmi.RemoteParamInfo;
import jet.server.api.rmi.crd.RemoteCRDManager;
import jet.server.api.rmi.crd.RemoteCubeManager;
import jet.server.jrrmisvr.JRParamInfo;
import jet.server.jrrmisvr.ServiceLogger;

public class JRCRDManager
implements CRDManager,
CubeManager {
    private RemoteCRDManager SEDU = null;
    private RemoteCubeManager add = null;

    public JRCRDManager(RemoteCRDManager remoteCRDManager, RemoteCubeManager remoteCubeManager) {
        this.SEDU = remoteCRDManager;
        this.add = remoteCubeManager;
    }

    @Override
    public void createCRD(String string, CRDInfo cRDInfo) throws CRDManageException {
        try {
            this.SEDU.createCRD(string, cRDInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void deleteCRD(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            this.SEDU.deleteCRD(string, cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CRDInfo getCRD(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            return this.SEDU.getCRD(string, cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listCompletedCRDs(String string) throws CRDManageException {
        try {
            return this.SEDU.listCompletedCRDs(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listRunningCRDs(String string) throws CRDManageException {
        try {
            return this.SEDU.listRunningCRDs(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listCRDs(String string) throws CRDManageException {
        try {
            return this.SEDU.listCRDs(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void updateCRD(String string, CRDInfo cRDInfo) throws CRDManageException {
        try {
            this.SEDU.updateCRD(string, cRDInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public List getParamInfos(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        return this.SEDU(string, cRDInfoKey);
    }

    private List SEDU(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            List<RemoteParamInfo> list = this.SEDU.getParamInfos(string, cRDInfoKey);
            if (list == null) {
                return null;
            }
            ArrayList<JRParamInfo> arrayList = new ArrayList<JRParamInfo>();
            for (RemoteParamInfo remoteParamInfo : list) {
                arrayList.add(new JRParamInfo(remoteParamInfo));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void deleteCompletedCRD(String string, int n) throws CRDManageException {
        try {
            this.SEDU.deleteCompletedCRD(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void deleteCompletedCRD(String string, int[] nArray) throws CRDManageException {
        try {
            this.SEDU.deleteCompletedCRD(string, nArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CompletedCRDInfo getCompletedCRD(String string, int n) throws CRDManageException {
        try {
            return this.SEDU.getCompletedCRD(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void createCube(String string, CubeInfo cubeInfo) throws CRDManageException {
        try {
            this.add.createCube(string, cubeInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CubeInfo getCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        try {
            return this.add.getCube(string, cubeInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void deleteCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        try {
            this.add.deleteCube(string, cubeInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void enableCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        try {
            this.add.enableCube(string, cubeInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void disableCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        try {
            this.add.disableCube(string, cubeInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void updateCube(String string, CubeInfo cubeInfo) throws CRDManageException {
        try {
            this.add.updateCube(string, cubeInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public Vector listCubes(String string) throws CRDManageException {
        try {
            return this.add.listCubes(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void deleteCompletedCube(String string, int n) throws CRDManageException {
        try {
            this.add.deleteCompletedCube(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void deleteCompletedCube(String string, int[] nArray) throws CRDManageException {
        try {
            this.add.deleteCompletedCube(string, nArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CompletedCubeInfo getCompletedCube(String string, int n) throws CRDManageException {
        try {
            return this.add.getCompletedCube(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listCompletedCubes(String string) throws CRDManageException {
        try {
            return this.add.listCompletedCubes(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public List getParamInfos(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        return this.SEDU(string, cubeInfoKey);
    }
}

