/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.CompletedTaskRecord;
import jet.server.api.CompletedTaskTable;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.db.CompletedTable;
import jet.server.log.ServiceLogger;

public class JRCompletedTaskTable
implements CompletedTaskTable {
    private CompletedTable SEDU = null;
    private ResourceManager add = null;

    public JRCompletedTaskTable(CompletedTable completedTable, ResourceManager resourceManager) {
        this.SEDU = completedTable;
        this.add = resourceManager;
    }

    @Override
    public Vector getCompletedTaskRecordsByTaskID(String string) throws RptServerException {
        try {
            return this.SEDU.getCompletedTaskRecordsByTaskID(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public Vector getCompletedTaskRecordsByReport(String string, String string2) throws RptServerException {
        try {
            return this.SEDU.getCompletedTaskRecordsByReport(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public Vector getCompletedTaskRecordsByUser(String string) throws RptServerException {
        try {
            boolean bl = this.add.isOrganizationAdminUser(string);
            boolean bl2 = this.add.isAdminUser(string);
            if (bl || bl2) {
                Vector vector = this.SEDU.getAllCompletedTaskRecordsVector();
                Vector<CompletedTaskRecord> vector2 = new Vector<CompletedTaskRecord>();
                if (bl) {
                    String string2 = string.substring(0, string.indexOf("\\") + 1);
                    for (CompletedTaskRecord completedTaskRecord : vector) {
                        if (!completedTaskRecord.getSubmitter().startsWith(string2)) continue;
                        vector2.add(completedTaskRecord);
                    }
                } else {
                    for (CompletedTaskRecord completedTaskRecord : vector) {
                        if (completedTaskRecord.getSubmitter().indexOf("\\") != -1) continue;
                        vector2.add(completedTaskRecord);
                    }
                }
                return vector2;
            }
            return this.SEDU.getCompletedTaskRecordsByUser(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public Enumeration getAllCompletedTaskRecords() throws RptServerException {
        try {
            Vector vector = this.SEDU.getAllCompletedTaskRecordsVector();
            return vector.elements();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public CompletedTaskRecord getCompletedTaskRecord(String string) throws RptServerException {
        CompletedTaskRecord completedTaskRecord = null;
        try {
            completedTaskRecord = this.SEDU.getCompletedTaskRecord(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
        return completedTaskRecord;
    }

    @Override
    public boolean removeCompletedTaskRecord(String string) throws RptServerException {
        try {
            return this.SEDU.removeCompletedTaskRecord(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public boolean removeAllCompletedTaskRecord() throws RptServerException {
        try {
            return this.SEDU.removeAllCompletedTaskRecord();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    @Override
    public void commit() throws RptServerException {
        try {
            this.SEDU.commit();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }
}

