/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Properties;
import jet.cs.TaskIntf;
import jet.server.api.LargeReportRecord;

public class JRLargeReportRecord
implements LargeReportRecord {
    long regTime = System.currentTimeMillis();
    String owner = null;
    String result = null;
    String report = null;
    String catalog = null;
    Properties params = null;
    String query = null;
    long compTime = -1L;
    String errorMessage = null;
    private transient TaskIntf SEDU = null;
    private transient Thread append = null;

    public JRLargeReportRecord(String string, String string2, String string3, String string4, Properties properties, String string5, Thread thread, TaskIntf taskIntf) {
        this.owner = string;
        this.catalog = string2;
        this.report = string3;
        this.result = string4;
        this.params = properties;
        this.query = string5;
        this.SEDU = taskIntf;
        this.append = thread;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
        this.notifyCompleted();
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public TaskIntf getTask() {
        return this.SEDU;
    }

    public Thread getRptThread() {
        return this.append;
    }

    public void notifyCompleted() {
        this.compTime = System.currentTimeMillis();
    }

    @Override
    public long getStartedTime() {
        return this.regTime;
    }

    public String toString() {
        return super.toString() + "[" + this.owner + ":" + this.catalog + ":" + this.report + ":" + this.result + ":" + this.params + ":" + this.query + ":" + this.regTime + ":" + this.compTime + "]";
    }

    @Override
    public String getUserID() {
        return this.owner;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getReportName() {
        return this.report;
    }

    @Override
    public Properties getParameters() {
        return this.params;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public boolean isCompleted() {
        return this.compTime != -1L;
    }

    @Override
    public long getCompletedTime() {
        return this.compTime;
    }

    @Override
    public long getTimeElapse() {
        return (this.compTime == -1L ? System.currentTimeMillis() : this.compTime) - this.regTime;
    }
}

