/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Locale;
import java.util.Vector;
import jet.connect.DbDateTime;
import jet.connect.DbValue;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.parameter.UserInput;
import jet.parameter.runtime.valuelist.item.ValueListItem;
import jet.server.api.ParamInfo;
import jet.server.api.RptServerException;
import jet.server.jrc.param.ParamDescsUtil;
import jet.server.log.ServiceLogger;
import jet.server.util.ParamUtil;

public class JRParamInfo
implements ParamInfo {
    private ParamDesc IsParameters = null;
    private ParamDesc SEDU = null;
    private Vector add = null;
    private Locale append = Locale.getDefault();
    private Locale clone = null;

    public JRParamInfo(ParamDesc paramDesc) {
        this.IsParameters = paramDesc;
    }

    @Override
    public String getName() {
        return this.IsParameters.name;
    }

    @Override
    public String getType() {
        return this.IsParameters.type;
    }

    @Override
    public String getPrompt() {
        String string = this.IsParameters.promptText;
        if (string != null && string.equals("*")) {
            string = this.getName() + "*";
        }
        return string;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.append)) {
            this.add = null;
            this.append = locale;
        }
    }

    @Override
    public Locale getLocale() {
        return this.append;
    }

    @Override
    public String getDefaultValue() {
        if (this.add == null) {
            this.getValueOptions();
        }
        if (this.add != null && this.add.size() > 0) {
            int n = this.IsParameters.getDefaultIndex();
            if (n > -1) {
                return (String)this.add.elementAt(n);
            }
            return (String)this.add.lastElement();
        }
        String string = this.IsParameters.getDisplayValue(this.IsParameters.getValue(), this.getLocale());
        return string == null ? "" : string;
    }

    @Override
    public boolean isColumn() {
        return this.IsParameters.isColumn();
    }

    @Override
    public boolean isDistinct() {
        return this.IsParameters.isDistinct();
    }

    @Override
    public boolean isRequired() {
        return this.IsParameters.isRequired();
    }

    @Override
    public Vector getDisplayValues(Locale locale) {
        return this.getDisplayValues();
    }

    @Override
    public Vector getDisplayValues() {
        if (this.IsParameters.getBeColumn() == 4) {
            return this.IsParameters.getShowValues();
        }
        if (ParamUtil.isDateTime(this.IsParameters)) {
            Vector vector = this.IsParameters.getValues(this.getLocale());
            Vector<String> vector2 = new Vector<String>();
            for (UserInput userInput : vector) {
                String string = userInput.getExpressionName();
                vector2.add(userInput.getUserInput());
            }
            return vector2;
        }
        return this.IsParameters.getDisplayValues(this.getLocale());
    }

    @Override
    public Vector getValueOptions(Locale locale) {
        return this.getValueOptions();
    }

    private boolean isDateTime() {
        String string = this.IsParameters.getType();
        return string.equals("Date") || string.equals("Time") || string.equals("DateTime");
    }

    @Override
    public Vector getValueOptions() {
        Vector vector = this.IsParameters.getValues(this.getLocale());
        this.add = new Vector();
        for (UserInput userInput : vector) {
            this.add.add(ParamUtil.toExpr(userInput));
        }
        return this.add;
    }

    @Override
    public long getDefaultDateValue() {
        if (this.IsParameters.getType().equals("DateTime") || this.IsParameters.getType().equals("Date") || this.IsParameters.getType().equals("Time")) {
            return ((DbDateTime)this.IsParameters.getValue()).get();
        }
        return 0L;
    }

    public String toString() {
        return super.toString() + "[" + this.IsParameters.name + ":" + this.IsParameters.type + ":" + this.IsParameters.getDisplayValue(this.IsParameters.getValue(), this.append) + "]";
    }

    @Override
    public void setValue(String string) {
        if (this.IsParameters.isMultipleValue()) {
            this.setValue(new String[]{string});
        } else {
            try {
                this.IsParameters.setValue(string, this.append);
            }
            catch (InvalidParameterException invalidParameterException) {
                ServiceLogger.logError(invalidParameterException);
            }
        }
    }

    @Override
    public void setValue(String[] stringArray) {
        try {
            if (stringArray != null && stringArray.length == 1 && "\u0007".equals(stringArray[0])) {
                this.IsParameters.setAllSelected(true);
            } else {
                this.IsParameters.setValue(stringArray, this.append);
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            ServiceLogger.logError(invalidParameterException);
        }
    }

    public ParamDesc getParamDesc() {
        return this.IsParameters;
    }

    @Override
    public String getMaxLimit(Locale locale) {
        return this.getMaxLimit();
    }

    @Override
    public String getMaxLimit() {
        Vector vector = this.IsParameters.getDisplayLimit(this.getLocale());
        if (vector != null && vector.size() > 1) {
            return (String)vector.elementAt(1);
        }
        return null;
    }

    @Override
    public String getMinLimit(Locale locale) {
        return this.getMinLimit();
    }

    @Override
    public String getMinLimit() {
        Vector vector = this.IsParameters.getDisplayLimit(this.getLocale());
        if (vector != null && vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        return null;
    }

    @Override
    public String getUserFormat() {
        if (this.getType().equals("String")) {
            return this.IsParameters.stringFormat;
        }
        return this.IsParameters.getFormat();
    }

    @Override
    public void setEncoding(String string) {
        this.IsParameters.setEncoding(string);
    }

    @Override
    public boolean isParameters() {
        return this.IsParameters.IsParameters();
    }

    @Override
    public boolean isReferedBy() {
        return this.IsParameters.isReferedBy();
    }

    @Override
    public Vector getReferedBy() {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = ParamDescsUtil.getReferedBy(this.IsParameters);
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                ParamDesc paramDesc = (ParamDesc)vector2.get(i);
                vector.add(paramDesc.getName());
            }
        }
        return vector;
    }

    @Override
    public boolean isReferOther() {
        return this.IsParameters.isReferOther();
    }

    @Override
    public String getBoundSQL() {
        return this.IsParameters.getImportSql();
    }

    @Override
    public boolean isDynamicDateParameter() {
        return (this.IsParameters.isUseCurrentDate() || this.IsParameters.isUseCurrentDateWhenBlank()) && this.isDateTime();
    }

    @Override
    public String getDynamicDisplayValue(long l, Locale locale) {
        return this.getDynamicDisplayValue(l);
    }

    @Override
    public String getDynamicDisplayValue(long l) {
        DbValue dbValue = this.IsParameters.getDynamicValue(l, this.getLocale());
        return this.IsParameters.getDisplayValue(dbValue, this.getLocale());
    }

    @Override
    public boolean isHideParameterWhenSingleValueReturn() {
        return this.IsParameters.isHideParameterWhenSingleValueReturn();
    }

    @Override
    public String[][] getBooleanLiteral() {
        return this.IsParameters.getBooleanLiteral();
    }

    @Override
    public boolean isMultiple() {
        return this.IsParameters.isMultipleValue();
    }

    @Override
    public boolean isAllowAll() {
        return this.IsParameters.isAllowAll();
    }

    @Override
    public boolean isCascading() {
        return this.IsParameters.isCascading();
    }

    @Override
    public String getPreviousLevel() {
        return this.IsParameters.getPreviousLevel();
    }

    @Override
    public String getNextLevel() {
        return this.IsParameters.getNextLevel();
    }

    @Override
    public boolean isSetAsParameter() {
        return this.IsParameters.isSetAsParameter();
    }

    @Override
    public boolean isAllowTypeIn() {
        return this.IsParameters.isAllowTypeIn();
    }

    @Override
    public int getWhenOutOfRange() {
        return this.IsParameters.getWhenOutOfRange();
    }

    @Override
    public String[] detectInvalidValues(String[] stringArray) {
        if (this.IsParameters.getWhenOutOfRange() == 3) {
            boolean bl = this.IsParameters.isAllSelected();
            this.IsParameters.setAllSelected(false);
            try {
                if (ParamUtil.isDateTime(this.IsParameters)) {
                    UserInput[] userInputArray = ParamUtil.makeUserInput(stringArray);
                    ParamUtil.setParamValue(this.IsParameters, userInputArray, this.append, 0L);
                    return stringArray;
                }
                return this.IsParameters.detectInvalidValues(stringArray, this.getLocale());
            }
            catch (InvalidParameterException invalidParameterException) {
            }
            catch (ExecFormulaFailedException execFormulaFailedException) {
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                // empty catch block
            }
            this.IsParameters.setAllSelected(bl);
        }
        return null;
    }

    @Override
    public void check(String string) throws RptServerException {
        if (string == null) {
            return;
        }
        if (this.SEDU == null) {
            this.SEDU = (ParamDesc)this.IsParameters.clone();
        }
        try {
            if (this.IsParameters.isMultipleValue()) {
                this.detectInvalidValues(new String[]{string});
            } else if (ParamUtil.isDateTime(this.IsParameters)) {
                UserInput userInput = ParamUtil.makeUserInput(string)[0];
                ParamUtil.setParamValue(this.IsParameters, userInput, this.append, 0L);
            } else {
                this.SEDU.setValue(string, this.getLocale());
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new RptServerException(invalidParameterException.getMessage(), (Throwable)invalidParameterException);
        }
        catch (ExecFormulaFailedException execFormulaFailedException) {
            throw new RptServerException(execFormulaFailedException.getMessage(), (Throwable)execFormulaFailedException);
        }
        catch (ParseFormulaFailedException parseFormulaFailedException) {
            throw new RptServerException(parseFormulaFailedException.getMessage(), (Throwable)parseFormulaFailedException);
        }
    }

    @Override
    public String getDefaultDateFormat() {
        return this.IsParameters.getDefaultDateFormat(this.getLocale());
    }

    @Override
    public String validateValue(String string) {
        return ParamUtil.validateParam(this.IsParameters, string, this.append);
    }

    @Override
    public boolean isGetValueFromAPI() {
        return this.IsParameters.isGetValueFromAPI();
    }

    public void setDisplayLocale(Locale locale) {
        this.clone = locale;
    }

    public Locale getDisplayLocale() {
        return this.clone;
    }

    public Vector getValueList() {
        Vector vector = null == this.clone ? this.IsParameters.getValueList(Locale.getDefault(), false) : this.IsParameters.getValueList(this.clone, true);
        Vector<String[]> vector2 = new Vector<String[]>();
        if (null != vector) {
            for (ValueListItem valueListItem : vector) {
                UserInput userInput = (UserInput)valueListItem.getValue();
                String string = ParamUtil.toExpr(userInput);
                String string2 = valueListItem.getShowValue();
                String string3 = valueListItem.getDisplayValue();
                String string4 = valueListItem.getNLSTranslation();
                if ((null == string2 || string2.isEmpty()) && userInput.isExpression()) {
                    string2 = userInput.getUserInput();
                }
                vector2.add(new String[]{string, string2, string3, string4});
            }
        }
        return vector2;
    }

    @Override
    public boolean needNLSDisplayValue() {
        return this.IsParameters.IsParameters() || this.IsParameters.getBeColumn() == 1 || this.IsParameters.getBeColumn() == 2;
    }
}

