/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataservice.api.JDataService;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;
import jet.rptservice.api.ParameterEnv;
import jet.rptservice.api.exception.JRScheduleException;
import jet.server.api.ParameterManager;
import jet.server.api.RptServerException;
import jet.server.jrc.param.InvalidParamsException;
import jet.server.jrc.param.ParamDescsUtil;
import jet.server.jrserver.JRParamInfo;
import jet.server.log.ServiceLogger;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.universe.JetUUniverse;

public class JRParameterManager
implements ParameterManager {
    private ParameterEnv IsParameters = null;
    private JetUUniverse SEDU = null;
    private JDataService add = null;
    private CatalogKey append = null;

    public JRParameterManager(ParameterEnv parameterEnv, JetUUniverse jetUUniverse, JDataService jDataService, CatalogKey catalogKey) {
        this.IsParameters = parameterEnv;
        this.SEDU = jetUUniverse;
        this.add = jDataService;
        this.append = catalogKey;
    }

    @Override
    public boolean haveParameters() throws RptServerException {
        try {
            return this.IsParameters.haveParameters();
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RptServerException(jRScheduleException.getMessage(), (Throwable)jRScheduleException);
        }
    }

    public Hashtable getAllParameters() throws RptServerException {
        try {
            Hashtable<String, JRParamInfo> hashtable = new Hashtable<String, JRParamInfo>();
            Hashtable hashtable2 = this.IsParameters.getAllParameters(false);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, new JRParamInfo((ParamDesc)hashtable2.get(string)));
            }
            ServiceLogger.logDebug("JRParamterManager::getAllParameters()--params: " + hashtable, 6);
            return hashtable;
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RptServerException(jRScheduleException.getMessage(), (Throwable)jRScheduleException);
        }
    }

    public Hashtable getAllParameters(boolean bl) throws RptServerException {
        try {
            Hashtable<String, JRParamInfo> hashtable = new Hashtable<String, JRParamInfo>();
            Hashtable hashtable2 = this.IsParameters.getAllParameters(bl);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, new JRParamInfo((ParamDesc)hashtable2.get(string)));
            }
            ServiceLogger.logDebug("JRParamterManager::getAllParameters(refreshParamEnv)--params: " + hashtable, 6);
            return hashtable;
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RptServerException(jRScheduleException.getMessage(), (Throwable)jRScheduleException);
        }
    }

    public Vector paramValueChanged(String string, String string2) throws RptServerException {
        return this.paramValueChanged(string, string2, 0L);
    }

    public Vector paramValueChanged(String string, String string2, long l) throws RptServerException {
        try {
            Vector<JRParamInfo> vector = new Vector<JRParamInfo>();
            ParamDesc paramDesc = (ParamDesc)this.IsParameters.getAllParameters(false).get(string.toUpperCase());
            ParamDesc[] paramDescArray = ParamUtil.isDateTime(paramDesc) ? this.IsParameters.paramValueChanged(string, ParamUtil.makeParamValueDesc(ParamUtil.makeUserInput(string2), l, Locale.getDefault(), TimeZone.getDefault())) : this.IsParameters.paramValueChanged(string, string2);
            ParamDescsUtil paramDescsUtil = new ParamDescsUtil(paramDescArray);
            Vector vector2 = paramDescsUtil.getParams();
            ServiceLogger.logDebug("JRParamterManager::paramValueChanged--paramName: " + string + "--paramValue: " + string2 + "--params: " + paramDescsUtil.getParams(), 6);
            for (ParamDesc paramDesc2 : vector2) {
                vector.add(new JRParamInfo(paramDesc2));
            }
            return vector;
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new RptServerException(invalidParameterException.getMessage(), (Throwable)invalidParameterException);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RptServerException(jRScheduleException.getMessage(), (Throwable)jRScheduleException);
        }
    }

    public Vector paramValueChanged(String string, String[] stringArray) throws RptServerException {
        return this.paramValueChanged(string, stringArray, 0L);
    }

    public Vector paramValueChanged(String string, String[] stringArray, long l) throws RptServerException {
        try {
            Vector<JRParamInfo> vector = new Vector<JRParamInfo>();
            ParamDesc paramDesc = (ParamDesc)this.IsParameters.getAllParameters(false).get(string.toUpperCase());
            ParamDesc[] paramDescArray = ParamUtil.isDateTime(paramDesc) ? this.IsParameters.paramValueChanged(string, ParamUtil.makeParamValueDesc(ParamUtil.makeUserInput(stringArray), l, Locale.getDefault(), TimeZone.getDefault())) : this.IsParameters.paramValueChanged(string, stringArray);
            ParamDescsUtil paramDescsUtil = new ParamDescsUtil(paramDescArray);
            Vector vector2 = paramDescsUtil.getParams();
            ServiceLogger.logDebug("JRParamterManager::paramValueChanged--paramName: " + string + "--paramValues: " + ParamUtil.toStringParamValue(stringArray) + "--params: " + paramDescsUtil.getParams(), 6);
            for (ParamDesc paramDesc2 : vector2) {
                vector.add(new JRParamInfo(paramDesc2));
            }
            return vector;
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new RptServerException(invalidParameterException.getMessage(), (Throwable)invalidParameterException);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RptServerException(jRScheduleException.getMessage(), (Throwable)jRScheduleException);
        }
    }

    public Vector getAllParametersWithChanging(Map map) throws RptServerException {
        try {
            Vector<JRParamInfo> vector = new Vector<JRParamInfo>();
            Map map2 = ParamUtil.filterParamProp(map);
            String string = (String)map.get("change_value");
            List list = this.IsParameters(map2, map, false, string);
            ServiceLogger.logDebug("JRParamterManager::getAllParametersWithChanging--changeParam: " + string + "--params: " + list, 6);
            if (list != null) {
                for (ParamDesc paramDesc : list) {
                    vector.add(new JRParamInfo(paramDesc));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            throw new RptServerException(exception.getMessage(), (Throwable)exception);
        }
    }

    private List IsParameters(Map map, Map map2, boolean bl, String string) throws Exception {
        Hashtable hashtable = this.IsParameters.getAllParameters(false);
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        ParamDescsUtil paramDescsUtil = new ParamDescsUtil(hashtable.values().toArray(new ParamDesc[0]));
        Vector vector = paramDescsUtil.getParams();
        if (map == null || map.isEmpty()) {
            return vector;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        InvalidParamsException invalidParamsException = null;
        List list = null;
        Locale locale = Locale.getDefault();
        String string2 = (String)map2.get("jrs.timezone");
        TimeZone timeZone = TimeZone.getTimeZone(null == string2 ? "" : string2);
        long l = ParamUtil.getTimeBaseLine(map2);
        for (int i = 0; i < vector.size(); ++i) {
            ParamDesc paramDesc = (ParamDesc)vector.get(i);
            if (list != null && list.contains(paramDesc)) continue;
            String string3 = paramDesc.getName();
            if (string3.equals(string)) {
                list = ParamDescsUtil.getReferedBy(paramDesc);
            }
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
            try {
                if (!paramDesc.IsParameters() && !paramDesc.isReferedBy()) continue;
                Object object = ParamUtil.evalParamValue(paramDesc, map, map2);
                if (!bl && ParamUtil.isEmptyParamValue(object)) continue;
                boolean bl2 = true;
                if (bl) {
                    bl2 = !ParamUtil.checkRange(paramDesc, object, locale, l);
                }
                boolean bl3 = bl2 = bl2 && ParamUtil.isChangedParamValue(paramDesc, object, locale, l);
                if (!bl2) continue;
                paramDescsUtil.setParams(ParamUtil.changeParamValue(this.IsParameters, paramDesc, object, l, locale, timeZone));
                vector = paramDescsUtil.getParams();
                if (!paramDesc.IsParameters()) continue;
                i = 0;
                continue;
            }
            catch (InvalidParameterException invalidParameterException) {
                if (!bl) continue;
                String string4 = paramDesc.getPrompt();
                string4 = string4 == null || string4.length() == 0 ? string3 : string4;
                String string5 = "Parameter \"" + string4 + "\", ";
                invalidParamsException = new InvalidParamsException(invalidParamsException, string5 + invalidParameterException.getMessage());
                continue;
            }
            catch (Exception exception) {
                if (!bl) continue;
                throw exception;
            }
        }
        if (bl && invalidParamsException != null) {
            throw invalidParamsException;
        }
        return vector;
    }

    private void SEDU(List list, Map map, Map map2, Locale locale) throws Exception {
        if (list == null) {
            return;
        }
        InvalidParamsException invalidParamsException = null;
        long l = ParamUtil.getTimeBaseLine(map2);
        for (ParamDesc paramDesc : list) {
            if (paramDesc.IsParameters() || paramDesc.isReferedBy()) continue;
            try {
                Object object = ParamUtil.evalParamValue(paramDesc, map, map2);
                ParamUtil.checkRange(paramDesc, object, locale, l);
                ParamUtil.setParamValue(paramDesc, object, locale, l);
                ParamUtil.putRuntimeParamValue(map2, paramDesc, locale);
            }
            catch (InvalidParameterException invalidParameterException) {
                String string = paramDesc.getPrompt();
                string = string == null || string.length() == 0 ? paramDesc.getName() : string;
                String string2 = "";
                invalidParamsException = new InvalidParamsException(invalidParamsException, string2 + invalidParameterException.getMessage());
            }
        }
        if (invalidParamsException != null) {
            throw invalidParamsException;
        }
    }

    @Override
    public void clear() {
        this.IsParameters.clear();
        try {
            this.add.unregistCatalog(this.append);
        }
        catch (DSException dSException) {
            ServiceLogger.logError(dSException, 3);
        }
        this.SEDU.free();
        this.SEDU = null;
    }

    public void validateParameters(Map map) throws InvalidParameterException, Exception {
        Locale locale = ServerUtil.getLocale((String)map.get("jrs.rpt_language"), (String)map.get("jrs.rpt_country"), (String)map.get("jrs.rpt_variant"));
        Map map2 = ParamUtil.filterParamProp(map);
        List list = this.IsParameters(map2, map, true, null);
        this.SEDU(list, map2, map, locale);
        Vector vector = this.IsParameters.validateParameterValues();
        if (vector != null && !vector.isEmpty()) {
            InvalidParamsException invalidParamsException = null;
            for (String string : vector) {
                if (string == null || string.isEmpty()) continue;
                invalidParamsException = new InvalidParamsException(invalidParamsException, string);
            }
            if (invalidParamsException != null) {
                ServiceLogger.logDebug("User error: " + vector);
                throw invalidParamsException;
            }
        }
    }
}

