/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.cs.CSUtil;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.schedule.JRResultFiles;

public class JRResultVersionRecord
implements ResultVersionRecord {
    private DbValue[] SEDU = null;
    protected Vector reportSheets = new Vector();

    public JRResultVersionRecord(DbValue[] dbValueArray) {
        this.SEDU = new DbValue[dbValueArray.length];
        for (int i = 0; i < dbValueArray.length; ++i) {
            this.SEDU[i] = (DbValue)dbValueArray[i].clone();
        }
    }

    @Override
    public String getVersionID() {
        return this.SEDU[1].isNull() ? null : this.SEDU[1].toString();
    }

    @Override
    public Properties toProperties(Properties properties) {
        Date date;
        String string;
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if ((string = this.getVersionID()) != null) {
            properties2.put("jrs.version_id", string);
        }
        if ((string = this.getCatalogFile()) != null) {
            properties2.put("jrs.catalog", string);
        }
        if ((string = this.getReportFile()) != null) {
            properties2.put("jrs.report", string);
        }
        JRResultFiles jRResultFiles = (JRResultFiles)this.getAllResultFiles();
        if (string != null) {
            properties2.put("jrs.result", jRResultFiles.getResultFileNames());
        }
        if ((string = this.getParamFile()) != null) {
            properties2.put("jrs.param_file", string);
        }
        if ((date = this.getCreatedTime()) != null) {
            properties2.put("jrs.created_time", String.valueOf(date.getTime()));
        }
        if ((date = this.getExpirationTime()) != null) {
            properties2.put("jrs.expired_time", String.valueOf(date.getTime()));
        }
        if ((string = this.getSubmitter()) != null) {
            properties2.put("jrs.uid", string);
        }
        return properties2;
    }

    @Override
    public String getCatalogFile() {
        return this.SEDU[2].isNull() ? null : this.SEDU[2].toString();
    }

    @Override
    public String getReportFile() {
        return this.SEDU[3].isNull() ? null : this.SEDU[3].toString();
    }

    @Override
    public String getResultFile() {
        ResultFiles resultFiles = this.getAllResultFiles();
        Vector vector = resultFiles.getResultFileNames();
        return (String)vector.elementAt(0);
    }

    @Override
    public ResultFiles getAllResultFiles() {
        Hashtable hashtable = this.getAllReportResultFiles();
        Enumeration enumeration = hashtable.keys();
        if (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            return (ResultFiles)hashtable.get(string);
        }
        return null;
    }

    @Override
    public Hashtable getAllReportResultFiles() {
        String string = "";
        if (this.SEDU[5].isNull()) {
            string = this.SEDU[5].toString();
        }
        Hashtable hashtable = new Hashtable();
        if (string.indexOf(";") < 0) {
            this.SEDU(hashtable, string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                this.SEDU(hashtable, string2);
            }
        }
        return hashtable;
    }

    private void SEDU(Hashtable hashtable, String string) {
        long l = this.SEDU[13].isNull() ? 0L : ((DbBigInt)this.SEDU[13]).get();
        int n = string.indexOf("=");
        JRResultFiles jRResultFiles = null;
        if (n < 0) {
            String string2 = string.length() == 0 ? null : string;
            jRResultFiles = l != 0L ? new JRResultFiles(string2, l, 0L, 0L, 0L, -1) : new JRResultFiles(CSUtil.getNameWithoutExt(string), CSUtil.getExtName(string));
            hashtable.put("jrs.report_result", jRResultFiles);
        } else {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (string3.equalsIgnoreCase("jrs.rst_result")) {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), ".rst");
            } else if (string3.equalsIgnoreCase("jrs.rsd_result")) {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), ".rsd");
            } else if (string3.equalsIgnoreCase("jrs.wst_result")) {
                if (string4.endsWith(".wst")) {
                    string4 = CSUtil.getNameWithoutExt(string4);
                }
                jRResultFiles = new JRResultFiles(string4, ".wst");
            } else {
                this.reportSheets.add(string3);
                if (l != 0L) {
                    jRResultFiles = new JRResultFiles(string4, l, 0L, 0L, 0L, -1);
                    jRResultFiles.removeFormat(0);
                    jRResultFiles.removeFormat(12);
                    jRResultFiles.removeFormat(13);
                } else {
                    jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string4), CSUtil.getExtName(string4));
                }
            }
            hashtable.put(string3, jRResultFiles);
        }
    }

    @Override
    public String getParamFile() {
        return this.SEDU[4].isNull() ? null : this.SEDU[4].toString();
    }

    @Override
    public Date getCreatedTime() {
        return ((DbTimestamp)this.SEDU[6]).isNull() ? null : ((DbTimestamp)this.SEDU[6]).toUtilDate();
    }

    @Override
    public Date getExpirationTime() {
        if (this.SEDU[9].isNull()) {
            return null;
        }
        return ((DbTimestamp)this.SEDU[9]).toUtilDate();
    }

    @Override
    public String getSubmitter() {
        return this.SEDU[7].isNull() ? null : this.SEDU[7].toString();
    }

    @Override
    public int getVersionNumber() {
        return 0;
    }

    @Override
    public String getVersionName() {
        return null;
    }

    @Override
    public String getCreator() {
        return this.SEDU[7].isNull() ? null : this.SEDU[7].toString();
    }

    @Override
    public String getResourcePath() {
        return null;
    }

    @Override
    public String getRealPath() {
        return null;
    }

    @Override
    public int getExpirationMethod() {
        return 1;
    }

    @Override
    public boolean hasOnlyRSDorWST() {
        return false;
    }
}

