/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import jet.server.api.SystemPerformanceInfo;

public class JRSystemPerformanceInfo
implements SystemPerformanceInfo {
    private int SEDU;
    private double append;
    private long get;
    private long getAvailableProcessors;
    private long getCollectionCount;
    private int getCollectionTime;
    private int getCommitted;
    private long getDaemonThreadCount;
    private long getGarbageCollectorMXBeans;

    public JRSystemPerformanceInfo() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.SEDU = operatingSystemMXBean.getAvailableProcessors();
        this.append = operatingSystemMXBean.getSystemLoadAverage();
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.get = memoryUsage.getUsed();
        this.getAvailableProcessors = memoryUsage.getCommitted();
        this.getCollectionCount = memoryUsage.getMax();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        this.getCollectionTime = threadMXBean.getThreadCount();
        this.getCommitted = threadMXBean.getDaemonThreadCount();
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        if (!list.isEmpty()) {
            this.getDaemonThreadCount = list.get(list.size() - 1).getCollectionCount();
            this.getGarbageCollectorMXBeans = list.get(list.size() - 1).getCollectionTime();
        }
    }

    public String toString() {
        return "{availableProcessors=" + this.SEDU + ", systemLoadAverage=" + this.append + ", usedMemory=" + this.get + ", committedMemory=" + this.getAvailableProcessors + ", maxMemory=" + this.getCollectionCount + ", threadCount=" + this.getCollectionTime + "}";
    }

    @Override
    public int getAvailableProcessors() {
        return this.SEDU;
    }

    @Override
    public double getSystemLoadAverage() {
        return this.append;
    }

    @Override
    public long getUsedMemory() {
        return this.get;
    }

    @Override
    public long getCommittedMemory() {
        return this.getAvailableProcessors;
    }

    @Override
    public long getMaxMemory() {
        return this.getCollectionCount;
    }

    @Override
    public int getThreadCount() {
        return this.getCollectionTime;
    }

    @Override
    public int getDaemonThreadCount() {
        return this.getCommitted;
    }

    @Override
    public long getGcCollectionCount() {
        return this.getDaemonThreadCount;
    }

    @Override
    public long getGcCollectionTime() {
        return this.getGarbageCollectorMXBeans;
    }

    public void setAvailableProcessors(int n) {
        this.SEDU = n;
    }

    public void setSystemLoadAverage(double d) {
        this.append = d;
    }

    public void setUsedMemory(long l) {
        this.get = l;
    }

    public void setCommittedMemory(long l) {
        this.getAvailableProcessors = l;
    }

    public void setMaxMemory(long l) {
        this.getCollectionCount = l;
    }

    public void setThreadCount(int n) {
        this.getCollectionTime = n;
    }

    public void setDaemonThreadCount(int n) {
        this.getCommitted = n;
    }

    public void setGcCollectionCount(long l) {
        this.getDaemonThreadCount = l;
    }

    public void setGcCollectionTime(long l) {
        this.getGarbageCollectorMXBeans = l;
    }
}

