/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.api.admin.cfg.OrgConfiguration;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;

class JROrgConfigurationDefault
implements OrgConfiguration {
    public static final String CONFIG_FILE_NAME = "organization_config.properties";
    public static final int CONCURRENT_USERS_MAXSIZE_DEFAULT_VALUE = 1000;
    public static final int CONCURRENT_REPORTS_MAXSIZE_DEFAULT_VALUE = 1000;
    public static final int DISK_MAXSIZE_DEFAULT_VALUE = 100;
    public static final int MEMERY_MAXSIZE_DEFAULT_VALUE = 4;
    public static final boolean CACHE_CATALOGS_ENABLED_DEFAULT_VALUE = true;
    public static final int CACHE_CATALOGS_MAXSIZE_DEFAULT_VALUE = 50;
    public static final boolean CACHE_REPORTS_ENABLED_DEFAULT_VALUE = true;
    public static final int CACHE_REPORTS_MAXSIZE_DEFAULT_VALUE = 50;
    public static final boolean CACHE_IMAGES_ENABLED_DEFAULT_VALUE = true;
    public static final int CACHE_IMAGES_MAXSIZE_DEFAULT_VALUE = 50;
    public static final int REPORT_DATA_MAXSIZE_DEFAULT_VALUE = 500;
    public static final int CUBE_MAXSIZE_DEFAULT_VALUE = 500;
    public static final boolean COMPRESS_SWAP_FILES_DEFAULT_VALUE = false;
    private Properties PROPERTIES = new Properties();

    public JROrgConfigurationDefault() {
        this.PROPERTIES.setProperty("Concurrent_Users", String.valueOf(1000));
        this.PROPERTIES.setProperty("Concurrent_Reports", String.valueOf(1000));
        this.PROPERTIES.setProperty("Maximum_Disk_Size", String.valueOf(100));
        this.PROPERTIES.setProperty("Maximum_Memory_Size", String.valueOf(4));
        this.PROPERTIES.setProperty("Enable_cache_catalogs", String.valueOf(true));
        this.PROPERTIES.setProperty("Maximum_cache_catalog_size", String.valueOf(50));
        this.PROPERTIES.setProperty("Enable_cache_reports", String.valueOf(true));
        this.PROPERTIES.setProperty("Maximum_cache_report_size", String.valueOf(50));
        this.PROPERTIES.setProperty("Enable_cache_images", String.valueOf(true));
        this.PROPERTIES.setProperty("Maximum_cache_image_size", String.valueOf(50));
        this.PROPERTIES.setProperty("Maximum_report_data_size", String.valueOf(500));
        this.PROPERTIES.setProperty("Maximum_cube_size", String.valueOf(500));
        this.PROPERTIES.setProperty("Compress_Swap_Files", String.valueOf(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        block6: {
            try {
                Properties properties = new Properties();
                File file = new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.PROPERTIES), CONFIG_FILE_NAME);
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                        properties.keySet().retainAll(this.PROPERTIES.keySet());
                        this.PROPERTIES.putAll((Map<?, ?>)properties);
                        break block6;
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                this.save();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        try {
            File file = new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.PROPERTIES), CONFIG_FILE_NAME);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                this.PROPERTIES.store(fileOutputStream, null);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
    }

    @Override
    public void setProperty(String string, String string2) {
        if (this.PROPERTIES.containsKey(string)) {
            this.PROPERTIES.setProperty(string, string2);
        }
    }

    @Override
    public int getMaxConcurrentUsers() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Concurrent_Users"), 1000);
    }

    @Override
    public int getMaxConcurrentReports() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Concurrent_Reports"), 1000);
    }

    @Override
    public int getMaxDiskSpace() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_Disk_Size"), 100);
    }

    @Override
    public int getMaxMemorySpace() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_Memory_Size"), 4);
    }

    @Override
    public boolean isEnabledCacheCatalogs() {
        return CSUtil.getBoolean(this.PROPERTIES.getProperty("Enable_cache_catalogs"), true);
    }

    @Override
    public int getMaxCacheCatalogsSize() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_cache_catalog_size"), 50);
    }

    @Override
    public boolean isEnabledCacheReports() {
        return CSUtil.getBoolean(this.PROPERTIES.getProperty("Enable_cache_reports"), true);
    }

    @Override
    public int getMaxCacheReportsSpace() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_cache_report_size"), 50);
    }

    @Override
    public boolean isEnabledCacheImages() {
        return CSUtil.getBoolean(this.PROPERTIES.getProperty("Enable_cache_images"), true);
    }

    @Override
    public int getMaxCacheImagesSpace() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_cache_image_size"), 50);
    }

    @Override
    public int getMaxReportDataSpace() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_report_data_size"), 500);
    }

    @Override
    public int getMaxCubeSpace() {
        return CSUtil.parseInt(this.PROPERTIES.getProperty("Maximum_cube_size"), 500);
    }

    @Override
    public boolean isCompressSwapFiles() {
        return CSUtil.getBoolean(this.PROPERTIES.getProperty("Compress_Swap_Files"), false);
    }

    @Override
    public int getCurConcurrentUsers() {
        return 0;
    }

    @Override
    public int getCurConcurrentReports() {
        return 0;
    }

    @Override
    public int getCurDiskSpace() {
        return 0;
    }

    @Override
    public int getCurMemorySpace() {
        return 0;
    }

    public List getPreloadCatalogsName() {
        return null;
    }

    public void setPreloadCatalogsName(List list) {
    }

    public List getPreloadReportsName() {
        return null;
    }

    public void setPreloadReportsName(List list) {
    }

    @Override
    public int getMaxCachedCatalogSize() {
        return 10;
    }

    public List getCachedCatalogs() {
        return null;
    }

    @Override
    public void setCachedCatalog(String string, String string2, boolean bl) {
    }

    @Override
    public int getMaxCachedReportSize() {
        return 10;
    }

    public List getCachedReports() {
        return null;
    }

    @Override
    public void setCachedReport(String string, String string2, boolean bl) {
    }
}

