/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.crd;

import com.jinfonet.api.crd.CRDResult;
import com.jinfonet.api.crd.DataResult;
import com.jinfonet.api.crd.QueryInformation;
import com.jinfonet.api.objectmanager.CatalogKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataservice.api.autocachekey.JAutoCacheKey;
import jet.server.api.crd.CRDInfo;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDManageException;
import jet.server.api.crd.CRDManager;
import jet.server.api.crd.CompletedCRDInfo;
import jet.server.api.crd.CompletedCubeInfo;
import jet.server.api.crd.CubeInfo;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.crd.CubeManager;
import jet.server.api.http.HttpUtil;
import jet.server.api.rmi.RemoteParamInfo;
import jet.server.crd.AutoCacheResult;
import jet.server.crd.CRDResultKey;
import jet.server.crd.CRDSimpleResult;
import jet.server.crd.ExtCRDManager;
import jet.server.intf.jrs.RemoteCRDManager;
import jet.server.jrc.JRRemoteCRDManager;
import jet.server.jrrmisvr.JRParamInfo;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerResourceStore;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;

public class JRCRDManager
implements CRDManager,
ExtCRDManager,
CubeManager {
    private RemoteCRDManager CRD_CACHE = null;
    private boolean SEDU = false;
    private Map add = new HashMap();
    private Map afterRename = new HashMap();
    private String append;

    public JRCRDManager(RemoteCRDManager remoteCRDManager, boolean bl) {
        this.CRD_CACHE = remoteCRDManager;
        this.SEDU = bl;
    }

    public void init() {
        try {
            if (this.SEDU) {
                ((JRRemoteCRDManager)this.CRD_CACHE).init(false);
            } else {
                this.append = ((JRRptServer)((Object)HttpUtil.getHttpRptServer())).getHomePath();
                this.CRD_CACHE();
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (CRDManageException cRDManageException) {
            ServiceLogger.logError((Throwable)((Object)cRDManageException));
        }
    }

    public void promoteToShareMemoryNode(JRRemoteCRDManager jRRemoteCRDManager) {
        this.quit();
        this.CRD_CACHE = jRRemoteCRDManager;
        this.SEDU = true;
        try {
            jRRemoteCRDManager.init(true);
        }
        catch (CRDManageException cRDManageException) {
            ServiceLogger.logError((Throwable)((Object)cRDManageException));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    private void CRD_CACHE() {
        try {
            File[] fileArray;
            Object object;
            File file = new File(this.append + this.CRD_CACHE.getCRDCacheDir());
            if (file.exists()) {
                object = file.listFiles();
                fileArray = object;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file2 = fileArray[i];
                    String object2 = file2.getName();
                    if (object2.indexOf(".rst") <= -1) continue;
                    file2.delete();
                }
            }
            if (((File)(object = new File(this.append + this.CRD_CACHE.getAutoCacheDir()))).exists()) {
                for (File file2 : fileArray = ((File)object).listFiles()) {
                    file2.delete();
                }
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public long getCacheSize() {
        try {
            return this.CRD_CACHE.getCacheSize();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0L;
        }
    }

    @Override
    public void createCRD(String string, CRDInfo cRDInfo) throws CRDManageException {
        try {
            this.CRD_CACHE.createCRD(string, cRDInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void deleteCRD(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            this.CRD_CACHE.deleteCRD(string, cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CRDInfo getCRD(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            return this.CRD_CACHE.getCRD(string, cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listCompletedCRDs(String string) throws CRDManageException {
        try {
            return this.CRD_CACHE.listCompletedCRDs(string, false);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listRunningCRDs(String string) throws CRDManageException {
        try {
            return this.CRD_CACHE.listRunningCRDs(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector listCRDs(String string) throws CRDManageException {
        try {
            return this.CRD_CACHE.listCRDs(string, false);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void updateCRD(String string, CRDInfo cRDInfo) throws CRDManageException {
        try {
            this.CRD_CACHE.updateCRD(string, cRDInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public List getParamInfos(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        return this.SEDU(string, cRDInfoKey);
    }

    private List SEDU(String string, CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            List list = this.CRD_CACHE.getParamInfos(string, cRDInfoKey);
            if (list == null) {
                return null;
            }
            ArrayList<JRParamInfo> arrayList = new ArrayList<JRParamInfo>();
            for (RemoteParamInfo remoteParamInfo : list) {
                arrayList.add(new JRParamInfo(remoteParamInfo));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public void recoverCRDs() throws CRDManageException {
        try {
            this.CRD_CACHE.recoverCRDs();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public boolean updateCRDResult(CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            return this.CRD_CACHE.updateCRDResult(cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public void upgradeCRD(String string) throws CRDManageException {
        try {
            this.CRD_CACHE.upgradeCRD(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    private CRDInfoKey add(QueryInformation queryInformation) {
        if (queryInformation == null) {
            return null;
        }
        if (queryInformation.isCube()) {
            return new CubeInfoKey(queryInformation.getCatalogPath(), queryInformation.getDataSource(), queryInformation.getType(), queryInformation.getName(), queryInformation.getBVName());
        }
        return new CRDInfoKey(queryInformation.getCatalogPath(), queryInformation.getDataSource(), queryInformation.getType(), queryInformation.getName());
    }

    private ServerResourceStore afterRename(String string) {
        return ServerResourceStoreFactory.getInstance().getResourceStoreByResourcePath(string);
    }

    @Override
    public CRDResult getCRDResult(QueryInformation queryInformation) {
        try {
            if (this.SEDU) {
                return this.CRD_CACHE.getCRDResult(queryInformation);
            }
            CRDInfoKey cRDInfoKey = this.add(queryInformation);
            CRDSimpleResult cRDSimpleResult = this.getCRDResult(cRDInfoKey);
            if (cRDSimpleResult == null || this.isExpired(cRDSimpleResult.getResultKey())) {
                CRDSimpleResult cRDSimpleResult2;
                if (cRDSimpleResult != null) {
                    cRDSimpleResult.setExpired(true);
                }
                if ((cRDSimpleResult2 = (CRDSimpleResult)this.CRD_CACHE.getCRDResult(queryInformation)) == null) {
                    return null;
                }
                String string = cRDSimpleResult2.getPersistFile();
                String string2 = this.append + string.substring(1);
                Storage storage = StorageEnv.getStorage();
                String string3 = cRDSimpleResult2.getPersistBVFile();
                if (!queryInformation.isBV()) {
                    storage.get(Storage.StorageRoot.CRD_CACHE, string.substring(JRRemoteCRDManager.getCachePath().length()));
                } else {
                    storage.get(Storage.StorageRoot.CRD_CACHE, string3.substring(JRRemoteCRDManager.getCachePath().length()));
                }
                cRDSimpleResult2.setLocalPersistFile(string2);
                cRDSimpleResult2.setCRDCache(this.afterRename(cRDSimpleResult2.getResultKey().getCRDKey().getCatalogPath()).getMemoryStore().getCrdCache());
                this.add.put(cRDInfoKey, cRDSimpleResult2);
            }
            return this.getCRDResult(cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        catch (CRDManageException cRDManageException) {
            ServiceLogger.logError((Throwable)((Object)cRDManageException));
        }
        catch (StorageException storageException) {
            ServiceLogger.logError((Throwable)((Object)storageException));
        }
        return null;
    }

    public boolean isExpired(CRDResultKey cRDResultKey) throws CRDManageException {
        try {
            return this.CRD_CACHE.isExpired(cRDResultKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    public boolean isExpired(JAutoCacheKey jAutoCacheKey) {
        try {
            return this.CRD_CACHE.isExpired(jAutoCacheKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public void deleteCRDResult(CRDInfoKey cRDInfoKey) throws CRDManageException {
        try {
            this.CRD_CACHE.deleteCRDResult(cRDInfoKey);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public CRDSimpleResult getCRDResult(CRDInfoKey cRDInfoKey) {
        return (CRDSimpleResult)this.add.get(cRDInfoKey);
    }

    @Override
    public CRDResult getAutoCacheResult(JAutoCacheKey jAutoCacheKey) {
        try {
            AutoCacheResult autoCacheResult;
            ServiceLogger.logDebug("CRDManager: getAutoCacheResult......[isShareMemoryNode=" + this.SEDU + " ,queryKey=" + jAutoCacheKey + "]", 6);
            if (this.SEDU) {
                return this.CRD_CACHE.getAutoCacheResult(jAutoCacheKey);
            }
            AutoCacheResult autoCacheResult2 = (AutoCacheResult)this.afterRename.get(jAutoCacheKey);
            if (autoCacheResult2 == null || autoCacheResult2.isExpired() || this.isExpired(jAutoCacheKey)) {
                ServiceLogger.logDebug("CRDManager: getAutoCacheResult, result is null or expired[isShareMemoryNode=" + this.SEDU + " ,existedResult=" + autoCacheResult2 + "]", 6);
                if (autoCacheResult2 != null) {
                    autoCacheResult2.setExpired(true);
                    this.afterRename.remove(jAutoCacheKey);
                }
                autoCacheResult = (AutoCacheResult)this.CRD_CACHE.getAutoCacheResult(jAutoCacheKey);
                ServiceLogger.logDebug("CRDManager: getAutoCacheResult from remote(admin)[isShareMemoryNode=" + this.SEDU + " ,autoCacheResult=" + autoCacheResult + "]", 6);
                if (autoCacheResult == null) {
                    return null;
                }
                String string = autoCacheResult.getPersistFile();
                String string2 = this.append + string.substring(1);
                Storage storage = StorageEnv.getStorage();
                storage.get(Storage.StorageRoot.CRD_CACHE, string.substring(JRRemoteCRDManager.getCachePath().length()));
                ServiceLogger.logDebug("CRDManager: getAutoCacheResult [isShareMemoryNode=" + this.SEDU + " ,localFile=" + string2 + "]", 6);
                autoCacheResult.setLocalPersistFile(string2);
                autoCacheResult.setPersistFile(string);
                autoCacheResult.setCRDCache(this.afterRename(jAutoCacheKey.getCatalogKey().getPath()).getMemoryStore().getCrdCache());
                this.afterRename.put(jAutoCacheKey, autoCacheResult);
            }
            autoCacheResult = (AutoCacheResult)this.afterRename.get(jAutoCacheKey);
            ServiceLogger.logDebug("CRDManager: getAutoCacheResult return. [isShareMemoryNode=" + this.SEDU + " ,result=" + autoCacheResult + "]", 6);
            return autoCacheResult;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        catch (StorageException storageException) {
            ServiceLogger.logError((Throwable)((Object)storageException));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerDataResult(JAutoCacheKey jAutoCacheKey, DataResult dataResult) {
        try {
            ServiceLogger.logDebug("CRDManager: registerDataResult......[isShareMemoryNode=" + this.SEDU + " ,queryKey=" + jAutoCacheKey + "]", 6);
            if (this.SEDU) {
                return this.CRD_CACHE.registerDataResult(jAutoCacheKey, dataResult);
            }
            String string = this.CRD_CACHE.getAutoCacheResultFile();
            String string2 = this.append + string.substring(1);
            ServiceLogger.logDebug("CRDManager: registerDataResult on slave......[localFile=" + string2 + "]", 6);
            InputStream inputStream = dataResult.getStream();
            FileOutputStream fileOutputStream = null;
            File file = new File(string2);
            try {
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                fileOutputStream = new FileOutputStream(file);
                int n = 0;
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                fileOutputStream.flush();
                AutoCacheResult autoCacheResult = new AutoCacheResult(jAutoCacheKey, this.CRD_CACHE.getAutoCacheExpired(), dataResult.getType(), file.length());
                autoCacheResult.setPersistFile(string);
                autoCacheResult.setCRDCache(this.afterRename(jAutoCacheKey.getCatalogKey().getPath()).getMemoryStore().getCrdCache());
                this.CRD_CACHE.registerAutoCacheResult(jAutoCacheKey, autoCacheResult);
                autoCacheResult.setLocalPersistFile(string2);
                this.afterRename.put(jAutoCacheKey, autoCacheResult);
                ServiceLogger.logDebug("CRDManager: registerDataResult on slave end.", 6);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Storage storage = StorageEnv.getStorage();
            storage.add(Storage.StorageRoot.CRD_CACHE, string.substring(JRRemoteCRDManager.getCachePath().length()), file);
            ServiceLogger.logDebug("CRDManager: registerDataResult to share memory node.", 6);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (DSException dSException) {
            ServiceLogger.logError(dSException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        catch (StorageException storageException) {
            ServiceLogger.logError((Throwable)((Object)storageException));
        }
        ServiceLogger.logDebug("CRDManager: registerDataResult end.[isShareMemoryNode=" + this.SEDU + "]", 6);
        return true;
    }

    public void quit() {
        if (this.SEDU) {
            ((JRRemoteCRDManager)this.CRD_CACHE).quit();
        }
    }

    @Override
    public void deleteCompletedCRD(String string, int n) throws CRDManageException {
        try {
            this.CRD_CACHE.deleteCompletedCRD(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void deleteCompletedCRD(String string, int[] nArray) throws CRDManageException {
        try {
            this.CRD_CACHE.deleteCompletedCRD(string, nArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CompletedCRDInfo getCompletedCRD(String string, int n) throws CRDManageException {
        try {
            return this.CRD_CACHE.getCompletedCRD(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void createCube(String string, CubeInfo cubeInfo) throws CRDManageException {
        this.createCRD(string, cubeInfo);
    }

    @Override
    public CubeInfo getCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        return (CubeInfo)this.getCRD(string, cubeInfoKey);
    }

    @Override
    public void deleteCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        this.deleteCRD(string, cubeInfoKey);
    }

    @Override
    public void updateCube(String string, CubeInfo cubeInfo) throws CRDManageException {
        this.updateCRD(string, cubeInfo);
    }

    public Vector listCubes(String string) throws CRDManageException {
        try {
            Vector<CubeInfo> vector = new Vector<CubeInfo>();
            Enumeration enumeration = this.CRD_CACHE.listCRDs(string, true).elements();
            while (enumeration.hasMoreElements()) {
                vector.add((CubeInfo)enumeration.nextElement());
            }
            return vector;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public void deleteCompletedCube(String string, int n) throws CRDManageException {
        this.deleteCompletedCRD(string, n);
    }

    @Override
    public void deleteCompletedCube(String string, int[] nArray) throws CRDManageException {
        this.deleteCompletedCRD(string, nArray);
    }

    @Override
    public CompletedCubeInfo getCompletedCube(String string, int n) throws CRDManageException {
        return (CompletedCubeInfo)this.getCompletedCRD(string, n);
    }

    public Vector listCompletedCubes(String string) throws CRDManageException {
        Vector<CompletedCubeInfo> vector = new Vector<CompletedCubeInfo>();
        try {
            Enumeration enumeration = this.CRD_CACHE.listCompletedCRDs(string, true).elements();
            while (enumeration.hasMoreElements()) {
                vector.add((CompletedCubeInfo)enumeration.nextElement());
            }
        }
        catch (RemoteException remoteException) {
            throw new CRDManageException(remoteException);
        }
        return vector;
    }

    public List getParamInfos(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        return this.SEDU(string, cubeInfoKey);
    }

    @Override
    public void disableCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        try {
            this.CRD_CACHE.disableCube(string, cubeInfoKey);
        }
        catch (RemoteException remoteException) {
            throw new CRDManageException(remoteException);
        }
    }

    @Override
    public void enableCube(String string, CubeInfoKey cubeInfoKey) throws CRDManageException {
        try {
            this.CRD_CACHE.enableCube(string, cubeInfoKey);
        }
        catch (RemoteException remoteException) {
            throw new CRDManageException(remoteException);
        }
    }

    public String startUsingCube(CatalogKey catalogKey, String string, String string2, String string3, String string4, int n, String string5, String string6) {
        try {
            return this.CRD_CACHE.startUsingCube(catalogKey, string, string2, string3, string4, n, string5, string6);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public void finishUsingCube(CatalogKey catalogKey, String string, String string2, String string3, String string4) {
        try {
            if (string4 != null) {
                this.CRD_CACHE.finishUsingCube(catalogKey, string, string2, string3, string4);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void afterRename(CatalogKey catalogKey, String string, String string2, String string3, String string4, String string5) {
        try {
            if (string4 != null) {
                this.CRD_CACHE.afterRename(catalogKey, string, string2, string3, string4, string5);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }
}

