/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.http;

import com.jinfonet.resstore.ResourceStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.log.JRLoggingUtil;
import jet.server.ServerEnv;
import jet.server.api.Authenticator;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.http.BaseHttpUtil;
import jet.server.api.http.HttpExternalAuthorized;
import jet.server.api.http.HttpUserSessionManager;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.TooManyTimesException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRUserSession;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.jrserver.http.AuthInfo;
import jet.server.jrserver.http.LogoutReg;
import jet.server.jrserver.http.MD5Info;
import jet.server.jrserver.http.RawUserSession;
import jet.server.log.ServiceLogger;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.servlets.ServletUtil;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.util.Base64;

public class JRHttpUserSessionManager
extends JRUserSessionManager
implements HttpUserSessionManager {
    public static final String TAG_JRSESSION = "jrs.userssn";
    public static final String TAG_RAWSESSION = "jrs.rawssn";
    private int SEDU = 5;
    private Hashtable _getCatAndRptNames = new Hashtable();
    private long add = 86400000L;
    private int append = 1024;
    private HttpExternalAuthorized askInvalidate = null;
    private boolean booleanValue = true;
    private String[] checkAdminLogin = new String[0];
    private boolean checkAdminLoginEx;
    private String checkLogin = null;

    public JRHttpUserSessionManager(Authenticator authenticator) {
        super(authenticator);
        String string;
        this.booleanValue = ServerEnv.invalidateHttpSessionWhenLogout();
        String string2 = System.getProperty("jrs.httpExternalAuthorized");
        if (string2 != null && string2.trim().length() > 0) {
            try {
                this.askInvalidate = (HttpExternalAuthorized)Class.forName(string2.trim()).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(3630046, string2, 3);
                ServiceLogger.logError(throwable);
            }
        }
        this.checkAdminLoginEx = ServerEnv.isEnableCheckCSRF();
        if (this.checkAdminLoginEx && (string = System.getProperty("jreport.server.csrf.whitelist")) != null && string.trim().length() > 0) {
            this.checkAdminLogin = string.split(";");
        }
    }

    @Override
    public String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession != null) {
            string = userSession.getUserID();
        }
        return string == null ? "" : string;
    }

    @Override
    public UserSession getUserSession(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            String string = (String)httpSession.getValue("isUserSessionValid");
            if (string == null || "true".equals(string)) {
                try {
                    userSession = this.getUserSession((String)httpSession.getValue(TAG_JRSESSION));
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            } else {
                userSession = new JRUserSession();
            }
        }
        return userSession;
    }

    @Override
    public void setHttpExternalAuthorized(HttpExternalAuthorized httpExternalAuthorized) {
        this.askInvalidate = httpExternalAuthorized;
    }

    @Override
    public HttpExternalAuthorized getHttpExternalAuthorized() {
        return this.askInvalidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredUserSessions(HttpServletRequest httpServletRequest) {
        try {
            UserSession userSession = null;
            Hashtable hashtable = this.htSessions;
            synchronized (hashtable) {
                Enumeration enumeration = this.getAllUserSessions();
                while (enumeration.hasMoreElements()) {
                    userSession = (UserSession)enumeration.nextElement();
                    if (System.currentTimeMillis() - userSession.getLastAccessTime() <= (long)userSession.getMaxInactiveInterval()) continue;
                    if (this.askInvalidate != null) {
                        boolean bl = this.askInvalidate.askInvalidate(userSession);
                        if (userSession.isExternalAuthorized() && !bl) continue;
                        this.logout(httpServletRequest, userSession);
                        continue;
                    }
                    this.logout(httpServletRequest, userSession);
                }
            }
            userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                this.putSessions(userSession);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    @Override
    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object) throws TooManyUsersException {
        return this.loginMD5(string, string2, string3, string4, string5, string6, object, false);
    }

    @Override
    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object, boolean bl) throws TooManyUsersException {
        UserSession userSession = null;
        String string7 = null;
        try {
            string7 = UserDataToolkit.securityAdapter.getPassword(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string3.equals(CSUtil.getH(CSUtil.getH(string2 + ":" + string + ":", string7) + ":" + string4 + ":" + CSUtil.getH(string6 + ":" + string5, null), null))) {
            userSession = this.login(string, string2, string7, object, false, bl);
        }
        return userSession;
    }

    @Override
    public boolean checkLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkLogin(httpServletRequest, null, string, properties);
    }

    @Override
    public boolean checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        try {
            return this.checkLoginEx(httpServletRequest, httpServletResponse, string, properties);
        }
        catch (InvalidUserException invalidUserException) {
            return false;
        }
    }

    @Override
    public boolean checkLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException, InvalidUserException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.contains(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.SEDU) {
                throw new TooManyTimesException(630085);
            }
            if (!this.needSecurity()) {
                String string2 = (String)properties.get("isWait");
                boolean bl = string2 == null ? false : string2.equals("true");
                userSession = this.login(string, "", "", userSession, false, bl);
            } else {
                userSession = this.encodeUrl(httpServletRequest, httpServletResponse, string, properties);
            }
            if (userSession != null) {
                this.checkLoginEx(httpServletRequest, userSession);
                return true;
            }
            return false;
        }
        if (userSession.getID() == null) {
            throw new TooManyUsersException(630088);
        }
        if (this.checkAdminLoginEx) {
            if (ServerEnv.needSecurity() && !this.SEDU(httpServletRequest, string, properties)) {
                if (this._getCatAndRptNames(httpServletRequest, userSession)) {
                    return false;
                }
            } else {
                String string3;
                String string4;
                String string5;
                String string6 = httpServletRequest.getHeader("referer");
                ArrayList<String> arrayList = (ArrayList<String>)userSession.getValue("referer");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    userSession.putValue("referer", arrayList);
                }
                if ((string5 = ServerUtil.getSiteFromUrl(string6)) != null && !arrayList.contains(string5)) {
                    arrayList.add(string5);
                }
                if ((string4 = ServerUtil.getSiteFromUrl(string3 = httpServletRequest.getRequestURL().toString())) != null && !arrayList.contains(string4)) {
                    arrayList.add(string4);
                }
            }
        }
        return true;
    }

    private boolean SEDU(HttpServletRequest httpServletRequest, String string, Properties properties) throws InvalidUserException {
        Object object;
        boolean bl = false;
        if (this.askInvalidate != null && (object = this.askInvalidate.getExternalAuthorizedUser(string, httpServletRequest)) != null) {
            bl = true;
        }
        if (!bl) {
            object = null;
            try {
                object = this.currentTimeMillis(httpServletRequest, string, properties);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            if (object != null) {
                String string2 = ((AuthInfo)object).password;
                RawUserSession rawUserSession = this.contains(httpServletRequest);
                if (rawUserSession != null) {
                    if (((AuthInfo)object).md5 != null && rawUserSession.md5 != null) {
                        if (((AuthInfo)object).userID != null && ((AuthInfo)object).md5.response != null && ((AuthInfo)object).md5.nonce != null && ((AuthInfo)object).md5.nonce.equals(rawUserSession.md5.nonce) && (((AuthInfo)object).md5.opaque == null || ((AuthInfo)object).md5.opaque.equals(rawUserSession.md5.opaque))) {
                            try {
                                string2 = UserDataToolkit.securityAdapter.getPassword(string, ((AuthInfo)object).userID);
                            }
                            catch (RemoteException remoteException) {
                                ServiceLogger.logError(remoteException, 3);
                            }
                            if (string2 == null) {
                                string2 = "";
                            }
                        }
                    } else {
                        string2 = ((AuthInfo)object).password;
                    }
                }
                if (super.getAuthenticator().isValidUserEx(string, ((AuthInfo)object).userID, string2)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkAdminLogin(httpServletRequest, null, string, properties);
    }

    @Override
    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        try {
            return this.checkAdminLoginEx(httpServletRequest, httpServletResponse, string, properties);
        }
        catch (InvalidUserException invalidUserException) {
            return false;
        }
    }

    @Override
    public boolean checkAdminLoginEx(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException, InvalidUserException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.contains(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.SEDU) {
                throw new TooManyTimesException(630085);
            }
            properties.setProperty("isAdmin", "true");
            userSession = this.encodeUrl(httpServletRequest, httpServletResponse, string, properties);
            if (userSession != null) {
                AuthInfo authInfo = this.currentTimeMillis(httpServletRequest, string, properties);
                if (UserDataToolkit.securityAdapter.isAdminUser(string, userSession.getUserID()) || UserDataToolkit.securityAdapter.isOrganizationAdminUser(string, userSession.getUserID())) {
                    this.checkLoginEx(httpServletRequest, userSession);
                    return true;
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                if (httpSession != null) {
                    this.booleanValue(httpSession);
                }
            }
            return false;
        }
        if (userSession.getID() == null) {
            throw new TooManyUsersException(630088);
        }
        if (this.checkAdminLoginEx) {
            if (!this.SEDU(httpServletRequest, string, properties)) {
                if (this._getCatAndRptNames(httpServletRequest, userSession)) {
                    return false;
                }
            } else {
                String string2;
                String string3;
                String string4;
                String string5 = httpServletRequest.getHeader("referer");
                ArrayList<String> arrayList = (ArrayList<String>)userSession.getValue("referer");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    userSession.putValue("referer", arrayList);
                }
                if ((string4 = ServerUtil.getSiteFromUrl(string5)) != null && !arrayList.contains(string4)) {
                    arrayList.add(string4);
                }
                if ((string3 = ServerUtil.getSiteFromUrl(string2 = httpServletRequest.getRequestURL().toString())) != null && !arrayList.contains(string3)) {
                    arrayList.add(string3);
                }
            }
        }
        if (UserDataToolkit.securityAdapter.isAdminUser(string, userSession.getUserID()) || UserDataToolkit.securityAdapter.isOrganizationAdminUser(string, userSession.getUserID())) {
            return true;
        }
        if (this.booleanValue) {
            httpServletRequest.getSession().invalidate();
        }
        return false;
    }

    private boolean _getCatAndRptNames(HttpServletRequest httpServletRequest, UserSession userSession) {
        String string = httpServletRequest.getHeader("referer");
        ArrayList<String> arrayList = (ArrayList<String>)userSession.getValue("referer");
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            userSession.putValue("referer", arrayList);
        }
        String string2 = httpServletRequest.getRequestURL().toString();
        String string3 = ServerUtil.getSiteFromUrl(string2);
        if (string == null || arrayList.contains(ServerUtil.getSiteFromUrl(string))) {
            ServiceLogger.logEvent(6670154, new Object[]{string, arrayList, "false"}, 6);
            if (string == null && string3 != null && !arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            return false;
        }
        String string4 = ServerUtil.getHostFromUrl(string);
        for (String string5 : this.checkAdminLogin) {
            if (!string5.equals(string4)) continue;
            String string6 = ServerUtil.getSiteFromUrl(string);
            if (!arrayList.contains(string6)) {
                arrayList.add(string6);
            }
            ServiceLogger.logEvent(6670154, new Object[]{string, arrayList, "false"}, 6);
            return false;
        }
        try {
            List<InetAddress> list = ServerUtil.getAllLocalAddresses();
            if (string4 == null || string4.equals("127.0.0.1") || string4.equals("localhost") || list.contains(InetAddress.getByName(string4))) {
                String string7 = ServerUtil.getSiteFromUrl(string);
                if (!arrayList.contains(string7)) {
                    arrayList.add(string7);
                }
                ServiceLogger.logEvent(6670154, new Object[]{string, arrayList, "false"}, 6);
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(unknownHostException);
        }
        ServiceLogger.logEvent(6670154, new Object[]{string, arrayList, "true"}, 6);
        return true;
    }

    private void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        Boolean bl = (Boolean)httpServletRequest.getAttribute("isAdmin");
        if (bl == null) {
            bl = false;
        }
        NlsClientResource nlsClientResource = new NlsClientResource(httpServletRequest, bl);
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = nlsClientResource.getServerResourceFactory();
        httpServletResponse.setContentType("text/html;charset=UTF-8");
        PrintWriter printWriter = ServerUtil.getResponseWriter(httpServletResponse);
        if (this.checkLogin == null) {
            this.checkLogin = ServerUtil.getUpperPath(httpServletRequest, "/javascript/jrServer/jrServer.min.js");
        }
        String string2 = httpServletRequest.getParameter("loginCode");
        String string3 = httpServletRequest.getContextPath();
        string3 = string3 + this.checkLogin;
        if (string2 == null || string2.trim().length() == 0) {
            printWriter.println("<!DOCTYPE html");
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            printWriter.println("<title>" + propertyMessageResourcesFactory.getMessage("HTTP_ERROR_8") + "</title>");
            printWriter.println("<link rel=\"shortcut icon\" href=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/favicon.ico") + "\" />");
            printWriter.println("<link href=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/style/jrServer/jrServer.min.css") + "\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />");
            printWriter.println("<script language=\"javascript\">");
            printWriter.println("var NLSResources = new Object();");
            printWriter.println("NLSResources[\"ERR_MSG_001\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_001") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_001\"] = \"" + propertyMessageResourcesFactory.getMessage("2221916") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_002\"] = \"" + propertyMessageResourcesFactory.getMessage("2221917") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_003\"] = \"" + propertyMessageResourcesFactory.getMessage("2221918") + "\";");
            printWriter.println("NLSResources[\"DIALOG_TITLE_004\"] = \"" + propertyMessageResourcesFactory.getMessage("2221919") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_001\"] = \"" + propertyMessageResourcesFactory.getMessage("91000007") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_002\"] = \"" + propertyMessageResourcesFactory.getMessage("91000026") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_003\"] = \"" + propertyMessageResourcesFactory.getMessage("91000004") + "\";");
            printWriter.println("NLSResources[\"DIALOG_BUTTON_004\"] = \"" + propertyMessageResourcesFactory.getMessage("91000006") + "\";");
            printWriter.println("NLSResources[\"LOAD_MSG_001\"] = \"" + propertyMessageResourcesFactory.getMessage("22221467") + "\";");
            printWriter.println("NLSResources[\"ERR_MSG_002\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_004") + "\";");
            printWriter.println("NLSResources[\"ERR_MSG_003\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_005") + "\";");
            printWriter.println("</script>");
            printWriter.println("<script type=\"text/javascript\" src=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/javascript/jquery-1.5.2.min.js") + "\"></script>");
            printWriter.println("<script type=\"text/javascript\" src=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/javascript/jquery.base64.js") + "\"></script>");
            printWriter.println("<script type=\"text/javascript\" src=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string3 + "/javascript/jrServer/jrServer.min.js") + "\"></script>");
            printWriter.println("</head>");
            printWriter.println("<body>");
        }
        if (string2 == null || !string2.trim().equals("ajaxLogin")) {
            Object object;
            String string4;
            String string5 = httpServletRequest.getRequestURI();
            if (string5.indexOf("?") != -1) {
                string5 = string5.substring(0, string5.indexOf("?"));
            }
            Enumeration enumeration = httpServletRequest.getParameterNames();
            if (string2 == null || string2.trim().length() == 0) {
                printWriter.println("<div class=\"jrServer-ui jrServer-dialog\"  draggable=\"false\" style=\"width:420px;height:222px;\" data-options=\"");
                printWriter.println("closed: false,");
                printWriter.println("styleName: 'logindialog', ");
                printWriter.println("minimizable: false,");
                printWriter.println("maximizable: false,");
                printWriter.println("closable: false, ");
                printWriter.println("shadow: false\" >");
            }
            printWriter.println("<form action=\"" + HttpUtil.getWebAppUrl(httpServletRequest, string5) + "\" method=\"POST\"");
            printWriter.println("class=\"jrServer-ui jrServer-loginform\"");
            printWriter.println(">");
            printWriter.println("<input type=\"hidden\" name=\"jrs.auth_isadmin\" value=\"" + bl + "\" />");
            String string6 = "";
            String string7 = "";
            String string8 = "";
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                object = httpServletRequest.getParameterValues(string4);
                if (object == null || string4.equals("loginCode")) continue;
                for (String charSequence : object) {
                    if (null != string4 && "jrs.auth_org".equalsIgnoreCase(string4)) {
                        string6 = charSequence;
                        continue;
                    }
                    if (null != string4 && "jrs.auth_uid".equalsIgnoreCase(string4)) {
                        string7 = charSequence;
                        continue;
                    }
                    if (null != string4 && "jrs.auth_pwd".equalsIgnoreCase(string4)) {
                        string8 = charSequence;
                        continue;
                    }
                    printWriter.println("<input type=\"hidden\" name=\"" + WebSecurityUtil.escapeHTMLAttribute(string4) + "\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(charSequence) + "\" />");
                }
            }
            printWriter.println("<div class=\"headerTitle\">" + propertyMessageResourcesFactory.getMessage("22221136") + "</div>");
            printWriter.println("<div class=\"headerSubTitle\">" + propertyMessageResourcesFactory.getMessage("22221137") + "</div>");
            printWriter.println("<table border=0 cellspacing=0 cellpadding=0 >");
            printWriter.println("<tr>");
            printWriter.println("<td colspan=2 style=\"height: 20px;\">");
            printWriter.println("<div class=\"message\"></div>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            if (ServerEnv.isEnableMultipleOrganization()) {
                printWriter.println("<tr>");
                printWriter.println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221342") + "</td>");
                printWriter.println("<td class=\"input\">");
                printWriter.println("<input type=\"text\" name=\"jrs.auth_org\" value=\"" + (0 < string6.length() ? WebSecurityUtil.escapeHTMLAttribute(string6) : "System") + "\" />");
                printWriter.println("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("<tr>");
            printWriter.println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221132") + "</td>");
            printWriter.println("<td class=\"input\"><input type=\"text\" name=\"jrs.auth_uid\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string7) + "\" /></td>");
            printWriter.println("</tr>");
            printWriter.println("<tr>");
            printWriter.println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221133") + "</td>");
            printWriter.println("<td class=\"input\"><input type=\"password\" name=\"jrs.auth_pwd\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string8) + "\" /></td>");
            printWriter.println("</tr>");
            printWriter.println("<tr>");
            printWriter.println("<td></td><td>");
            printWriter.println("<table border=0 cellspacing=0 cellpadding=0 style=\"width: 100%;\"><tr>");
            printWriter.println("<td style=\"white-space:nowrap;padding-left: 3px;\">");
            printWriter.println("<input name=\"Submit\" type=\"submit\" class=\"submit btn-red\" value=\"" + propertyMessageResourcesFactory.getMessage("22221519") + "\" /><input name=\"Reset\" type=\"button\" class=\"reset btn-gray\" value=\"" + propertyMessageResourcesFactory.getMessage("2220511") + "\" />");
            printWriter.println("</td>");
            printWriter.println("<td id=\"rememberMecheckboxTd\"><input type=\"checkbox\" style=\"padding: 0; margin: 0;\" class=\"rememberMe\" /></td>");
            printWriter.println("<td id=\"rememberMeLabelTd\" class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221134") + "</td>");
            printWriter.println("</tr></table>");
            printWriter.println("</td>");
            printWriter.println("</tr>");
            printWriter.println("</table>");
            string4 = httpServletRequest.getParameter("jrs.report");
            object = httpServletRequest.getParameter("jrs.catalog");
            boolean bl2 = CSUtil.getBoolean((String)httpServletRequest.getAttribute("JRServlet"), false);
            if (bl2 && (string4 == null || object == null)) {
                String string9 = httpServletRequest.getPathInfo();
                if (string9 == null || string9.length() == 0) {
                    string9 = "/";
                }
                if (string9 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    ServletUtil._getCatAndRptNames(string9, stringBuffer2, stringBuffer);
                    String string10 = null;
                    String string11 = null;
                    if (string9.endsWith(".clx") && string9.indexOf(".cat") == -1 && string9.indexOf(".clx") == string9.lastIndexOf(".clx")) {
                        string10 = string9;
                        string11 = string9;
                    } else {
                        if (stringBuffer2 != null && stringBuffer2.toString().trim().length() > 0) {
                            string11 = stringBuffer2.toString();
                        }
                        if (stringBuffer != null && stringBuffer.toString().trim().length() > 0) {
                            string10 = stringBuffer.toString();
                        }
                    }
                    if (string4 == null && string10 != null) {
                        printWriter.println("<input type=\"hidden\" name=\"jrs.report\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(ServerUtil.encodeUrl(string10)) + "\" />");
                    }
                    if (object == null && string11 != null) {
                        printWriter.println("<input type=\"hidden\" name=\"jrs.catalog\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(ServerUtil.encodeUrl(string11)) + "\" />");
                    }
                }
            }
            printWriter.println("</form>");
            if (string2 == null || string2.trim().length() == 0) {
                printWriter.println("</div>");
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            printWriter.println("</body>");
            printWriter.println("</html>");
        }
    }

    @Override
    public void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        Object object;
        if (!BaseHttpUtil.isJRClient(httpServletRequest, null)) {
            if (this.askInvalidate != null && !this.askInvalidate.handleUnAuthenticatedRequest(httpServletRequest, httpServletResponse, string, string2)) {
                return;
            }
            this.add(httpServletRequest, httpServletResponse, string2);
            return;
        }
        if (this.append(httpServletRequest)) {
            return;
        }
        this.clear(httpServletRequest);
        RawUserSession rawUserSession = this.contains(httpServletRequest);
        rawUserSession.realm = string2;
        if (string.equals("Digest")) {
            rawUserSession.md5 = new MD5Info(httpServletRequest);
        }
        if (this.askInvalidate != null && !this.askInvalidate.handleUnAuthenticatedRequest(httpServletRequest, httpServletResponse, string, string2)) {
            return;
        }
        String string3 = "";
        if (ServerEnv.isUseNewRealmName() && (object = httpServletRequest.getHeader("User-Agent")) != null && (((String)object).indexOf("MSIE") != -1 || ((String)object).indexOf("Chrome") != -1)) {
            string3 = "_" + this.endsWith();
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", WebSecurityUtil.validateResponseHeader(rawUserSession.makeAuthHeader(string3)));
        httpServletResponse.setContentType("text/html");
        object = ServerUtil.getResponseWriter(httpServletResponse);
        ((PrintWriter)object).println("<html>");
        ((PrintWriter)object).println("<head>");
        ((PrintWriter)object).println("<title>" + JCliResource.getMessage("CS_MSG_110") + "</title>");
        ((PrintWriter)object).println("</head>");
        ((PrintWriter)object).println("<body>");
        ((PrintWriter)object).println("<H1>401 " + JCliResource.getMessage("CS_MSG_110") + "</H1><h2>");
        ((PrintWriter)object).println("</body>");
        ((PrintWriter)object).println("</html>");
    }

    private boolean append(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("jrs.kickOutOldSsn");
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string2 = null;
        if (httpSession != null) {
            string2 = (String)httpSession.getValue("jrs.kickOutOldSsn");
            httpSession.removeValue("jrs.kickOutOldSsn");
        }
        return string != null || string2 != null;
    }

    @Override
    public boolean isExtraChannel(HttpServletRequest httpServletRequest) {
        return this.isExtraSession(httpServletRequest.getSession(false));
    }

    @Override
    public void logout(HttpServletRequest httpServletRequest) {
        this.checkLogin();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            UserSession userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                // empty if block
            }
            this.logout(httpServletRequest, userSession, true);
        }
    }

    private void askInvalidate(HttpSession httpSession) {
        try {
            if (httpSession != null) {
                String string = httpSession.getId();
                this._getCatAndRptNames.remove(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void booleanValue(HttpSession httpSession) {
        block5: {
            try {
                if (httpSession == null) break block5;
                try {
                    String string = httpSession.getId();
                    LogoutReg logoutReg = (LogoutReg)this._getCatAndRptNames.get(string);
                    if (logoutReg != null) {
                        logoutReg.setRetry();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean checkAdminLogin(HttpServletRequest httpServletRequest) {
        boolean bl;
        block5: {
            bl = false;
            try {
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession == null) break block5;
                try {
                    String string = httpSession.getId();
                    LogoutReg logoutReg = (LogoutReg)this._getCatAndRptNames.get(string);
                    if (logoutReg != null && !logoutReg.retry()) {
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
    }

    private void checkAdminLoginEx(HttpServletRequest httpServletRequest, String string) {
        try {
            if (string != null && !HttpUtil.isJRClient(httpServletRequest, null)) {
                this._getCatAndRptNames.put(string, new LogoutReg());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLogin() {
        try {
            Hashtable hashtable = this._getCatAndRptNames;
            synchronized (hashtable) {
                if (this._getCatAndRptNames.size() >= this.append) {
                    String string;
                    Enumeration enumeration = this._getCatAndRptNames.keys();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (System.currentTimeMillis() - ((LogoutReg)this._getCatAndRptNames.get(string)).getTime() <= this.add) continue;
                        this._getCatAndRptNames.remove(string);
                    }
                    if (this._getCatAndRptNames.size() >= this.append) {
                        int n = this.append / 2;
                        enumeration = this._getCatAndRptNames.keys();
                        for (int i = 0; enumeration.hasMoreElements() && i < n; ++i) {
                            string = (String)enumeration.nextElement();
                            this._getCatAndRptNames.remove(string);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            try {
                Hashtable hashtable = this._getCatAndRptNames;
                synchronized (hashtable) {
                    if (this._getCatAndRptNames.size() > this.append) {
                        this._getCatAndRptNames.clear();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }

    public void logout(HttpServletRequest httpServletRequest, UserSession userSession) {
        this.logout(httpServletRequest, userSession, false);
    }

    private void logout(HttpServletRequest httpServletRequest, UserSession userSession, boolean bl) {
        if (userSession != null) {
            HttpSession httpSession;
            Object object = this.getExtObj(userSession.getID());
            HttpSession httpSession2 = httpSession = object instanceof HttpSession ? (HttpSession)object : null;
            if (userSession.getID() != null) {
                super.logout(userSession);
                this.setUserOndemandClearTime(userSession.getUserID());
            }
            if (httpSession != null) {
                try {
                    httpSession.removeValue(TAG_JRSESSION);
                    if (this.booleanValue) {
                        httpSession.invalidate();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
                httpSession = httpServletRequest.getSession(true);
                if (bl) {
                    try {
                        this.checkAdminLoginEx(httpServletRequest, httpSession.getId());
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                    }
                }
            }
            if (userSession.isExternalAuthorized() && this.askInvalidate != null) {
                this.askInvalidate.notifyLogout(userSession);
            }
        }
    }

    private void checkLoginEx(HttpServletRequest httpServletRequest, UserSession userSession) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            httpSession.putValue(TAG_JRSESSION, (Object)userSession.getID());
            httpSession.removeValue(TAG_RAWSESSION);
            httpSession.putValue("isUserSessionValid", (Object)"true");
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void clear(HttpServletRequest httpServletRequest) {
        if (this.contains(httpServletRequest) == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                httpSession.putValue(TAG_RAWSESSION, (Object)new RawUserSession());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private RawUserSession contains(HttpServletRequest httpServletRequest) {
        RawUserSession rawUserSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                rawUserSession = (RawUserSession)httpSession.getValue(TAG_RAWSESSION);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return rawUserSession;
    }

    private AuthInfo currentTimeMillis(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string2 = httpServletRequest.getHeader("Authorization");
        boolean bl = HttpUtil.isJRClient(httpServletRequest, properties);
        if (string2 != null && string2.length() > 0) {
            if (this.checkAdminLogin(httpServletRequest)) {
                this.booleanValue(httpServletRequest.getSession(true));
                return null;
            }
            HttpSession httpSession = httpServletRequest.getSession(false);
            if ((httpSession == null || httpSession.isNew()) && (authInfo = this.decode(properties, bl)) == null) {
                this.booleanValue(httpServletRequest.getSession(true));
                return null;
            }
            int n = (string2 = string2.trim()).indexOf(" ");
            if (n > 0) {
                if (string2.startsWith("Basic")) {
                    string2 = string2.substring(n).trim();
                    String string3 = !bl ? (CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string2), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string2), "ISO-8859-1")) : new String(Base64.decode((byte[])string2.getBytes("ISO-8859-1")));
                    n = string3.indexOf(":");
                    if (n > 0) {
                        authInfo = new AuthInfo();
                        authInfo.userID = string3.substring(0, n).trim();
                        authInfo.password = string3.substring(n + 1);
                    }
                } else if (string2.startsWith("Digest")) {
                    Object object;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    string2 = string2.substring("Digest".length() + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken().trim();
                        int n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) continue;
                        String string9 = ((String)object).substring(0, n2).trim();
                        String string10 = ((String)object).substring(n2 + 1).trim();
                        if (string9.equalsIgnoreCase("username")) {
                            string4 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("realm")) {
                            string5 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("nonce")) {
                            string6 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("response")) {
                            string7 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("opaque")) continue;
                        string8 = CSUtil.removeQuotes(string10);
                    }
                    object = new MD5Info();
                    ((MD5Info)object).nonce = string6;
                    ((MD5Info)object).opaque = string8;
                    ((MD5Info)object).response = string7;
                    authInfo = new AuthInfo();
                    authInfo.userID = string4.trim();
                    authInfo.md5 = object;
                }
            }
        } else {
            authInfo = this.decode(properties, bl);
        }
        return authInfo;
    }

    private AuthInfo decode(Properties properties, boolean bl) throws IOException {
        AuthInfo authInfo = null;
        String string = null;
        String string2 = null;
        String string3 = (String)properties.get("jrs.authorization");
        if (string3 != null && string3.trim().length() > 0) {
            String string4 = !bl ? (CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string3), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string3), "ISO-8859-1")) : new String(Base64.decode((byte[])string3.getBytes("ISO-8859-1")));
            int n = string4.indexOf(":");
            if (n > 0) {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            String string5 = (String)properties.get("jrs.auth_org");
            string = (String)properties.get("jrs.auth_uid");
            string2 = (String)properties.get("jrs.auth_pwd");
            if (string2 == null) {
                string2 = "";
            }
            if (string5 != null && string5.trim().length() > 0 && !string5.equals("System")) {
                string = string5 + "\\" + string;
            }
        }
        if (string != null) {
            authInfo = new AuthInfo();
            authInfo.userID = string.trim();
            authInfo.password = string2;
        }
        return authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserSession encodeUrl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, IOException, InvalidUserException {
        Object object;
        Object object2;
        if (null != httpServletRequest.getAttribute("RequestUS")) {
            Object object3 = httpServletRequest.getAttribute("RequestUS");
            return object3 instanceof String ? null : (UserSession)object3;
        }
        UserSession userSession = null;
        if (this.askInvalidate != null && (object2 = this.askInvalidate.getExternalAuthorizedUser(string, httpServletRequest)) != null) {
            userSession = this.loginExternalAuthorized(string, (String)object2, httpServletRequest.getSession(true));
        }
        if (userSession == null) {
            object2 = this.currentTimeMillis(httpServletRequest, string, properties);
            object = (String)properties.get("isWait");
            boolean bl = object == null ? false : ((String)object).equals("true");
            if (object2 != null) {
                boolean bl2;
                RawUserSession rawUserSession = this.contains(httpServletRequest);
                if (rawUserSession != null && ((AuthInfo)object2).md5 != null && rawUserSession.md5 != null && ((AuthInfo)object2).userID != null && ((AuthInfo)object2).md5.response != null && ((AuthInfo)object2).md5.nonce != null && ((AuthInfo)object2).md5.nonce.equals(rawUserSession.md5.nonce) && (((AuthInfo)object2).md5.opaque == null || ((AuthInfo)object2).md5.opaque.equals(rawUserSession.md5.opaque))) {
                    userSession = this.loginMD5(rawUserSession.realm, ((AuthInfo)object2).userID, ((AuthInfo)object2).md5.response, ((AuthInfo)object2).md5.nonce, rawUserSession.md5.uri, httpServletRequest.getMethod(), httpServletRequest.getSession(true), bl);
                    httpServletRequest.setAttribute("RequestUS", null == userSession ? "null" : userSession);
                    return userSession;
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                boolean bl3 = super.getAuthenticator().isValidUserEx(string, ((AuthInfo)object2).userID, ((AuthInfo)object2).password);
                if (!bl3) {
                    httpServletRequest.setAttribute("RequestUS", (Object)"null");
                    return null;
                }
                boolean bl4 = bl2 = super.getAuthenticator().isAdminUser(string, ((AuthInfo)object2).userID) || super.getAuthenticator().isOrganizationAdminUser(string, ((AuthInfo)object2).userID);
                if (!properties.getProperty("isAdmin", "false").equals("true") || bl2) {
                    if (httpServletRequest != null) {
                        try {
                            httpSession.putValue("jrs.extraReq", (Object)httpServletRequest);
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable, 3);
                        }
                    }
                    if (httpServletResponse != null) {
                        try {
                            httpSession.putValue("jrs.extraRes", (Object)httpServletResponse);
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable, 3);
                        }
                    }
                    try {
                        userSession = this.login(string, ((AuthInfo)object2).userID, ((AuthInfo)object2).password, httpSession, false, bl, HttpUtil.isJRClient(httpServletRequest, properties));
                    }
                    finally {
                        httpSession.removeValue("jrs.extraReq");
                        httpSession.removeValue("jrs.extraRes");
                    }
                }
                if (userSession != null) {
                    this.askInvalidate(httpSession);
                } else if (httpSession != null) {
                    this.booleanValue(httpSession);
                }
            }
        }
        httpServletRequest.setAttribute("RequestUS", null == userSession ? "null" : userSession);
        if (userSession != null) {
            object2 = userSession.getUserID();
            object = JRServerResourceStoreFactory.getInstance().getResourceStoreByUser((String)object2);
            JRLoggingUtil.setMDCManager((ResourceStore)object);
        }
        return userSession;
    }

    private String endsWith() {
        Object var1_1 = null;
        int n = 4;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(Math.random() * 10.0 + 48.0);
        }
        return new String(cArray);
    }
}

