/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.monitor;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.RptServer;
import jet.server.api.UserSession;
import jet.server.api.monitor.UserSessionMonitor;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.log.ServiceLogger;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class JRUserSessionMonitor
implements UserSessionMonitor,
SortCompareInterface {
    private RptServer SEDU = null;
    private int[] addElement = new int[0];
    private ExProperties compareTo = new ExProperties();
    private String elementAt = ServerEnv.getServPropName();

    public JRUserSessionMonitor(RptServer rptServer) {
        this.SEDU = rptServer;
        try {
            this.compareTo.load(this.elementAt);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    @Override
    public Vector getAllUserSessions() {
        Vector vector = new Vector();
        Enumeration enumeration = this.SEDU.getUserSessionManager().getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public Vector getAllUserSessionsByUserID(String string) {
        UserSession userSession = null;
        Vector<UserSession> vector = new Vector<UserSession>();
        Vector vector2 = this.getAllUserSessions();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            userSession = (UserSession)vector2.elementAt(i);
            if (!userSession.getUserID().equalsIgnoreCase(string)) continue;
            vector.addElement(userSession);
        }
        return vector;
    }

    @Override
    public Vector getSortedUserSessions(Vector vector, int[] nArray) {
        this.addElement = nArray;
        return MiniSort.sort(vector, this);
    }

    @Override
    public void removeUserSessionBySessionID(String string) {
        this.SEDU.getUserSessionManager().logout(this.SEDU.getUserSessionManager().getUserSession(string));
    }

    @Override
    public void removeUserSessionsByUserID(String string) {
        Vector vector = this.getAllUserSessionsByUserID(string);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.SEDU.getUserSessionManager().logout((UserSession)vector.elementAt(i));
        }
    }

    @Override
    public void removeAllSelectedUserSessions(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.SEDU.getUserSessionManager().logout(this.SEDU.getUserSessionManager().getUserSession(stringArray[i]));
        }
    }

    @Override
    public void removeAllUserSessions() {
        Enumeration enumeration = this.SEDU.getUserSessionManager().getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            this.SEDU.getUserSessionManager().logout((UserSession)enumeration.nextElement());
        }
    }

    @Override
    public void setSessionTimeout(int n) {
        this.SEDU.getUserSessionManager().setDefaultMaxInactiveInterval(1000 * n);
        this.compareTo.setProperty("server.session.timeout", n);
        try {
            this.compareTo.save(this.elementAt, null);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.SEDU.getUserSessionManager().getDefaultMaxInactiveInterval() / 1000;
    }

    @Override
    public HttpSession getHttpSession(String string) {
        Object object = this.SEDU.getUserSessionManager();
        if (object instanceof JRUserSessionManager) {
            if ((object = ((JRUserSessionManager)object).getExtObj(string)) instanceof HttpSession) {
                return (HttpSession)object;
            }
            return null;
        }
        return null;
    }

    public String getHttpSessionID(String string) {
        HttpSession httpSession = this.getHttpSession(string);
        if (httpSession != null) {
            return httpSession.getId();
        }
        return null;
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        if (object != null && object2 != null && object instanceof UserSession) {
            UserSession userSession = (UserSession)object;
            UserSession userSession2 = (UserSession)object2;
            if (this.SEDU(userSession, userSession2, this.addElement[0]) < 0) {
                return true;
            }
            if (this.SEDU(userSession, userSession2, this.addElement[0]) == 0 && this.addElement.length > 1) {
                if (this.SEDU(userSession, userSession2, this.addElement[1]) < 0) {
                    return true;
                }
                if (this.SEDU(userSession, userSession2, this.addElement[1]) == 0 && this.addElement.length > 2) {
                    if (this.SEDU(userSession, userSession2, this.addElement[2]) < 0) {
                        return true;
                    }
                    if (this.SEDU(userSession, userSession2, this.addElement[2]) == 0 && this.addElement.length > 3) {
                        if (this.SEDU(userSession, userSession2, this.addElement[3]) < 0) {
                            return true;
                        }
                        if (this.SEDU(userSession, userSession2, this.addElement[3]) == 0 && this.addElement.length > 4) {
                            if (this.SEDU(userSession, userSession2, this.addElement[4]) < 0) {
                                return true;
                            }
                            if (this.SEDU(userSession, userSession2, this.addElement[4]) == 0 && this.addElement.length > 5 && this.SEDU(userSession, userSession2, this.addElement[5]) < 0) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }

    private int SEDU(UserSession userSession, UserSession userSession2, int n) {
        switch (n) {
            case 0: {
                return userSession.getID().toUpperCase().compareTo(userSession2.getID().toUpperCase());
            }
            case 1: {
                return userSession.getUserID().toUpperCase().compareTo(userSession2.getUserID().toUpperCase());
            }
            case 2: {
                long l = userSession.getCreationTime();
                long l2 = userSession2.getCreationTime();
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                long l = userSession.getLastAccessTime();
                long l3 = userSession2.getLastAccessTime();
                if (l < l3) {
                    return -1;
                }
                if (l > l3) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                String string = this.getHttpSession(userSession.getID()) == null ? "" : this.getHttpSession(userSession.getID()).getId();
                String string2 = this.getHttpSession(userSession2.getID()) == null ? "" : this.getHttpSession(userSession2.getID()).getId();
                return string.toUpperCase().compareTo(string2.toUpperCase());
            }
            case 5: {
                String string = userSession.isExternalAuthorized() ? "External" : "Internal";
                String string3 = userSession2.isExternalAuthorized() ? "External" : "Internal";
                return string.toUpperCase().compareTo(string3.toUpperCase());
            }
        }
        return -1;
    }
}

