/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.nls;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jet.jetc.ReadFailureException;
import jet.server.api.cluster.ClusterException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.nls.FontNLSEntry;
import jet.server.api.nls.FormatNLSEntry;
import jet.server.api.nls.NLSEntry;
import jet.server.api.nls.NLSType;
import jet.server.api.nls.ReportNLSLibrary;
import jet.server.api.nls.TextNLSEntry;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.NLSContent;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.util.NLSResourceBundle;

public class JRReportNLSLibrary
implements ReportNLSLibrary {
    private NLSManager $SwitchMap$jet$server$api$nls$NLSType = null;
    private Map COLUMN = new HashMap();
    private ClusterMap DISP = null;
    private String LABEL;
    private int META;
    private String NLS_SUB_REPORT_VERSION_NUMBER;

    public JRReportNLSLibrary(String string, int n, String string2) {
        this.LABEL = string;
        this.META = n;
        this.NLS_SUB_REPORT_VERSION_NUMBER = string2;
        this.$SwitchMap$jet$server$api$nls$NLSType = UserDataToolkit.getNLSManager();
        this.COLUMN();
    }

    public boolean isLegalLocale(Locale locale) {
        return NLSUtil.getAvailableLocalesOfNLS().contains(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NLSContent $SwitchMap$jet$server$api$nls$NLSType(Locale locale) {
        if (!this.isLegalLocale(locale)) {
            return null;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            if (!this.COLUMN.containsKey(locale)) {
                return null;
            }
            NLSContent nLSContent = (NLSContent)this.COLUMN.get(locale);
            if (null != nLSContent) {
                return nLSContent;
            }
            try {
                nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType.getAvailableCategoryContents(this.LABEL, this.META, locale, this.NLS_SUB_REPORT_VERSION_NUMBER);
                this.COLUMN.put(locale, nLSContent);
                ArrayList arrayList = (ArrayList)NLSUtil.nlsContentToNLSEntries(nLSContent);
                this.DISP.put(locale, arrayList);
                return nLSContent;
            }
            catch (UnknownResource unknownResource) {
                ServiceLogger.logError((Throwable)((Object)unknownResource));
            }
            catch (NoPrivilegeException noPrivilegeException) {
                ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            return null;
        }
    }

    private void COLUMN() {
        Locale[] localeArray = null;
        try {
            localeArray = this.$SwitchMap$jet$server$api$nls$NLSType.getAvailableLocalesOfReport(this.LABEL, this.META, this.NLS_SUB_REPORT_VERSION_NUMBER);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        if (null != localeArray) {
            for (Locale locale : localeArray) {
                this.COLUMN.put(locale, null);
            }
        }
        try {
            this.DISP = MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.REPORT_NLS_LIBRARY, "@" + this.LABEL + ":" + this.META));
            this.DISP.addListener(new MapListenerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPut(String string, int n, Locale locale, ArrayList arrayList, ArrayList arrayList2, MapFlags mapFlags) {
                    ServiceLogger.logDebug("JRReportNLSLibrary: listened reportNLSMap.afterPut: key is " + locale + ", value is " + arrayList + ", prev is " + arrayList2, 6);
                    Map map = JRReportNLSLibrary.this.COLUMN;
                    synchronized (map) {
                        NLSContent nLSContent;
                        if (!JRReportNLSLibrary.this.COLUMN.containsKey(locale) || null == (nLSContent = (NLSContent)JRReportNLSLibrary.this.COLUMN.get(locale))) {
                            nLSContent = new NLSContent(locale);
                            Map[] mapArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                            nLSContent.setContent(mapArray);
                            nLSContent.setReportPath(JRReportNLSLibrary.this.LABEL);
                            nLSContent.setVersionNumber(JRReportNLSLibrary.this.META);
                            nLSContent.setEncoding("UTF-8");
                        }
                        NLSUtil.nlsEntriesToNLSContent(arrayList, nLSContent);
                        JRReportNLSLibrary.this.COLUMN.put(locale, nLSContent);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRemove(String string, int n, Locale locale, ArrayList arrayList, MapFlags mapFlags) {
                    ServiceLogger.logDebug("JRReportNLSLibrary: listened reportNLSMap.afterRemove: key is " + locale + ", value is " + arrayList, 6);
                    Map map = JRReportNLSLibrary.this.COLUMN;
                    synchronized (map) {
                        if (JRReportNLSLibrary.this.COLUMN.containsKey(locale)) {
                            JRReportNLSLibrary.this.COLUMN.remove(locale);
                        }
                    }
                }
            });
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
    }

    public List getAvailableLocales() {
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        for (Locale locale : this.COLUMN.keySet()) {
            linkedList.add(locale);
        }
        return linkedList;
    }

    @Override
    public boolean containsLocale(Locale locale) {
        return this.getAvailableLocales().contains(locale);
    }

    private static String[] DISP(String string) {
        return NLSResourceBundle.parseFontValueTexts((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNLSEntries(Locale locale) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                Object object;
                String string;
                Map[] mapArray = nLSContent.getContent();
                Map map = mapArray[0];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.LABEL, string2, string);
                    linkedList.add(object);
                }
                map = mapArray[1];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new FormatNLSEntry(string2, string);
                    linkedList.add(object);
                }
                map = mapArray[2];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = JRReportNLSLibrary.DISP(string2);
                    double d = NLSUtil.getPointSize(Integer.parseInt(object[1]));
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
                    decimalFormat.applyPattern("####");
                    String string3 = decimalFormat.format(d);
                    String[] stringArray = JRReportNLSLibrary.DISP(string);
                    double d2 = NLSUtil.getPointSize(Integer.parseInt(stringArray[1]));
                    String string4 = decimalFormat.format(d2);
                    FontNLSEntry fontNLSEntry = new FontNLSEntry(object[0], Integer.parseInt(string3), stringArray[0], Integer.parseInt(string4), false);
                    linkedList.add(fontNLSEntry);
                }
                map = mapArray[3];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.COLUMN, string2, string);
                    linkedList.add(object);
                }
                map = mapArray[4];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.PROMPT, string2, string);
                    linkedList.add(object);
                }
                map = mapArray[5];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.TOC, string2, string);
                    linkedList.add(object);
                }
                map = mapArray[6];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.META, string2, string);
                    linkedList.add(object);
                }
                map = mapArray[7];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.TITLE, string2, string);
                    linkedList.add(object);
                }
                map = mapArray[8];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    object = new TextNLSEntry(NLSType.DISP, string2, string);
                    linkedList.add(object);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTextNLSEntries(Locale locale) {
        LinkedList<TextNLSEntry> linkedList = new LinkedList<TextNLSEntry>();
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                TextNLSEntry textNLSEntry;
                String string;
                Map[] mapArray = nLSContent.getContent();
                Map map = mapArray[0];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.LABEL, string2, string);
                    linkedList.add(textNLSEntry);
                }
                map = mapArray[3];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.COLUMN, string2, string);
                    linkedList.add(textNLSEntry);
                }
                map = mapArray[4];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.PROMPT, string2, string);
                    linkedList.add(textNLSEntry);
                }
                map = mapArray[5];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.TOC, string2, string);
                    linkedList.add(textNLSEntry);
                }
                map = mapArray[6];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.META, string2, string);
                    linkedList.add(textNLSEntry);
                }
                map = mapArray[7];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.TITLE, string2, string);
                    linkedList.add(textNLSEntry);
                }
                map = mapArray[8];
                for (String string2 : map.keySet()) {
                    string = (String)map.get(string2);
                    textNLSEntry = new TextNLSEntry(NLSType.DISP, string2, string);
                    linkedList.add(textNLSEntry);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFormatNLSEntries(Locale locale) {
        LinkedList<FormatNLSEntry> linkedList = new LinkedList<FormatNLSEntry>();
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                Map[] mapArray = nLSContent.getContent();
                Map map = mapArray[1];
                for (String string : map.keySet()) {
                    String string2 = (String)map.get(string);
                    FormatNLSEntry formatNLSEntry = new FormatNLSEntry(string, string2);
                    linkedList.add(formatNLSEntry);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFontNLSEntries(Locale locale) {
        LinkedList<FontNLSEntry> linkedList = new LinkedList<FontNLSEntry>();
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                Map[] mapArray = nLSContent.getContent();
                Map map = mapArray[2];
                for (String string : map.keySet()) {
                    String string2 = (String)map.get(string);
                    String[] stringArray = JRReportNLSLibrary.DISP(string);
                    double d = NLSUtil.getPointSize(Integer.parseInt(stringArray[1]));
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
                    decimalFormat.applyPattern("####");
                    String string3 = decimalFormat.format(d);
                    String[] stringArray2 = JRReportNLSLibrary.DISP(string2);
                    double d2 = NLSUtil.getPointSize(Integer.parseInt(stringArray2[1]));
                    String string4 = decimalFormat.format(d2);
                    FontNLSEntry fontNLSEntry = new FontNLSEntry(stringArray[0], Integer.parseInt(string3), stringArray2[0], Integer.parseInt(string4), false);
                    linkedList.add(fontNLSEntry);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextNLSEntry getTextNLSEntry(Locale locale, NLSType nLSType, String string) {
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                Map[] mapArray = nLSContent.getContent();
                Map map = null;
                switch (nLSType) {
                    case LABEL: {
                        map = mapArray[0];
                        break;
                    }
                    case COLUMN: {
                        map = mapArray[3];
                        break;
                    }
                    case PROMPT: {
                        map = mapArray[4];
                        break;
                    }
                    case TOC: {
                        map = mapArray[5];
                        break;
                    }
                    case META: {
                        map = mapArray[6];
                        break;
                    }
                    case TITLE: {
                        map = mapArray[7];
                        break;
                    }
                    case DISP: {
                        map = mapArray[8];
                    }
                }
                if (null != map && map.containsKey(string)) {
                    String string2 = (String)map.get(string);
                    TextNLSEntry textNLSEntry = new TextNLSEntry(nLSType, string, string2);
                    return textNLSEntry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormatNLSEntry getFormatNLSEntry(Locale locale, String string) {
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                Map[] mapArray = nLSContent.getContent();
                Map map = mapArray[1];
                if (null != map && map.containsKey(string)) {
                    String string2 = (String)map.get(string);
                    FormatNLSEntry formatNLSEntry = new FormatNLSEntry(string, string2);
                    return formatNLSEntry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontNLSEntry getFontNLSEntry(Locale locale, String string, int n) {
        NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
        if (null != nLSContent) {
            NLSContent nLSContent2 = nLSContent;
            synchronized (nLSContent2) {
                Map[] mapArray = nLSContent.getContent();
                Map map = mapArray[2];
                String string2 = string + "," + String.valueOf(n);
                if (null != map && map.containsKey(string2)) {
                    String string3 = (String)map.get(string2);
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
                    decimalFormat.applyPattern("####");
                    String[] stringArray = JRReportNLSLibrary.DISP(string3);
                    double d = NLSUtil.getPointSize(Integer.parseInt(stringArray[1]));
                    String string4 = decimalFormat.format(d);
                    FontNLSEntry fontNLSEntry = new FontNLSEntry(string, n, stringArray[0], Integer.parseInt(string4), false);
                    return fontNLSEntry;
                }
            }
        }
        return null;
    }

    private void LABEL(NLSContent nLSContent) {
        try {
            this.$SwitchMap$jet$server$api$nls$NLSType.saveReportNLS(nLSContent, this.NLS_SUB_REPORT_VERSION_NUMBER);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void META(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            if (!this.COLUMN.containsKey(locale)) {
                NLSContent nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                Map[] mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            NLSContent nLSContent = (NLSContent)this.COLUMN.get(locale);
            Map[] mapArray = nLSContent.getContent();
            mapArray[0].clear();
            mapArray[1].clear();
            mapArray[2].clear();
            mapArray[3].clear();
            mapArray[4].clear();
            mapArray[5].clear();
            mapArray[6].clear();
            mapArray[7].clear();
            mapArray[8].clear();
            for (NLSEntry nLSEntry : list) {
                Object object;
                Map map2 = null;
                if (nLSEntry instanceof TextNLSEntry) {
                    object = ((TextNLSEntry)nLSEntry).getType();
                    String string = ((TextNLSEntry)nLSEntry).getKeyText();
                    String string2 = ((TextNLSEntry)nLSEntry).getValueText();
                    switch (2.$SwitchMap$jet$server$api$nls$NLSType[((Enum)object).ordinal()]) {
                        case 1: {
                            map2 = mapArray[0];
                            break;
                        }
                        case 2: {
                            map2 = mapArray[3];
                            break;
                        }
                        case 3: {
                            map2 = mapArray[4];
                            break;
                        }
                        case 4: {
                            map2 = mapArray[5];
                            break;
                        }
                        case 5: {
                            map2 = mapArray[6];
                            break;
                        }
                        case 6: {
                            map2 = mapArray[7];
                            break;
                        }
                        case 7: {
                            map2 = mapArray[8];
                        }
                    }
                    if (map2.containsKey(string) && !bl) continue;
                    bl2 = true;
                    map2.put(string, string2);
                    continue;
                }
                if (nLSEntry instanceof FormatNLSEntry) {
                    object = ((FormatNLSEntry)nLSEntry).getKeyFormat();
                    String string = ((FormatNLSEntry)nLSEntry).getValueFormat();
                    map2 = mapArray[1];
                    if (map2.containsKey(object) && !bl) continue;
                    bl3 = true;
                    map2.put(object, string);
                    continue;
                }
                object = ((FontNLSEntry)nLSEntry).getOrginalFace();
                long l = NLSUtil.getUnit(((FontNLSEntry)nLSEntry).getOrginalSize());
                String string = ((FontNLSEntry)nLSEntry).getTargetFace();
                long l2 = NLSUtil.getUnit(((FontNLSEntry)nLSEntry).getTargetSize());
                String string3 = NLSUtil.mergeFontContext((String)object, String.valueOf(l));
                String string4 = NLSUtil.mergeFontContext(string, String.valueOf(l2));
                map2 = mapArray[2];
                if (map2.containsKey(string3) && !bl) continue;
                bl4 = true;
                map2.put(string3, string4);
            }
            nLSContent.setEnableLabel(bl2);
            nLSContent.setEnableFormat(bl3);
            nLSContent.setEnableFont(bl4);
            this.LABEL(nLSContent);
            this.DISP.put(locale, (ArrayList)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NLS_SUB_REPORT_VERSION_NUMBER(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            Map[] mapArray;
            if (!this.COLUMN.containsKey(locale)) {
                NLSContent nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            boolean bl2 = false;
            mapArray = (Map[])this.COLUMN.get(locale);
            Map[] mapArray2 = mapArray.getContent();
            mapArray2[0].clear();
            mapArray2[3].clear();
            mapArray2[4].clear();
            mapArray2[5].clear();
            mapArray2[6].clear();
            mapArray2[7].clear();
            mapArray2[8].clear();
            for (NLSEntry nLSEntry : list) {
                NLSType nLSType = ((TextNLSEntry)nLSEntry).getType();
                String string = ((TextNLSEntry)nLSEntry).getKeyText();
                String string2 = ((TextNLSEntry)nLSEntry).getValueText();
                Map map2 = null;
                switch (nLSType) {
                    case LABEL: {
                        map2 = mapArray2[0];
                        break;
                    }
                    case COLUMN: {
                        map2 = mapArray2[3];
                        break;
                    }
                    case PROMPT: {
                        map2 = mapArray2[4];
                        break;
                    }
                    case TOC: {
                        map2 = mapArray2[5];
                        break;
                    }
                    case META: {
                        map2 = mapArray2[6];
                        break;
                    }
                    case TITLE: {
                        map2 = mapArray2[7];
                        break;
                    }
                    case DISP: {
                        map2 = mapArray2[8];
                    }
                }
                if (map2.containsKey(string) && !bl) continue;
                bl2 = true;
                map2.put(string, string2);
            }
            mapArray.setEnableLabel(bl2);
            this.LABEL((NLSContent)mapArray);
            this.DISP.put(locale, (ArrayList)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void PROMPT(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent;
            if (!this.COLUMN.containsKey(locale)) {
                nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                Map[] mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            nLSContent = (NLSContent)this.COLUMN.get(locale);
            boolean bl2 = false;
            Map[] mapArray = nLSContent.getContent();
            mapArray[1].clear();
            for (NLSEntry nLSEntry : list) {
                String string = ((FormatNLSEntry)nLSEntry).getKeyFormat();
                String string2 = ((FormatNLSEntry)nLSEntry).getValueFormat();
                Map map2 = mapArray[1];
                if (map2.containsKey(string) && !bl) continue;
                bl2 = true;
                map2.put(string, string2);
            }
            nLSContent.setEnableFormat(bl2);
            this.LABEL(nLSContent);
            this.DISP.put(locale, (ArrayList)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void REPORT_NLS_LIBRARY(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent;
            if (!this.COLUMN.containsKey(locale)) {
                nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                Map[] mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            nLSContent = (NLSContent)this.COLUMN.get(locale);
            boolean bl2 = false;
            Map[] mapArray = nLSContent.getContent();
            mapArray[2].clear();
            for (FontNLSEntry fontNLSEntry : list) {
                String string = fontNLSEntry.getOrginalFace();
                long l = NLSUtil.getUnit(fontNLSEntry.getOrginalSize());
                String string2 = fontNLSEntry.getTargetFace();
                long l2 = NLSUtil.getUnit(fontNLSEntry.getTargetSize());
                String string3 = NLSUtil.mergeFontContext(string, String.valueOf(l));
                String string4 = NLSUtil.mergeFontContext(string2, String.valueOf(l2));
                Map map2 = mapArray[2];
                if (map2.containsKey(string3) && !bl) continue;
                bl2 = true;
                map2.put(string3, string4);
            }
            nLSContent.setEnableFont(bl2);
            this.LABEL(nLSContent);
            this.DISP.put(locale, (ArrayList)list);
        }
    }

    public void updateNLSEntries(Locale locale, List list) {
        ArrayList<NLSEntry> arrayList = new ArrayList<NLSEntry>();
        for (NLSEntry nLSEntry : list) {
            if (nLSEntry instanceof TextNLSEntry) {
                arrayList.add(new TextNLSEntry(((TextNLSEntry)nLSEntry).getType(), ((TextNLSEntry)nLSEntry).getKeyText(), ((TextNLSEntry)nLSEntry).getValueText()));
                continue;
            }
            if (nLSEntry instanceof FormatNLSEntry) {
                arrayList.add(new FormatNLSEntry(((FormatNLSEntry)nLSEntry).getKeyFormat(), ((FormatNLSEntry)nLSEntry).getValueFormat()));
                continue;
            }
            arrayList.add(new FontNLSEntry(((FontNLSEntry)nLSEntry).getOrginalFace(), ((FontNLSEntry)nLSEntry).getOrginalSize(), ((FontNLSEntry)nLSEntry).getTargetFace(), ((FontNLSEntry)nLSEntry).getTargetSize(), false));
        }
        this.META(locale, arrayList, true);
    }

    public void updateTextNLSEntries(Locale locale, List list) {
        ArrayList<TextNLSEntry> arrayList = new ArrayList<TextNLSEntry>();
        for (TextNLSEntry textNLSEntry : list) {
            arrayList.add(new TextNLSEntry(textNLSEntry.getType(), textNLSEntry.getKeyText(), textNLSEntry.getValueText()));
        }
        this.NLS_SUB_REPORT_VERSION_NUMBER(locale, arrayList, true);
    }

    public void updateFormatNLSEntries(Locale locale, List list) {
        ArrayList<FormatNLSEntry> arrayList = new ArrayList<FormatNLSEntry>();
        for (FormatNLSEntry formatNLSEntry : list) {
            arrayList.add(new FormatNLSEntry(formatNLSEntry.getKeyFormat(), formatNLSEntry.getValueFormat()));
        }
        this.PROMPT(locale, arrayList, true);
    }

    public void updateFontNLSEntries(Locale locale, List list) {
        ArrayList<FontNLSEntry> arrayList = new ArrayList<FontNLSEntry>();
        for (FontNLSEntry fontNLSEntry : list) {
            arrayList.add(new FontNLSEntry(fontNLSEntry.getOrginalFace(), fontNLSEntry.getOrginalSize(), fontNLSEntry.getTargetFace(), fontNLSEntry.getTargetSize(), false));
        }
        this.REPORT_NLS_LIBRARY(locale, arrayList, true);
    }

    @Override
    public void updateNLSEntry(Locale locale, NLSEntry nLSEntry) {
        if (nLSEntry instanceof TextNLSEntry) {
            this.updateTextNLSEntry(locale, (TextNLSEntry)nLSEntry);
        } else if (nLSEntry instanceof FormatNLSEntry) {
            this.updateFormatNLSEntry(locale, (FormatNLSEntry)nLSEntry);
        } else {
            this.updateFontNLSEntry(locale, (FontNLSEntry)nLSEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTextNLSEntry(Locale locale, TextNLSEntry textNLSEntry) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            Map[] mapArray;
            NLSContent nLSContent;
            if (!this.COLUMN.containsKey(locale)) {
                nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            nLSContent = (NLSContent)this.COLUMN.get(locale);
            mapArray = nLSContent.getContent();
            NLSType nLSType = textNLSEntry.getType();
            String string = textNLSEntry.getKeyText();
            String string2 = textNLSEntry.getValueText();
            Map map2 = null;
            switch (nLSType) {
                case LABEL: {
                    map2 = mapArray[0];
                    break;
                }
                case COLUMN: {
                    map2 = mapArray[3];
                    break;
                }
                case PROMPT: {
                    map2 = mapArray[4];
                    break;
                }
                case TOC: {
                    map2 = mapArray[5];
                    break;
                }
                case META: {
                    map2 = mapArray[6];
                    break;
                }
                case TITLE: {
                    map2 = mapArray[7];
                    break;
                }
                case DISP: {
                    map2 = mapArray[8];
                }
            }
            map2.put(string, string2);
            nLSContent.setEnableLabel(true);
            this.LABEL(nLSContent);
            ((ArrayList)this.DISP.get(locale)).remove(textNLSEntry);
            ((ArrayList)this.DISP.get(locale)).add(textNLSEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFormatNLSEntry(Locale locale, FormatNLSEntry formatNLSEntry) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            Map[] mapArray;
            NLSContent nLSContent;
            if (!this.COLUMN.containsKey(locale)) {
                nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            nLSContent = (NLSContent)this.COLUMN.get(locale);
            mapArray = nLSContent.getContent();
            String string = formatNLSEntry.getKeyFormat();
            String string2 = formatNLSEntry.getValueFormat();
            Map map2 = mapArray[1];
            map2.put(string, string2);
            nLSContent.setEnableFormat(true);
            this.LABEL(nLSContent);
            ((ArrayList)this.DISP.get(locale)).remove(formatNLSEntry);
            ((ArrayList)this.DISP.get(locale)).add(formatNLSEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFontNLSEntry(Locale locale, FontNLSEntry fontNLSEntry) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.COLUMN;
        synchronized (map) {
            Map[] mapArray;
            NLSContent nLSContent;
            if (!this.COLUMN.containsKey(locale)) {
                nLSContent = new NLSContent(locale);
                nLSContent.setEncoding("UTF-8");
                nLSContent.setReportPath(this.LABEL);
                nLSContent.setResourcePath(this.LABEL);
                nLSContent.setVersionNumber(this.META);
                mapArray = new Map[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
                nLSContent.setContent(mapArray);
                this.COLUMN.put(locale, nLSContent);
            }
            nLSContent = (NLSContent)this.COLUMN.get(locale);
            mapArray = nLSContent.getContent();
            String string = fontNLSEntry.getOrginalFace();
            long l = NLSUtil.getUnit(fontNLSEntry.getOrginalSize());
            String string2 = fontNLSEntry.getTargetFace();
            long l2 = NLSUtil.getUnit(fontNLSEntry.getTargetSize());
            String string3 = NLSUtil.mergeFontContext(string, String.valueOf(l));
            String string4 = NLSUtil.mergeFontContext(string2, String.valueOf(l2));
            Map map2 = mapArray[2];
            map2.put(string3, string4);
            nLSContent.setEnableFont(true);
            this.LABEL(nLSContent);
            ((ArrayList)this.DISP.get(locale)).remove(fontNLSEntry);
            ((ArrayList)this.DISP.get(locale)).add(fontNLSEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNLSEntries(Locale locale) {
        Map map = this.COLUMN;
        synchronized (map) {
            if (this.COLUMN.containsKey(locale)) {
                NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
                if (null != nLSContent) {
                    try {
                        this.COLUMN.remove(locale);
                        this.$SwitchMap$jet$server$api$nls$NLSType.removeReportNLS(nLSContent, this.NLS_SUB_REPORT_VERSION_NUMBER);
                        return true;
                    }
                    catch (UnknownResource unknownResource) {
                        ServiceLogger.logError((Throwable)((Object)unknownResource));
                    }
                    catch (NoPrivilegeException noPrivilegeException) {
                        ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                }
                this.DISP.remove(locale);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNLSEntries(Locale locale, List list) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                Map[] mapArray = nLSContent.getContent();
                Map map2 = null;
                for (Object object : list) {
                    Object object2;
                    if (object instanceof TextNLSEntry) {
                        object2 = ((TextNLSEntry)object).getType();
                        String string = ((TextNLSEntry)object).getKeyText();
                        switch (2.$SwitchMap$jet$server$api$nls$NLSType[((Enum)object2).ordinal()]) {
                            case 1: {
                                map2 = mapArray[0];
                                break;
                            }
                            case 2: {
                                map2 = mapArray[3];
                                break;
                            }
                            case 3: {
                                map2 = mapArray[4];
                                break;
                            }
                            case 4: {
                                map2 = mapArray[5];
                                break;
                            }
                            case 5: {
                                map2 = mapArray[6];
                                break;
                            }
                            case 6: {
                                map2 = mapArray[7];
                                break;
                            }
                            case 7: {
                                map2 = mapArray[8];
                            }
                        }
                        if (!map2.containsKey(string)) continue;
                        map2.remove(string);
                        bl = true;
                        continue;
                    }
                    if (object instanceof FormatNLSEntry) {
                        map2 = mapArray[1];
                        object2 = ((FormatNLSEntry)object).getKeyFormat();
                        if (!map2.containsKey(object2)) continue;
                        map2.remove(object2);
                        bl = true;
                        continue;
                    }
                    object2 = ((FontNLSEntry)object).getOrginalFace();
                    long l = NLSUtil.getUnit(((FontNLSEntry)object).getOrginalSize());
                    String string = ((FontNLSEntry)object).getTargetFace();
                    long l2 = NLSUtil.getUnit(((FontNLSEntry)object).getTargetSize());
                    String string2 = NLSUtil.mergeFontContext((String)object2, String.valueOf(l));
                    String string3 = NLSUtil.mergeFontContext(string, String.valueOf(l2));
                    map2 = mapArray[2];
                    if (!map2.containsKey(string2)) continue;
                    map2.remove(string2);
                    bl = true;
                }
                if (bl) {
                    List list2 = (List)this.DISP.get(locale);
                    for (Object object2 : list) {
                        list2.remove(object2);
                    }
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTextNLSEntries(Locale locale, List list) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                Map[] mapArray = nLSContent.getContent();
                Map map2 = null;
                for (Object object : list) {
                    Object object2 = ((TextNLSEntry)object).getType();
                    String string = ((TextNLSEntry)object).getKeyText();
                    switch (object2) {
                        case LABEL: {
                            map2 = mapArray[0];
                            break;
                        }
                        case COLUMN: {
                            map2 = mapArray[3];
                            break;
                        }
                        case PROMPT: {
                            map2 = mapArray[4];
                            break;
                        }
                        case TOC: {
                            map2 = mapArray[5];
                            break;
                        }
                        case META: {
                            map2 = mapArray[6];
                            break;
                        }
                        case TITLE: {
                            map2 = mapArray[7];
                            break;
                        }
                        case DISP: {
                            map2 = mapArray[8];
                        }
                    }
                    if (!map2.containsKey(string)) continue;
                    map2.remove(string);
                    bl = true;
                }
                if (bl) {
                    List list2 = (List)this.DISP.get(locale);
                    for (Object object2 : list) {
                        list2.remove(object2);
                    }
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFormatNLSEntries(Locale locale, List list) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                Map[] mapArray = nLSContent.getContent();
                Map map2 = mapArray[1];
                for (Object object : list) {
                    Object object2 = ((FormatNLSEntry)object).getKeyFormat();
                    if (!map2.containsKey(object2)) continue;
                    map2.remove(object2);
                    bl = true;
                }
                if (bl) {
                    List list2 = (List)this.DISP.get(locale);
                    for (Object object2 : list) {
                        list2.remove(object2);
                    }
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFontNLSEntries(Locale locale, List list) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                Map[] mapArray = nLSContent.getContent();
                Map map2 = mapArray[2];
                for (Object object : list) {
                    Object object2 = ((FontNLSEntry)object).getOrginalFace();
                    long l = NLSUtil.getUnit(((FontNLSEntry)object).getOrginalSize());
                    String string = ((FontNLSEntry)object).getTargetFace();
                    long l2 = NLSUtil.getUnit(((FontNLSEntry)object).getTargetSize());
                    String string2 = NLSUtil.mergeFontContext((String)object2, String.valueOf(l));
                    String string3 = NLSUtil.mergeFontContext(string, String.valueOf(l2));
                    if (!map2.containsKey(string2)) continue;
                    map2.remove(string2);
                    bl = true;
                }
                if (bl) {
                    List list2 = (List)this.DISP.get(locale);
                    for (Object object2 : list) {
                        list2.remove(object2);
                    }
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeNLSEntry(Locale locale, NLSEntry nLSEntry) {
        if (nLSEntry instanceof TextNLSEntry) {
            return this.removeTextNLSEntry(locale, (TextNLSEntry)nLSEntry);
        }
        if (nLSEntry instanceof FormatNLSEntry) {
            return this.removeFormatNLSEntry(locale, (FormatNLSEntry)nLSEntry);
        }
        return this.removeFontNLSEntry(locale, (FontNLSEntry)nLSEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTextNLSEntry(Locale locale, TextNLSEntry textNLSEntry) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                Map[] mapArray = nLSContent.getContent();
                Map map2 = null;
                NLSType nLSType = textNLSEntry.getType();
                String string = textNLSEntry.getKeyText();
                switch (nLSType) {
                    case LABEL: {
                        map2 = mapArray[0];
                        break;
                    }
                    case COLUMN: {
                        map2 = mapArray[3];
                        break;
                    }
                    case PROMPT: {
                        map2 = mapArray[4];
                        break;
                    }
                    case TOC: {
                        map2 = mapArray[5];
                        break;
                    }
                    case META: {
                        map2 = mapArray[6];
                        break;
                    }
                    case TITLE: {
                        map2 = mapArray[7];
                        break;
                    }
                    case DISP: {
                        map2 = mapArray[8];
                    }
                }
                if (map2.containsKey(string)) {
                    map2.remove(string);
                    bl = true;
                }
                if (bl) {
                    ((ArrayList)this.DISP.get(locale)).remove(textNLSEntry);
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFormatNLSEntry(Locale locale, FormatNLSEntry formatNLSEntry) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                String string;
                Map[] mapArray = nLSContent.getContent();
                Map map2 = mapArray[1];
                if (map2.containsKey(string = formatNLSEntry.getKeyFormat())) {
                    map2.remove(string);
                    bl = true;
                }
                if (bl) {
                    ((ArrayList)this.DISP.get(locale)).remove(formatNLSEntry);
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFontNLSEntry(Locale locale, FontNLSEntry fontNLSEntry) {
        boolean bl = false;
        Map map = this.COLUMN;
        synchronized (map) {
            NLSContent nLSContent = this.$SwitchMap$jet$server$api$nls$NLSType(locale);
            if (null != nLSContent) {
                long l;
                String string;
                String string2;
                Map[] mapArray = nLSContent.getContent();
                Map map2 = mapArray[2];
                if (map2.containsKey(string2 = NLSUtil.mergeFontContext(string = fontNLSEntry.getOrginalFace(), String.valueOf(l = NLSUtil.getUnit(fontNLSEntry.getOrginalSize()))))) {
                    map2.remove(string2);
                    bl = true;
                }
                if (bl) {
                    ((ArrayList)this.DISP.get(locale)).remove(fontNLSEntry);
                    this.LABEL(nLSContent);
                }
            }
        }
        return bl;
    }

    public Map getTextKeys(String string, int n) {
        Hashtable hashtable = new Hashtable();
        Map[] mapArray = null;
        try {
            mapArray = this.$SwitchMap$jet$server$api$nls$NLSType.getAvailableContentsFromReport(this.LABEL, this.META, string, n, null, this.NLS_SUB_REPORT_VERSION_NUMBER);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        if (null != mapArray) {
            ArrayList<String> arrayList;
            Map map = mapArray[0];
            if (null != map) {
                arrayList = new ArrayList<String>();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.LABEL, arrayList);
            }
            if (null != (map = mapArray[3])) {
                arrayList = new ArrayList();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.COLUMN, arrayList);
            }
            if (null != (map = mapArray[4])) {
                arrayList = new ArrayList();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.PROMPT, arrayList);
            }
            if (null != (map = mapArray[5])) {
                arrayList = new ArrayList();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.TOC, arrayList);
            }
            if (null != (map = mapArray[6])) {
                arrayList = new ArrayList();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.META, arrayList);
            }
            if (null != (map = mapArray[7])) {
                arrayList = new ArrayList();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.TITLE, arrayList);
            }
            if (null != (map = mapArray[8])) {
                arrayList = new ArrayList();
                for (String string2 : map.keySet()) {
                    arrayList.add(string2);
                }
                hashtable.put(NLSType.DISP, arrayList);
            }
        }
        return hashtable;
    }

    /*
     * WARNING - void declaration
     */
    public List getFormatKeys(String string, int n) {
        void var5_8;
        ArrayList<String> arrayList = new ArrayList<String>();
        Map[] mapArray = null;
        try {
            mapArray = this.$SwitchMap$jet$server$api$nls$NLSType.getAvailableContentsFromReport(this.LABEL, this.META, string, n, null, this.NLS_SUB_REPORT_VERSION_NUMBER);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        if (null != mapArray && null != (var5_8 = mapArray[1])) {
            for (String string2 : var5_8.keySet()) {
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public List getFontKeys(String string, int n) {
        void var5_8;
        ArrayList<Font> arrayList = new ArrayList<Font>();
        Map[] mapArray = null;
        try {
            mapArray = this.$SwitchMap$jet$server$api$nls$NLSType.getAvailableContentsFromReport(this.LABEL, this.META, string, n, null, this.NLS_SUB_REPORT_VERSION_NUMBER);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        if (null != mapArray && null != (var5_8 = mapArray[2])) {
            for (String string2 : var5_8.keySet()) {
                String[] stringArray = string2.split(",");
                String string3 = stringArray[0];
                int n2 = Integer.parseInt(stringArray[1]);
                n2 = n2 * 72 / 5760;
                Font font = new Font(string3, 0, n2);
                arrayList.add(font);
            }
        }
        return arrayList;
    }

    public Map getParameterNamesMap(String string, int n) {
        try {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            String string2 = httpRptServer.getResourceManager().getCatalogVersion(this.NLS_SUB_REPORT_VERSION_NUMBER, string, n).getRealPath();
            return this.$SwitchMap$jet$server$api$nls$NLSType.getParameterNamesMap(string2);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        return null;
    }

    public Map getSubReportNLSLibraries() {
        HashMap<String, JRReportNLSLibrary> hashMap = new HashMap<String, JRReportNLSLibrary>();
        try {
            String[] stringArray = this.$SwitchMap$jet$server$api$nls$NLSType.getAllSubReportsFromMainReportRealPath(this.LABEL, this.META, this.NLS_SUB_REPORT_VERSION_NUMBER);
            if (null != stringArray) {
                for (String string : stringArray) {
                    JRReportNLSLibrary jRReportNLSLibrary = new JRReportNLSLibrary(string, NLSUtil.NLS_SUB_REPORT_VERSION_NUMBER, this.NLS_SUB_REPORT_VERSION_NUMBER);
                    String string2 = null;
                    int n = string.lastIndexOf(File.separator);
                    string2 = -1 == n ? string : string.substring(n + 1);
                    hashMap.put(string2, jRReportNLSLibrary);
                }
            }
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        return hashMap;
    }

    public Map getOriginalTextKeys(String string, int n) {
        Hashtable hashtable = new Hashtable();
        Map[] mapArray = null;
        try {
            mapArray = this.$SwitchMap$jet$server$api$nls$NLSType.getAvailableContentsFromReport(this.LABEL, this.META, string, n, null, this.NLS_SUB_REPORT_VERSION_NUMBER);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        if (null != mapArray) {
            HashMap<String, String> hashMap;
            Map map = mapArray[0];
            if (null != map) {
                hashMap = new HashMap<String, String>();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.LABEL, hashMap);
            }
            if (null != (map = mapArray[3])) {
                hashMap = new HashMap();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.COLUMN, hashMap);
            }
            if (null != (map = mapArray[4])) {
                hashMap = new HashMap();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.PROMPT, hashMap);
            }
            if (null != (map = mapArray[5])) {
                hashMap = new HashMap();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.TOC, hashMap);
            }
            if (null != (map = mapArray[6])) {
                hashMap = new HashMap();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.META, hashMap);
            }
            if (null != (map = mapArray[7])) {
                hashMap = new HashMap();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.TITLE, hashMap);
            }
            if (null != (map = mapArray[8])) {
                hashMap = new HashMap();
                for (String string2 : map.keySet()) {
                    hashMap.put(string2, (String)map.get(string2));
                }
                hashtable.put(NLSType.DISP, hashMap);
            }
        }
        return hashtable;
    }
}

