/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jsapiservice;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.OrgConfiguration;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.util.StringUtil;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ConfigurationService {
    public static void execute(Writer writer, HttpServletRequest httpServletRequest) throws IOException, JSONException {
        String string;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=============================ConfigurationService: Request Parameters===========================\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            stringBuffer.append(string + " = " + StringUtil.toString(stringArray) + "\n");
        }
        stringBuffer.append("==========================================================================");
        ServiceLogger.logDebug(stringBuffer.toString());
        string = httpServletRequest.getParameter("method");
        try {
            if ("setSessionTimeout".equals(string)) {
                ConfigurationService.setSessionTimeout(writer, httpServletRequest);
            } else if ("saveOrgConfiguration".equals(string)) {
                ConfigurationService.saveOrgConfiguration(writer, httpServletRequest);
            } else {
                writer.write("{}");
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(stringBuffer.toString());
            ServiceLogger.logError(throwable);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("statusCode", 300);
            jSONObject.put("message", (Object)ConfigurationService.getMessage(throwable));
            writer.write(jSONObject.toString());
        }
    }

    private static void saveOrgConfiguration(Writer writer, HttpServletRequest httpServletRequest) throws JSONException, IOException {
        String string;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        ConfigService configService = httpRptServer.getAdminService().getConfigService();
        long l = 0x100000L;
        long l2 = 1024L * l;
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = new NlsClientResource(httpServletRequest, true).getServerResourceFactory();
        String string2 = HttpUtil.getUser(httpServletRequest);
        String string3 = httpServletRequest.getParameter("orgName");
        OrgConfiguration orgConfiguration = configService.getOrgConfiguration(string3);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string4 = httpServletRequest.getParameter(string);
            try {
                orgConfiguration.setProperty(string, string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string5 = null;
                if (string.equals("Concurrent_Users")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221473");
                } else if (string.equals("Concurrent_Reports")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221474");
                } else if (string.equals("Maximum_Disk_Size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221475");
                } else if (string.equals("Maximum_Memory_Size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221476");
                } else if (string.equals("Maximum_cache_catalog_size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221477");
                } else if (string.equals("Maximum_cache_report_size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221478");
                } else if (string.equals("Maximum_cache_image_size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221479");
                } else if (string.equals("Maximum_report_data_size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221480");
                } else if (string.equals("Maximum_cube_size")) {
                    string5 = propertyMessageResourcesFactory.getMessage("22221481");
                } else {
                    throw illegalArgumentException;
                }
                throw new IllegalArgumentException(string5);
            }
        }
        string = new JSONObject();
        string.put("statusCode", 200);
        string.put("message", (Object)propertyMessageResourcesFactory.getMessage("22221472"));
        writer.write(string.toString());
    }

    public static void setSessionTimeout(Writer writer, HttpServletRequest httpServletRequest) throws IOException, JSONException {
        HttpSession httpSession = httpServletRequest.getSession(true);
        String string = httpServletRequest.getParameter("timeoutSeconds");
        httpSession.setMaxInactiveInterval(Integer.parseInt(string));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("statusCode", 200);
        writer.write(jSONObject.toString());
    }

    public static String getMessage(Throwable throwable) {
        if (throwable.getCause() != null) {
            return ConfigurationService.getMessage(throwable.getCause());
        }
        if (throwable.getClass().equals(NullPointerException.class)) {
            return throwable.toString();
        }
        return throwable.getMessage();
    }
}

