/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.adhoc;

import java.io.Serializable;
import java.util.Date;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.adhoc.AdhocServiceInfo;
import jet.server.monitor.jrmon.adhoc.AdhocConstants;

public class JRAdhocServiceInfo
implements AdhocServiceInfo,
AdhocConstants,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8053108929972364501L;
    private String sessionID;
    private String userID;
    private String[] engines;
    private long startedTime;
    private long lastAccessedTime;
    private int serviceStatus;
    private String[] reportSets;

    public JRAdhocServiceInfo() {
    }

    public JRAdhocServiceInfo(String string, String string2, String[] stringArray, String[] stringArray2, long l, long l2, int n) {
        this.sessionID = string;
        this.userID = string2;
        this.engines = stringArray;
        this.reportSets = stringArray2;
        this.startedTime = l;
        this.lastAccessedTime = l2;
        this.serviceStatus = n;
    }

    public JRAdhocServiceInfo(AdhocServiceInfo adhocServiceInfo) {
        this(adhocServiceInfo.getSessionID(), adhocServiceInfo.getUserName(), adhocServiceInfo.getEngines(), adhocServiceInfo.getReportSets(), adhocServiceInfo.getStartedTime(), adhocServiceInfo.getLastAccessedTime(), ((JRAdhocServiceInfo)adhocServiceInfo).getStatusIntValue());
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }

    @Override
    public String getUserName() {
        return this.userID;
    }

    public void setUserName(String string) {
        this.userID = string;
    }

    @Override
    public String[] getEngines() {
        return this.engines;
    }

    public void setEngines(String[] stringArray) {
        this.engines = stringArray;
    }

    @Override
    public long getStartedTime() {
        return this.startedTime;
    }

    public void setStartedTime(long l) {
        this.startedTime = l;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setlastAccessedTime(long l) {
        this.lastAccessedTime = l;
    }

    @Override
    public String getStatus() {
        boolean bl;
        boolean bl2 = bl = this.serviceStatus < 0 || this.serviceStatus >= SERVICE_STATUS_VALUES.length;
        if (bl) {
            ServiceLogger.logEvent(6660038, String.valueOf(this.serviceStatus), 3);
            return SERVICE_STATUS_VALUES[0];
        }
        return SERVICE_STATUS_VALUES[this.serviceStatus];
    }

    public void setStatus(int n) {
        this.serviceStatus = n;
    }

    public int getStatusIntValue() {
        return this.serviceStatus;
    }

    @Override
    public String[] getReportSets() {
        return this.reportSets;
    }

    public void setReportSets(String[] stringArray) {
        this.reportSets = stringArray;
    }

    public Object clone() {
        return new JRAdhocServiceInfo(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Adhoc Service Info [service session ID:").append(this.sessionID);
        stringBuffer.append(";user ID:").append(this.userID);
        stringBuffer.append(";service status:").append(this.getStatus());
        stringBuffer.append(";engines:<");
        for (n = 0; n < this.engines.length; ++n) {
            stringBuffer.append(this.engines[n]);
            if (n >= this.engines.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(">;report sets:");
        for (n = 0; n < this.reportSets.length; ++n) {
            stringBuffer.append(this.reportSets[n]);
            if (n >= this.reportSets.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(">;started time:").append(new Date(this.startedTime));
        stringBuffer.append(";last accessed time:").append(new Date(this.lastAccessedTime));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

