/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.log.ServiceLogger;
import jet.server.profiling.jreport.JRAuditTaskRecord;

public class TaskAuditTable
extends TableImpl
implements Table {
    public static final String TABLE_NAME = "TaskAudit";
    private static final String[] BIGINT = new String[]{"ID", "TASK_ID", "REPORT_NAME", "CATALOG_NAME", "CATALOG_NAMES", "USER_NAME", "TASK_TYPE", "TASK_STATUS", "PAGE_NUMBER", "RUN_TIMES", "SUBMIT_TIME", "START_TIME", "COMPLETE_TIME", "FAIL_REASON", "PARAMETERS"};
    private static final int BLOB = 0;
    private static final int EMPTY = 1;
    private static final int INTEGER = 2;
    private static final int SEDU = 3;
    private static final int VARCHAR = 4;
    private static final int add = 5;
    private static final int append = 6;
    private static final int appendProfileTable = 7;
    private static final int contains = 8;
    private static final int createTable = 9;
    private static final int executeInLock = 10;
    private static final int getBytes = 11;
    private static final int getDatabase = 12;
    private static final int getID = 13;
    private static final int getInt = 14;
    private static TaskAuditTable getLong = null;

    public static TaskAuditTable getInstance(Database database) {
        if (null == getLong && null != database) {
            try {
                getLong = new TaskAuditTable(database);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
        return getLong;
    }

    public TaskAuditTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[1], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[2], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[3], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[4], JDBCType.BLOB, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[5], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[6], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[7], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[8], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[9], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[10], JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[11], JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[12], JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[13], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[14], JDBCType.BLOB, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        } else {
            int n = super.queryMaxValue("id", null, ParameterMetaInfo.EMPTY, false).intValue();
            if (n == Integer.MIN_VALUE) {
                n = -1;
            }
            this.adapter.setID(this, this.fields("id"), n++);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendProfileTable(this);
    }

    public synchronized void addAuditTask(final JRAuditTaskRecord jRAuditTaskRecord) throws SQLException {
        final StringBuffer stringBuffer = new StringBuffer().append("insert into ").append(super.getName()).append("(").append(BIGINT[0] + ",").append(BIGINT[1] + ",").append(BIGINT[5] + ",").append(BIGINT[6] + ",").append(BIGINT[7] + ",").append(BIGINT[8] + ",").append(BIGINT[9] + ",").append(BIGINT[10] + ",").append(BIGINT[11] + ",").append(BIGINT[12] + ",").append(BIGINT[4] + ",").append(BIGINT[14]).append(") values(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            Integer n = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n = 0;
                    Statement statement = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        List list = jRAuditTaskRecord.getCatalogNames();
                        Map map = jRAuditTaskRecord.getParameters();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        if (null != list) {
                            objectOutputStream.writeObject(list);
                        }
                        objectOutputStream.close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        if (null != map) {
                            objectOutputStream.writeObject(map);
                        }
                        objectOutputStream.close();
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                        statement = connection.prepareStatement(stringBuffer.toString());
                        statement.setInt(1, jRAuditTaskRecord.getID());
                        statement.setString(2, jRAuditTaskRecord.getTaskID());
                        statement.setString(3, jRAuditTaskRecord.getUserName());
                        statement.setInt(4, jRAuditTaskRecord.getTaskType());
                        statement.setInt(5, jRAuditTaskRecord.getTaskStatus());
                        statement.setInt(6, jRAuditTaskRecord.getPageNumber());
                        statement.setInt(7, jRAuditTaskRecord.getRunTimes());
                        statement.setLong(8, jRAuditTaskRecord.getSubmitTime());
                        statement.setLong(9, jRAuditTaskRecord.getStartTime());
                        statement.setLong(10, jRAuditTaskRecord.getCompleteTime());
                        statement.setBytes(11, byArray);
                        statement.setBytes(12, byArray2);
                        n = statement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    return n;
                }
            });
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    private List BIGINT(byte[] byArray) {
        List list = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            list = (List)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException);
        }
        return list;
    }

    private Map BLOB(byte[] byArray) {
        Map map = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            map = (Map)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException);
        }
        return map;
    }

    public synchronized JRAuditTaskRecord getTaskRecord(int n) throws SQLException {
        JRAuditTaskRecord jRAuditTaskRecord = null;
        StringBuilder stringBuilder = new StringBuilder("where ").append(BIGINT[0]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[0], n, 4);
        Recordset recordset = super.query(this.fields().toArray(), stringBuilder.toString(), parameterMetaInfo, false);
        if (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[3]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
        }
        return jRAuditTaskRecord;
    }

    public synchronized int updateAuditTaskByID(final int n, final FieldValue[] fieldValueArray) throws SQLException {
        final StringBuffer stringBuffer = new StringBuffer("update ").append(super.getName()).append(" set ");
        for (int i = 0; i < fieldValueArray.length; ++i) {
            if (0 != i) {
                stringBuffer.append(",");
            }
            stringBuffer.append(fieldValueArray[i].getName()).append("=?");
        }
        stringBuffer.append(" where ").append(BIGINT[0]).append("=?");
        try {
            Integer n2 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n3 = 0;
                    PreparedStatement preparedStatement = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuffer.toString());
                        block11: for (int i = 0; i < fieldValueArray.length; ++i) {
                            int n2 = fieldValueArray[i].getJDBCType().dataType();
                            switch (n2) {
                                case 4: {
                                    preparedStatement.setInt(i + 1, fieldValueArray[i].getInt());
                                    continue block11;
                                }
                                case 12: {
                                    preparedStatement.setString(i + 1, fieldValueArray[i].getString());
                                    continue block11;
                                }
                                case 2004: {
                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                    objectOutputStream.writeObject(fieldValueArray[i]);
                                    objectOutputStream.close();
                                    byte[] byArray = byteArrayOutputStream.toByteArray();
                                    preparedStatement.setBytes(i + 1, byArray);
                                    continue block11;
                                }
                                case -5: {
                                    preparedStatement.setLong(i + 1, fieldValueArray[i].getLong());
                                    continue block11;
                                }
                            }
                        }
                        preparedStatement.setInt(fieldValueArray.length + 1, n);
                        n3 = preparedStatement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return n3;
                }
            });
            return n2;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public synchronized int addTaskCatalogByID(final int n, final String string) throws SQLException {
        final StringBuffer stringBuffer = new StringBuffer("select ").append(BIGINT[4]).append(" from ").append(super.getName()).append(" where ").append(BIGINT[0]).append("=?");
        final StringBuffer stringBuffer2 = new StringBuffer("update ").append(super.getName()).append(" set ").append(BIGINT[4]).append("=? where ").append(BIGINT[0]).append("=?");
        try {
            Integer n2 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n3 = 0;
                    PreparedStatement preparedStatement = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        byte[] byArray;
                        AutoCloseable autoCloseable;
                        List list = null;
                        preparedStatement = connection.prepareStatement(stringBuffer.toString());
                        try {
                            preparedStatement.setInt(1, n);
                            autoCloseable = preparedStatement.executeQuery();
                            if (!autoCloseable.next()) {
                                ServiceLogger.logError("Failed to add task catalog " + string + "for record:" + n, 3);
                                Integer n2 = -1;
                                return n2;
                            }
                            byArray = autoCloseable.getBytes(1);
                            list = TaskAuditTable.this.BIGINT(byArray);
                            if (!list.contains(string)) {
                                list.add(string);
                            }
                        }
                        finally {
                            preparedStatement.close();
                        }
                        preparedStatement = connection.prepareStatement(stringBuffer2.toString());
                        try {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            autoCloseable = new ObjectOutputStream(byteArrayOutputStream);
                            ((ObjectOutputStream)autoCloseable).writeObject(list);
                            ((ObjectOutputStream)autoCloseable).close();
                            byArray = byteArrayOutputStream.toByteArray();
                            preparedStatement.setBytes(1, byArray);
                            preparedStatement.setInt(2, n);
                            n3 = preparedStatement.executeUpdate();
                            return n3;
                        }
                        finally {
                            preparedStatement.close();
                        }
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                    return n3;
                }
            });
            return n2;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public synchronized int setTaskParametersByID(final int n, final Map map) throws SQLException {
        final StringBuffer stringBuffer = new StringBuffer("update ").append(super.getName()).append(" set ").append(BIGINT[14]).append("=? where ").append(BIGINT[0]).append("=?");
        try {
            Integer n2 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n2 = 0;
                    PreparedStatement preparedStatement = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuffer.toString());
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(map);
                        objectOutputStream.close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        preparedStatement.setBytes(1, byArray);
                        preparedStatement.setInt(2, n);
                        n2 = preparedStatement.executeUpdate();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException);
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return n2;
                }
            });
            return n2;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public synchronized int getID() {
        try {
            int n = this.adapter.getID(this, this.fields("id"));
            return n;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
    }

    public synchronized List getAllAuditTasks() throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        Recordset recordset = super.query(this.fields().toArray(), "", null, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getAllAuditTasks(long l, long l2) throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[10]).append(" > ?").append(" and ").append(BIGINT[10]).append(" < ?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[10], l, -5);
        parameterMetaInfo.add(BIGINT[10], l2, -5);
        Recordset recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getWaitingAuditTasks() throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 1, 4);
        Recordset recordset = super.query(this.fields().toArray(), "", null, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getWaitingAuditTasks(long l, long l2) throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?").append(" and ").append(BIGINT[10]).append(" > ?").append(" and ").append(BIGINT[10]).append(" < ?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 1, 4);
        parameterMetaInfo.add(BIGINT[10], l, -5);
        parameterMetaInfo.add(BIGINT[10], l2, -5);
        Recordset recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getRunningAuditTasks() throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 4, 4);
        Recordset recordset = super.query(this.fields().toArray(), "", null, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getRunningAuditTasks(long l, long l2) throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?").append(" and ").append(BIGINT[10]).append(" > ?").append(" and ").append(BIGINT[10]).append(" < ?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 4, 4);
        parameterMetaInfo.add(BIGINT[10], l, -5);
        parameterMetaInfo.add(BIGINT[10], l2, -5);
        Recordset recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getFinishedAuditTasks() throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 9, 4);
        Recordset recordset = super.query(this.fields().toArray(), "", null, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getFinishedAuditTasks(long l, long l2) throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?").append(" and ").append(BIGINT[10]).append(" > ?").append(" and ").append(BIGINT[10]).append(" < ?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 9, 4);
        parameterMetaInfo.add(BIGINT[10], l, -5);
        parameterMetaInfo.add(BIGINT[10], l2, -5);
        Recordset recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getFailedAuditTasks() throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 10, 4);
        Recordset recordset = super.query(this.fields().toArray(), "", null, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }

    public synchronized List getFailedAuditTasks(long l, long l2) throws SQLException {
        LinkedList<JRAuditTaskRecord> linkedList = new LinkedList<JRAuditTaskRecord>();
        StringBuffer stringBuffer = new StringBuffer().append(" where ").append(BIGINT[7]).append("=?").append(" and ").append(BIGINT[10]).append(" > ?").append(" and ").append(BIGINT[10]).append(" < ?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(BIGINT[7], 10, 4);
        parameterMetaInfo.add(BIGINT[10], l, -5);
        parameterMetaInfo.add(BIGINT[10], l2, -5);
        Recordset recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
        while (recordset.next()) {
            List list = this.BIGINT(recordset.getBytes(BIGINT[4]));
            Map map = this.BLOB(recordset.getBytes(BIGINT[14]));
            JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(recordset.getInt(BIGINT[0]), recordset.getString(BIGINT[1]), recordset.getString(BIGINT[2]), recordset.getString(BIGINT[3]), list, recordset.getString(BIGINT[5]), recordset.getInt(BIGINT[6]), recordset.getInt(BIGINT[7]), recordset.getInt(BIGINT[8]), recordset.getInt(BIGINT[9]), recordset.getLong(BIGINT[10]), recordset.getLong(BIGINT[11]), recordset.getLong(BIGINT[12]), recordset.getString(BIGINT[13]), map);
            linkedList.add(jRAuditTaskRecord);
        }
        return linkedList;
    }
}

