/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.db.Connector;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.adapter.DBFactory;
import jet.server.db.core.ConnectorManager;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.MemResultSet;
import jet.server.log.ServiceLogger;

public class UDS4RptProfile
implements JRUserDataSource {
    private Connector BIGINT;
    private DBAdapter DOUBLE;
    private Connection INTEGER = null;
    private Statement SEDU = null;
    private ResultSet VARCHAR = null;
    private SimpleDateFormat add = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String append = "NC_TSK_TOTALS";
    private static final String close = "NC_TSK_SUCCESSFUL";
    private static final String commit = "NC_TSK_SCHEDULE";
    private static final String create = "SUM_TSKTIME_TOTAL";
    private static final String createFieldValue = "MAX_TSKTIME_TOTAL";
    private static final String createStatement = "MIN_TSKTIME_TOTAL";
    private static final String delete = "SUM_PGS_TOTALS";
    private static final String equals = "MAX_PGS_TOTALS";
    private static final String equalsIgnoreCase = "MIN_PGS_TOTALS";
    private static final String executeQuery = "SUM_ENGTIME_TOTAL";
    private static final String formatValue = "MAX_ENGTIME";
    private static final String get = "MIN_ENGTIME";
    private static final String getAutoCommit = "SUM_TSKTIME_WAITED";
    private static final String getConnection = "MAX_TSKTIME_WAITED";
    private static final String getConnector = "MIN_TSKTIME_WAITED";
    private static final String getInt = "SUM_ENG_CONCURRENT";
    private static final String getLong = "MAX_ENG_CONCURRENT";
    private static final String getMessage = "MIN_ENG_CONCURRENT";
    private static final String getObject = "SUM_QUE_LENGTH";
    private static final String getProperty = "MAX_QUE_LENGTH";
    private static final String getString = "MIN_QUE_LENGTH";
    private static final String getTime = "TASK_TOTAL";
    private static final String indexOf = "RUNNING_TASKS";
    private static final String insertRow = "FAILED_TASKS";
    private static final String length = "DHTML_TOTAL";
    private static final String logError = "RUNNING_DHTML";
    private static final String newInstance = "FAILED_DHTML";
    private static final String next = "NONDHTML_TOTAL";
    private static final String parse = "RUNNING_NONDHTML";
    private static final String parseInt = "FAILED_NONDHTML";
    private static final String releaseResultSet = "SELECT  COUNT(ID) AS NC_TSK_TOTALS,SUM(VI_TSK_STATUS) AS NC_TSK_SUCCESSFUL,SUM(VI_TSK_TYPE) AS NC_TSK_SCHEDULE,SUM(TC_TSK_TOTAL) AS SUM_TSKTIME_TOTAL,MAX(TC_TSK_TOTAL) AS MAX_TSKTIME_TOTAL,MIN(TC_TSK_TOTAL) AS MIN_TSKTIME_TOTAL,SUM(NC_RPT_FORMATS*NC_RPT_PAGES) AS SUM_PGS_TOTALS,MAX(NC_RPT_FORMATS*NC_RPT_PAGES) AS MAX_PGS_TOTALS,MIN(NC_RPT_FORMATS*NC_RPT_PAGES) AS MIN_PGS_TOTALS,SUM(TC_ENG_TOTAL) AS SUM_ENGTIME_TOTAL,MAX(TC_ENG_TOTAL) AS MAX_ENGTIME,MIN(TC_ENG_TOTAL) AS MIN_ENGTIME,SUM(TC_TSK_WAITED) AS SUM_TSKTIME_WAITED,MAX(TC_TSK_WAITED) AS MAX_TSKTIME_WAITED,MIN(TC_TSK_WAITED) AS MIN_TSKTIME_WAITED,SUM(NC_ENG_CONCURRENT) AS SUM_ENG_CONCURRENT,MAX(NC_ENG_CONCURRENT) AS MAX_ENG_CONCURRENT,MIN(NC_ENG_CONCURRENT) AS MIN_ENG_CONCURRENT,SUM(NC_QUE_LENGTH) AS SUM_QUE_LENGTH,MAX(NC_QUE_LENGTH) AS MAX_QUE_LENGTH,MIN(NC_QUE_LENGTH) AS MIN_QUE_LENGTH FROM TASKCONTEXT_2";

    public void releaseResultSet() throws JRUserDataSourceException {
        if (this.VARCHAR != null) {
            try {
                this.VARCHAR.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        this.VARCHAR = null;
        if (this.SEDU != null) {
            try {
                this.SEDU.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        this.SEDU = null;
        if (this.INTEGER != null) {
            try {
                this.INTEGER.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        this.INTEGER = null;
    }

    public ResultSet getResultSet(String string) throws JRUserDataSourceException {
        Properties properties = UDS4RptProfile.BIGINT(string);
        String string2 = properties.getProperty("jdbc.driver");
        String string3 = properties.getProperty("jdbc.url");
        String string4 = properties.getProperty("jdbc.user");
        String string5 = properties.getProperty("jdbc.password");
        this.BIGINT = ConnectorManager.newInstance().getConnector(string2, string3, string4, string5);
        try {
            this.DOUBLE = DBFactory.create(this.BIGINT);
        }
        catch (InstantiationException instantiationException) {
            throw new JRUserDataSourceException(instantiationException.getMessage());
        }
        try {
            this.INTEGER = this.BIGINT.getConnection(10000L);
            this.SEDU = this.INTEGER.createStatement();
            this.SEDU.setEscapeProcessing(true);
            this.VARCHAR = this.query(properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            this.releaseResultSet();
            throw new JRUserDataSourceException(exception.getMessage());
        }
        finally {
            try {
                if (!this.INTEGER.getAutoCommit()) {
                    this.INTEGER.commit();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return this.VARCHAR;
    }

    private static Properties BIGINT(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(16);
        Properties properties = new Properties();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("&", n)) != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        arrayList.add(string.substring(n));
        for (n = 0; n < arrayList.size(); ++n) {
            String string2 = (String)arrayList.get(n);
            n2 = string2.indexOf("=");
            if (n2 == -1) continue;
            properties.setProperty(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        return properties;
    }

    private ResultSet query(Properties properties) throws Exception {
        ResultSet resultSet = null;
        String string = properties.getProperty("query");
        Timestamp timestamp = new Timestamp(this.add.parse(properties.getProperty("start.time")).getTime());
        Timestamp timestamp2 = new Timestamp(this.add.parse(properties.getProperty("end.time")).getTime());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE TASKCONTEXT_2.TS_TSK_SUBMIT >= ").append(this.DOUBLE.formatValue(timestamp)).append(" AND TASKCONTEXT_2.TS_TSK_COMPLETE <= ").append(this.DOUBLE.formatValue(timestamp2));
        String string2 = stringBuffer.substring(0);
        stringBuffer.delete(0, stringBuffer.length());
        if (string.equalsIgnoreCase("QueryStat")) {
            stringBuffer.append(releaseResultSet).append(string2).append(" AND VI_tsk_status = 1");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl(append, JDBCType.INTEGER, 0, 0), new FieldImpl(close, JDBCType.INTEGER, 0, 0), new FieldImpl(commit, JDBCType.INTEGER, 0, 0), new FieldImpl(create, JDBCType.BIGINT, 0, 0), new FieldImpl(createFieldValue, JDBCType.BIGINT, 0, 0), new FieldImpl(createStatement, JDBCType.BIGINT, 0, 0), new FieldImpl(delete, JDBCType.BIGINT, 0, 0), new FieldImpl(equals, JDBCType.BIGINT, 0, 0), new FieldImpl(equalsIgnoreCase, JDBCType.BIGINT, 0, 0), new FieldImpl(executeQuery, JDBCType.BIGINT, 0, 0), new FieldImpl(formatValue, JDBCType.BIGINT, 0, 0), new FieldImpl(get, JDBCType.BIGINT, 0, 0), new FieldImpl(getAutoCommit, JDBCType.BIGINT, 0, 0), new FieldImpl(getConnection, JDBCType.BIGINT, 0, 0), new FieldImpl(getConnector, JDBCType.BIGINT, 0, 0), new FieldImpl(getInt, JDBCType.BIGINT, 0, 0), new FieldImpl(getLong, JDBCType.BIGINT, 0, 0), new FieldImpl(getMessage, JDBCType.BIGINT, 0, 0), new FieldImpl(getObject, JDBCType.BIGINT, 0, 0), new FieldImpl(getProperty, JDBCType.BIGINT, 0, 0), new FieldImpl(getString, JDBCType.BIGINT, 0, 0), new FieldImpl(length, JDBCType.BIGINT, 0, 0), new FieldImpl(logError, JDBCType.BIGINT, 0, 0), new FieldImpl(newInstance, JDBCType.BIGINT, 0, 0), new FieldImpl(next, JDBCType.BIGINT, 0, 0), new FieldImpl(parse, JDBCType.BIGINT, 0, 0), new FieldImpl(parseInt, JDBCType.BIGINT, 0, 0), new FieldImpl(getTime, JDBCType.BIGINT, 0, 0), new FieldImpl(indexOf, JDBCType.BIGINT, 0, 0), new FieldImpl(insertRow, JDBCType.BIGINT, 0, 0)};
            FieldValue[] fieldValueArray = new FieldValue[30];
            if (resultSet.next()) {
                fieldValueArray[0] = fieldArray[0].createFieldValue();
                fieldValueArray[0].setValue(new Integer(resultSet.getInt(append)));
                fieldValueArray[1] = fieldArray[1].createFieldValue();
                fieldValueArray[1].setValue(new Integer(resultSet.getInt(close)));
                fieldValueArray[2] = fieldArray[2].createFieldValue();
                fieldValueArray[2].setValue(new Integer(resultSet.getInt(commit)));
                fieldValueArray[3] = fieldArray[3].createFieldValue();
                fieldValueArray[3].setValue(new Long(resultSet.getLong(create)));
                fieldValueArray[4] = fieldArray[4].createFieldValue();
                fieldValueArray[4].setValue(new Long(resultSet.getLong(createFieldValue)));
                fieldValueArray[5] = fieldArray[5].createFieldValue();
                fieldValueArray[5].setValue(new Long(resultSet.getLong(createStatement)));
                fieldValueArray[6] = fieldArray[6].createFieldValue();
                fieldValueArray[6].setValue(new Long(resultSet.getLong(delete)));
                fieldValueArray[7] = fieldArray[7].createFieldValue();
                fieldValueArray[7].setValue(new Long(resultSet.getLong(equals)));
                fieldValueArray[8] = fieldArray[8].createFieldValue();
                fieldValueArray[8].setValue(new Long(resultSet.getLong(equalsIgnoreCase)));
                fieldValueArray[9] = fieldArray[9].createFieldValue();
                fieldValueArray[9].setValue(new Long(resultSet.getLong(executeQuery)));
                fieldValueArray[10] = fieldArray[10].createFieldValue();
                fieldValueArray[10].setValue(new Long(resultSet.getLong(formatValue)));
                fieldValueArray[11] = fieldArray[11].createFieldValue();
                fieldValueArray[11].setValue(new Long(resultSet.getLong(get)));
                fieldValueArray[12] = fieldArray[12].createFieldValue();
                fieldValueArray[12].setValue(new Long(resultSet.getLong(getAutoCommit)));
                fieldValueArray[13] = fieldArray[13].createFieldValue();
                fieldValueArray[13].setValue(new Long(resultSet.getLong(getConnection)));
                fieldValueArray[14] = fieldArray[14].createFieldValue();
                fieldValueArray[14].setValue(new Long(resultSet.getLong(getConnector)));
                fieldValueArray[15] = fieldArray[15].createFieldValue();
                fieldValueArray[15].setValue(new Long(resultSet.getLong(getInt)));
                fieldValueArray[16] = fieldArray[16].createFieldValue();
                fieldValueArray[16].setValue(new Long(resultSet.getLong(getLong)));
                fieldValueArray[17] = fieldArray[17].createFieldValue();
                fieldValueArray[17].setValue(new Long(resultSet.getLong(getMessage)));
                fieldValueArray[18] = fieldArray[18].createFieldValue();
                fieldValueArray[18].setValue(new Long(resultSet.getLong(getObject)));
                fieldValueArray[19] = fieldArray[19].createFieldValue();
                fieldValueArray[19].setValue(new Long(resultSet.getLong(getProperty)));
                fieldValueArray[20] = fieldArray[20].createFieldValue();
                fieldValueArray[20].setValue(new Long(resultSet.getLong(getString)));
                resultSet.close();
            }
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("SELECT COUNT(ID) AS DHTML_TOTAL FROM TASKCONTEXT_2 ").append(string2).append(" AND VI_tsk_status = 1 AND Task_type = 'DHTML'");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            long l = 0L;
            if (resultSet.next()) {
                fieldValueArray[21] = fieldArray[21].createFieldValue();
                l = resultSet.getLong(length);
                fieldValueArray[21].setValue(new Long(l));
            }
            resultSet.close();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("SELECT COUNT(ID) AS RUNNING_DHTML FROM TASKCONTEXT_2 ").append(string2).append(" AND VI_tsk_status = 2 AND Task_type = 'DHTML'");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            long l2 = 0L;
            if (resultSet.next()) {
                fieldValueArray[22] = fieldArray[22].createFieldValue();
                l2 = resultSet.getLong(logError);
                fieldValueArray[22].setValue(new Long(l2));
            }
            resultSet.close();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("SELECT COUNT(ID) AS FAILED_DHTML FROM TASKCONTEXT_2 ").append(string2).append(" AND VI_tsk_status = 0 AND Task_type = 'DHTML'");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            long l3 = 0L;
            if (resultSet.next()) {
                fieldValueArray[23] = fieldArray[23].createFieldValue();
                l3 = resultSet.getLong(newInstance);
                fieldValueArray[23].setValue(new Long(l3));
            }
            resultSet.close();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("SELECT COUNT(ID) AS NONDHTML_TOTAL FROM TASKCONTEXT_2 ").append(string2).append(" AND VI_tsk_status = 1 AND Task_type = 'Non-DHTML'");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            long l4 = 0L;
            if (resultSet.next()) {
                fieldValueArray[24] = fieldArray[25].createFieldValue();
                l4 = resultSet.getLong(next);
                fieldValueArray[24].setValue(new Long(l4));
            }
            resultSet.close();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("SELECT COUNT(ID) AS RUNNING_NONDHTML FROM TASKCONTEXT_2 ").append(string2).append(" AND VI_tsk_status = 2 AND Task_type = 'Non-DHTML'");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            long l5 = 0L;
            if (resultSet.next()) {
                fieldValueArray[25] = fieldArray[25].createFieldValue();
                l5 = resultSet.getLong(parse);
                fieldValueArray[25].setValue(new Long(l5));
            }
            resultSet.close();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("SELECT COUNT(ID) AS FAILED_NONDHTML FROM TASKCONTEXT_2 ").append(string2).append(" AND VI_tsk_status = 0 AND Task_type = 'Non-DHTML'");
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            long l6 = 0L;
            if (resultSet.next()) {
                fieldValueArray[26] = fieldArray[26].createFieldValue();
                l6 = resultSet.getLong(parseInt);
                fieldValueArray[26].setValue(new Long(l6));
            }
            resultSet.close();
            fieldValueArray[27] = fieldArray[27].createFieldValue();
            fieldValueArray[27].setValue(new Long(l + l4));
            fieldValueArray[28] = fieldArray[28].createFieldValue();
            fieldValueArray[28].setValue(new Long(l2 + l5));
            fieldValueArray[29] = fieldArray[29].createFieldValue();
            fieldValueArray[29].setValue(new Long(l3 + l6));
            this.VARCHAR = new MemResultSet(fieldArray);
            ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("GroupOfTskTime")) {
            stringBuffer.append(" SELECT 'Time Cost for Waiting' AS ITEM_NAME, SUM(TC_TSK_WAITED) AS ITEM_VALUE ").append(" FROM TASKCONTEXT_2").append(string2).append(" UNION ALL").append(" SELECT 'Running Time' AS ITEM_NAME, SUM(TC_ENG_TOTAL) AS ITEM_VALUE ").append(" FROM TASKCONTEXT_2").append(string2).append(" UNION ALL").append(" SELECT 'Other' AS ITEM_NAME, SUM(TC_TSK_OTHER) AS ITEM_VALUE ").append(" FROM TASKCONTEXT_2").append(string2);
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("ITEM_NAME", JDBCType.VARCHAR, 32, 0), new FieldImpl("ITEM_VALUE", JDBCType.BIGINT, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            while (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[]{fieldArray[0].createFieldValue(), fieldArray[1].createFieldValue()};
                fieldValueArray[0].setValue(resultSet.getString("ITEM_NAME"));
                fieldValueArray[1].setValue(new Long(resultSet.getLong("ITEM_VALUE")));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("GroupOfEngTime")) {
            stringBuffer.append(" SELECT 'Loading Time' AS ITEM_NAME, SUM(TC_ENG_LOAD) AS ITEM_VALUE ").append(" FROM TASKCONTEXT_2").append(string2).append(" UNION ALL").append(" SELECT 'Exporting Time' AS ITEM_NAME, SUM(TC_ENG_EXPORT) AS ITEM_VALUE ").append(" FROM TASKCONTEXT_2").append(string2).append(" UNION ALL").append(" SELECT 'Other' AS ITEM_NAME, SUM(TC_ENG_OTHER) AS ITEM_VALUE ").append(" FROM TASKCONTEXT_2").append(string2);
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("ITEM_NAME", JDBCType.VARCHAR, 32, 0), new FieldImpl("ITEM_VALUE", JDBCType.BIGINT, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            while (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[]{fieldArray[0].createFieldValue(), fieldArray[1].createFieldValue()};
                fieldValueArray[0].setValue(resultSet.getString("ITEM_NAME"));
                fieldValueArray[1].setValue(new Long(resultSet.getLong("ITEM_VALUE")));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("DistOfTasks")) {
            int n = 10;
            stringBuffer.append("SELECT MAX(TC_ENG_TOTAL) AS MAX_ENGTIME, ").append(" MIN(TC_ENG_TOTAL) AS MIN_ENGTIME").append(" FROM TASKCONTEXT_2").append(string2);
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            resultSet.next();
            long l = resultSet.getLong(formatValue);
            long l7 = resultSet.getLong(get);
            int n2 = (int)((l - l7) / (long)(n - 1));
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = l7 + (long)(i * n2);
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append("SELECT COUNT(ID) AS NC_TSK_INRANGE ");
                stringBuffer.append(" FROM TASKCONTEXT_2").append(string2);
                stringBuffer.append(" AND TC_ENG_TOTAL BETWEEN ").append(lArray[i]).append(" AND ").append(lArray[i] + (long)n2);
                resultSet = this.SEDU.executeQuery(stringBuffer.substring(0));
                resultSet.next();
                nArray[i] = resultSet.getInt("NC_TSK_INRANGE");
            }
            resultSet.close();
            Field[] fieldArray = new Field[]{new FieldImpl("ENG_TIME", JDBCType.DOUBLE, 0, 0), new FieldImpl("RPT_COUNT", JDBCType.INTEGER, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            for (int i = 0; i < n; ++i) {
                FieldValue[] fieldValueArray = new FieldValue[]{fieldArray[0].createFieldValue(), fieldArray[1].createFieldValue()};
                fieldValueArray[0].setValue(new Double((float)lArray[i] / 1000.0f));
                fieldValueArray[1].setValue(new Integer(nArray[i]));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("QueryTopNFreq")) {
            stringBuffer.append(" SELECT");
            stringBuffer.append(" TASKCONTEXT_2.VS_RPT_NAME");
            stringBuffer.append(",COUNT(TASKCONTEXT_2.ID) AS ACCESSCOUNT");
            stringBuffer.append(" FROM TASKCONTEXT_2").append(string2);
            stringBuffer.append(" GROUP BY TASKCONTEXT_2.VS_RPT_NAME");
            if ("jet.server.db.adapter.AccessDriver".equals(properties.getProperty("jdbc.driver"))) {
                stringBuffer.append(" ORDER BY COUNT(TASKCONTEXT_2.ID) DESC");
            } else {
                stringBuffer.append(" ORDER BY ACCESSCOUNT DESC");
            }
            int n = Integer.parseInt(properties.getProperty("top.n", "10"));
            this.SEDU.setMaxRows(n);
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            Field[] fieldArray = new Field[]{new FieldImpl("REPORT", JDBCType.VARCHAR, 254, 0), new FieldImpl("ACCESSCOUNT", JDBCType.INTEGER, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            while (resultSet.next()) {
                FieldValue[] fieldValueArray = new FieldValue[2];
                fieldValueArray[0] = fieldArray[0].createFieldValue();
                fieldValueArray[0].setValue(resultSet.getObject("VS_RPT_NAME"));
                fieldValueArray[1] = fieldArray[1].createFieldValue();
                fieldValueArray[1].setValue(resultSet.getObject("ACCESSCOUNT"));
                ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            }
            resultSet.close();
            return this.VARCHAR;
        }
        if (string.equalsIgnoreCase("ProportionOfFreq")) {
            stringBuffer.append(" SELECT COUNT(ID) AS COUNT_TOTAL ").append(" FROM TASKCONTEXT_2").append(string2);
            resultSet = this.SEDU.executeQuery(stringBuffer.toString());
            resultSet.next();
            int n = resultSet.getInt("COUNT_TOTAL");
            resultSet.close();
            int n3 = this.DOUBLE(string2, properties);
            int n4 = Integer.parseInt(properties.getProperty("top.n"));
            Field[] fieldArray = new Field[]{new FieldImpl("ITEM_NAME", JDBCType.VARCHAR, 16, 0), new FieldImpl("ITEM_VALUE", JDBCType.INTEGER, 0, 0)};
            this.VARCHAR = new MemResultSet(fieldArray);
            FieldValue[] fieldValueArray = new FieldValue[2];
            fieldValueArray[0] = fieldArray[0].createFieldValue();
            fieldValueArray[0].setValue("Top " + n4);
            fieldValueArray[1] = fieldArray[1].createFieldValue();
            fieldValueArray[1].setValue(new Integer(n3));
            ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            fieldValueArray = new FieldValue[2];
            fieldValueArray[0] = fieldArray[0].createFieldValue();
            fieldValueArray[0].setValue("Other");
            fieldValueArray[1] = fieldArray[1].createFieldValue();
            fieldValueArray[1].setValue(new Integer(n - n3));
            ((MemResultSet)this.VARCHAR).insertRow(fieldValueArray);
            return this.VARCHAR;
        }
        return null;
    }

    private int DOUBLE(String string, Properties properties) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT");
        stringBuffer.append(" TASKCONTEXT_2.VS_RPT_NAME");
        stringBuffer.append(",COUNT(TASKCONTEXT_2.ID) AS ACCESSCOUNT");
        stringBuffer.append(" FROM TASKCONTEXT_2").append(string);
        stringBuffer.append(" GROUP BY TASKCONTEXT_2.VS_RPT_NAME");
        if ("jet.server.db.adapter.AccessDriver".equals(properties.getProperty("jdbc.driver"))) {
            stringBuffer.append(" ORDER BY COUNT(TASKCONTEXT_2.ID) DESC");
        } else {
            stringBuffer.append(" ORDER BY ACCESSCOUNT DESC");
        }
        int n = Integer.parseInt(properties.getProperty("top.n"));
        this.SEDU.setMaxRows(n);
        ResultSet resultSet = this.SEDU.executeQuery(stringBuffer.toString());
        int n2 = 0;
        while (resultSet.next()) {
            n2 += resultSet.getInt("ACCESSCOUNT");
        }
        return n2;
    }
}

