/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import guitools.toolkit.JDebug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.export.mail.mailconfig;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.log.ServiceLogger;
import jet.server.rc.AclProcessor;
import jet.server.rc.ActionProcessor;
import jet.server.rc.GroupProcessor;
import jet.server.rc.HomeProcessor;
import jet.server.rc.PreferenceSettingProcessor;
import jet.server.rc.ProtectProcessor;
import jet.server.rc.RealmProcessor;
import jet.server.rc.ResourceProcessor;
import jet.server.rc.UserProcessor;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.server.userman.GroupImpl;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.UserDataToolkit;
import jet.server.userman.UserImpl;
import jet.server.userman.ldap.LdapConnection;
import jet.server.userman.ldap.LdapEnvironments;
import jet.server.userman.ldap.LdapToolkit;
import jet.server.util.JSTreeMaker;
import jet.server.util.JSTreeNode;
import jet.server.util.ServerUtil;

public class ConfigProcessor
extends ActionProcessor {
    public static String IDS_CONFIG_INDEX = "ConfigIndex";
    public static String IDS_REQUEST_CONFIG_SERVICE = "RequestConfigService";
    public static String IDS_REQUEST_CONFIG_LOG = "RequestConfigLog";
    public static String IDS_REQUEST_CONFIG_MAIL = "RequestConfigMail";
    public static String IDS_REQUEST_CONFIG_ADVANCE = "RequestConfigAdvance";
    public static String IDS_REQUEST_CONFIG_LDAP = "RequestConfigLdap";
    public static String IDS_REQUEST_CONFIG_LDAP_LOAD = "RequestConfigLdapLoad";
    public static String IDS_REQUEST_CONFIG_LDAP_IMPORT = "RequestConfigLdapImport";
    public static String IDS_REQUEST_CONFIG_LDAP_IMPORT_CONFIRM = "RequestConfigLdapImportConfirm";
    public static String IDS_REQUEST_CONFIG_LDAP_CHECKSYNCHRONIZATION_CONFIRM = "RequestConfigLdapSynchronizationCheckConfirm";
    public static String IDS_CONFIG_SERVICE = "ConfigService";
    public static String IDS_CONFIG_LOG = "ConfigLog";
    public static String IDS_CONFIG_MAIL = "ConfigMail";
    public static String IDS_CONFIG_ADVANCE = "ConfigAdvance";
    public static String IDS_CONFIG_LDAP = "ConfigLdap";
    public static String IDS_CONFIG_LDAP_GET_ALL_USER = "ConfigLdapGetAllUser";
    public static String IDS_CONFIG_LDAP_REMOVE_ALL_USER = "ConfigLdapRemoveAllUser";
    public static String IDS_CONFIG_LDAP_IMPORT = "ConfigLdapImport";
    public static String IDS_CONFIG_LDAP_TESTCONNECTION = "ConfigLdapTestConnection";
    public static String IDS_CONFIG_LDAP_USERQUERY = "ConfigLdapUserQuery";
    public static String IDS_CONFIG_LDAP_GROUPQUERY = "ConfigLdapGroupQuery";
    public static String IDS_CONFIG_LDAP_CHECKSYNCHRONIZATION = "LdapSynchronizationCheck";
    public static String IDS_REQUEST_LEFTLAYOUT = "LeftLayout";
    public static String IDS_REQUEST_TOPLAYOUT = "TopLayout";
    public static String IDS_REQUEST_LEFTTOPLAYOUT = "LeftTopLayout";
    private static String CompressMail = "";
    private static LdapEnvironments DefaultFormat = new LdapEnvironments();
    private static LdapEnvironments IDS_LIST_ACL = new LdapEnvironments();
    private static int IDS_LIST_GROUP = 0;
    HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
    ConfigService sConf = this.httpRptServer.getAdminService().getConfigService();
    ConfigurationLDAPServer confLSer = null;
    private String[] IDS_LIST_PROTECT = new String[]{"access", "manage", "error", "event", "debug", "engine", "viaWebDesg", "viaWebCat"};
    private String[] IDS_LIST_REALM = new String[]{JSvrResource.getDlgText("LogConfigPanel", "access"), JSvrResource.getDlgText("LogConfigPanel", "manage"), JSvrResource.getDlgText("LogConfigPanel", "error"), JSvrResource.getDlgText("LogConfigPanel", "event"), JSvrResource.getDlgText("LogConfigPanel", "debug"), JSvrResource.getDlgText("LogConfigPanel", "engine"), JSvrResource.getDlgText("LogConfigPanel", "viaWebDesg"), JSvrResource.getDlgText("LogConfigPanel", "viaWebCat")};
    private String[] IDS_LIST_ROOT_RESOURCE = new String[]{JSvrResource.getDlgText("LogConfigPanel", "desc1"), JSvrResource.getDlgText("LogConfigPanel", "desc2"), JSvrResource.getDlgText("LogConfigPanel", "desc3"), JSvrResource.getDlgText("LogConfigPanel", "desc4"), JSvrResource.getDlgText("LogConfigPanel", "desc5"), JSvrResource.getDlgText("LogConfigPanel", "desc6"), JSvrResource.getDlgText("LogConfigPanel", "viaWebDesg"), JSvrResource.getDlgText("LogConfigPanel", "viaWebCat")};
    private String[] IDS_LIST_USER = new String[]{JSvrResource.getDlgText("LogConfigPanel", "file"), JSvrResource.getDlgText("LogConfigPanel", "rolling_logfile"), JSvrResource.getDlgText("LogConfigPanel", "socket"), JSvrResource.getDlgText("LogConfigPanel", "stdout"), JSvrResource.getDlgText("LogConfigPanel", "stderr")};
    private static InetAddress[] IDS_REQUEST_HOME;

    private ConfigurationLDAPServer CompressMail() {
        if (this.confLSer == null) {
            this.confLSer = this.sConf.getConfigurationLDAPServer();
        }
        return this.confLSer;
    }

    public ConfigProcessor() {
        this.actions.addElement(IDS_CONFIG_INDEX);
        this.actions.addElement(IDS_REQUEST_CONFIG_SERVICE);
        this.actions.addElement(IDS_REQUEST_CONFIG_LOG);
        this.actions.addElement(IDS_REQUEST_CONFIG_MAIL);
        this.actions.addElement(IDS_REQUEST_CONFIG_ADVANCE);
        this.actions.addElement(IDS_REQUEST_CONFIG_LDAP);
        this.actions.addElement(IDS_REQUEST_CONFIG_LDAP_IMPORT);
        this.actions.addElement(IDS_REQUEST_CONFIG_LDAP_IMPORT_CONFIRM);
        this.actions.addElement(IDS_REQUEST_CONFIG_LDAP_CHECKSYNCHRONIZATION_CONFIRM);
        this.actions.addElement(IDS_CONFIG_SERVICE);
        this.actions.addElement(IDS_CONFIG_LOG);
        this.actions.addElement(IDS_CONFIG_MAIL);
        this.actions.addElement(IDS_CONFIG_ADVANCE);
        this.actions.addElement(IDS_CONFIG_LDAP);
        this.actions.addElement(IDS_CONFIG_LDAP_GET_ALL_USER);
        this.actions.addElement(IDS_CONFIG_LDAP_REMOVE_ALL_USER);
        this.actions.addElement(IDS_CONFIG_LDAP_IMPORT);
        this.actions.addElement(IDS_CONFIG_LDAP_TESTCONNECTION);
        this.actions.addElement(IDS_CONFIG_LDAP_USERQUERY);
        this.actions.addElement(IDS_CONFIG_LDAP_GROUPQUERY);
        this.actions.addElement(IDS_CONFIG_LDAP_CHECKSYNCHRONIZATION);
        this.actions.addElement(IDS_REQUEST_LEFTLAYOUT);
        this.actions.addElement(IDS_REQUEST_TOPLAYOUT);
        this.actions.addElement(IDS_REQUEST_LEFTTOPLAYOUT);
    }

    private void DefaultFormat() {
        String string = this.getPropertyIgnoreCase("txPassword");
        if (string == null) {
            string = "";
        }
        if (this.getPropertyIgnoreCase("chbRememberPsw") != null) {
            this.request.getSession().putValue("password", (Object)string);
        } else {
            this.request.getSession().removeValue("password");
        }
    }

    private int getPort() {
        if (IDS_LIST_GROUP == 0) {
            IDS_LIST_GROUP = ServerEnv.getPort();
        }
        return IDS_LIST_GROUP;
    }

    private void setPort(int n) {
        IDS_LIST_GROUP = n;
    }

    @Override
    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_CONFIG_INDEX)) {
            this.IDS_LIST_ACL();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_SERVICE)) {
            this.IDS_LIST_PROTECT();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_LOG)) {
            this.IDS_LIST_REALM();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_MAIL)) {
            this.IDS_LIST_ROOT_RESOURCE();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_ADVANCE)) {
            this.IDS_LIST_GROUP();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_LDAP)) {
            this.IDS_CONFIG_SERVICE();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_LDAP_IMPORT)) {
            this.IDS_CONFIG_LDAP_GROUPQUERY();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_LDAP_IMPORT_CONFIRM)) {
            this.IDS_CONFIG_LDAP_CHECKSYNCHRONIZATION();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_CONFIG_LDAP_CHECKSYNCHRONIZATION_CONFIRM)) {
            this.IDS_CONFIG_LDAP_TESTCONNECTION();
        } else if (string.equalsIgnoreCase(IDS_CONFIG_SERVICE)) {
            this.IDS_REQUEST_CONFIG_ADVANCE();
        } else if (string.equalsIgnoreCase(IDS_CONFIG_LOG)) {
            this.IDS_REQUEST_CONFIG_LDAP_CHECKSYNCHRONIZATION_CONFIRM();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_MAIL)) {
            this.IDS_REQUEST_CONFIG_LDAP_IMPORT();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_ADVANCE)) {
            this.IDS_LIST_USER();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_LDAP)) {
            this.IDS_CONFIG_MAIL();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_LDAP_IMPORT)) {
            this.IDS_CONFIG_LDAP_GET_ALL_USER();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_LDAP_TESTCONNECTION)) {
            this.IDS_CONFIG_LOG();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_LDAP_USERQUERY)) {
            this.IDS_CONFIG_LDAP_IMPORT();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_LDAP_GROUPQUERY)) {
            this.IDS_CONFIG_LDAP_REMOVE_ALL_USER();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_LDAP_CHECKSYNCHRONIZATION)) {
            this.IDS_CONFIG_LDAP_USERQUERY();
        }
        if (string.equalsIgnoreCase(IDS_CONFIG_ADVANCE)) {
            this.IDS_LIST_USER();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_LEFTLAYOUT)) {
            this.IDS_CONFIG_LDAP();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_TOPLAYOUT)) {
            this.IDS_CONFIG_ADVANCE();
        }
        if (string.equalsIgnoreCase(IDS_REQUEST_LEFTTOPLAYOUT)) {
            this.IDS_CONFIG_INDEX();
        }
    }

    private void IDS_CONFIG_ADVANCE() throws IOException {
        String string = this.getImage("jinfo");
        string = string.substring(0, string.indexOf(".gif")) + ".jpg";
        String string2 = "";
        string2 = string2 + "  <body bgcolor=#5095ba>";
        string2 = string2 + "  <img src=\"" + string + "\" border=0 style=\"position:absolute; left:0; top:0\">";
        string2 = string2 + "  </body>";
        this.writeResponse(string2);
    }

    private void IDS_CONFIG_INDEX() throws IOException {
        String string;
        String string2 = string = this.request.getRemoteUser();
        if (string == null && this.request.getSession() != null) {
            string2 = this.request.getSession().getValue("rcUser").toString();
        }
        String string3 = "";
        string3 = string3 + "<body bgcolor=#d0d0c9>";
        string3 = string3 + "<table width=\"100%\" border=\"0\" bgcolor=\"#000000\">";
        string3 = string3 + "  <tr>";
        string3 = string3 + "    <td><font face=\"Arial\" color=\"#FFFFFF\" style=\"font-size:12px\" >&nbsp;&nbsp;&nbsp;User : ";
        string3 = string3 + string2;
        string3 = string3 + "</font></td>";
        string3 = string3 + "  </tr>";
        string3 = string3 + "</table>";
        string3 = string3 + "</body>";
        this.writeResponse(string3);
    }

    private void IDS_CONFIG_LDAP() throws IOException {
        Object object;
        String string = "";
        String string2 = null;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        Member member = null;
        if (httpRptServer.isClusterEnable()) {
            member = httpRptServer.getClusterService().getLocalMember();
        }
        string2 = member == null ? null : (member.isAdmin() ? "Admin Server" : (member.isBackupAdmin() ? "Backup Server" : "Slave Server"));
        string = string + "<style type=\"text/css\">";
        string = string + "<!--";
        string = string + "span {";
        string = string + "    font-family: Arial;";
        string = string + "    font-size: 12px;";
        string = string + "    text-decoration: none;";
        string = string + "    font-weight: bold;";
        string = string + "}";
        string = string + "-->";
        string = string + "</style>";
        string = string + "<br><br>";
        string = string + "    <body bgcolor=\"#d0d0c9\">";
        string = string + "  <br><br>";
        Vector<JSTreeNode> vector = new Vector<JSTreeNode>();
        String string3 = null;
        if (member == null) {
            object = InetAddress.getLocalHost();
            string3 = ((InetAddress)object).getHostName();
        } else {
            string3 = member.getServerName();
        }
        vector.addElement(new JSTreeNode(string3, "", this.getImage("menu_folder_closed.gif"), this.getImage("menu_folder_opened.gif"), string3 + (string2 == null ? "" : " (" + string2 + ")"), null, null, null));
        vector.addElement(new JSTreeNode(string3 + "/Home", HomeProcessor.IDS_REQUEST_HOME, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        vector.addElement(new JSTreeNode(string3 + "/Configuration", "", this.getImage("menu_folder_closed.gif"), this.getImage("menu_folder_opened.gif"), "", null, null, null));
        vector.addElement(new JSTreeNode(string3 + "/Configuration/Service", referer + "RequestConfigService", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        if (member == null || member.isAdmin()) {
            vector.addElement(new JSTreeNode(string3 + "/Configuration/Mail", referer + "RequestConfigMail", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        }
        vector.addElement(new JSTreeNode(string3 + "/Configuration/Advanced", referer + "RequestConfigAdvance", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        if (member == null || member.isAdmin()) {
            vector.addElement(new JSTreeNode(string3 + "/Configuration/LDAP", "", this.getImage("menu_folder_closed.gif"), this.getImage("menu_folder_opened.gif"), "", null, null, null));
            vector.addElement(new JSTreeNode(string3 + "/Configuration/LDAP/Support", referer + "RequestConfigLdap", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Configuration/LDAP/Import", referer + "RequestConfigLdapImport", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Configuration/LDAP/Synchronize", referer + "RequestConfigLdapSynchronizationCheckConfirm", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        }
        vector.addElement(new JSTreeNode(string3 + "/Preference Setting", PreferenceSettingProcessor.IDS_SET_DEFAULT_PREFERENCE, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        if (!httpRptServer.isClusterEnable() || member.isAdmin()) {
            vector.addElement(new JSTreeNode(string3 + "/Resource", ResourceProcessor.IDS_LIST_ROOT_RESOURCE, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Security", "", this.getImage("menu_folder_closed.gif"), this.getImage("menu_folder_opened.gif"), "", null, null, null));
            vector.addElement(new JSTreeNode(string3 + "/Security/Realm", RealmProcessor.IDS_LIST_REALM, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Security/User", UserProcessor.IDS_LIST_USER, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Security/Group", GroupProcessor.IDS_LIST_GROUP, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Security/Protection", ProtectProcessor.IDS_LIST_PROTECT, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Security/Acl", AclProcessor.IDS_LIST_ACL, this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        }
        if (isMyServer) {
            vector.addElement(new JSTreeNode(string3 + "/Restart", referer + "RequestRestart", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
            vector.addElement(new JSTreeNode(string3 + "/Shut down", referer + "RequestShutdown", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        }
        vector.addElement(new JSTreeNode(string3 + "/Garbage Collection", referer + "gc", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        vector.addElement(new JSTreeNode(string3 + "/Logout", referer + "Logout", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        vector.addElement(new JSTreeNode(string3 + "/Help", referer + "help/userguide/rmguide.htm", this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        vector.addElement(new JSTreeNode(string3 + "/Tech Support", "mailto:" + JSvrResource.getMessage("SUPPORTMAIL"), this.getImage("file.gif"), this.getImage("fileon.gif"), "", null, null, "main"));
        object = new JSTreeMaker(vector, this.getImage(null), false);
        ((JSTreeMaker)object).setOverUppercase(false);
        string = string + ((JSTreeMaker)object).getTree(string3 + "");
        string = string + "  </small></body></body>";
        this.writeResponse(string);
    }

    private void IDS_CONFIG_LDAP_CHECKSYNCHRONIZATION() throws IOException {
        boolean bl = false;
        String string = this.getPropertyIgnoreCase("cbbShowType");
        String string2 = "";
        boolean bl2 = true;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        try {
            enumeration = LdapToolkit.listExsitedUsers(ServerEnv.getActiveRealm()).elements();
            enumeration2 = LdapToolkit.listExsitedGroups(ServerEnv.getActiveRealm()).elements();
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        if (enumeration == null || enumeration2 == null) {
            this.printMessage("LDAP Connection error. Please check your settings.", HomeProcessor.IDS_REQUEST_HOME);
            return;
        }
        if (this.getPropertyIgnoreCase("cbbImportType") != null) {
            if (this.getPropertyIgnoreCase("cbbImportType").equalsIgnoreCase("Ask before overwrite")) {
                bl2 = false;
            } else if (this.getPropertyIgnoreCase("cbbImportType").equalsIgnoreCase("Overwrite all existing users or groups")) {
                this.IDS_CONFIG_LDAP_GET_ALL_USER();
            }
        }
        if (string != null) {
            bl2 = false;
            if (string.equalsIgnoreCase("User(s)")) {
                bl = false;
            } else if (string.equalsIgnoreCase("Group(s)")) {
                bl = true;
            }
        }
        if (!bl2) {
            string2 = string2 + "<script>";
            string2 = string2 + "    function doBack() {";
            string2 = string2 + "        window.location = \"javascript:history.back(1)\"";
            string2 = string2 + "    }";
            string2 = string2 + "</script>";
            string2 = string2 + "<p>&nbsp;<font face=\"Arial\"><b>Import LDAP users and Groups</b></p>";
            string2 = string2 + "<p>&nbsp;<font face=\"Arial\"><small>Following users and groups already exist, overwrite them all?</small></font></p>";
            string2 = string2 + "<form method=\"POST\" >";
            string2 = string2 + "<p>&nbsp;<input style = \"width = 70\" type=\"submit\" value=\"Yes\" name=\"button" + IDS_CONFIG_LDAP_IMPORT + "\">";
            string2 = string2 + "&nbsp;<input style = \"width = 70\" type=\"button\" value=\"Cancel\" name=\"button1\" onclick = \"doBack()\"></p>";
            string2 = string2 + "<hr>";
            string2 = string2 + "  <p>&nbsp;<select size=1 name=cbbShowType>";
            string2 = string2 + "    <option " + (!bl ? "selected" : "") + ">User(s)</option>";
            string2 = string2 + "    <option " + (bl ? "selected" : "") + ">Group(s)</option>";
            string2 = string2 + "  </select>";
            string2 = string2 + "  &nbsp;<input type=\"submit\" value=\"Refresh\" name=\"button" + IDS_REQUEST_CONFIG_LDAP_IMPORT_CONFIRM + "\"></p>";
            string2 = string2 + "</form>";
            if (!bl) {
                if (!enumeration.hasMoreElements()) {
                    string2 = string2 + "<font face=\"Arial\"><small><p>&nbsp;No users exists.</p>";
                } else {
                    string2 = string2 + "<table border=0 align=center width=419 height=13>";
                    string2 = string2 + "  <tr>";
                    string2 = string2 + "    <td width=129 bgcolor=#5095ba align=center>";
                    string2 = string2 + "      <p align=center><font color=#FFFFFF><font face=\"Arial\"><b>Name</b></font></td>";
                    string2 = string2 + "    <td width=276 bgcolor=#5095ba align=center>";
                    string2 = string2 + "      <p align=center><font color=#FFFFFF><font face=\"Arial\"><b>Fullname</b></font></td>";
                    string2 = string2 + "  </tr>";
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            UserImpl userImpl = (UserImpl)enumeration.nextElement();
                            string2 = string2 + "  <tr>";
                            string2 = string2 + "    <td width=129 align=left><font face=\"Arial\"><small>" + userImpl.getName() + "</td>";
                            string2 = string2 + "    <td width=276 align=left><font face=\"Arial\"><small>" + userImpl.getFullname() + "</td>";
                            string2 = string2 + "  </tr>";
                        }
                    }
                }
                string2 = string2 + "</table>";
            } else if (bl) {
                if (!enumeration2.hasMoreElements()) {
                    string2 = string2 + "<font face=\"Arial\"><small><p>&nbsp;No groups exists.</p>";
                } else {
                    string2 = string2 + "<table border=0 align=center width=419 >";
                    string2 = string2 + "  <tr>";
                    string2 = string2 + "    <td width=129 bgcolor=#5095ba align=center>";
                    string2 = string2 + "      <p align=center><font color=#FFFFFF><font face=\"Arial\"><b>Name</b></font></td>";
                    string2 = string2 + "    <td width=276 bgcolor=#5095ba align=center>";
                    string2 = string2 + "      <p align=center><font color=#FFFFFF><font face=\"Arial\"><b>Description</b></font></td>";
                    string2 = string2 + "  </tr>";
                    if (enumeration2 != null) {
                        while (enumeration2.hasMoreElements()) {
                            GroupImpl groupImpl = (GroupImpl)enumeration2.nextElement();
                            string2 = string2 + "  <tr>";
                            string2 = string2 + "    <td width=129 align=left><font face=\"Arial\"><small>" + groupImpl.getName() + "</td>";
                            string2 = string2 + "    <td width=276 align=left><font face=\"Arial\"><small>" + groupImpl.getDescription() + "</td>";
                            string2 = string2 + "  </tr>";
                        }
                    }
                }
                string2 = string2 + "</table>";
            }
        }
        this.writeResponse(string2);
    }

    private void IDS_CONFIG_LDAP_GET_ALL_USER() throws IOException {
        String string;
        String string2 = "";
        boolean bl = false;
        UserImpl userImpl = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        String string3 = "";
        String string4 = "";
        SharedPasswordRealm sharedPasswordRealm = null;
        try {
            sharedPasswordRealm = (SharedPasswordRealm)Realm.get(ServerEnv.getActiveRealm());
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        vector2 = LdapToolkit.getUsers();
        vector3 = LdapToolkit.getGroups()[0];
        if (vector2 == null && vector3 == null) {
            this.printMessage("No Any user/group can be imported!", HomeProcessor.IDS_REQUEST_HOME);
            return;
        }
        vector = LdapToolkit.listEncryptedUser(vector2);
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                userImpl = (UserImpl)vector.elementAt(i);
                string3 = userImpl.getName();
                string4 = this.getPropertyIgnoreCase("pw_" + string3);
                if (string4 == null) break;
                string = this.getPropertyIgnoreCase("confirmPw_" + string3);
                if (!string4.equals(string)) {
                    vector4.addElement(string3);
                    continue;
                }
                if (string4.equals("")) {
                    vector5.addElement(string3);
                }
                try {
                    ((UserImpl)vector.elementAt(i)).setAuthInfo(string4);
                    continue;
                }
                catch (BadRealmException badRealmException) {
                    ServiceLogger.logError((Throwable)((Object)badRealmException));
                }
            }
        }
        if (vector4.isEmpty() && string4 != null) {
            bl = true;
        }
        if (!bl && vector != null) {
            string2 = string2 + "<font face=\"Arial\"><p>&nbsp;<b>Import LDAP users and Groups</b></p>";
            string2 = string2 + "&nbsp;<font face=\"Arial\"><small>Please create new passwords for those users.";
            string2 = string2 + "<p>&nbsp;<input type=\"submit\" value=\"OK\" name=\"button" + IDS_CONFIG_LDAP_IMPORT + "\">";
            string2 = string2 + "<hr>";
            string2 = string2 + "<form method=\"POST\" >";
            string2 = string2 + "<table border=0 width=406 align=center height=49>";
            string2 = string2 + "  <tr>";
            string2 = string2 + "   <td width=129 bgcolor=#5095ba height=20>";
            string2 = string2 + "     <p align=center><b><font color=#FFFFFF face=\"Arial\">Name</font></b></p>";
            string2 = string2 + "   </td>";
            string2 = string2 + "   <td width=261 bgcolor=#5095ba height=20 colspan=2>";
            string2 = string2 + "     <p align=center><font color=#FFFFFF face=\"Arial\"><b>Password</b></font></p>";
            string2 = string2 + "   </td>";
            string2 = string2 + "  </tr>";
            String string5 = "";
            string = "bgcolor=#FF0000";
            for (int i = 0; i < vector.size(); ++i) {
                string5 = i % 2 == 0 ? "" : "bgcolor=#C0C0C0";
                userImpl = (UserImpl)vector.elementAt(i);
                string3 = userImpl.getName();
                if (vector4.contains(string3)) {
                    string5 = string;
                    string4 = "";
                } else {
                    try {
                        string4 = (String)userImpl.getAuthInfo();
                        if (string4.startsWith("{")) {
                            string4 = "";
                        }
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                    }
                }
                string2 = string2 + "  <tr>";
                string2 = string2 + "    <td width=129 height=21 align=center rowspan=2 " + string5 + "><font face=\"Arial\"><small>" + userImpl.getName() + "</td>";
                string2 = string2 + "    <td width=80 height=11 align=center " + string5 + ">";
                string2 = string2 + "        <p align=right><font face=\"Arial\"><small><u>New:</u> &nbsp;&nbsp; <u> </u> ";
                string2 = string2 + "    </td>";
                string2 = string2 + "    <td width=181 height=11 align=center " + string5 + ">";
                string2 = string2 + "          <p align=left><font face=\"Arial\"><small><input type=password name=pw_" + userImpl.getName() + " value=\"" + string4 + "\" size=23></p>";
                string2 = string2 + "    </td>";
                string2 = string2 + "  </tr>";
                string2 = string2 + "  <tr>";
                string2 = string2 + "    <td width=80 height=10 align=center " + string5 + ">";
                string2 = string2 + "        <p align=right><font face=\"Arial\"><small><u>Confirm:</u> &nbsp;&nbsp; <u> </u> ";
                string2 = string2 + "    </td>";
                string2 = string2 + "    <td width=181 height=10 align=center " + string5 + ">";
                string2 = string2 + "    <p align=left><font face=\"Arial\"><small><input type=password name=confirmPw_" + userImpl.getName() + " value=\"" + string4 + "\" size=23>";
                string2 = string2 + "    </td>";
                string2 = string2 + "  </tr>";
            }
            string2 = string2 + "</table>";
            string2 = string2 + "</form>";
        }
        if (bl) {
            LdapToolkit.bIsImport = true;
            if (vector2 != null) {
                LdapToolkit.saveUsers(vector2, true);
            }
            if (vector != null) {
                LdapToolkit.saveUsers(vector, true);
            }
            if (vector3 != null) {
                // empty if block
            }
            LdapToolkit.runAtServerRestart(ServerEnv.getActiveRealm());
            LdapToolkit.bIsImport = false;
            this.printMessage("Import finished!", HomeProcessor.IDS_REQUEST_HOME);
        } else {
            this.writeResponse(string2);
        }
    }

    private void IDS_CONFIG_LDAP_GROUPQUERY() throws IOException {
        if (!LdapToolkit.isLdapEnable()) {
            this.printMessage("LDAP support is disabled.", HomeProcessor.IDS_REQUEST_HOME);
            return;
        }
        String string = "";
        string = string + "<script>";
        string = string + "    function doBack() {";
        string = string + "        window.location = \"javascript:history.back(1)\"";
        string = string + "    }";
        string = string + "</script>";
        string = string + "<p>&nbsp;<font face=\"Arial\"><b>Import LDAP users and Groups</b></p>";
        string = string + "&nbsp;<small>Import All LDAP users and groups?</small></font>";
        string = string + "<form method=\"POST\" >";
        string = string + "  <p>&nbsp;<select size=1 name=cbbImportType>";
        string = string + "    <option>Overwrite all existing users or groups</option>";
        string = string + "    <option selected>Ask before overwrite</option>";
        string = string + "  </select></p>";
        string = string + "<p>&nbsp;<input style = \"width = 80\" type=\"submit\" value=\"Import All\" name=\"button" + IDS_REQUEST_CONFIG_LDAP_IMPORT_CONFIRM + "\">";
        string = string + "     &nbsp;<input style = \"width = 80\" type=\"button\" value=\"Back\" name=\"button1\" onclick = \"doBack()\"></p>";
        string = string + "</form>";
        string = string + "<hr>";
        this.writeResponse(string);
    }

    private void IDS_CONFIG_LDAP_IMPORT() throws IOException {
        this.DefaultFormat();
        String string = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Object var3_3 = null;
        hashtable.put("ldaprealm.url", this.getPropertyIgnoreCase("txLdapUrl"));
        hashtable.put("ldaprealm.port", this.getPropertyIgnoreCase("txPort"));
        hashtable.put("ldaprealm.root", this.getPropertyIgnoreCase("txRoot"));
        hashtable.put("ldaprealm.authentication", this.getPropertyIgnoreCase("cbbEncryptionType"));
        if (!this.getPropertyIgnoreCase("cbbEncryptionType").equalsIgnoreCase("none")) {
            hashtable.put("ldaprealm.principal", this.getPropertyIgnoreCase("txManagerName"));
            hashtable.put("ldaprealm.credential", this.getPropertyIgnoreCase("txPassword"));
        }
        if (this.getPropertyIgnoreCase("chbSSL") == null) {
            hashtable.put("ldaprealm.ssl", "false");
        } else if (this.getPropertyIgnoreCase("chbSSL").equalsIgnoreCase("ON")) {
            hashtable.put("ldaprealm.ssl", "true");
        }
        hashtable.put("ldaprealm.scheme.user.distinguish_name", this.getPropertyIgnoreCase("txUserDN"));
        hashtable.put("ldaprealm.scheme.user.common_name", this.getPropertyIgnoreCase("txUserCN"));
        hashtable.put("ldaprealm.scheme.user.user_id", this.getPropertyIgnoreCase("txUserID"));
        hashtable.put("ldaprealm.scheme.user.password", this.getPropertyIgnoreCase("txUserPassword"));
        hashtable.put("ldaprealm.scheme.user.search_filter", this.getPropertyIgnoreCase("txUserFilter"));
        Vector vector = new Vector();
        vector = this.CompressMail().queryUsers(hashtable);
        if (vector == null) {
            string = string + "<p>&nbsp;<font face=\"Arial\"><small><font face=\"Arial\">No any user found. Please check your settings.</font></p>";
            string = string + "&nbsp;<font face=\"Arial\"><small><a href=\"RequestConfigLdap\">Cancel</a></p>";
            this.writeResponse(string);
            return;
        }
        string = string + "<script>";
        string = string + "    function doBack() {";
        string = string + "        window.location = \"RequestConfigLdap\"";
        string = string + "    }";
        string = string + "</script>";
        string = string + "<p>&nbsp;<font face=\"Arial\"><b> LDAP User Query Result</b></font></p>";
        string = string + "     &nbsp;<input type=\"button\" value=\"Back\" name=\"button1\" onclick = \"doBack()\"></p>";
        string = string + "<hr>";
        string = string + "<table align=center border=0 width=418>";
        string = string + "  <tr>";
        string = string + "    <td width=187 bgcolor=#5095ba align=left>";
        string = string + "      <p align=center><font face=\"Arial\"><font color=#FFFFFF><b>User ID</b></font></td>";
        string = string + "    <td width=219 bgcolor=#5095ba align=left>";
        string = string + "      <p align=center><font face=\"Arial\"><font color=#FFFFFF><b>Full name</b></font></td>";
        string = string + "  </tr>";
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            UserImpl userImpl = (UserImpl)vector.elementAt(i);
            if (vector2.contains(userImpl.getName())) continue;
            vector2.addElement(userImpl.getName());
            string = string + "  <tr>";
            string = string + "    <td width=187 align=left><font face=\"Arial\"><small>" + userImpl.getName() + "</td>";
            string = string + "    <td width=219 align=left><font face=\"Arial\"><small>" + userImpl.getFullname() + "</td>";
            string = string + "  </tr>";
        }
        string = string + "</table>";
        this.writeResponse(string);
    }

    private void IDS_CONFIG_LDAP_REMOVE_ALL_USER() throws IOException {
        this.DefaultFormat();
        String string = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Object var3_3 = null;
        hashtable.put("ldaprealm.url", this.getPropertyIgnoreCase("txLdapUrl"));
        hashtable.put("ldaprealm.port", this.getPropertyIgnoreCase("txPort"));
        hashtable.put("ldaprealm.root", this.getPropertyIgnoreCase("txRoot"));
        hashtable.put("ldaprealm.principal", this.getPropertyIgnoreCase("txManagerName"));
        hashtable.put("ldaprealm.credential", this.getPropertyIgnoreCase("txPassword"));
        hashtable.put("ldaprealm.authentication", this.getPropertyIgnoreCase("cbbEncryptionType"));
        if (this.getPropertyIgnoreCase("chbSSL") == null) {
            hashtable.put("ldaprealm.ssl", "false");
        } else if (this.getPropertyIgnoreCase("chbSSL").equalsIgnoreCase("ON")) {
            hashtable.put("ldaprealm.ssl", "true");
        }
        hashtable.put("ldaprealm.scheme.user.distinguish_name", this.getPropertyIgnoreCase("txUserDN"));
        hashtable.put("ldaprealm.scheme.user.common_name", this.getPropertyIgnoreCase("txUserCN"));
        hashtable.put("ldaprealm.scheme.user.user_id", this.getPropertyIgnoreCase("txUserID"));
        hashtable.put("ldaprealm.scheme.user.password", this.getPropertyIgnoreCase("txUserPassword"));
        hashtable.put("ldaprealm.scheme.user.search_filter", this.getPropertyIgnoreCase("txUserFilter"));
        hashtable.put("ldaprealm.scheme.group.common_name", this.getPropertyIgnoreCase("txGroupCN"));
        hashtable.put("ldaprealm.scheme.group.member_type", this.getPropertyIgnoreCase("txGroupMemberType"));
        hashtable.put("ldaprealm.scheme.group.distinguish_name", this.getPropertyIgnoreCase("txGroupDN"));
        hashtable.put("ldaprealm.scheme.group.search_filter", this.getPropertyIgnoreCase("txGroupFilter"));
        hashtable.put("ldaprealm.scheme.group.admin_group", this.getPropertyIgnoreCase("txAdminGroup"));
        Vector vector = new Vector();
        vector = this.CompressMail().queryGroups(hashtable);
        if (vector == null) {
            string = string + "<p>&nbsp;<font face=\"Arial\"><small><font face=\"Arial\">No any group found. Please check your settings.</font></p>";
            string = string + "&nbsp;<font face=\"Arial\"><small><a href=\"RequestConfigLdap\">Cancel</a></p>";
            this.writeResponse(string);
            return;
        }
        string = string + "<script>";
        string = string + "    function doBack() {";
        string = string + "        window.location = \"RequestConfigLdap\"";
        string = string + "    }";
        string = string + "</script>";
        string = string + "<p>&nbsp;<font face=\"Arial\"><b> LDAP User Query Result</b></font></p>";
        string = string + "     &nbsp;<input type=\"button\" value=\"Back\" name=\"button1\" onclick = \"doBack()\"></p>";
        string = string + "<hr>";
        string = string + "<table align=center border=0 width=574>";
        string = string + "  <tr>";
        string = string + "    <td width=156 bgcolor=#5095ba align=left>";
        string = string + "      <p align=center><font face=\"Arial\"><font color=#FFFFFF><b>Group Name</b></font></td>";
        string = string + "    <td width=406 bgcolor=#5095ba align=left>";
        string = string + "      <p align=center><font face=\"Arial\"><font color=#FFFFFF><b>Description</b></font></td>";
        string = string + "  </tr>";
        for (int i = 0; i < vector.size(); ++i) {
            GroupImpl groupImpl = (GroupImpl)vector.elementAt(i);
            string = string + "  <tr>";
            string = string + "    <td width=156 align=left><font face=\"Arial\"><small>" + groupImpl.getName() + "</td>";
            string = string + "    <td width=406 align=left><font face=\"Arial\"><small>" + groupImpl.getDescription() + "</td>";
            string = string + "  </tr>";
        }
        string = string + "</table>";
        this.writeResponse(string);
    }

    private void IDS_CONFIG_LDAP_TESTCONNECTION() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (!LdapToolkit.isLdapEnable()) {
            this.printMessage("LDAP support is disabled.", HomeProcessor.IDS_REQUEST_HOME);
            return;
        }
        try {
            object5 = (SharedPasswordRealm)Realm.get(ServerEnv.getActiveRealm());
            object4 = ((Realm)object5).getGroups();
            while (object4.hasMoreElements()) {
                object3 = (GroupImpl)object4.nextElement();
                object2 = ((GroupImpl)object3).listDisappearedPrincipal();
                while (object2.hasMoreElements()) {
                    Object object6;
                    object = (String)object2.nextElement();
                    if (!((SharedPasswordRealm)object5).isUserExist((String)object)) {
                        object6 = new UserImpl((String)object);
                        ((GroupImpl)object3).removeMember((Principal)object6);
                        continue;
                    }
                    if (((Realm)object5).isGroupExist((String)object)) continue;
                    object6 = new GroupImpl((String)object);
                    ((GroupImpl)object3).removeMember((Principal)object6);
                }
                try {
                    if (((GroupImpl)object3).getLdapFlag()) continue;
                    UserDataToolkit.saveGroupProperties((GroupImpl)object3);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        LdapToolkit.runAtServerRestart(ServerEnv.getActiveRealm());
        object5 = null;
        object4 = "";
        object3 = "";
        try {
            object5 = LdapToolkit.checkSynchronization(Realm.get(ServerEnv.getActiveRealm()), false);
        }
        catch (BadRealmException badRealmException) {
            object3 = (String)object3 + "<p> " + (Object)((Object)badRealmException) + "</p>";
        }
        catch (NoSuchRealmException noSuchRealmException) {
            object3 = (String)object3 + "<p> " + (Object)((Object)noSuchRealmException) + "</p>";
        }
        object4 = (String)object4 + "<script>";
        object4 = (String)object4 + "    function doBack() {";
        object4 = (String)object4 + "        window.location = \"javascript:history.back(1)\"";
        object4 = (String)object4 + "    }";
        object4 = (String)object4 + "</script>";
        object4 = (String)object4 + "<p>&nbsp;<font face=\"Arial\"><b> Synchronization Check</b></font></p>";
        object4 = (String)object4 + "&nbsp;<font face=\"Arial\"><small>The following users or/and ACLs are no longer in use, delete?</small></font>";
        object4 = (String)object4 + "<form method=\"POST\" >";
        object4 = (String)object4 + "<p>&nbsp;<input style = \"width = 80\" type=\"submit\" value=\"Delete All\" name=\"button" + IDS_CONFIG_LDAP_CHECKSYNCHRONIZATION + "\">";
        object4 = (String)object4 + "     &nbsp;<input style = \"width = 80\" type=\"button\" value=\"Back\" name=\"button1\" onclick = \"doBack()\"></p>";
        object4 = (String)object4 + "</form>";
        object4 = (String)object4 + "<hr>";
        object4 = (String)object4 + "<table align=center border=0 width=\"418\">";
        object4 = (String)object4 + "  <tr>";
        object4 = (String)object4 + "    <td width=187 bgcolor=#5095ba>";
        object4 = (String)object4 + "      <p align=center><font face=\"Arial\"><font color=#FFFFFF><b>ACL</b></font></td>";
        object4 = (String)object4 + "    <td width=219 bgcolor=#5095ba>";
        object4 = (String)object4 + "      <p align=center><font face=\"Arial\"><font color=#FFFFFF><b>Principal</b></font></td>";
        object4 = (String)object4 + "  </tr>";
        while (object5.hasMoreElements()) {
            object2 = (String)object5.nextElement();
            object = new StringTokenizer((String)object2, ";");
            object4 = (String)object4 + "  <tr>";
            object4 = (String)object4 + "    <td align=center width=187><font face=\"Arial\"><small>" + ((StringTokenizer)object).nextElement() + "</td>";
            object4 = (String)object4 + "    <td align=center width=219><font face=\"Arial\"><small>" + ((StringTokenizer)object).nextElement() + "</td>";
            object4 = (String)object4 + "  </tr>";
        }
        object4 = (String)object4 + "</table>";
        this.writeResponse((String)object4);
    }

    private void IDS_CONFIG_LDAP_USERQUERY() throws IOException {
        String string = null;
        try {
            LdapToolkit.checkSynchronization(Realm.get(ServerEnv.getActiveRealm()), true);
        }
        catch (BadRealmException badRealmException) {
            string = string + "<p> " + (Object)((Object)badRealmException) + "</p>";
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = string + "<p> " + (Object)((Object)noSuchRealmException) + "</p>";
        }
        this.printMessage(string == null ? "Synchronization check OK!" : string, HomeProcessor.IDS_REQUEST_HOME);
    }

    private void IDS_CONFIG_LOG() throws IOException {
        this.DefaultFormat();
        IDS_LIST_ACL = (LdapEnvironments)DefaultFormat.clone();
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        IDS_LIST_ACL.clear();
        IDS_LIST_ACL.setProperty("ldaprealm.url", this.getPropertyIgnoreCase("txLdapUrl"));
        IDS_LIST_ACL.setProperty("ldaprealm.port", this.getPropertyIgnoreCase("txPort"));
        IDS_LIST_ACL.setProperty("ldaprealm.root", this.getPropertyIgnoreCase("txRoot"));
        IDS_LIST_ACL.setProperty("ldaprealm.principal", this.getPropertyIgnoreCase("txManagerName"));
        IDS_LIST_ACL.setProperty("ldaprealm.credential", this.getPropertyIgnoreCase("txPassword"));
        IDS_LIST_ACL.setProperty("ldaprealm.authentication", this.getPropertyIgnoreCase("cbbEncryptionType"));
        if (this.getPropertyIgnoreCase("chbSSL") == null) {
            IDS_LIST_ACL.setProperty("ldaprealm.ssl", "false");
        } else if (this.getPropertyIgnoreCase("chbSSL").equalsIgnoreCase("ON")) {
            IDS_LIST_ACL.setProperty("ldaprealm.ssl", "true");
        }
        IDS_LIST_ACL.buildEnvironments();
        n = APIUtil.parseInt(this.getPropertyIgnoreCase("txPort"));
        n2 = APIUtil.parseInt(this.getPropertyIgnoreCase("txEncryptedPort"));
        LdapConnection ldapConnection = new LdapConnection();
        if (!LdapConnection.reconnect(IDS_LIST_ACL)) {
            string = "";
            string = string + "\n<p><font face=\"Arial\"><small>&nbsp;Connection to LDAP Server: <b>" + LdapEnvironments.getProperty("ldaprealm.url") + "</b> failed!\n</p>";
            string = string + "<p><font face=\"Arial\"><small>&nbsp;Click <a href=\"RequestConfigLdap\">Back</a> to try again</p>";
        } else {
            if (this.getPropertyIgnoreCase("txPort") == null || this.getPropertyIgnoreCase("txPort").trim().length() == 0) {
                bl = true;
                string = "";
                string = "<p><font face=\"Arial\">&nbsp;LDAP Server Port should not be null.</p>";
            } else if (n < 1 || n > 65535) {
                bl = true;
                string = "";
                string = "<p><font face=\"Arial\">&nbsp;LDAP Server Port should be integer between 1 and 65535.</p>";
            }
            if (this.getPropertyIgnoreCase("txEncryptedPort") != null && this.getPropertyIgnoreCase("txEncryptedPort").trim().length() != 0 && (n2 < 1 || n2 > 65535)) {
                bl = true;
                string = string == null || string.trim().length() == 0 ? "<p><font face=\"Arial\">&nbsp;LDAP Encrypted Port should be integer between 1 and 65535.</p>" : string + "<p><font face=\"Arial\">&nbsp;LDAP Encrypted Port should be integer between 1 and 65535.</p>";
            }
            if (this.getPropertyIgnoreCase("txPassword").equals("") && this.getPropertyIgnoreCase("cbbEncryptionType").equalsIgnoreCase("Simple")) {
                bl = true;
                string = string == null || string.trim().length() == 0 ? "<p><font face=\"Arial\">&nbsp;If your encryption type is simple, password can't be null.</p>" : string + "<p><font face=\"Arial\">&nbsp;If your encryption type is simple, password can't be null.</p>";
            }
            string = string + "<p>&nbsp;<font face=\"Arial\"><small>Click <a href=\"RequestConfigLdap\">Back</a> to try again</p>";
            if (!bl) {
                string = "";
                string = "<p>&nbsp;<font face=\"Arial\">Connection to LDAP Server: <b>" + LdapEnvironments.getProperty("ldaprealm.url") + "</b> succeed!</p>";
                string = string + "<p>&nbsp;<font face=\"Arial\"><small>Click <a href=\"RequestConfigLdap\">Back</a> to try again</p>";
            }
        }
        this.writeResponse(string);
    }

    private void IDS_CONFIG_MAIL() throws IOException {
        this.DefaultFormat();
        IDS_LIST_ACL = (LdapEnvironments)DefaultFormat.clone();
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        IDS_LIST_ACL.clear();
        IDS_LIST_ACL.setProperty("ldaprealm.url", this.getPropertyIgnoreCase("txLdapUrl"));
        IDS_LIST_ACL.setProperty("ldaprealm.port", this.getPropertyIgnoreCase("txPort"));
        IDS_LIST_ACL.setProperty("ldaprealm.root", this.getPropertyIgnoreCase("txRoot"));
        IDS_LIST_ACL.setProperty("ldaprealm.principal", this.getPropertyIgnoreCase("txManagerName"));
        IDS_LIST_ACL.setProperty("ldaprealm.credential", this.getPropertyIgnoreCase("txPassword"));
        IDS_LIST_ACL.setProperty("ldaprealm.authentication", this.getPropertyIgnoreCase("cbbEncryptionType"));
        if (this.getPropertyIgnoreCase("chbSSL") == null) {
            IDS_LIST_ACL.setProperty("ldaprealm.ssl", "false");
        } else if (this.getPropertyIgnoreCase("chbSSL").equalsIgnoreCase("ON")) {
            IDS_LIST_ACL.setProperty("ldaprealm.ssl", "true");
        }
        if (this.getPropertyIgnoreCase("chbEnableSupport") == null) {
            IDS_LIST_ACL.setProperty("ldaprealm.enable_ldap_support", "false");
            bl = false;
        } else if (this.getPropertyIgnoreCase("chbEnableSupport").equalsIgnoreCase("ON")) {
            IDS_LIST_ACL.setProperty("ldaprealm.enable_ldap_support", "true");
            bl = true;
        }
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", this.getPropertyIgnoreCase("txUserID"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", this.getPropertyIgnoreCase("txUserCN"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", this.getPropertyIgnoreCase("txUserPassword"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", this.getPropertyIgnoreCase("txUserDN"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", this.getPropertyIgnoreCase("txUserFilter"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", this.getPropertyIgnoreCase("txGroupCN"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", this.getPropertyIgnoreCase("txGroupMemberType"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", this.getPropertyIgnoreCase("txGroupDN"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", this.getPropertyIgnoreCase("txGroupFilter"));
        IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", this.getPropertyIgnoreCase("txAdminGroup"));
        IDS_LIST_ACL.setComments("");
        IDS_LIST_ACL.buildProperties();
        n = APIUtil.parseInt(this.getPropertyIgnoreCase("txPort"));
        n2 = APIUtil.parseInt(this.getPropertyIgnoreCase("txEncryptedPort"));
        boolean bl2 = false;
        if (this.getPropertyIgnoreCase("txPort") == null || this.getPropertyIgnoreCase("txPort").trim().length() == 0) {
            bl2 = true;
            string = "";
            string = "<p><font face=\"Arial\">&nbsp;LDAP Server Port should not be null.</p>";
        } else if (n < 1 || n > 65535) {
            bl2 = true;
            string = "";
            string = "<p><font face=\"Arial\">&nbsp;LDAP Server Port should be integer between 1 and 65535.</p>";
        }
        if (this.getPropertyIgnoreCase("txEncryptedPort") != null && this.getPropertyIgnoreCase("txEncryptedPort").trim().length() != 0 && (n2 < 1 || n2 > 65535)) {
            bl2 = true;
            string = string == null || string.trim().length() == 0 ? "<p><font face=\"Arial\">&nbsp;LDAP Encrypted Port should be integer between 1 and 65535.</p>" : string + "<p><font face=\"Arial\">&nbsp;LDAP Encrypted Port should be integer between 1 and 65535.</p>";
        }
        if (this.getPropertyIgnoreCase("txPassword").equals("") && this.getPropertyIgnoreCase("cbbEncryptionType").equalsIgnoreCase("Simple")) {
            bl2 = true;
            string = string == null || string.trim().length() == 0 ? "<p><font face=\"Arial\">&nbsp;If your encryption type is simple, password can't be null.</p>" : string + "<p><font face=\"Arial\">&nbsp;If your encryption type is simple, password can't be null.</p>";
        }
        if (bl2) {
            string = string + "<p>&nbsp;<font face=\"Arial\"><small>Click <a href=\"RequestConfigLdap\">Back</a> to try again</p>";
        }
        if (string == null) {
            IDS_LIST_ACL.saveProperties();
            LdapToolkit.refreshLdapSettings();
            LdapToolkit.runAtServerRestart(ServerEnv.getActiveRealm());
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            ClusterService clusterService = httpRptServer.getClusterService();
            if (clusterService != null) {
                Member[] memberArray = null;
                try {
                    memberArray = clusterService.getAllMembers();
                }
                catch (ClusterException clusterException) {
                    ServiceLogger.logError((Throwable)((Object)clusterException), 3);
                }
                for (int i = 0; i < memberArray.length; ++i) {
                    if (!memberArray[i].isBackupAdmin()) continue;
                    try {
                        MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(memberArray[i].getHost(), Integer.parseInt(memberArray[i].getPort()), "MemberMonitor");
                        memberMonitor.setLdapConfig(ServerEnv.getLdapConfig());
                        continue;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
            }
            this.printMessage("Configuration has been changed!", HomeProcessor.IDS_REQUEST_HOME);
        } else {
            this.writeResponse(string);
        }
    }

    private void IDS_CONFIG_SERVICE() throws IOException {
        String string = "";
        String string2 = "";
        String string3 = this.getPropertyIgnoreCase("cbbDefaultSetting");
        String string4 = "";
        int n = 0;
        if (string3 != null) {
            IDS_LIST_ACL = (LdapEnvironments)DefaultFormat.clone();
            if (string3.equalsIgnoreCase("iPlanet Directory Server")) {
                n = 2;
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", "ou=people");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", "(&(uid=*)(objectclass=person))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", "userPassword");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", "uid");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", "ou=groups");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", "(&(cn=*)(objectclass=groupofuniquenames))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", "uniqueMember");
            } else if (string3.equalsIgnoreCase("Microsoft Site Server")) {
                n = 3;
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", "ou=Members");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", "(&(cn=*)(objectclass=member))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", "userPassword");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", "ou=groups");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", "(&(cn=*)(objectclass=mgroup))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", "uniqueMember");
            } else if (string3.equalsIgnoreCase("Novell Directory Server")) {
                n = 1;
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", "ou=people");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", "(&(cn=*)(objectclass=person))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", "userPassword");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", "uid");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", "ou=groups");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", "(&(cn=*)(objectclass=groupofuniquenames))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", "uniqueMember");
            } else if (string3.equalsIgnoreCase("OpenLDAP Directory Server")) {
                n = 4;
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", "ou=members");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", "(&(uid=*)(objectclass=person))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", "userPassword");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", "uid");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", "ou=groups");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", "(&(cn=*)(objectclass=groupofuniquenames))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", "uniqueMember");
            } else if (string3.equalsIgnoreCase("Win2000 Active Directory")) {
                n = 5;
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", "(&(cn=*)(objectclass=person))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", "userPassword");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", "sAMAccountName");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", "(&(cn=*)(objectclass=group))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", "member");
            } else if (string3.equalsIgnoreCase("Lotus Domino on NT")) {
                n = 6;
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.distinguish_name", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.search_filter", "(&(cn=*)(objectclass=person))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.password", "userPassword");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.user.user_id", "uid");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.admin_group", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.common_name", "cn");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.distinguish_name", "");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.search_filter", "(&(cn=*)(objectclass=groupofnames))");
                IDS_LIST_ACL.setProperty("ldaprealm.scheme.group.member_type", "member");
            } else if (string3.equalsIgnoreCase("Current Settings")) {
                n = 0;
                IDS_LIST_ACL = new LdapEnvironments();
            }
        }
        string = string + " <script language=javaScript > \t\n";
        string = string + " <!-- \t\n";
        string = string + " function trim(str) { \t\n";
        string = string + "     if (str == null) { return null } \t\n";
        string = string + "     while (str.substring(0,1) == \" \") { \t\n";
        string = string + "         str=str.substring(1,str.length); \t\n";
        string = string + "     } \t\n";
        string = string + "     return str; \t\n";
        string = string + " } \t\n";
        string = string + " function setCookies(name,load) { \t\n";
        string = string + "     var cookieStr ; \t\n";
        string = string + "     if (load) { \t\n";
        string = string + "         document.cookie = \"load=load#true\"; \t\n";
        string = string + "     } else { \t\n";
        string = string + "         document.cookie = \"load=load#false\"; \t\n";
        string = string + "     } \t\n";
        string = string + "     cookieStr=\"\"; name=\"ldap\"; \t\n";
        string = string + "         cookieStr += \"EnableSupport#\"+document.forms[0].chbEnableSupport.checked+\"%\"; \t\n";
        string = string + "         cookieStr += \"UserAuthentication#\"+document.forms[0].chbUserAuthentication.checked+\"%\"; \t\n";
        string = string + "         cookieStr += \"ldapUrl#\"+document.forms[0].txLdapUrl.value+\"%\"; \t\n";
        string = string + "         cookieStr += \"Port#\"+document.forms[0].txPort.value+\"%\"; \t\n";
        string = string + "     cookieStr += \"EncryptedPort#\"+document.forms[0].txEncryptedPort.value+\"%\"; \t\n";
        string = string + "     cookieStr += \"Root#\"+document.forms[0].txRoot.value+\"%\"; \t\n";
        string = string + "     cookieStr += \"ManagerName#\"+document.forms[0].txManagerName.value+\"%\"; \t\n";
        string = string + "     cookieStr += \"EncryptionType#\"+document.forms[0].cbbEncryptionType.value+\"%\"; \t\n";
        string = string + "     cookieStr += \"FirstAuthentication#\"+document.forms[0].cbbFirstAuthentication.value; \t\n";
        string = string + "     document.cookie = name+\"=\"+cookieStr; \t\n";
        string = string + "         cookieStr = \"\";  name = \"user\"; \t\n";
        string = string + "         cookieStr += \"UserID#\"+document.forms[0].txUserID.value+\"%\";     \t\n";
        string = string + "         cookieStr += \"UserCN#\"+document.forms[0].txUserCN.value+\"%\";     \t\n";
        string = string + "         cookieStr += \"UserPassword#\"+document.forms[0].txUserPassword.value+\"%\";     \t\n";
        string = string + "         cookieStr += \"UserDN#\"+document.forms[0].txUserDN.value+\"%\";     \t\n";
        string = string + "         cookieStr += \"UserFilter#\"+document.forms[0].txUserFilter.value;     \t\n";
        string = string + "     document.cookie = name+\"=\"+cookieStr;     \t\n";
        string = string + "     cookieStr = \"\";  name = \"group\";     \t\n";
        string = string + "     cookieStr += \"GroupCN#\"+document.forms[0].txGroupCN.value+\"%\";      \t\n";
        string = string + "         cookieStr += \"GroupMemberType#\"+document.forms[0].txGroupMemberType.value+\"%\"; \t\n";
        string = string + "         cookieStr += \"GroupDN#\"+document.forms[0].txGroupDN.value+\"%\"; \t\n";
        string = string + "         cookieStr += \"GroupFilter#\"+document.forms[0].txGroupFilter.value+\"%\"; \t\n";
        string = string + "         cookieStr += \"AdminGroup#\"+document.forms[0].txAdminGroup.value; \t\n";
        string = string + "     document.cookie = name+\"=\"+cookieStr;         \t\n";
        string = string + " } \t\n";
        string = string + " function getCookies(name) { \t\n";
        string = string + "     var cookieStr = document.cookie.split(\";\"); \t\n";
        string = string + "     var ldapStr ; \t\n";
        string = string + "     var userStr ; \t\n";
        string = string + "     var groupStr; \t\n";
        string = string + "     var tempStr; \t\n";
        string = string + "     var arrStr; \t\n";
        string = string + "     var cPair; \t\n";
        string = string + "     var cName; \t\n";
        string = string + "     var cValue; \t\n";
        string = string + "     var loadStr; \t\n";
        string = string + "     for (i=0; i<cookieStr.length; i++) { \t\n";
        string = string + "         tempStr =  trim(cookieStr[i]); \t\n";
        string = string + "         if ((tempStr.substring(0,5)) == \"ldap=\") { \t\n";
        string = string + "             ldapStr = tempStr.substring(5,tempStr.length) ;       \t\n";
        string = string + "         } else if ((tempStr.substring(0,5)) == \"user=\" ) { \t\n";
        string = string + "             userStr = tempStr.substring(5,tempStr.length) ; \t\n";
        string = string + "         } else if ((tempStr.substring(0,6)) == \"group=\" ) { \t\n";
        string = string + "             groupStr = tempStr.substring(6,tempStr.length) ;     \t\n";
        string = string + "         } else if ((tempStr.substring(0,5)) == \"load=\") { \t\n";
        string = string + "             loadStr =  tempStr.substring(5,tempStr.length) ; \t\n";
        string = string + "         }      \t\n";
        string = string + "     }     \t\n";
        string = string + "     arrStr = (loadStr+\"%\"+ldapStr+\"%\"+userStr+\"%\"+groupStr).split(\"%\"); \t\n";
        string = string + "     for (j=0; j<arrStr.length; j++) { \t\n";
        string = string + "         cPair = arrStr[j].split(\"#\"); \t\n";
        string = string + "         cName = trim(cPair[0]); \t\n";
        string = string + "         cValue = trim(cPair[1]); \t\n";
        string = string + "         if (cName == name) { \t\n";
        string = string + "             return cValue; \t\n";
        string = string + "         } \t\n";
        string = string + "     } \t\n";
        string = string + "     return null; \t\n";
        string = string + " } \t\n";
        string = string + " function putCookies() { \t\n";
        string = string + "     var cStr;     \t\n";
        string = string + "     if (getCookies(\"load\") != \"true\") { \t\n";
        string = string + "     cStr = getCookies(\"EnableSupport\"); \t\n";
        string = string + "     if (cStr == \"true\") document.forms[0].chbEnableSupport.checked = true; \t\n";
        string = string + "     if (cStr == \"false\") document.forms[0].chbEnableSupport.checked = false; \t\n";
        string = string + "     cStr = getCookies(\"UserAuthentication\"); \t\n";
        string = string + "     if (cStr == \"true\") document.forms[0].chbUserAuthentication.checked = true; \t\n";
        string = string + "     if (cStr == \"false\") document.forms[0].chbUserAuthentication.checked = false; \t\n";
        string = string + "     cStr = getCookies(\"ldapUrl\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].txLdapUrl.value = cStr; \t\n";
        string = string + "     cStr = getCookies(\"Port\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].txPort.value = cStr; \t\n";
        string = string + "     cStr = getCookies(\"EncryptedPort\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].txEncryptedPort.value = cStr; \t\n";
        string = string + "     cStr = getCookies(\"Root\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].txRoot.value = cStr; \t\n";
        string = string + "     cStr = getCookies(\"ManagerName\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].txManagerName.value = cStr; \t\n";
        string = string + "     cStr = getCookies(\"EncryptionType\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].cbbEncryptionType.value = cStr; \t\n";
        string = string + "     cStr = getCookies(\"FirstAuthentication\"); \t\n";
        string = string + "     if (cStr != null) document.forms[0].cbbFirstAuthentication.value = cStr; \t\n";
        string = string + "       cStr = getCookies(\"UserID\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txUserID.value = cStr; \t\n";
        string = string + "       cStr = getCookies(\"UserCN\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txUserCN.value = cStr;     \t\n";
        string = string + "       cStr = getCookies(\"UserPassword\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txUserPassword.value = cStr;     \t\n";
        string = string + "       cStr = getCookies(\"UserDN\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txUserDN.value = cStr;     \t\n";
        string = string + "       cStr = getCookies(\"UserFilter\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txUserFilter.value = cStr;      \t\n";
        string = string + "       cStr = getCookies(\"GroupCN\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txGroupCN.value = cStr;     \t\n";
        string = string + "       cStr = getCookies(\"GroupMemberType\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txGroupMemberType.value = cStr;     \t\n";
        string = string + "       cStr = getCookies(\"GroupDN\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txGroupDN.value = cStr;      \t\n";
        string = string + "       cStr = getCookies(\"GroupFilter\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txGroupFilter.value = cStr;     \t\n";
        string = string + "       cStr = getCookies(\"AdminGroup\"); \t\n";
        string = string + "       if (cStr != null) document.forms[0].txAdminGroup.value = cStr;     \t\n";
        string = string + "     }  \t\n";
        string = string + "     } \t\n";
        string = string + " //--> \t\n";
        string = string + " </script> \t\n";
        string = string + "<form method=\"POST\" >";
        string = string + "<p><font face=\"Arial\"><b>&nbsp;LDAP Support Configuration</b></font></p>";
        string = string + "<p>&nbsp;<u><small><font face=\"Arial\">Select LDAP Server:</font></small></u>";
        string = string + "    <select size=\"1\" name=\"cbbDefaultSetting\">";
        string = string + "        <option value=\"Current Settings\"" + (n == 0 ? "selected" : "") + ">" + "Current Settings" + "</option>";
        string = string + "        <option value=\"Novell Directory Server\"" + (n == 1 ? "selected" : "") + ">" + "Novell Directory Server" + "</option>";
        string = string + "        <option value=\"iPlanet Directory Server\"" + (n == 2 ? "selected" : "") + ">" + "iPlanet Directory Server" + "</option>";
        string = string + "        <option value=\"Microsoft site Server\"" + (n == 3 ? "selected" : "") + ">" + "Microsoft Site Server" + "</option>";
        string = string + "        <option value=\"OpenLDAP Directory Server\"" + (n == 4 ? "selected" : "") + ">" + "OpenLDAP Directory Server" + "</option>";
        string = string + "        <option value=\"Win2000 Active Directory\"" + (n == 5 ? "selected" : "") + ">" + "Win2000 Active Directory" + "</option>";
        string = string + "        <option value=\"Lotus Domino on NT\"" + (n == 6 ? "selected" : "") + ">" + "Lotus Domino on NT" + "</option>";
        string = string + "    </select>";
        string = string + "         <input type=\"submit\" value=\"Load Settings\" name=\"button" + IDS_REQUEST_CONFIG_LDAP + "\"  onclick=setCookies(\"load\",true)>&nbsp;</p>";
        string = string + "         <input type=\"hidden\" name=\"isload\" >";
        string = string + "<hr>";
        string = string + "<table border=\"0\" width=\"500\" align=\"center\">";
        string = string + "  <tr>";
        string = string + "     <td width=\"500\" align=\"right\" colspan=\"2\" bgcolor=\"#5095ba\">";
        string = string + "      <p align=\"center\"><font face=\"Arial\"><b><font color=\"#FFFFFF\">Server Configuration</font></b></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"></td>";
        string2 = LdapEnvironments.getProperty("ldaprealm.enable_ldap_support");
        string2 = string2.equalsIgnoreCase("true") ? "checked" : "";
        string = string + "    <td width=\"289\" align=\"left\"><input type=\"checkbox\" name=\"chbEnableSupport\" " + string2 + "><u><small><font face=\"Arial\">Enable LDAP Support</small></u></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">LDAP URL:</small></u></td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.url");
        string = string + "        <p align=\"left\"><input type=\"text\" name=\"txLdapUrl\" size=\"39\" value=" + string2 + "></p>";
        string = string + "    </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">LDAP Server Port:</small></u></td>";
        string2 = LdapEnvironments.getProperty("ldaprealm.port");
        string = string + "    <td width=\"289\" align=\"left\"><input type=\"text\" name=\"txPort\" size=\"16\" value=" + string2 + " ></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">Encrypted Port:</small></u></small></td>";
        string = string + "    <td width=\"289\" align=\"left\"><input type=\"text\" name=\"txEncryptedPort\" size=\"16\" value=" + string2 + "></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">Root Entry:</small></u></td>";
        string = string + "    <td width=\"289\" align=\"left\"><input type=\"text\" name=\"txRoot\" size=\"39\" value=" + string2 + "></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">Directory Manager DN:</small></u></td>";
        string2 = LdapEnvironments.getProperty("ldaprealm.principal");
        string = string + "    <td width=\"289\" align=\"left\"><input type=\"text\" name=\"txManagerName\" size=\"39\" value=\"" + string2 + "\"></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">Password:</small></u></td>";
        if (this.request.getSession().getValue("password") != null) {
            string2 = this.request.getSession().getValue("password").toString();
            CompressMail = "checked";
        } else {
            string2 = "";
            CompressMail = "";
        }
        string = string + "    <td width=\"289\" align=\"left\"><input type=\"password\" name=\"txPassword\" size=\"16\" value=" + string2 + ">";
        string = string + "    <input type=\"checkbox\" name=\"chbRememberPsw\" " + CompressMail + "><u><small><font face=\"Arial\">Remember Password</font></small></u></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">Encryption Type:</small></u></td>";
        string = string + "    <td width=\"289\" align=\"left\"><select size=\"1\" name=\"cbbEncryptionType\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.authentication");
        string = string + "        <option value=\"simple\"" + (string2.equalsIgnoreCase("simple") ? "selected" : "") + ">simple</option>";
        string = string + "        <option value=\"none\"" + (string2.equalsIgnoreCase("none") ? "selected" : "") + ">none</option>";
        string = string + "      </select></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\"><u><small><font face=\"Arial\">Prior Check to the Users of:</small></u></td>";
        string = string + "    <td width=\"289\" align=\"left\"><select size=\"1\" name=\"cbbFirstAuthentication\">";
        string = string + "      </select></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"500\" align=\"center\" colspan=\"2\">";
        string = string + "      <p align=\"right\">";
        string = string + "      <input type=\"submit\" value=\"Test Connection\" name=\"button" + IDS_CONFIG_LDAP_TESTCONNECTION + "\" onclick=setCookies(\"ldap\",false)  >";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"500\" align=\"center\" colspan=\"2\" bgcolor=\"#5095ba\">";
        string = string + "      <font color=\"#FFFFFF\"><font face=\"Arial\"><b>User Schema</b></font> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">UserID Attribute Name:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.user.user_id");
        string = string + "      <input type=\"text\" name=\"txUserID\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">User Common Name:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.user.common_name");
        string = string + "      <input type=\"text\" name=\"txUserCN\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">User Password:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.user.password");
        string = string + "      <input type=\"text\" name=\"txUserPassword\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">Distinguished Name:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.user.distinguish_name");
        string = string + "      <input type=\"text\" name=\"txUserDN\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">Filter:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.user.search_filter");
        string = string + "      <input type=\"text\" name=\"txUserFilter\" size=\"42\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"500\" align=\"center\" colspan=\"2\">";
        string = string + "      <p align=\"right\">";
        string = string + "      <input style = \"width = 100\" type=\"submit\" value=\"User Query\" name=\"button" + IDS_CONFIG_LDAP_USERQUERY + "\"  onclick=setCookies(\"user\",false)  >";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"500\" align=\"center\" colspan=\"2\" bgcolor=\"#5095ba\">";
        string = string + "      <b><font face=\"Arial\"><font color=\"#FFFFFF\">Group Schema</font></b> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <u><small><font face=\"Arial\">Group Common Name:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.group.common_name");
        string = string + "      <input type=\"text\" name=\"txGroupCN\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">Group Member Type:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.group.member_type");
        string = string + "      <input type=\"text\" name=\"txGroupMemberType\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">Distinguished Name:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.group.distinguish_name");
        string = string + "      <input type=\"text\" name=\"txGroupDN\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">Filter:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.group.search_filter");
        string = string + "      <input type=\"text\" name=\"txGroupFilter\" size=\"42\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"180\" align=\"right\">";
        string = string + "      <p align=\"right\"><u><small><font face=\"Arial\">Admin Group:</small></u> </td>";
        string = string + "    <td width=\"289\" align=\"left\">";
        string2 = LdapEnvironments.getProperty("ldaprealm.scheme.group.admin_group");
        string = string + "      <input type=\"text\" name=\"txAdminGroup\" size=\"26\" value=\"" + string2 + "\"> </td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"500\" align=\"right\" colspan=\"2\">";
        string = string + "      <p align=\"right\">";
        string = string + "      <input style = \"width = 100\" type=\"submit\" value=\"Group Query\" name=\"button" + IDS_CONFIG_LDAP_GROUPQUERY + "\"  onclick=setCookies(\"group\",false) >";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "    <td width=\"500\" align=\"right\" colspan=\"2\">";
        string = string + "      <p align=\"right\">";
        string = string + "      <input style = \"width = 50\" type=\"submit\" value=\"Save\" name=\"button" + IDS_CONFIG_LDAP + "\"></td>";
        string = string + "  </tr>";
        string = string + "</table>";
        string = string + " <script language=javascript>\t\n";
        string = string + " <!--\t\n";
        string = string + " putCookies();\t\n";
        string = string + " -->\t\n";
        string = string + " </script>\t\n";
        string = string + "</form>";
        this.writeResponse(string);
    }

    private void IDS_LIST_ACL() throws IOException {
        String string = "";
        string = string + "<form method=\"POST\">";
        string = string + "  <h3>Configuration</h3>";
        string = string + "  <input type=\"submit\" value=\"Service\" name=\"button" + IDS_REQUEST_CONFIG_SERVICE + "\">";
        string = string + "  <input type=\"submit\" value=\"Mail\" name=\"button" + IDS_REQUEST_CONFIG_MAIL + "\">";
        string = string + "</form>";
        this.writeResponse(string);
    }

    private void IDS_LIST_GROUP() throws IOException {
        String string = "";
        string = string + "<form method=\"POST\">";
        string = string + " <table border=\"0\" width=\"100%\">";
        string = string + "  <tr>";
        string = string + "   <td width=\"100%\"><strong><font face=\"Arial\">Advanced Configuration</font></strong></td>";
        string = string + "  </tr>";
        string = string + " </table>";
        string = string + " <hr>";
        string = string + " <table border=\"0\" width=\"100%\" height=\"179\">";
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        if (!httpRptServer.isClusterEnable() || httpRptServer.getClusterService().getLocalMember().isAdmin()) {
            string = string + "  <tr>";
            string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"1\"></td>";
            string = string + "   <td width=\"82%\" height=\"1\" valign=\"top\"><small><font face=\"Arial\">";
            string = string + "    <input type=\"checkbox\" name=\"security\" value=\"ON\" " + (ServerEnv.needSecurity() ? "" : "checked") + ">No Security Check</font></small></td>";
            string = string + "  </tr>";
            string = string + "  <tr>";
            string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"1\"></td>";
            string = string + "   <td width=\"82%\" height=\"1\" valign=\"top\"><small><font face=\"Arial\">";
            string = string + "    <input type=\"checkbox\" name=\"publishTempToVersion\" value=\"ON\" " + (ServerEnv.isPublishTempToVersion() ? "checked" : "") + ">Enable publish to version system</font></small></td>";
            string = string + "  </tr>";
            string = string + "  <tr>";
            string = string + "    <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"1\"></td>";
            string = string + "    <td width=\"82%\" height=\"1\" valign=\"top\"><small><font face=\"Arial\">";
            string = string + "      <input type=\"checkbox\" name=\"schdShouldRun\" value=\"ON\" " + (ServerEnv.shouldSchedule() ? "checked" : "") + ">schedule should run if time has passed during the system crashing</font></small></td>";
            string = string + "  </tr>";
        }
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">User Session Timeout:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"25\" valign=\"top\">";
        string = string + "    <input type=\"text\" name=\"sessionTimeout\" size=\"6\" value=\"" + ServerEnv.getSessionTimeout() + "\"><small><font face=\"Arial\">(s)</font></small></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">View Report Timeout:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"25\" valign=\"top\">";
        string = string + "    <input type=\"text\" name=\"viewReportTimeout\" size=\"6\" value=\"" + ServerEnv.getViewReportTimeout() + "\"><small><font face=\"Arial\">(s)</font></small></td>";
        string = string + "  </tr>";
        if (isMyServer) {
            string = string + "  <tr>";
            string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"21\"><u><small><font face=\"Arial\">Administration Port :</font></small></u></td>";
            string = string + "   <td width=\"82%\" height=\"21\" valign=\"top\">";
            string = string + "    <input type=\"text\" name=\"adminPort\" size=\"6\" value=\"" + ServerEnv.getAdminPort() + "\"></td>";
            string = string + "  </tr>";
        }
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Report Result Life:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"25\" valign=\"top\">";
        string = string + "    <input type=\"text\" name=\"resultLife\" size=\"6\" value=\"" + ServerEnv.getResultLife() + "\"><small><font face=\"Arial\">(s)</font></small></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Engine Priority:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"25\" valign=\"top\">";
        string = string + "    <select name=\"enginePriority\" size=\"1\">";
        int n = ServerEnv.getInternalEnginePriority();
        string = string + "      <option " + (n == 0 ? "selected" : "") + " value=\"0\">Lowest Priority</option>";
        string = string + "      <option " + (n == 1 ? "selected" : "") + " value=\"1\">Low Priority</option>";
        string = string + "      <option " + (n == 2 ? "selected" : "") + " value=\"2\">Normal Priority</option>";
        string = string + "      <option " + (n == 3 ? "selected" : "") + " value=\"3\">High Priority</option>";
        string = string + "      <option " + (n == 4 ? "selected" : "") + " value=\"4\">Highest Priority</option>";
        string = string + "    </select></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"24\"></td>";
        string = string + "   <td width=\"82%\" valign=\"bottom\" height=\"24\">";
        string = string + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_CONFIG_ADVANCE + "\"></td>";
        string = string + "  </tr>";
        string = string + " </table>";
        string = string + "</form>";
        this.writeResponse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void IDS_LIST_PROTECT() throws IOException {
        String string;
        InetAddress[] inetAddressArray;
        String string2 = "";
        string2 = string2 + "<form method=\"POST\">";
        string2 = string2 + " <table border=\"0\" width=\"100%\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"100%\"><strong><font face=\"Arial\">Service Configuration</font></strong></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        string2 = string2 + " <hr>";
        string2 = string2 + " <table border=\"0\" width=\"100%\" height=\"178\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"1\"><u><small><font face=\"Arial\">Port:</font></small></u></td>";
        string2 = string2 + "   <td width=\"82%\" height=\"1\"><small><font face=\"Arial\">";
        string2 = string2 + "    <input type=\"text\" name=\"port\" size=\"20\" value=\"" + this.getPort() + "\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Maximum number of handlers:</font></small></u></td>";
        string2 = string2 + "   <td width=\"82%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"text\" name=\"maxHandler\" size=\"20\" value=\"" + ServerEnv.getMaxHandlers() + "\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Maximum number of connections:</font></small></u></td>";
        string2 = string2 + "   <td width=\"82%\" height=\"25\"><small><font face=\"Arial\">";
        string2 = string2 + "   <input type=\"text\" name=\"maxConnection\" size=\"20\" value=\"" + ServerEnv.getMaxConnections() + "\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"21\"><u><small><font face=\"Arial\">Connection Timeout(s):</font></small></u></td>";
        string2 = string2 + "   <td width=\"82%\" height=\"21\"><small><font face=\"Arial\">";
        string2 = string2 + "    <input type=\"text\" name=\"timeout\" size=\"20\" value=\"" + ServerEnv.getTimeout() + "\"></font></small></td>";
        string2 = string2 + "  </tr>";
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        if (!httpRptServer.isClusterEnable() || httpRptServer.getClusterService().getLocalMember().isAdmin()) {
            string2 = string2 + "  <tr>";
            string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"29\"><u><small><font face=\"Arial\">Active Realm:</font></small></u></td>";
            string2 = string2 + "   <td width=\"82%\" height=\"29\" valign=\"top\" align=\"left\">";
            string2 = string2 + "    <select name=\"activeRealm\" size=\"1\">";
            String string3 = ServerEnv.getActiveRealm();
            inetAddressArray = Realm.class;
            // MONITORENTER : jet.server.userman.Realm.class
            Enumeration enumeration = UserDataToolkit.getRealmNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = string2 + "<option " + (string3.equals(string) ? "selected" : "") + " value=\"" + string + "\">" + string + "</option>";
            }
            // MONITOREXIT : inetAddressArray
            string2 = string2 + "    </select></td>";
            string2 = string2 + "  </tr>";
        }
        boolean bl = ServerEnv.useAllHosts();
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"44\"><u><small><font face=\"Arial\">Provide Service on:</font></small></u></td>";
        string2 = string2 + "   <td width=\"82%\" height=\"44\"><small><font face=\"Arial\">";
        string2 = string2 + "    <input type=\"radio\" value=\"all\" " + (bl ? "checked" : "") + " name=\"serviceAddress\">All Network Addresses<br>";
        string2 = string2 + "    <input type=\"radio\" value=\"value\" " + (bl ? "" : "checked") + " name=\"serviceAddress\">Network Address at: ";
        string2 = string2 + "    <input type=\"text\" name=\"addressValue\" size=\"23\" value=\"" + ServerEnv.getHostName() + "\"></font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"40\"><u><small><font face=\"Arial\">Active";
        string2 = string2 + "   host addresses</font></small></u>:</td>";
        string2 = string2 + "   <td width=\"82%\" valign=\"bottom\" height=\"40\">";
        string2 = string2 + "    <select name=\"hosts\" size=\"3\">";
        inetAddressArray = ServerEnv.getHostAddrs();
        int n = 0;
        while (true) {
            if (n >= inetAddressArray.length) {
                string2 = string2 + "    </select></td>";
                string2 = string2 + "  </tr>";
                string2 = string2 + "  <tr>";
                string2 = string2 + "   <td width=\"30%\" valign=\"top\" align=\"right\" height=\"32\"></td>";
                string2 = string2 + "   <td width=\"82%\" valign=\"bottom\" height=\"32\">";
                string2 = string2 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_CONFIG_SERVICE + "\"></td>";
                string2 = string2 + "  </tr>";
                string2 = string2 + "  <tr>";
                string2 = string2 + "    <td width=\"100%\" valign=\"top\" align=\"left\" height=\"125\" colspan=\"2\"><font face=\"Arial\"><small><strong>Note</strong>:";
                string2 = string2 + "    </small><br>";
                string2 = string2 + "    <small>1. The number \"Max number of connections\" should be bigger than the number \"Max number of handlers\". ";
                string2 = string2 + "    Otherwise, \"Max number of handlers\" will not have effect.</small><br>";
                string2 = string2 + "    <small>2. Changes to these will not take effect until next time server starts.</small></font></td>";
                string2 = string2 + "  </tr>";
                string2 = string2 + " </table>";
                string2 = string2 + "</form>";
                this.writeResponse(string2);
                return;
            }
            string = inetAddressArray[n].toString();
            string2 = string2 + "<option value=\"" + n + "\">" + string + "</option>";
            ++n;
        }
    }

    private void IDS_LIST_REALM() throws IOException {
        String string = "The config log has been deprecated from RCServlet since V8";
        this.writeResponse(string);
    }

    private void IDS_LIST_ROOT_RESOURCE() throws IOException {
        int n;
        Properties properties = null;
        try {
            properties = SchdTools.loadMailConfig();
        }
        catch (Exception exception) {
            properties = new Properties();
            ServiceLogger.logError(exception);
        }
        String string = "";
        string = string + "<form method=\"POST\">";
        string = string + " <table border=\"0\" width=\"100%\">";
        string = string + "  <tr>";
        string = string + "   <td width=\"100%\"><strong><font face=\"Arial\">Mail Configuration</font></strong></td>";
        string = string + "  </tr>";
        string = string + " </table>";
        string = string + " <hr>";
        string = string + " <table border=\"0\" width=\"100%\" height=\"179\">";
        String string2 = properties.getProperty("smtp.server");
        if (string2 == null) {
            string2 = mailconfig.SMTPServerIP == null ? "" : mailconfig.SMTPServerIP;
        }
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"1\"><u><small><font face=\"Arial\">SMTP";
        string = string + "   Server:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"1\" valign=\"top\">";
        string = string + "    <input type=\"text\" name=\"smtp\" size=\"20\" value=\"" + string2 + "\"></td>";
        string = string + "  </tr>";
        string2 = properties.getProperty("smtp.server.port");
        if (string2 == null) {
            string2 = String.valueOf(mailconfig.SMTPServerPort);
        }
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">SMTP";
        string = string + "   Server Port:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"25\" valign=\"top\">";
        string = string + "    <input type=\"text\" name=\"Port\" size=\"20\" value=\"" + string2 + "\"></td>";
        string = string + "  </tr>";
        string2 = properties.getProperty("mailbox");
        if (string2 == null) {
            string2 = mailconfig.MyMailAddress == null ? "" : mailconfig.MyMailAddress;
        }
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"25\"><u><small><font face=\"Arial\">Mail";
        string = string + "   Box:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"25\" valign=\"top\">";
        string = string + "    <input type=\"text\" name=\"mailbox\" size=\"20\" value=\"" + string2 + "\"></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"21\"><u><small><font face=\"Arial\">Default";
        string = string + "   Mail Format:</font></small></u></td>";
        string = string + "   <td width=\"82%\" height=\"21\" valign=\"top\">";
        string = string + "    <select name=\"format\" size=\"1\">";
        int n2 = CSUtil.parseInt(properties.getProperty("default.format"), mailconfig.DefaultFormat);
        for (n = 0; n < mailconfig.mailformat.length; ++n) {
            string = string + "<option " + (n2 == n ? "selected" : "") + " value=\"" + n + "\">" + mailconfig.mailformat[n] + "</option>";
        }
        string = string + "    </select></td>";
        string = string + "  </tr>";
        n = CSUtil.getBoolean(properties.getProperty("compress.mail"), mailconfig.CompressMail) ? 1 : 0;
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"1\"></td>";
        string = string + "   <td width=\"82%\" valign=\"top\" height=\"1\"><small><font face=\"Arial\">";
        string = string + "    <input type=\"checkbox\" name=\"compress\" value=\"ON\" " + (n != 0 ? "checked" : "") + ">Java Archive Compress</font></small></td>";
        string = string + "  </tr>";
        string = string + "  <tr>";
        string = string + "   <td width=\"30%\" valign=\"middle\" align=\"right\" height=\"24\"></td>";
        string = string + "   <td width=\"82%\" valign=\"bottom\" height=\"24\">";
        string = string + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_CONFIG_MAIL + "\"></td>";
        string = string + "  </tr>";
        string = string + " </table>";
        string = string + "</form>";
        this.writeResponse(string);
    }

    private void IDS_LIST_USER() throws IOException {
        String string = null;
        int n = 8889;
        if (isMyServer) {
            String string2 = this.getPropertyIgnoreCase("adminPort");
            try {
                n = Integer.parseInt(string2);
                if (n <= 0 || n > 65535) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                string = JSvrResource.getMessage("SVR_1", string2);
            }
            if (n == ServerEnv.getPort()) {
                string = JSvrResource.getMessage("SVR_66");
            }
        } else {
            n = ServerEnv.getAdminPort();
        }
        int n2 = 180;
        String string3 = this.getPropertyIgnoreCase("sessionTimeout");
        try {
            n2 = Integer.parseInt(string3);
            if (n2 <= 0) {
                string = JSvrResource.getMessage("SVR_68");
            }
        }
        catch (Exception exception) {
            string = JSvrResource.getMessage("SVR_9", string3);
        }
        int n3 = 86400;
        String string4 = this.getPropertyIgnoreCase("resultLife");
        try {
            n3 = Integer.parseInt(string4);
            int n4 = n3 = (long)n3 < ServerEnv.MIN_RESULT_LIFE ? (int)ServerEnv.MIN_RESULT_LIFE : n3;
            if (n2 <= 0) {
                string = JSvrResource.getMessage("SVR_70");
            }
        }
        catch (Exception exception) {
            string = JSvrResource.getMessage("SVR_9", string4);
        }
        String string5 = this.getPropertyIgnoreCase("enginePriority");
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        boolean bl = this.getPropertyIgnoreCase("security") != null;
        boolean bl2 = this.getPropertyIgnoreCase("schdShouldRun") != null;
        boolean bl3 = this.getPropertyIgnoreCase("publishTempToVersion") != null;
        int n6 = 170;
        String string6 = this.getPropertyIgnoreCase("viewReportTimeout");
        try {
            n6 = Integer.parseInt(string6);
            if (n6 <= 0) {
                string = JSvrResource.getMessage("SVR_72");
            }
        }
        catch (Exception exception) {
            string = JSvrResource.getMessage("SVR_9", string6);
        }
        if (string == null && (n != ServerEnv.getAdminPort() || n2 != ServerEnv.getSessionTimeout() || (long)n3 != ServerEnv.getResultLife() || bl == ServerEnv.needSecurity() || n5 != ServerEnv.getInternalEnginePriority() || bl3 != ServerEnv.isPublishTempToVersion() || n6 != ServerEnv.getViewReportTimeout() || bl2 != ServerEnv.shouldSchedule())) {
            ExProperties exProperties = new ExProperties();
            try {
                exProperties.load(ServerEnv.getServPropName());
                exProperties.setProperty("httpserver.admin.port", n);
                exProperties.setProperty("server.session.timeout", n2);
                exProperties.setProperty("resource.result.life", n3);
                exProperties.setProperty("server.security", !bl);
                exProperties.setProperty("engine.priority", n5);
                exProperties.setProperty("server.schedule_should_run", bl2);
                exProperties.setProperty("server.version.from.temp", bl3);
                exProperties.setProperty("web.timeouts.report_wait", n6);
                exProperties.save(ServerEnv.getServPropName(), null);
                this.logManageSuccessEvent("admin port:" + n + " no security check:" + bl);
                if (isMyServer) {
                    String string7 = "The change will take effect the next time " + JSvrResource.getMessage("SERVERNAME") + " starts up.  Do you want to shutdown the server?";
                    String[] stringArray = new String[]{" Yes ", "Shutdown", " No ", HomeProcessor.IDS_REQUEST_HOME};
                    this.printMessage(string7, stringArray);
                } else {
                    String string8 = "The change will take effect the next time " + JSvrResource.getMessage("SERVERNAME") + " starts up.";
                    this.printMessage(string8, IDS_REQUEST_CONFIG_ADVANCE);
                }
                return;
            }
            catch (IOException iOException) {
                string = JSvrResource.getMessage("SVR_6", iOException.getMessage());
                ServiceLogger.logError(iOException);
            }
        }
        this.printMessage(string == null ? "Nothing changed." : string, IDS_REQUEST_CONFIG_ADVANCE);
    }

    private void IDS_REQUEST_CONFIG_ADVANCE() throws IOException {
        Object object;
        Object object2;
        String string = null;
        int n = 8888;
        String string2 = this.getPropertyIgnoreCase("port");
        try {
            n = Integer.parseInt(string2);
            if (n <= 0 || n > 65535) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            string = JSvrResource.getMessage("SVR_1", string2);
        }
        if (n == ServerEnv.getAdminPort()) {
            string = JSvrResource.getMessage("SVR_66");
        }
        if (string == null) {
            this.setPort(n);
        }
        int n2 = 10000;
        if (string == null) {
            string2 = this.getPropertyIgnoreCase("timeout");
            try {
                n2 = Integer.parseInt(string2);
                if (n2 < 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                string = JSvrResource.getMessage("SVR_2", string2);
            }
        }
        int n3 = 50;
        if (string == null) {
            string2 = this.getPropertyIgnoreCase("maxHandler");
            try {
                n3 = Integer.parseInt(string2);
                if (n3 < 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                string = JSvrResource.getMessage("SVR_3", string2);
            }
        }
        int n4 = 1000;
        if (string == null) {
            string2 = this.getPropertyIgnoreCase("maxConnection");
            try {
                n4 = Integer.parseInt(string2);
                if (n4 < 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                string = JSvrResource.getMessage("SVR_71", string2);
            }
        }
        boolean bl = this.getPropertyIgnoreCase("serviceAddress").equals("all");
        String string3 = this.getPropertyIgnoreCase("addressValue");
        if (string == null && !bl) {
            if (string3 == null || string3.length() == 0) {
                string = JSvrResource.getMessage("SVR_5");
            } else if (!(string3 = string3.trim()).equals("*")) {
                object2 = new StringTokenizer(string3, " \t;");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (this.IDS_REQUEST_CONFIG_LDAP((String)object)) continue;
                    string = "Not a valid local address: " + (String)object;
                }
            }
        }
        if (string == null) {
            object2 = this.getPropertyIgnoreCase("activeRealm");
            if (n != ServerEnv.getPort() || n3 != ServerEnv.getMaxHandlers() || n4 != ServerEnv.getMaxConnections() || n2 != ServerEnv.getTimeout() || !((String)object2).equals(ServerEnv.getActiveRealm()) || bl != ServerEnv.useAllHosts() || !string3.equals(ServerEnv.getHostName())) {
                object = new ExProperties();
                try {
                    ((ExProperties)object).load(ServerEnv.getServPropName());
                    ((ExProperties)object).setProperty("httpserver.port", n);
                    ((ExProperties)object).setProperty("httpserver.max.handlers", n3);
                    ((ExProperties)object).setProperty("httpserver.max.connections", n4);
                    ((ExProperties)object).setProperty("httpserver.timeout", n2);
                    ((ExProperties)object).setProperty("server.realm.active", (String)object2);
                    ((ExProperties)object).setProperty("httpserver.host.all", bl);
                    if (!bl) {
                        ((ExProperties)object).setProperty("httpserver.host.name", string3);
                    }
                    ((ExProperties)object).save(ServerEnv.getServPropName(), null);
                    this.logManageSuccessEvent("Service config changed");
                    if (isMyServer) {
                        String string4 = "The change will take effect the next time " + JSvrResource.getMessage("SERVERNAME") + " starts up.  Do you want to restart the server?";
                        String[] stringArray = new String[]{" Yes ", "Restart", " No ", HomeProcessor.IDS_REQUEST_HOME};
                        this.printMessage(string4, stringArray);
                    } else {
                        String string5 = "The change will take effect the next time " + JSvrResource.getMessage("SERVERNAME") + " starts up.";
                        this.printMessage(string5, IDS_REQUEST_CONFIG_SERVICE);
                    }
                    return;
                }
                catch (IOException iOException) {
                    string = JSvrResource.getMessage("SVR_6", iOException.getMessage());
                    ServiceLogger.logError(iOException);
                }
            }
        }
        this.printMessage(string == null ? "Nothing changed." : string, IDS_REQUEST_CONFIG_SERVICE);
    }

    private boolean IDS_REQUEST_CONFIG_LDAP(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            for (int i = 0; i < IDS_REQUEST_HOME.length; ++i) {
                if (!inetAddress.equals(IDS_REQUEST_HOME[i])) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(unknownHostException, 3);
        }
        return false;
    }

    private void IDS_REQUEST_CONFIG_LDAP_CHECKSYNCHRONIZATION_CONFIRM() throws IOException {
        this.logManageFailEvent("The config log has been deprecated from RCServlet since V8.");
    }

    private void IDS_REQUEST_CONFIG_LDAP_IMPORT() throws IOException {
        String string = null;
        String string2 = IDS_REQUEST_CONFIG_MAIL;
        Properties properties = new Properties();
        properties.put("smtp.server", this.getPropertyIgnoreCase("smtp"));
        properties.put("mailbox", this.getPropertyIgnoreCase("mailbox"));
        String string3 = this.getPropertyIgnoreCase("port");
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            string = "Port value must be a positive integer value";
        }
        if (n < 0) {
            string = "Port value must be a positive integer value";
        }
        properties.put("smtp.server.port", "" + n);
        properties.put("default.format", this.getPropertyIgnoreCase("format"));
        properties.put("compress.mail", new Boolean(this.getPropertyIgnoreCase("compress") != null).toString());
        if (string == null) {
            try {
                properties = SchdTools.saveMailConfig(properties);
                SchdTools.setMailConfig(properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ServiceLogger.logError(exception);
                string = exception.toString();
                JDebug.WARNING((Throwable)exception);
            }
        }
        this.printMessage(string == null ? "Configuration has been changed!" : string, IDS_REQUEST_CONFIG_MAIL);
    }

    static {
        try {
            IDS_REQUEST_HOME = ServerUtil.getAllLocalAddresses().toArray(new InetAddress[0]);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown host address " + unknownHostException.getMessage());
        }
    }
}

