/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.rc.ActionProcessor;
import jet.server.rc.HomeProcessor;
import jet.server.rc.RealmProcessor;
import jet.server.userman.GroupImpl;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.User;
import jet.server.userman.UserDataToolkit;
import jet.server.userman.UserImpl;
import jet.util.MiscTools;

public class GroupProcessor
extends ActionProcessor {
    public static String IDS_LIST_GROUP = "ListGroup";
    public static String IDS_NEW_GROUP = "NewGroup";
    public static String IDS_EDIT_GROUP = "EditGroup";
    public static String IDS_REQUEST_NEW_GROUP = "RequestNewGroup";
    public static String IDS_REQUEST_EDIT_GROUP = "RequestEditGroup";
    public static String IDS_REMOVE_GROUP = "RemoveGroup";
    public static String IDS_REQUEST_REMOVE_GROUP = "RequestRemoveGroup";
    public static String IDS_LIST_MEMBER = "ListMember";
    public static String IDS_ADD_MEMBER = "AddMember";
    public static String IDS_DELETE_MEMBER = "DeleteMember";

    public GroupProcessor() {
        this.actions.addElement(IDS_LIST_GROUP);
        this.actions.addElement(IDS_NEW_GROUP);
        this.actions.addElement(IDS_EDIT_GROUP);
        this.actions.addElement(IDS_REQUEST_NEW_GROUP);
        this.actions.addElement(IDS_REQUEST_EDIT_GROUP);
        this.actions.addElement(IDS_REMOVE_GROUP);
        this.actions.addElement(IDS_REQUEST_REMOVE_GROUP);
        this.actions.addElement(IDS_LIST_MEMBER);
        this.actions.addElement(IDS_ADD_MEMBER);
        this.actions.addElement(IDS_DELETE_MEMBER);
    }

    @Override
    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_LIST_GROUP)) {
            this.IDS_ADD_MEMBER();
        } else if (string.equalsIgnoreCase(IDS_NEW_GROUP)) {
            this.IDS_EDIT_GROUP();
        } else if (string.equalsIgnoreCase(IDS_EDIT_GROUP)) {
            this.IDS_DELETE_MEMBER();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_NEW_GROUP)) {
            this.IDS_LIST_MEMBER();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_GROUP)) {
            this.IDS_LIST_GROUP();
        } else if (string.equalsIgnoreCase(IDS_REMOVE_GROUP)) {
            this.IDS_NEW_GROUP();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_REMOVE_GROUP)) {
            this.IDS_LIST_REALM();
        } else if (string.equalsIgnoreCase(IDS_LIST_MEMBER)) {
            this.IDS_REQUEST_HOME();
        } else if (string.equalsIgnoreCase(IDS_ADD_MEMBER)) {
            this.IDS_REQUEST_EDIT_GROUP();
        } else if (string.equalsIgnoreCase(IDS_DELETE_MEMBER)) {
            this.IDS_REMOVE_GROUP();
        }
    }

    private void IDS_ADD_MEMBER() throws IOException {
        String string = null;
        String string2 = this.getCurEditRealm();
        try {
            Realm realm = Realm.get(string2);
            String string3 = "";
            string3 = string3 + "<html>";
            string3 = string3 + "<head>";
            string3 = string3 + "<title>Group List</title>";
            string3 = string3 + "</head>";
            string3 = string3 + "<body>";
            string3 = string3 + "<table width=100% border=0>";
            string3 = string3 + "  <tbody>";
            string3 = string3 + "    <tr>";
            string3 = string3 + "      <td width=32%><strong><font face=Arial>Group List</font></strong></td>";
            string3 = string3 + "      <td width=68%>";
            string3 = string3 + "        <p align=right><font face=Arial><small>Selected Realm: [" + string2 + "]</small></font></p>";
            string3 = string3 + "      </td>";
            string3 = string3 + "    </tr>";
            string3 = string3 + "  </tbody>";
            string3 = string3 + "</table>";
            string3 = string3 + "<hr>";
            string3 = string3 + "<p align=left><font face=Arial size=2>&nbsp;<a href=" + IDS_REQUEST_NEW_GROUP + "?realm=" + string2 + "><img border=0 src=" + this.getImage("create") + " width=18 height=13>Create a new group</a></font></p>";
            string3 = string3 + " <input type=\"hidden\" name=\"realm\" value=\"" + string2 + "\">";
            string3 = string3 + "<table border=1 width=100% align=\"center\" bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0 height=58>";
            string3 = string3 + "  <tr>";
            string3 = string3 + "    <td bgcolor=#5095ba height=19><font face=Arial color=#FFFFFF><b style=\"font-size=12px\">&nbsp;Name</b></font></td>";
            string3 = string3 + "    <td width = \"40%\"bgcolor=#5095ba height=19><font face=Arial color=#FFFFFF><b style=\"font-size=12px\">&nbsp;Members</b></font></td>";
            string3 = string3 + "    <td width = \"50\" bgcolor=#5095ba height=19>&nbsp;</td>";
            string3 = string3 + "  </tr>";
            Enumeration enumeration = realm.getGroups();
            while (enumeration.hasMoreElements()) {
                GroupImpl groupImpl = (GroupImpl)enumeration.nextElement();
                String string4 = groupImpl.getName();
                int n = groupImpl.getMemberCount();
                string3 = string3 + "  <tr>";
                string3 = string3 + "    <td height=19><font face=Arial size=2>&nbsp;" + string4 + "</a></font></td>";
                string3 = string3 + "    <td height=19><font face=Arial size=2>&nbsp;" + n + "<a href=" + IDS_LIST_MEMBER + "?realm=" + string2 + "&group=" + HttpUtil.encodeEsc(string4) + ">" + " member(s)</a></font></td>";
                string3 = string3 + "    <td height=19>";
                if (!string4.equalsIgnoreCase("administrators") & !string4.equalsIgnoreCase("everyone")) {
                    string3 = string3 + "      <p align=center><a href=" + IDS_REQUEST_REMOVE_GROUP + "?realm=" + string2 + "&group=" + HttpUtil.encodeEsc(string4) + "><font face=Arial size=2>Delete</font></a></td>";
                }
                string3 = string3 + "  </tr>";
            }
            string3 = string3 + "</table>";
            string3 = string3 + "</body>";
            string3 = string3 + "</html>";
            this.writeResponse(string3);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string2 + " does not exist!";
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string2 + " is invalid!";
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        if (string != null) {
            this.printMessage(string, HomeProcessor.IDS_REQUEST_HOME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_DELETE_MEMBER() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("group");
        String string3 = this.getPropertyIgnoreCase("description");
        String string4 = null;
        String string5 = IDS_LIST_GROUP;
        if (string2.trim().equals("")) {
            string4 = "Group name cannot be blank!";
        } else {
            try {
                Realm realm;
                Realm realm2 = realm = Realm.get(string);
                synchronized (realm2) {
                    if (((SharedPasswordRealm)realm).isUserExist(string2)) {
                        string4 = "Group name is same to a user name";
                    } else {
                        GroupImpl groupImpl = (GroupImpl)realm.getGroup(string2);
                        groupImpl.setDescription(string3);
                        UserDataToolkit.saveGroupProperties(groupImpl);
                        this.logManageSuccessEvent("create group " + string + ":" + string2);
                    }
                }
                this.IDS_ADD_MEMBER();
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string4 = "Realm " + string + " does not exist!";
                string5 = RealmProcessor.IDS_LIST_REALM;
                ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
            }
            catch (BadRealmException badRealmException) {
                string4 = "Realm " + string + " is invalid!";
                string5 = RealmProcessor.IDS_LIST_REALM;
                ServiceLogger.logError((Throwable)((Object)badRealmException));
            }
            catch (NoSuchGroupException noSuchGroupException) {
                string4 = "Group " + string2 + " does not exist!";
                ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            }
            catch (IOException iOException) {
                string4 = "Save group properties failed!";
                ServiceLogger.logError(iOException);
            }
        }
        if (string4 != null) {
            this.printMessage(new String[]{"realm", string}, string4, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_EDIT_GROUP() throws IOException {
        String string;
        String string2;
        String string3;
        block17: {
            string3 = this.getPropertyIgnoreCase("realm");
            String string4 = this.getPropertyIgnoreCase("group");
            String string5 = this.getPropertyIgnoreCase("description");
            string2 = null;
            string = IDS_LIST_GROUP;
            String string6 = "!#$%^&*()<>[]=\\/|\"?. {}:;\t\n";
            if (string4.trim().equals("")) {
                string2 = "Group name cannot be blank!";
            } else if (MiscTools.containChar((String)string4, (String)string6)) {
                string2 = JSvrResource.getMessage("SVR_39", "\"!#$%^&*()<>[]=\\/|\"?. {}:;\"");
            } else {
                try {
                    Realm realm = Realm.get(string3);
                    if (realm.isGroupExist(string4)) {
                        string2 = "Group: " + string4 + " already exists.";
                        break block17;
                    }
                    Realm realm2 = realm;
                    synchronized (realm2) {
                        if (((SharedPasswordRealm)realm).isUserExist(string4)) {
                            string2 = "Group name is same to a user name";
                        } else {
                            realm.makeGroup(string4);
                            GroupImpl groupImpl = (GroupImpl)realm.getGroup(string4);
                            groupImpl.setDescription(string5);
                            UserDataToolkit.saveGroupProperties(groupImpl);
                            this.logManageSuccessEvent("create group " + string3 + ":" + string4);
                            this.IDS_ADD_MEMBER();
                        }
                    }
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    string2 = "Realm " + string3 + " does not exist!";
                    string = RealmProcessor.IDS_LIST_REALM;
                    ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
                }
                catch (BadRealmException badRealmException) {
                    string2 = "Realm " + string3 + " is invalid!";
                    string = RealmProcessor.IDS_LIST_REALM;
                    ServiceLogger.logError((Throwable)((Object)badRealmException));
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    string2 = "Group " + string4 + " does not exist!";
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                }
                catch (InUseException inUseException) {
                    string2 = "Group " + string4 + " is in use!";
                }
                catch (IOException iOException) {
                    string2 = "Save group properties failed!";
                    ServiceLogger.logError(iOException);
                }
            }
        }
        if (string2 != null) {
            this.printMessage(new String[]{"realm", string3}, string2, string);
        }
    }

    private void IDS_LIST_GROUP() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = this.request.getParameter("group");
        String string3 = "";
        try {
            Realm realm = Realm.get(string);
            GroupImpl groupImpl = (GroupImpl)realm.getGroup(string2);
            String string4 = groupImpl.getDescription();
            string3 = string3 + " <input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
            string3 = string3 + " <table border=\"0\" width=\"100%\">";
            string3 = string3 + "  <tr>";
            string3 = string3 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; New Group</font></strong></td>";
            string3 = string3 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "]</font></small></td>";
            string3 = string3 + "  </tr>";
            string3 = string3 + " </table>";
            string3 = string3 + " <hr>";
            string3 = string3 + " <table border=\"0\" width=\"100%\" height=\"94\">";
            string3 = string3 + "  <tr>";
            string3 = string3 + "   <td width=\"17%\" valign=\"top\" align=\"right\" height=\"14\"><u><small><font face=\"Arial\">Group Name:</font></small></u></td>";
            string3 = string3 + "   <td width=\"83%\" height=\"14\" valign=\"top\">";
            string3 = string3 + "     <input type=\"text\" name=\"group\" size=\"20\" value=" + string2 + "></td>";
            string3 = string3 + "  </tr>";
            string3 = string3 + "  <tr>";
            string3 = string3 + "   <td width=\"17%\" valign=\"top\" align=\"right\" height=\"30\"><u><small><font face=\"Arial\">Description</font></small></u>:</td>";
            string3 = string3 + "   <td width=\"83%\" valign=\"top\" height=\"30\">";
            string3 = string3 + "    <input type=\"text\" name=\"description\" size=\"20\" value=" + string4 + "></td>";
            string3 = string3 + "  </tr>";
            string3 = string3 + "  <tr>";
            string3 = string3 + "   <td width=\"17%\" valign=\"top\" align=\"right\" height=\"50\"></td>";
            string3 = string3 + "   <td width=\"83%\" valign=\"bottom\" height=\"50\">";
            string3 = string3 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_EDIT_GROUP + "\">";
            string3 = string3 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_GROUP + "\"></td>";
            string3 = string3 + "  </tr>";
            string3 = string3 + " </table>";
            this.writeResponse(string3);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
        }
    }

    private void IDS_LIST_MEMBER() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = "";
        string2 = string2 + " <input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
        string2 = string2 + " <table border=\"0\" width=\"100%\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; New Group</font></strong></td>";
        string2 = string2 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "]</font></small></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        string2 = string2 + " <hr>";
        string2 = string2 + " <table border=\"0\" width=\"100%\" height=\"94\">";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"17%\" valign=\"top\" align=\"right\" height=\"14\"><u><small><font face=\"Arial\">Group Name:</font></small></u></td>";
        string2 = string2 + "   <td width=\"83%\" height=\"14\" valign=\"top\">";
        string2 = string2 + "     <input type=\"text\" name=\"group\" size=\"20\" maxlength=\"32\"></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"17%\" valign=\"top\" align=\"right\" height=\"30\"><u><small><font face=\"Arial\">Description</font></small></u>:</td>";
        string2 = string2 + "   <td width=\"83%\" valign=\"top\" height=\"30\">";
        string2 = string2 + "    <input type=\"text\" name=\"description\" size=\"20\" maxlength=\"64\"></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + "  <tr>";
        string2 = string2 + "   <td width=\"17%\" valign=\"top\" align=\"right\" height=\"50\"></td>";
        string2 = string2 + "   <td width=\"83%\" valign=\"bottom\" height=\"50\">";
        string2 = string2 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_NEW_GROUP + "\">";
        string2 = string2 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_GROUP + "\"></td>";
        string2 = string2 + "  </tr>";
        string2 = string2 + " </table>";
        this.writeResponse(string2);
    }

    private void IDS_LIST_REALM() throws IOException {
        String string = this.request.getParameter("realm");
        String string2 = this.request.getParameter("group");
        if (string2.equals("administrators") || string2.equals("everyone")) {
            String string3 = "Group " + string2 + " cannot be deleted!";
            this.printMessage(new String[]{"realm", string}, string3, IDS_LIST_GROUP);
        } else {
            String string4 = "Do you confirm to delete group " + string2 + "?";
            String[] stringArray = new String[]{"realm", string, "group", string2};
            String[] stringArray2 = new String[]{" Yes ", IDS_REMOVE_GROUP, " No ", IDS_LIST_GROUP};
            this.printMessage(stringArray, string4, stringArray2);
        }
    }

    private void IDS_NEW_GROUP() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("group");
        String string3 = null;
        String string4 = IDS_LIST_GROUP;
        try {
            Realm realm = Realm.get(string);
            if (!realm.deleteGroup(string2)) {
                string3 = JSvrResource.getMessage("SVR_34", string2);
                this.logManageFailEvent("delete group " + string + ":" + string2);
            } else {
                UserDataToolkit.deleteGroupData(string, string2);
                this.logManageSuccessEvent("delete group " + string + ":" + string2);
                this.IDS_ADD_MEMBER();
            }
        }
        catch (InUseException inUseException) {
            String string5 = inUseException.toString();
            string3 = JSvrResource.getMessage("SVR_35", string5.substring(string5.indexOf(": ") + 2));
            this.logManageFailEvent("delete group " + string + ":" + string2);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string + " does not exist!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string + " is invalid!";
            string4 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (NoSuchGroupException noSuchGroupException) {
            string3 = "Group " + string2 + " does not exist!";
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
        }
        if (string3 != null) {
            this.printMessage(new String[]{"realm", string}, string3, string4);
        }
    }

    private void IDS_REMOVE_GROUP() throws IOException {
        Enumeration enumeration = this.request.getParameterNames();
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("group");
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string4 = HttpUtil.decodeEsc((String)enumeration.nextElement());
            if (!string4.startsWith("delete_")) continue;
            String string5 = string4.substring("delete_".length());
            String string6 = string5.substring(string5.indexOf("_") + 1);
            if (string6.equals("admin") && string2.equals("administrators")) {
                string3 = "User " + string6 + " can't be deleted from group " + string2 + ".";
            } else {
                try {
                    stringArray = (String[])Realm.get(string);
                    Group group = stringArray.getGroup(string2);
                    boolean bl = false;
                    bl = string5.substring(0, string5.indexOf("_")).startsWith("Group");
                    Object object = null;
                    object = bl ? stringArray.getGroup(string6) : stringArray.getUser(string6);
                    if (!group.isMember((Principal)object)) continue;
                    group.removeMember((Principal)object);
                    UserDataToolkit.saveGroupProperties((GroupImpl)group);
                    if (object instanceof GroupImpl) {
                        UserDataToolkit.saveGroupProperties((GroupImpl)object);
                    } else {
                        UserDataToolkit.saveUserProperties((UserImpl)object);
                    }
                    this.logManageSuccessEvent("delete member " + string5 + " from group " + string + ":" + string2);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    string3 = "Group " + string6 + " does not exist!";
                    ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
                }
                catch (NoSuchUserException noSuchUserException) {
                    string3 = "User " + string6 + " does not exist!";
                    ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    string3 = "Realm " + string + " does not exist!";
                    ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
                }
                catch (BadRealmException badRealmException) {
                    string3 = "Realm " + string + " is invalid!";
                    ServiceLogger.logError((Throwable)((Object)badRealmException));
                }
                catch (IOException iOException) {
                    string3 = "Save group properties failed!";
                    ServiceLogger.logError(iOException);
                }
            }
            if (string3 == null) continue;
            stringArray = new String[]{"realm", string, "group", string2};
            this.printMessage(stringArray, string3, this.action);
        }
        this.IDS_REQUEST_HOME();
    }

    private void IDS_REQUEST_EDIT_GROUP() throws IOException {
        Enumeration enumeration = this.request.getParameterNames();
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("group");
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string3 = null;
            String string4 = HttpUtil.decodeEsc((String)enumeration.nextElement());
            if (!string4.startsWith("add_")) continue;
            String string5 = string4.substring("add_".length());
            String string6 = string5.substring(string5.indexOf("_") + 1);
            try {
                stringArray = Realm.get(string);
                Group group = stringArray.getGroup(string2);
                boolean bl = string5.substring(0, string5.indexOf("_")).startsWith("Group");
                Object object = null;
                object = bl ? stringArray.getGroup(string6) : stringArray.getUser(string6);
                if (group.isMember((Principal)object)) continue;
                if (group.addMember((Principal)object)) {
                    UserDataToolkit.saveGroupProperties((GroupImpl)group);
                    if (object instanceof GroupImpl) {
                        UserDataToolkit.saveGroupProperties((GroupImpl)object);
                    } else {
                        UserDataToolkit.saveUserProperties((UserImpl)object);
                    }
                    this.logManageSuccessEvent("add member " + string5 + " to group " + string + ":" + string2);
                } else {
                    string3 = JSvrResource.getMessage("SVR_36", new String[]{string5, string2});
                }
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string3 = "Realm " + string + " does not exist!";
                ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
            }
            catch (BadRealmException badRealmException) {
                string3 = "Realm " + string + " is invalid!";
                ServiceLogger.logError((Throwable)((Object)badRealmException));
            }
            catch (NoSuchGroupException noSuchGroupException) {
                string3 = "Group " + string2 + " does not exist!";
            }
            catch (NoSuchUserException noSuchUserException) {
                string3 = "User " + string5 + " does not exist!";
                ServiceLogger.logError((Throwable)((Object)noSuchUserException));
            }
            catch (IOException iOException) {
                string3 = "Save group properties failed!";
                ServiceLogger.logError(iOException);
            }
            if (string3 == null) continue;
            stringArray = new String[]{"realm", string, "group", string2};
            this.printMessage(stringArray, string3, this.action);
        }
        this.IDS_REQUEST_HOME();
    }

    private void IDS_REQUEST_HOME() throws IOException {
        String[] stringArray;
        String string = this.request.getParameter("realm");
        String string2 = this.request.getParameter("group");
        String string3 = null;
        try {
            String string4;
            Object object;
            Object object2;
            stringArray = (String[])Realm.get(string);
            Group group = stringArray.getGroup(string2);
            String string5 = "";
            string5 = string5 + "<script>";
            string5 = string5 + "NS4 = (document.layers) ? 1 : 0;";
            string5 = string5 + "function init(){";
            string5 = string5 + "    if (!NS4){";
            string5 = string5 + "        show();";
            string5 = string5 + "    }";
            string5 = string5 + "}";
            string5 = string5 + "function show() {";
            string5 = string5 + "    if (allList.style.visibility == \"hidden\")";
            string5 = string5 + "        allList.style.visibility = \"visible\";";
            string5 = string5 + "    else ";
            string5 = string5 + "        allList.style.visibility = \"hidden\";";
            string5 = string5 + "}";
            string5 = string5 + "</script>";
            string5 = string5 + "<html>";
            string5 = string5 + "<head>";
            string5 = string5 + "<title>Edit Group Members</title>";
            string5 = string5 + "</head>";
            string5 = string5 + "<body onLoad=\"init()\">";
            string5 = string5 + "<table width=100% border=0>";
            string5 = string5 + "  <tbody>";
            string5 = string5 + "    <tr>";
            string5 = string5 + "      <td width=32%><strong><font face=Arial>Edit Group Members</font></strong></td>";
            string5 = string5 + "      <td width=68%>";
            string5 = string5 + "        <p align=right><font face=Arial><small>Selected Realm:[" + string + "] &nbsp;Group:[" + string2 + "]</small></font></p>";
            string5 = string5 + "      </td>";
            string5 = string5 + "    </tr>";
            string5 = string5 + "  </tbody>";
            string5 = string5 + "</table>";
            string5 = string5 + "<hr>";
            string5 = string5 + "<p align=left><font face=Arial>Member list:</font></p>";
            string5 = string5 + "<form >";
            string5 = string5 + " <input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
            string5 = string5 + " <input type=\"hidden\" name=\"group\" value=\"" + string2 + "\">";
            string5 = string5 + "<table border=1 width=100% bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "    <td width=6% bgcolor=#5095ba><font color=#FFFFFF face=Arial><b>&nbsp;</b></font></td>";
            string5 = string5 + "    <td width=60% bgcolor=#5095ba><font color=#FFFFFF face=Arial size=2><b>&nbsp;Name</b></font></td>";
            string5 = string5 + "    <td width=34% bgcolor=#5095ba><font color=#FFFFFF face=Arial size=2><b>&nbsp;Type</b></font></td>";
            string5 = string5 + "  </tr>";
            Enumeration enumeration = group.members();
            while (enumeration.hasMoreElements()) {
                object2 = (Principal)enumeration.nextElement();
                object = object2.getName();
                string4 = "Unknow";
                if (object2 instanceof User) {
                    string4 = "User";
                } else if (object2 instanceof Group) {
                    string4 = "Group";
                }
                if (!string2.equalsIgnoreCase("everyone")) {
                    string5 = string5 + "  <tr>";
                    string5 = string5 + "    <td width=6% align=center>";
                    string5 = string5 + "      <font face=Arial size=2><input type=checkbox name=delete_" + string4 + "_" + HttpUtil.encodeEsc((String)object) + " value=ON></font></td>";
                    string5 = string5 + "    <td width=60%><font face=Arial size=2>&nbsp;" + (String)object + "</font></td>";
                    string5 = string5 + "    <td width=34%><font face=Arial size=2>&nbsp;" + string4 + "</font></td>";
                    string5 = string5 + "  </tr>";
                    continue;
                }
                if (string4.equalsIgnoreCase("Group")) continue;
                string5 = string5 + "  <tr>";
                string5 = string5 + "    <td width=6% align=center>";
                string5 = string5 + "      <font face=Arial size=2></font></td>";
                string5 = string5 + "    <td width=60%><font face=Arial size=2>&nbsp;" + (String)object + "</font></td>";
                string5 = string5 + "    <td width=34%><font face=Arial size=2>&nbsp;" + string4 + "</font></td>";
                string5 = string5 + "  </tr>";
            }
            string5 = string5 + "  <tr>";
            string5 = string5 + "    <td width=100% colspan=3>";
            string5 = !string2.equalsIgnoreCase("everyone") ? string5 + "      <p align=right><input type=submit value=Delete name=button" + IDS_DELETE_MEMBER + "></td>" : string5 + "      <p align=right><input type=submit value=OK name=button" + IDS_LIST_GROUP + "></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "</table>";
            string5 = string5 + "</form>";
            if (!string2.equalsIgnoreCase("everyone")) {
                string5 = string5 + "<p align=left><a onclick=\"show()\"><font face=Arial size=2>&nbsp;<img border=0 src=" + this.getImage("create") + " width=18 height=13>Add member</font></a></p>";
            }
            string5 = string5 + "<div ID=allList>";
            string5 = string5 + "<form >";
            string5 = string5 + " <input type=\"hidden\" name=\"realm\" value=\"" + string + "\">";
            string5 = string5 + " <input type=\"hidden\" name=\"group\" value=\"" + string2 + "\">";
            string5 = string5 + "<table border=1 width=100% bordercolor=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolordark=#C0C0C0>";
            string5 = string5 + "  <tr>";
            string5 = string5 + "    <td width=6% bgcolor=#5095ba><font color=#FFFFFF face=Arial><b>&nbsp;</b></font></td>";
            string5 = string5 + "    <td width=60% bgcolor=#5095ba><font color=#FFFFFF face=Arial size=2><b>&nbsp;Name</b></font></td>";
            string5 = string5 + "    <td width=34% bgcolor=#5095ba><font color=#FFFFFF face=Arial size=2><b>&nbsp;Type</b></font></td>";
            string5 = string5 + "  </tr>";
            object2 = stringArray.getUsers();
            while (object2.hasMoreElements()) {
                object = (User)object2.nextElement();
                if (group.isMember((Principal)object)) continue;
                string5 = string5 + "  <tr>";
                string5 = string5 + "    <td width=6% align=center>";
                string5 = string5 + "      <font face=Arial size=2><input type=checkbox name=add_User_" + HttpUtil.encodeEsc(object.getName()) + " value=ON></font></td>";
                string5 = string5 + "    <td width=60%><font face=Arial size=2>&nbsp;" + object.getName() + "</font></td>";
                string5 = string5 + "    <td width=34%><font face=Arial size=2>&nbsp;User</font></td>";
                string5 = string5 + "  </tr>";
            }
            object = stringArray.getGroups();
            while (object.hasMoreElements()) {
                string4 = (Group)object.nextElement();
                if (string4.getName().equalsIgnoreCase(string2) || group.isMember((Principal)((Object)string4))) continue;
                string5 = string5 + "  <tr>";
                string5 = string5 + "    <td width=6% align=center>";
                string5 = string5 + "      <font face=Arial size=2><input type=checkbox name=add_Group_" + HttpUtil.encodeEsc(string4.getName()) + " value=ON></font></td>";
                string5 = string5 + "    <td width=60%><font face=Arial size=2>&nbsp;" + string4.getName() + "</font></td>";
                string5 = string5 + "    <td width=34%><font face=Arial size=2>&nbsp;Group</font></td>";
                string5 = string5 + "  </tr>";
            }
            string5 = string5 + "  <tr>";
            string5 = string5 + "    <td width=100% colspan=3>";
            string5 = string5 + "      <p align=right><input type=submit value=Add name=button" + IDS_ADD_MEMBER + "></td>";
            string5 = string5 + "  </tr>";
            string5 = string5 + "</table>";
            string5 = string5 + "</form>";
            string5 = string5 + "</div>";
            string5 = string5 + "</body>";
            string5 = string5 + "</html>";
            this.writeResponse(string5);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string3 = "Realm " + string + " does not exist!";
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string3 = "Realm " + string + " is invalid!";
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (NoSuchGroupException noSuchGroupException) {
            string3 = "Group " + string2 + " does not exist!";
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
        }
        if (string3 != null) {
            stringArray = new String[]{"realm", string, "group", string2};
            this.printMessage(stringArray, string3, this.action);
        }
    }
}

