/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resource;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.cs.UnknownPath;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.ResourceInfoException;
import jet.server.api.exception.UnknownMIMEType;
import jet.server.log.ServiceLogger;
import jet.server.resource.AliasNode;
import jet.server.resource.AliasTableError;
import jet.server.resource.GenericAliasInfo;
import jet.server.resource.InvalidResources;
import jet.server.resource.JRptUtil;
import jet.server.resource.ResourceInfo;
import jet.server.resource.ResourceTreeMan;
import jet.server.resource.ResourceUtil;
import jet.server.resource.RptResourceNode;
import jet.server.resource.RptResourceRoot;
import jet.server.resource.UsersAliasManager;
import jet.server.util.MIMETypeMismatch;
import jet.server.util.MIMETypeTable;
import jet.server.util.WebSecurityUtil;

public class RptResourceManager {
    private String C = null;
    private UsersAliasManager INFO = null;
    private boolean SEDU = true;
    private MIMETypeTable addElement = null;
    private ResourceInfo append = null;
    private ResourceTreeMan charAt = null;
    private Object contains = null;

    public RptResourceManager(ResourceInfo resourceInfo, boolean bl, MIMETypeTable mIMETypeTable, String string, Object object) {
        this.append = resourceInfo;
        this.addElement = mIMETypeTable;
        this.C = string;
        this.contains = object;
        this.SEDU = bl;
        this.charAt = new ResourceTreeMan(mIMETypeTable, resourceInfo.getResource(string), resourceInfo.getRscProperties(string));
        this.INFO = new UsersAliasManager(this);
    }

    public String getRealPath(String string, String string2) throws NoSuchUserException, AliasTableError {
        StringBuffer stringBuffer;
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        String string3 = genericAliasInfo.getResourceName(string2, stringBuffer = new StringBuffer());
        if (string3 != null) {
            RptResourceNode rptResourceNode = this.charAt.getResourceNode(string3);
            if (rptResourceNode == null) {
                return null;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            String string4 = (rptResourceNode = this.charAt.getResourceNode(rptResourceNode, stringBuffer.toString(), stringBuffer2)).getRealPath();
            if (string4 == null) {
                return null;
            }
            String string5 = string4.replace(File.separatorChar, '/');
            if (stringBuffer2.length() > 0) {
                string5 = string5.endsWith("/") ? string5 + stringBuffer2.toString().substring(1) : string5 + stringBuffer2;
            }
            return string5;
        }
        return null;
    }

    public String getResourcePath(String string, String string2) throws NoSuchUserException, AliasTableError {
        RptResourceNode rptResourceNode;
        StringBuffer stringBuffer;
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        String string3 = genericAliasInfo.getResourceName(string2, stringBuffer = new StringBuffer());
        if (string3 != null && (rptResourceNode = this.charAt.getResourceNode(string3)) != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            rptResourceNode = this.charAt.getResourceNode(rptResourceNode, stringBuffer.toString(), stringBuffer2);
            String string4 = rptResourceNode.getFullName();
            if (stringBuffer2.length() > 0) {
                string4 = !string4.endsWith("/") ? string4 + stringBuffer2 : string4 + stringBuffer2.toString().substring(1);
            }
            return string4;
        }
        return null;
    }

    public RptResourceNode getResourceNode(String string, String string2, StringBuffer stringBuffer) throws NoSuchUserException, AliasTableError {
        RptResourceNode rptResourceNode;
        StringBuffer stringBuffer2;
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        String string3 = genericAliasInfo.getResourceName(string2, stringBuffer2 = new StringBuffer());
        if (string3 != null && (rptResourceNode = this.charAt.getResourceNode(string3)) != null) {
            return this.charAt.getResourceNode(rptResourceNode, stringBuffer2.toString(), stringBuffer);
        }
        return null;
    }

    public String getRealPathOfParent(String string, String string2) throws NoSuchUserException, AliasTableError {
        if (!string2.startsWith("/")) {
            return null;
        }
        Vector vector = ResourceUtil.getTokenSkippingDots(string2 = string2.endsWith("/") ? string2 + ".." : string2 + "/..");
        if (vector == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("/");
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)vector.elementAt(i);
            stringBuffer.append(string3);
            if (i >= n - 1) continue;
            stringBuffer.append("/");
        }
        return this.getRealPath(string, stringBuffer.toString());
    }

    public boolean checkExistenceOfResource(String string) {
        return this.charAt.getResourceNode(string) != null;
    }

    public String getPathInfo(String string, String string2) throws NoSuchUserException, AliasTableError, UnknownPath {
        CharSequence charSequence;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** RptResourceManager.getPathInfo()");
        JDebug.INFO((String)(" user...." + string));
        JDebug.INFO((String)(" path...." + string2));
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        boolean bl = false;
        JDebug.INFO((String)(" The alias node..." + aliasNode));
        if (aliasNode != null) {
            charSequence = this.getAliasNodeInfo(string, aliasNode);
            if (((String)charSequence).length() > 1 || ((String)charSequence).charAt(((String)charSequence).length() - 1) == '1') {
                return charSequence;
            }
            JDebug.INFO((String)"The alias does not refer valid resource node.");
        }
        charSequence = new StringBuffer();
        RptResourceNode rptResourceNode = this.getResourceNode(string, string2, (StringBuffer)charSequence);
        JDebug.INFO((String)(" Getting the resource node..." + rptResourceNode));
        JDebug.INFO((String)("  buffer..." + ((StringBuffer)charSequence).toString()));
        return this.INFO(string2, rptResourceNode, (StringBuffer)charSequence);
    }

    public String getReferInfo(String string, String string2) throws NoSuchUserException, AliasTableError, UnknownPath {
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        if (aliasNode != null) {
            return this.getAliasNodeReferInfo(string, aliasNode);
        }
        StringBuffer stringBuffer = new StringBuffer();
        RptResourceNode rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
        return this.SEDU(string2, rptResourceNode, stringBuffer);
    }

    public String getAliasNodeReferInfo(String string, AliasNode aliasNode) {
        String string2;
        boolean bl = false;
        if (aliasNode.hasSubNodes()) {
            bl = true;
        }
        if ((string2 = aliasNode.getResourceName()) != null) {
            RptResourceNode rptResourceNode = this.charAt.getResourceNode(string2);
            if (rptResourceNode != null) {
                String string3 = this.charAt.getRscNodeReferInfo(rptResourceNode);
                if (string3.charAt(1) == '1' || !bl) {
                    return string3;
                }
                return string3.charAt(0) + "1";
            }
            return "0" + (bl ? "1" : "0");
        }
        return "0" + (bl ? "1" : "0");
    }

    public String getAliasNodeInfo(String string, AliasNode aliasNode) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Get alias node info...");
        JDebug.INFO((String)(" user..." + string));
        boolean bl = false;
        if (aliasNode.hasSubNodes()) {
            JDebug.INFO((String)" the alias node has sub nodes.");
            bl = true;
        }
        String string2 = aliasNode.getResourceName();
        JDebug.INFO((String)(" The resource name this node refers to..." + string2));
        if (string2 != null) {
            RptResourceNode rptResourceNode = this.charAt.getResourceNode(string2);
            JDebug.INFO((String)(" The real resource node..." + rptResourceNode));
            if (rptResourceNode != null) {
                String string3 = this.charAt.getRscNodeInfo(rptResourceNode);
                int n = string3.length();
                char c = string3.charAt(n - 1);
                JDebug.INFO((String)(" Info get from resource node..." + string3));
                if (c == '1' || !bl) {
                    return string3;
                }
                if (n == 1) {
                    return "1";
                }
                return string3.substring(n - 2, n - 1) + (bl ? "1" : "0");
            }
            return bl ? "1" : "0";
        }
        return bl ? "1" : "0";
    }

    public Vector getSubRscNodesInType(String string, String string2, String string3) throws NoSuchUserException, AliasTableError, UnknownPath {
        Vector vector = new Vector();
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        if (aliasNode != null) {
            this.getSubRscNodsInType(string, aliasNode, string3, vector);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
            if (rptResourceNode != null) {
                if (stringBuffer.length() == 0) {
                    this.charAt.getSubRscNodsInType(rptResourceNode, string3, vector);
                }
            } else {
                throw new UnknownPath(string2);
            }
        }
        return vector;
    }

    public Vector getSubpathsAndFilesInType(String string, String string2, String string3) throws NoSuchUserException, AliasTableError, UnknownPath {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"RptResourceManager.getSubpathsAndFilesInType()");
        JDebug.INFO((String)(" user......." + string));
        JDebug.INFO((String)(" path......." + string2));
        JDebug.INFO((String)(" mimeType..." + string3));
        Vector vector = new Vector();
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        JDebug.INFO((String)(" Get alias node according to path..." + aliasNode));
        if (aliasNode != null) {
            this.getSubpathsAndFilesInType(string, aliasNode, string3, vector);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
            JDebug.INFO((String)(" Get rsc node..." + rptResourceNode));
            JDebug.INFO((String)(" buffer........." + stringBuffer));
            this.addElement(string2, rptResourceNode, string3, stringBuffer, vector);
        }
        return vector;
    }

    public void getSubRscNodsInType(String string, AliasNode aliasNode, String string2, Vector vector) {
        Vector vector2 = aliasNode.getSubNodes();
        int n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            String string3;
            AliasNode aliasNode2 = (AliasNode)vector2.elementAt(i);
            if (aliasNode2.isHidden() || (string3 = this.getAliasNodeInfo(string, aliasNode2)) == null) continue;
            int n2 = string3.length();
            boolean bl = string3.charAt(n2 - 1) == '1';
            boolean bl2 = string3.substring(0, n2 - 1).equals(string2);
            if (!bl && !bl2) continue;
            vector.addElement(aliasNode2.getText() + (bl ? "1" : "0") + (bl2 ? "1" : "0"));
        }
        String string4 = aliasNode.getResourceName();
        RptResourceNode rptResourceNode = this.charAt.getResourceNode(string4);
        if (rptResourceNode != null) {
            this.charAt.getSubRscNodsInType(rptResourceNode, string2, vector);
        }
    }

    public void getSubpathsAndFilesInType(String string, AliasNode aliasNode, String string2, Vector vector) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"RptResourceManager.getSubpathsAndFilesInType()");
        JDebug.INFO((String)(" user........" + string));
        JDebug.INFO((String)(" aliasNode..." + aliasNode.getFullName()));
        JDebug.INFO((String)(" mimeType...." + string2));
        Vector vector2 = aliasNode.getSubNodes();
        int n = vector2 == null ? 0 : vector2.size();
        JDebug.INFO((String)(" Number sub alias node..." + n));
        JDebug.INFO((String)" Retrunging sub alias nodes...");
        for (int i = 0; i < n; ++i) {
            AliasNode aliasNode2 = (AliasNode)vector2.elementAt(i);
            if (aliasNode2.isHidden()) continue;
            String string3 = this.getAliasNodeInfo(string, aliasNode2);
            JDebug.INFO((String)("  " + aliasNode2.getText() + "=" + string3));
            if (string3 == null) continue;
            int n2 = string3.length();
            boolean bl = string3.charAt(n2 - 1) == '1';
            boolean bl2 = string3.substring(0, n2 - 1).equals(string2);
            boolean bl3 = string3.substring(0, n2 - 1).equals("application/x-jrreport");
            JDebug.INFO((String)("   dir..............." + bl));
            JDebug.INFO((String)("   mime type match..." + bl2));
            if (bl || bl2) {
                vector.addElement(aliasNode2.getText() + (bl ? "1" : "0") + (bl2 ? "1" : "0") + "1");
                continue;
            }
            if (!bl3) continue;
            vector.addElement(aliasNode2.getText() + "001");
        }
        String string4 = aliasNode.getResourceName();
        RptResourceNode rptResourceNode = this.charAt.getResourceNode(string4);
        if (rptResourceNode != null) {
            this.charAt.getSubpathsAndFilesInType(rptResourceNode, string2, vector);
        }
    }

    public Vector getSubRscRefFileOrDir(String string, String string2) throws NoSuchUserException, AliasTableError, UnknownPath {
        Vector vector = new Vector();
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        if (aliasNode != null) {
            this.getSubRscRefFileOrDir(string, aliasNode, vector);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
            if (rptResourceNode != null) {
                if (stringBuffer.length() == 0) {
                    this.charAt.getSubRscRefFileOrDir(rptResourceNode, vector);
                }
            } else {
                throw new UnknownPath(string2);
            }
        }
        return vector;
    }

    public void getSubRscRefFileOrDir(String string, AliasNode aliasNode, Vector vector) {
        Vector vector2 = aliasNode.getSubNodes();
        int n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            AliasNode aliasNode2 = (AliasNode)vector2.elementAt(i);
            if (aliasNode2.isHidden() || (string2 = this.getAliasNodeReferInfo(string, aliasNode2)) == null || string2.charAt(0) != '1' && string2.charAt(1) != '1') continue;
            vector.addElement(aliasNode2.getText() + string2);
        }
        String string3 = aliasNode.getResourceName();
        RptResourceNode rptResourceNode = this.charAt.getResourceNode(string3);
        if (rptResourceNode != null) {
            this.charAt.getSubRscRefFileOrDir(rptResourceNode, vector);
        }
    }

    public Vector getSubpathsAndFileSysDirs(String string, String string2) throws NoSuchUserException, AliasTableError, UnknownPath {
        Vector vector = new Vector();
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        if (aliasNode != null) {
            this.getSubpathsAndFileSysDirs(string, aliasNode, vector);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            RptResourceNode rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
            this.append(string2, rptResourceNode, stringBuffer, vector);
        }
        return vector;
    }

    public void getSubpathsAndFileSysDirs(String string, AliasNode aliasNode, Vector vector) {
        Vector vector2 = aliasNode.getSubNodes();
        int n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            AliasNode aliasNode2 = (AliasNode)vector2.elementAt(i);
            if (aliasNode2.isHidden() || (string2 = this.getAliasNodeReferInfo(string, aliasNode2)) == null || string2.charAt(0) != '1' && string2.charAt(1) != '1') continue;
            vector.addElement(aliasNode2.getText() + string2 + "1");
        }
        String string3 = aliasNode.getResourceName();
        RptResourceNode rptResourceNode = this.charAt.getResourceNode(string3);
        if (rptResourceNode != null) {
            this.charAt.getSubpathsAndFileSysDirs(rptResourceNode, vector);
        }
    }

    public String getRptParamFile(String string, String string2, String string3) throws NoSuchUserException, AliasTableError, UnknownPath, UnknownMIMEType, MIMETypeMismatch {
        Object var4_4 = null;
        String string4 = this.getRptRealPath(string, string2, string3);
        return this.charAt(string4);
    }

    public String getRptRealPath(String string, String string2, String string3) throws NoSuchUserException, AliasTableError, UnknownPath, UnknownMIMEType, MIMETypeMismatch {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Get real path of report...");
        JDebug.INFO((String)(" user................" + string));
        JDebug.INFO((String)(" catalog full name..." + string2));
        JDebug.INFO((String)(" report name........." + string3));
        Object var4_4 = null;
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        StringBuffer stringBuffer = new StringBuffer();
        RptResourceNode rptResourceNode = null;
        if (aliasNode == null) {
            rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
        } else {
            AliasNode aliasNode2 = aliasNode.getSubNode(string3);
            if (aliasNode2 != null) {
                String string4 = aliasNode2.getResourceName();
                RptResourceNode rptResourceNode2 = this.charAt.getResourceNode(string4);
                if (rptResourceNode2 != null) {
                    return rptResourceNode2.getRealPath();
                }
                throw new UnknownPath(string2.endsWith("/") ? string2 + string3 : string2 + "/" + string3);
            }
            String string5 = aliasNode.getResourceName();
            if (string5 != null) {
                rptResourceNode = this.charAt.getResourceNode(string5);
            }
        }
        JDebug.INFO((String)" Getting resource node according to the catalog full name...");
        JDebug.INFO((String)("  resource node..." + (rptResourceNode == null ? "null" : rptResourceNode.getFullName())));
        JDebug.INFO((String)("  retBuff........." + stringBuffer));
        return this.contains(string2, rptResourceNode, stringBuffer, string3);
    }

    public Vector getReports(String string, String string2) throws NoSuchUserException, AliasTableError, UnknownPath, UnknownMIMEType, MIMETypeMismatch {
        Vector<String> vector = new Vector<String>();
        GenericAliasInfo genericAliasInfo = this.INFO.getAliasInfoAcrdToSecurity(string);
        AliasNode aliasNode = genericAliasInfo.getAliasNode(string2);
        StringBuffer stringBuffer = new StringBuffer();
        RptResourceNode rptResourceNode = null;
        if (aliasNode == null) {
            rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
        } else {
            Vector vector2 = aliasNode.getSubNodes();
            int n = vector2 == null ? 0 : vector2.size();
            for (int i = 0; i < n; ++i) {
                AliasNode aliasNode2 = (AliasNode)vector2.elementAt(i);
                String string3 = aliasNode2.getResourceName();
                if (string3 == null || string3.length() <= 0) continue;
                vector.addElement(aliasNode2.getText() + "1");
            }
            String string4 = aliasNode.getResourceName();
            if (string4 != null) {
                rptResourceNode = this.charAt.getResourceNode(string4);
            }
        }
        this.elementAt(string2, rptResourceNode, stringBuffer, vector);
        return vector;
    }

    public boolean isReport(String string, String string2) throws NoSuchUserException, AliasTableError {
        StringBuffer stringBuffer = new StringBuffer();
        RptResourceNode rptResourceNode = this.getResourceNode(string, string2, stringBuffer);
        return this.endsWith(rptResourceNode, stringBuffer);
    }

    public GenericAliasInfo getAliasInfoAcrdToSecurity(String string) throws NoSuchUserException, AliasTableError {
        return this.INFO.getAliasInfoAcrdToSecurity(string);
    }

    public InvalidResources getInvalidResources() {
        return this.charAt.getInvalidResources();
    }

    public ResourceTreeMan getResourceTreeMan() {
        return this.charAt;
    }

    public RptResourceRoot getResourceRoot() {
        return this.charAt.getResourceRoot();
    }

    public MIMETypeTable getMIMETypeTable() {
        return this.addElement;
    }

    public UsersAliasManager getAliasManager() {
        return this.INFO;
    }

    public ResourceInfo getResourceInfo() {
        return this.append;
    }

    public Object getData() {
        return this.contains;
    }

    public String getRealm() {
        return this.C;
    }

    public boolean needSecurity() {
        return this.SEDU;
    }

    public void save() throws ResourceInfoException {
        ExProperties exProperties = new ExProperties();
        ExProperties exProperties2 = new ExProperties();
        this.charAt.export(exProperties, exProperties2);
        this.append.saveResource(this.C, exProperties, exProperties2);
    }

    private String C(String string) {
        int n = string.indexOf(47);
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String INFO(String string, RptResourceNode rptResourceNode, StringBuffer stringBuffer) throws UnknownPath {
        if (rptResourceNode != null) {
            if (stringBuffer.length() == 0) {
                return this.charAt.getRscNodeInfo(rptResourceNode);
            }
            String string2 = stringBuffer.toString().substring(1);
            String string3 = this.C(string2);
            JDebug.INFO((String)" It's a virtual path...");
            JDebug.INFO((String)(" sub dir name is......." + string3));
            if (rptResourceNode.isVrtFileReachable(string3)) {
                String string4 = WebSecurityUtil.validateFilePathStr(rptResourceNode.getRealPath());
                JDebug.INFO((String)(" This virtual node is reachable, and real path..." + string4));
                if (string4 != null) {
                    Object object;
                    string4 = string4.replace(File.separatorChar, '/');
                    string4 = string4 + (string4.endsWith("/") ? string2 : stringBuffer.toString());
                    JDebug.INFO((String)(" Full file name..." + string4));
                    String string5 = string4;
                    if (string5.endsWith(".cls")) {
                        object = string5.substring(string5.lastIndexOf("/"));
                        if ((string5 = string5.substring(0, string5.lastIndexOf("/"))).endsWith(".cat")) {
                            string5 = string5.substring(0, string5.lastIndexOf("/"));
                            string4 = string5 + (String)object;
                        }
                    }
                    if (((File)(object = new File(string4))).exists()) {
                        JDebug.INFO((String)" file exists.");
                        try {
                            String string6 = new File(((File)object).getCanonicalPath()).getName();
                            JDebug.INFO((String)(" Canonical name..." + string6));
                            if (!stringBuffer.toString().substring(1).endsWith(string6)) {
                                throw new UnknownPath(string);
                            }
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException, 3);
                        }
                        if (((File)object).isDirectory()) {
                            JDebug.INFO((String)" File is directory.");
                            return "1";
                        }
                        int n = ((File)object).getName().lastIndexOf(".");
                        if (n != -1) {
                            String string7 = ((File)object).getName().substring(n);
                            return this.addElement.getMimeType(string7) + "0";
                        }
                        return "application/octet-stream0";
                    }
                    JDebug.INFO((String)" File not exists");
                    throw new UnknownPath(string);
                }
                throw new UnknownPath(string);
            }
            JDebug.INFO((String)" Virtual node is not reachable.");
            throw new UnknownPath(string);
        }
        throw new UnknownPath(string);
    }

    private String SEDU(String string, RptResourceNode rptResourceNode, StringBuffer stringBuffer) throws UnknownPath {
        if (rptResourceNode != null) {
            if (stringBuffer.length() == 0) {
                return this.charAt.getRscNodeReferInfo(rptResourceNode);
            }
            String string2 = stringBuffer.toString().substring(1);
            String string3 = this.C(string2);
            if (rptResourceNode.isVrtFileReachable(string3)) {
                String string4 = rptResourceNode.getRealPath();
                if (string4 != null) {
                    string4 = string4.replace(File.separatorChar, '/');
                    File file = new File(string4 = string4 + (string4.endsWith("/") ? string2 : stringBuffer.toString()));
                    if (file.exists()) {
                        try {
                            String string5 = new File(file.getCanonicalPath()).getName();
                            if (!string5.endsWith(stringBuffer.toString().substring(1))) {
                                throw new UnknownPath(string);
                            }
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException, 3);
                        }
                        if (file.isDirectory()) {
                            return "11";
                        }
                        return "00";
                    }
                    throw new UnknownPath(string);
                }
                throw new UnknownPath(string);
            }
            throw new UnknownPath(string);
        }
        throw new UnknownPath(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addElement(String string, RptResourceNode rptResourceNode, String string2, StringBuffer stringBuffer, Vector vector) throws UnknownPath {
        File file;
        if (rptResourceNode == null) throw new UnknownPath(string);
        if (stringBuffer.length() == 0) {
            this.charAt.getSubpathsAndFilesInType(rptResourceNode, string2, vector);
            return;
        }
        String string3 = stringBuffer.toString().substring(1);
        String string4 = this.C(string3);
        if (!rptResourceNode.isVrtFileReachable(string4)) {
            JDebug.INFO((String)" Sub dirs and cats are not reachable.");
            throw new UnknownPath(string);
        }
        String string5 = rptResourceNode.getRealPath();
        JDebug.INFO((String)(" The real path of resource node..." + string5));
        if (string5 == null) throw new UnknownPath(string);
        string5 = string5.replace(File.separatorChar, '/');
        if (stringBuffer.length() > 0) {
            string5 = string5 + (string5.endsWith("/") ? string3 : stringBuffer.toString());
        }
        if ((file = new File(string5)).exists()) {
            this.charAt.getSubpathsAndFilesInType(file, string2, null, vector);
            return;
        }
        JDebug.INFO((String)" File not exixts.");
        throw new UnknownPath(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void append(String string, RptResourceNode rptResourceNode, StringBuffer stringBuffer, Vector vector) throws UnknownPath {
        if (rptResourceNode == null) throw new UnknownPath(string);
        if (stringBuffer.length() == 0) {
            this.charAt.getSubpathsAndFileSysDirs(rptResourceNode, vector);
            return;
        } else {
            File file;
            String string2 = stringBuffer.toString().substring(1);
            String string3 = this.C(string2);
            if (!rptResourceNode.isVrtFileReachable(string3)) throw new UnknownPath(string);
            String string4 = rptResourceNode.getRealPath();
            if (string4 == null) throw new UnknownPath(string);
            string4 = string4.replace(File.separatorChar, '/');
            if (stringBuffer.length() > 0) {
                string4 = string4 + (string4.endsWith("/") ? string2 : stringBuffer.toString());
            }
            if (!(file = new File(string4)).exists()) throw new UnknownPath(string);
            this.charAt.getSubpathsAndFileSysDirs(file, null, vector);
        }
    }

    private String charAt(String string) {
        File file;
        String string2 = null;
        if (string != null && (file = new File(string)).exists()) {
            String string3 = file.getName();
            try {
                String string4 = new File(file.getCanonicalPath()).getParent();
                string4 = string4.endsWith(File.separator) ? string4 : string4 + File.separator;
                int n = string3.lastIndexOf(".");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                string2 = string4 + string3 + ".paramdesc";
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String contains(String string, RptResourceNode rptResourceNode, StringBuffer stringBuffer, String string2) throws UnknownPath, UnknownMIMEType, MIMETypeMismatch {
        String string3 = null;
        if (rptResourceNode == null) throw new UnknownPath(string.endsWith("/") ? string + string2 : string + "/" + string2);
        if (stringBuffer.length() == 0) {
            if (!rptResourceNode.isCatNode()) {
                if (!rptResourceNode.isDirectory()) throw new MIMETypeMismatch(670006);
            }
            RptResourceNode rptResourceNode2 = rptResourceNode.getRscByName(string2);
            JDebug.INFO((String)" The catalog name points to a RptResourceNode and that is mapped name of a catalog file.");
            JDebug.INFO((String)(" The report node of that catalog node..." + rptResourceNode2));
            if (rptResourceNode2 != null) {
                return rptResourceNode2.getRealPath();
            }
            if (rptResourceNode.isVrtFileReachable(string2)) {
                JDebug.INFO((String)" The report file is reachable.");
                File file = WebSecurityUtil.validateFilePath(rptResourceNode.getRealPath());
                String string4 = file.isDirectory() ? file.getPath() : file.getParent();
                File file2 = WebSecurityUtil.validateFilePath(file, string2);
                if (file2.exists()) {
                    return (string4.endsWith(File.separator) ? string4 : string4 + File.separator) + string2;
                }
                JDebug.INFO((String)" The report file does not exist.");
                return string3;
            } else {
                JDebug.INFO((String)" The report file is not reachable.");
            }
            return string3;
        } else {
            String string5 = stringBuffer.toString().substring(1);
            String string6 = this.C(string5);
            JDebug.INFO((String)(" The rest path in buff..." + string5));
            JDebug.INFO((String)(" Next directory name....." + string6));
            if (!rptResourceNode.isVrtFileReachable(string6)) throw new UnknownPath(string.endsWith("/") ? string + string2 : string + "/" + string2);
            String string7 = WebSecurityUtil.validateFilePathStr(rptResourceNode.getRealPath());
            JDebug.INFO((String)(" The real path of resource node..." + string7));
            if (string7 == null) throw new UnknownPath(string.endsWith("/") ? string + string2 : string + "/" + string2);
            String string8 = string7.replace(File.separatorChar, '/');
            if (stringBuffer.length() > 0) {
                string8 = string8 + (string8.endsWith("/") ? string5 : stringBuffer.toString());
            }
            JDebug.INFO((String)(" File name..." + string8));
            File file = WebSecurityUtil.validateFilePath(string8);
            if (file.exists() && this.addElement.mimeCheck("application/x-jrcatalog", string8)) {
                try {
                    String string9 = new File(file.getCanonicalPath()).getParent();
                    File file3 = new File(string9, string2);
                    if (!file3.exists()) return string3;
                    return (string9.endsWith(File.separator) ? string9 : string9 + File.separator) + string2;
                }
                catch (IOException iOException) {}
                return string3;
            } else {
                if (!string2.endsWith(".clx")) throw new UnknownPath(string.endsWith("/") ? string + string2 : string + "/" + string2);
                return string8 + File.separator + string2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void elementAt(String string, RptResourceNode rptResourceNode, StringBuffer stringBuffer, Vector vector) throws UnknownPath, UnknownMIMEType, MIMETypeMismatch {
        if (rptResourceNode == null) throw new UnknownPath(string);
        String string2 = rptResourceNode.getRealPath();
        if (stringBuffer.length() == 0) {
            Vector vector2;
            if (!rptResourceNode.isCatNode() && !rptResourceNode.isDirectory()) {
                if (!rptResourceNode.isJRptNode()) throw new MIMETypeMismatch(670006);
            }
            int n = (vector2 = rptResourceNode.getRscNodes()) == null ? 0 : vector2.size();
            for (int i = 0; i < n; ++i) {
                RptResourceNode rptResourceNode2 = (RptResourceNode)vector2.elementAt(i);
                String string3 = rptResourceNode2.getName();
                if (rptResourceNode2.getRealPath() == null || rptResourceNode2.isDirectory() || vector.contains(string3)) continue;
                vector.addElement(string3 + "1");
            }
            if (rptResourceNode.isJRptNode() && !vector.contains(rptResourceNode.getName())) {
                vector.addElement(rptResourceNode.getName() + "1");
                return;
            }
            try {
                Vector vector3 = JRptUtil.getRptFiles(rptResourceNode.getFile(), this.addElement);
                if (rptResourceNode.isDirectory()) {
                    vector3 = JRptUtil.getRptFiles(rptResourceNode.getFile(), "clx");
                }
                if (vector3 == null) {
                    return;
                }
                int n2 = vector3.size();
                int n3 = n2;
                int n4 = 0;
                while (n4 < n3) {
                    String string4 = (String)vector3.elementAt(n4);
                    if (!vector.contains(string4 + "1") && rptResourceNode.isVrtFileReachable(string4)) {
                        vector.addElement(string4 + "0");
                    }
                    ++n4;
                }
                return;
            }
            catch (IOException iOException) {
                throw new MIMETypeMismatch(670006);
            }
        }
        if (string2 == null) throw new UnknownPath(string);
        String string5 = stringBuffer.toString().substring(1);
        String string6 = this.C(string5);
        if (rptResourceNode.isJRptNode() && !vector.contains(rptResourceNode.getName())) {
            vector.addElement(rptResourceNode.getName() + "0");
            return;
        }
        if (!rptResourceNode.isVrtFileReachable(string6)) throw new UnknownPath(string);
        string2 = string2.replace(File.separatorChar, '/');
        string2 = string2 + (string2.endsWith("/") ? string5 : stringBuffer.toString());
        File file = new File(string2);
        if (file.exists() && this.addElement.mimeCheck("application/x-jrcatalog", string2)) {
            try {
                Vector vector4 = JRptUtil.getRptFiles(file, this.addElement);
                if (vector4 == null) {
                    return;
                }
                int n = vector4.size();
                int n5 = n;
                int n6 = 0;
                while (n6 < n5) {
                    vector.addElement(vector4.elementAt(n6) + "0");
                    ++n6;
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        if (!file.isDirectory()) throw new MIMETypeMismatch(670006);
        try {
            Vector vector5 = JRptUtil.getRptFiles(file, "clx");
            if (vector5 == null) {
                return;
            }
            int n = vector5.size();
            int n7 = n;
            int n8 = 0;
            while (n8 < n7) {
                vector.addElement(vector5.elementAt(n8) + "0");
                ++n8;
            }
            return;
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
            return;
        }
    }

    private boolean endsWith(RptResourceNode rptResourceNode, StringBuffer stringBuffer) {
        if (rptResourceNode != null) {
            if (stringBuffer.length() == 0) {
                return rptResourceNode.isJRptNode();
            }
            File file = rptResourceNode.getFile();
            if (file != null) {
                String string = stringBuffer.toString();
                int n = string.lastIndexOf("/");
                if (n <= 0) {
                    if (rptResourceNode.isCatNode()) {
                        try {
                            if (n == 0) {
                                string = string.substring(1);
                            }
                            if (JRptUtil.isRptBelongsToCat(file, string, this.addElement)) {
                                return true;
                            }
                        }
                        catch (UnknownMIMEType unknownMIMEType) {
                            ServiceLogger.logError((Throwable)((Object)unknownMIMEType), 3);
                        }
                    }
                } else if (file.exists() && file.isDirectory()) {
                    String string2 = string.substring(n + 1);
                    string = string.substring(0, n);
                    File file2 = new File(file, string);
                    try {
                        if (file2.exists() && JRptUtil.isRptBelongsToCat(file2, string2, this.addElement)) {
                            return true;
                        }
                    }
                    catch (UnknownMIMEType unknownMIMEType) {
                        ServiceLogger.logError((Throwable)((Object)unknownMIMEType), 3);
                    }
                }
            }
        }
        return false;
    }
}

