/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rmi;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.SecureRandom;
import java.util.Vector;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectProxy;
import jet.server.rmi.RemoteObjectProxyImpl;
import jet.server.rmi.rpc.JRRpcDispatcher;
import jet.server.rmi.rpc.RpcDispatcher;
import jet.server.rmi.rpc.RpcHandler;

public class RemoteObjectFactory {
    private static final String SEDU = "jrs.rmi.auth_file";
    private static final String addElement = "jrs.rmi.auth_string";
    private static String append = "rmi.auth";
    private static String arraycopy = null;
    private static final int bind = 1024;
    private static RemoteObjectProxyImpl clearHandlers = null;
    private static Registry contains = null;
    private static Object createRegistry = null;
    private static boolean elementAt = false;
    private static Vector endsWith = null;
    private static boolean exists = false;
    private static JRRpcDispatcher getBytes = null;

    public static String getRandomAuthString() {
        int n = 32;
        byte[] byArray = new byte[n];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        String string = RemoteObjectFactory.SEDU(byArray);
        clearHandlers.putRandomAuthObj(string);
        return string;
    }

    private static String SEDU(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return "";
    }

    private static Object addElement(String string) {
        byte[] byArray;
        block8: {
            String string2 = System.getProperty(addElement);
            byArray = null;
            if (string2 == null) {
                String string3 = System.getProperty(SEDU);
                if (string3 != null) {
                    byArray = RemoteObjectFactory.append(string3);
                }
            } else {
                try {
                    byArray = string2.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!ServiceLogger.isLoggable(2, 3)) break block8;
                    ServiceLogger.logError(unsupportedEncodingException, 3);
                }
            }
        }
        if (byArray == null && arraycopy != null) {
            byArray = RemoteObjectFactory.append(arraycopy);
        }
        if (byArray == null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            byArray = RemoteObjectFactory.append(string + "bin" + File.separator + append);
        }
        return byArray;
    }

    private static byte[] append(String string) {
        byte[] byArray;
        block6: {
            byArray = null;
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray2 = new byte[1024];
                    int n = fileInputStream.read(byArray2);
                    if (n == -1) break block6;
                    if (n < 1024) {
                        byArray = new byte[n];
                        System.arraycopy(byArray2, 0, byArray, 0, n);
                        break block6;
                    }
                    byArray = byArray2;
                }
                catch (Exception exception) {
                    if (ServiceLogger.isLoggable(2, 3)) {
                        ServiceLogger.logError(exception, 3);
                    }
                    break block6;
                }
            }
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(3670005, string, 3);
            }
        }
        return byArray;
    }

    public static void initAuthInfo(String string) {
        if (elementAt && createRegistry != null) {
            return;
        }
        createRegistry = RemoteObjectFactory.addElement(string);
    }

    public static boolean init(int n, String string) {
        if (elementAt) {
            return true;
        }
        RemoteObjectFactory.initAuthInfo(string);
        clearHandlers = RemoteObjectProxyImpl.newInstance(createRegistry, exists);
        try {
            block7: {
                try {
                    contains = LocateRegistry.createRegistry(n);
                }
                catch (Exception exception) {
                    if (HttpUtil.isStandaloneServer()) break block7;
                    contains = LocateRegistry.getRegistry(n);
                }
            }
            contains.list();
            contains.bind("JReportRemoteObjectProxy", clearHandlers);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 1);
            return false;
        }
        endsWith = new Vector();
        elementAt = true;
        try {
            getBytes = new JRRpcDispatcher();
            RemoteObjectFactory.register("RpcDispatcher", getBytes);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 1);
        }
        return true;
    }

    public static boolean isStartedRMI() {
        return elementAt;
    }

    public static void quit() {
        block4: {
            createRegistry = null;
            if (!elementAt) {
                return;
            }
            try {
                contains.unbind("JReportRemoteObjectProxy");
                for (int i = 0; i < endsWith.size(); ++i) {
                    contains.unbind((String)endsWith.elementAt(i));
                }
            }
            catch (Exception exception) {
                if (!ServiceLogger.isLoggable(2, 3)) break block4;
                ServiceLogger.logError(exception, 3);
            }
        }
        clearHandlers = null;
        RemoteObjectProxyImpl.releaseInstance();
        contains = null;
        endsWith.removeAllElements();
        endsWith = null;
        getBytes.clearHandlers();
        getBytes = null;
        elementAt = false;
    }

    public static void register(String string, Remote remote) {
        RemoteObjectFactory.register(string, remote, false);
    }

    public static void register(String string, Remote remote, boolean bl) {
        if (elementAt) {
            clearHandlers.register(string, remote);
            if (bl) {
                try {
                    contains.bind(string, remote);
                    endsWith.addElement(string);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
        }
    }

    public static void unregister(String string) {
        block3: {
            clearHandlers.unregister(string);
            if (endsWith.contains(string)) {
                try {
                    contains.unbind(string);
                }
                catch (Exception exception) {
                    if (!ServiceLogger.isLoggable(2, 2)) break block3;
                    ServiceLogger.logError(exception, 2);
                }
            }
        }
    }

    public static Remote getRemoteObject(String string) throws RemoteException {
        Remote remote = clearHandlers.getRemoteObject(string, createRegistry);
        if (remote == null) {
            throw new RemoteException("No such remote object: " + string);
        }
        return remote;
    }

    public static Remote getRemoteObject(String string, int n, String string2) throws MalformedURLException, NotBoundException, RemoteException {
        String string3 = "//" + string + ":" + n + "/" + "JReportRemoteObjectProxy";
        RemoteObjectProxy remoteObjectProxy = (RemoteObjectProxy)Naming.lookup(string3);
        Remote remote = remoteObjectProxy.getRemoteObject(string2, createRegistry);
        if (remote == null) {
            throw new NotBoundException("//" + string + ":" + n + "/" + string2);
        }
        return remote;
    }

    public static void setAuthFile(String string) {
        arraycopy = string;
    }

    public static void setIsMonitorServer(boolean bl) {
        exists = bl;
    }

    public static RpcHandler registerRpcHandler(String string, Object object) {
        if (elementAt) {
            return getBytes.registerHandler(string, object);
        }
        return null;
    }

    public static RpcDispatcher getRpcDispatcher(String string, int n) throws MalformedURLException, RemoteException, NotBoundException {
        return (RpcDispatcher)RemoteObjectFactory.getRemoteObject(string, n, "RpcDispatcher");
    }
}

