/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.ServerInfo;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class JRServerInfo
implements ServerInfo,
Serializable {
    private static final long serialVersionUID = -8444281840979925053L;
    private Properties propsTask = null;
    String requestURL = null;
    String remoteAddress = null;
    private Vector paramDescs;

    public JRServerInfo(Properties properties) {
        this.propsTask = properties == null ? new Properties() : properties;
    }

    public void setRequestURL(String string) {
        this.requestURL = string;
    }

    public void setRemoteAddr(String string) {
        this.remoteAddress = string;
    }

    @Override
    public Properties getTaskProperties() {
        return this.propsTask;
    }

    @Override
    public Properties getScheduleProperties() {
        return this.propsTask;
    }

    @Override
    public String getRequestURL() throws RptServerException {
        return this.requestURL;
    }

    @Override
    public String getRemoteAddress() throws RptServerException {
        return this.remoteAddress;
    }

    @Override
    public Vector getUserGroups(String string) throws RptServerException {
        Vector<String> vector = new Vector<String>();
        try {
            Vector vector2 = new Vector();
            SecurityService securityService = UserDataToolkit.getSecurityService(ServerEnv.getActiveRealm());
            vector2 = securityService.getRolesNameByUser(string);
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector2.elementAt(i);
                if (vector.contains(string2)) continue;
                vector.addElement(string2);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        return vector;
    }

    public void setParamDescs(Vector vector) {
        this.paramDescs = vector;
    }

    @Override
    public Vector getParamDescs() throws RptServerException {
        if (this.paramDescs == null) {
            this.paramDescs = new Vector();
        }
        return this.paramDescs;
    }

    protected void finalize() throws Throwable {
        if (this.propsTask != null) {
            this.propsTask.clear();
            this.propsTask = null;
        }
    }
}

