/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import guitools.toolkit.JDebug;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.cs.CSUtil;
import jet.server.jrc.quartz.JRBasicTrigger;
import jet.server.jrc.quartz.JRTimeQuartzTrigger;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.JetLch;
import jet.server.schedule.TimeLaunchableObj;
import jet.server.schedule.TriggerLaunchableObj;

public class JetTimeLch
extends JetLch {
    protected JetNumber exeTime = new JetNumber((JetObject)this, "exeTime");
    protected JetBoolean isLaunchEvenIfExpired = new JetBoolean((JetObject)this, "isLEIE");

    public JetTimeLch() {
    }

    public JetTimeLch(TimeLaunchableObj timeLaunchableObj, Vector vector) {
        super(timeLaunchableObj, vector);
        this.exeTime.set(timeLaunchableObj.getExeTime(false));
        this.timezone.set(timeLaunchableObj.getGC().getTimeZone().getID());
        this.isLaunchEvenIfExpired.set(timeLaunchableObj.isLaunchEvenIfExpired());
    }

    public long getExeTime() {
        return this.exeTime.longValue();
    }

    @Override
    public TimeLaunchableObj createLaunchableObj(Hashtable hashtable) {
        TimeLaunchableObj timeLaunchableObj = null;
        if (hashtable != null) {
            Properties properties = (Properties)hashtable.get(this.getTaskId());
            JDebug.INFO((String)("createLaunchableObj: id=" + this.getTaskId() + " task=" + properties));
            if (properties != null) {
                int n = Integer.parseInt(properties.getProperty("jrs.launch_type"));
                String string = properties.getProperty("jrs.triggers");
                timeLaunchableObj = n == 0 && string != null ? new TriggerLaunchableObj(properties) : new TimeLaunchableObj(properties, new ExeTimeInfo(this.getExeTime(), this.getTimeZone(), this.getTimeoutValue(), this.isLaunchEvenIfExpired.get()));
                timeLaunchableObj.setUid(this.getUid());
                timeLaunchableObj.setNext(this.createNextLaunchableObj(hashtable));
                timeLaunchableObj.setEnabled(this.isEnabled.get());
            }
        }
        return timeLaunchableObj;
    }

    @Override
    public Hashtable toHashtable(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        hashtable.put("jrs.task_class", ((Object)((Object)this)).getClass().getName());
        hashtable.put("jrs.task_id", String.valueOf(this.getTaskId()));
        if (this.getUid() != null) {
            hashtable.put("jrs.uid", this.getUid());
        }
        hashtable.put("jrs.exe_time", String.valueOf(this.getExeTime()));
        hashtable.put("jrs.timezone", this.getTimeZone());
        hashtable.put("jrs.timeout", String.valueOf(this.getTimeoutValue()));
        hashtable.put("jrs.is_launch_even_expired", String.valueOf(this.isLaunchEvenIfExpired.get()));
        hashtable.put("jrs.is_enabled", String.valueOf(this.isEnabled.get()));
        return hashtable;
    }

    @Override
    public void init(Hashtable hashtable) throws Exception {
        this.taskId.set((String)hashtable.get("jrs.task_id"));
        this.uid.set((String)hashtable.get("jrs.uid"));
        Object v = hashtable.get("jrs.exe_time");
        this.exeTime.set(CSUtil.parseLong(v != null ? v.toString() : "0"));
        this.timezone.set((String)hashtable.get("jrs.timezone"));
        this.timeout.set(CSUtil.parseLong(hashtable.get("jrs.timeout").toString()));
        this.isLaunchEvenIfExpired.set(CSUtil.getBoolean((String)hashtable.get("jrs.is_launch_even_expired"), false));
        this.isEnabled.set(CSUtil.getBoolean((String)hashtable.get("jrs.is_enabled"), true));
    }

    @Override
    public JRTrigger createTrigger(Hashtable hashtable) {
        if (hashtable != null) {
            Properties properties = (Properties)hashtable.get(this.getTaskId());
            JDebug.INFO((String)("createLaunchableObj: id=" + this.getTaskId() + " task=" + properties));
            if (properties != null) {
                int n = Integer.parseInt(properties.getProperty("jrs.launch_type"));
                String string = properties.getProperty("jrs.triggers");
                if (n == 0 && string != null) {
                    String string2 = "JR_BASIC_TRG_" + this.getTaskId();
                    JRBasicTrigger jRBasicTrigger = new JRBasicTrigger(string2, "JR_DETAULT_GROUP");
                    jRBasicTrigger.setType(0);
                    jRBasicTrigger.init(properties, new ExeTimeInfo(this.getExeTime(), this.getTimeZone(), this.getTimeoutValue(), this.isLaunchEvenIfExpired.get()));
                    jRBasicTrigger.setUid(this.getUid());
                    jRBasicTrigger.setTaskID(this.getTaskId());
                    jRBasicTrigger.setTask(properties);
                    return jRBasicTrigger;
                }
                String string3 = "JR_TRG_" + this.getTaskId();
                JRTimeQuartzTrigger jRTimeQuartzTrigger = new JRTimeQuartzTrigger(string3, "JR_DETAULT_GROUP", this.getTimeZone());
                jRTimeQuartzTrigger.init(properties, new ExeTimeInfo(this.getExeTime(), this.getTimeZone(), this.getTimeoutValue(), this.isLaunchEvenIfExpired.get()));
                jRTimeQuartzTrigger.setUid(this.getUid());
                jRTimeQuartzTrigger.setTaskID(this.getTaskId());
                jRTimeQuartzTrigger.setEnable(this.isEnabled.get());
                jRTimeQuartzTrigger.setType(1);
                jRTimeQuartzTrigger.setTask(properties);
                return jRTimeQuartzTrigger;
            }
        }
        return null;
    }
}

