/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.JetLch;
import jet.server.schedule.JetTimeLch;
import jet.server.schedule.SchdTools;
import jet.server.schedule.TimeLaunchable;

public class TimeLaunchableObj
implements TimeLaunchable {
    private GregorianCalendar after = null;
    private boolean appendScript = false;
    protected boolean isEnabled = true;
    protected String taskId = null;
    protected String taskName = null;
    protected String uid = null;
    protected Properties htTask = null;
    private long get = 0L;
    private String getDefaultTimeZone = "";
    private TimeLaunchableObj getExeDateObj = null;

    public TimeLaunchableObj(Properties properties, ExeTimeInfo exeTimeInfo) {
        SchdTools.removeScheduleProps(properties);
        this.htTask = properties;
        this.taskId = (String)properties.get("jrs.task_id");
        if (this.taskId == null || this.taskId.trim().length() == 0) {
            this.taskId = SchdTools.getIdBase();
        }
        this.htTask.put("jrs.task_id", this.taskId);
        this.taskName = (String)properties.get("jrs.schedule_name");
        if (this.taskName == null) {
            this.taskName = (String)properties.get("jrs.task_name");
        }
        if (this.taskName == null || this.taskName.trim().length() == 0) {
            this.taskName = "";
        }
        this.htTask.put("jrs.schedule_name", this.taskName);
        long l = this.get = exeTimeInfo == null ? 0L : exeTimeInfo.getTimeoutValue();
        if (exeTimeInfo != null) {
            this.after = exeTimeInfo.getGC();
            this.appendScript = exeTimeInfo.isLaunchEvenIfExpired();
        }
        this.htTask.put("jrs.launch_type", String.valueOf(this.getLaunchType()));
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Properties getTask() {
        this.htTask.put("jrs.schd_props", this.toProperties(null));
        return this.htTask;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public boolean isLaunchNext() {
        return true;
    }

    public long getTimeoutValue() {
        return this.get;
    }

    public long getExeTime(boolean bl) {
        return this.getExeTime();
    }

    @Override
    public long getExeTime() {
        return this.after == null ? -1L : this.after.getTime().getTime();
    }

    public String getTimeZone() {
        return this.after == null ? CSUtil.getDefaultTimeZone() : this.after.getTimeZone().getID();
    }

    public GregorianCalendar getGC() {
        return this.after;
    }

    @Override
    public void setExeTime(long l) {
        this.after.setTime(new Date(l));
    }

    @Override
    public boolean isExeTimeExpired() {
        return new Date().after(this.after.getTime());
    }

    @Override
    public boolean isLaunchEvenIfExpired() {
        return this.appendScript;
    }

    @Override
    public long getWakenTime() {
        return this.after.getTime().getTime();
    }

    @Override
    public void wakeUp(long l) {
    }

    @Override
    public boolean isMultipleWaken() {
        return false;
    }

    protected Date getExeDateObj() {
        return this.after != null ? this.after.getTime() : null;
    }

    public JetLch createJetLaunchable(Vector vector) {
        return new JetTimeLch(this, vector);
    }

    public int getLaunchType() {
        return 1;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (this.htTask != null) {
            this.htTask.put("jrs.is_enabled", String.valueOf(bl));
        }
    }

    public void setMessage(String string) {
        this.getDefaultTimeZone = string == null ? "" : this.getDefaultTimeZone + string + "\n";
    }

    public String getMessage() {
        return this.getDefaultTimeZone;
    }

    public void setNext(TimeLaunchableObj timeLaunchableObj) {
        this.getExeDateObj = timeLaunchableObj;
    }

    public TimeLaunchableObj getNext() {
        return this.getExeDateObj;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.launch_type", String.valueOf(1));
        if (this.after != null) {
            properties2.put("jrs.exe_year", String.valueOf(this.after.get(1)));
            properties2.put("jrs.exe_month", String.valueOf(this.after.get(2) + 1));
            properties2.put("jrs.exe_day", String.valueOf(this.after.get(5)));
            properties2.put("jrs.exe_hour", String.valueOf(this.after.get(11)));
            properties2.put("jrs.exe_min", String.valueOf(this.after.get(12)));
            properties2.put("jrs.exe_sec", String.valueOf(this.after.get(13)));
            properties2.put("jrs.next_exe_time", String.valueOf(this.after.getTime().getTime()));
            properties2.put("jrs.timezone", this.after.getTimeZone().getID());
            properties2.put("jrs.exe_date", this.getExeDateObj().toString());
        }
        properties2.put("jrs.is_enabled", String.valueOf(this.isEnabled));
        return properties2;
    }

    public String toString() {
        return super.toString() + ":exeTime=\"" + (this.after == null ? null : this.after.getTime()) + "\":isLaunchEvenIfExpired=" + this.appendScript;
    }

    public static String filterTimeLaunchableScriptItems(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector();
        CSUtil.appendScript(vector, hashtable, "jrs.launch_type", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_enabled", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.timezone", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_sec", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_date", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_stat", true, bl);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.get(i)).append(CSUtil.LINE);
        }
        return stringBuffer.toString();
    }

    public String getParamFile() {
        return CSUtil.getFileNameOnly(this.htTask.getProperty("jrs.param_file"));
    }
}

