/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.bursting;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.JREngine;
import jet.dataengine.api.BurstingSchemaOptimized;
import jet.dataengine.api.BurstingSchemaQueue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.DataBlockSet;
import jet.dataengine.api.DataBlockSetIDGenerator;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataservice.api.JDataService;
import jet.jetc.ReadFailureException;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ReportLogic;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.RawDataQueryCreator;
import jet.rptservice.api.exception.JRScheduleException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.bursting.BurstingExecutor;
import jet.server.schedule.bursting.NonBurstingResultListener;

public class MultiBurstingExecutor {
    private JREngine SEDU;
    private boolean addAll;
    private String addElement;
    private String asList;
    Properties paramValues = null;
    private BurstingSchema[] contains;
    DataBlock[] shareDataBlock;
    private Object containsKey = new Object();
    private boolean createRawDataQuery = false;
    private int exit = 0;
    private BurstingExecutor[] get = null;
    private int[] getBurstingDataSetNames = null;
    private DataBlockSetIDGenerator getBurstingSchema;
    private boolean getBurstingSchemaQueue = false;
    private int getCurrentID = 0;
    private int getDataResult = 0;
    private Object getDiskStore = new Object();
    private int getInstance = 3000;
    private NonBurstingResultListener getJDataServiceByUser = null;
    private CatalogKey getNextBurstingDataBlockSet;
    private JDataService getNonBurstingDataBlockSet;
    private HashMap getQueryFactory = null;

    public MultiBurstingExecutor(JREngine jREngine, String string, CatalogKey catalogKey, boolean bl, String string2, Properties properties, String[] stringArray, boolean bl2, boolean bl3) {
        this.SEDU = jREngine;
        this.addElement = string;
        this.addAll = bl;
        this.asList = string2;
        this.paramValues = properties;
        this.createRawDataQuery = bl2;
        this.getNextBurstingDataBlockSet = catalogKey;
        this.contains = this.addElement(stringArray);
        BurstingSchemaQueue[] burstingSchemaQueueArray = BurstingSchemaOptimized.optimize((BurstingSchema[])this.contains);
        this.getCurrentID = burstingSchemaQueueArray.length;
        this.getBurstingDataSetNames = new int[this.getCurrentID];
        this.getBurstingSchema = new DataBlockSetIDGenerator();
        this.get = new BurstingExecutor[this.getCurrentID];
        this.getNonBurstingDataBlockSet = UserDataToolkit.getJDataServiceByUser(string);
        for (int i = 0; i < this.getCurrentID; ++i) {
            BurstingSchema[] burstingSchemaArray = burstingSchemaQueueArray[i].getBurstingSchemaQueue();
            this.get[i] = new BurstingExecutor(jREngine, string, catalogKey, bl, properties, burstingSchemaArray, i == 0 ? bl2 : false, bl3, this.getBurstingSchema, this.getNonBurstingDataBlockSet);
        }
    }

    public void setMaxFileNumberInFolder(int n) {
        this.getInstance = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DSException, JRScheduleException, JRStopEngineException, ConditionException, ReadFailureException, OutOfSpaceException, IOException {
        try {
            String[] stringArray = this.asList(this.contains);
            Object object = this.containsKey;
            synchronized (object) {
                this.shareDataBlock = new DataBlock[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    ResultSet resultSet = this.contains(stringArray[i]);
                    this.shareDataBlock[i] = resultSet == null ? null : new DataBlock(resultSet, stringArray[i], (DiskStore)JRServerResourceStoreFactory.getInstance().getResourceStoreByUser(this.addElement).getDiskStore());
                }
                this.containsKey.notifyAll();
            }
            for (int i = 0; i < this.getCurrentID; ++i) {
                this.getBurstingDataSetNames[i] = this.getBurstingSchema.getCurrentID();
                this.get[i].setMaxFileNumberInFolder(this.getInstance);
                this.get[i].init();
                if (this.getJDataServiceByUser == null || i != 0) continue;
                this.getJDataServiceByUser.startNonBurstingResultTask();
            }
        }
        catch (DSException dSException) {
            throw dSException;
        }
        catch (JRScheduleException jRScheduleException) {
            throw jRScheduleException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw jRStopEngineException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlockSet getNextBurstingDataBlockSet() throws DSException {
        if (this.getBurstingSchemaQueue) {
            return null;
        }
        Object object = this.getDiskStore;
        synchronized (object) {
            while (this.getDataResult < this.getCurrentID) {
                DataBlockSet dataBlockSet = null;
                BurstingExecutor burstingExecutor = this.get[this.getDataResult];
                dataBlockSet = burstingExecutor.getNextBurstingDataBlockSet();
                if (dataBlockSet != null) {
                    return dataBlockSet;
                }
                ++this.getDataResult;
            }
        }
        return null;
    }

    public void exit() {
        this.getBurstingSchemaQueue = true;
        for (int i = 0; i < this.get.length; ++i) {
            this.get[i].exit();
            this.get[i] = null;
        }
    }

    public void runBurstingDataBlockFinished(int n) {
        this.SEDU(n).runBurstingDataBlockFinished(n);
    }

    private BurstingExecutor SEDU(int n) {
        int n2;
        for (int i = n2 = this.getDataResult < this.getCurrentID ? this.getDataResult : this.getDataResult - 1; i >= 0; --i) {
            if (this.getBurstingDataSetNames[i] == 0 || this.getBurstingDataSetNames[i] > n) continue;
            return this.get[i];
        }
        return null;
    }

    public DataBlock getSharedDataBlock(String string) throws DSException, JRScheduleException, JRStopEngineException, OutOfSpaceException, IOException {
        ResultSet resultSet = this.contains(string);
        if (resultSet != null) {
            return new DataBlock(resultSet, string, (DiskStore)JRServerResourceStoreFactory.getInstance().getResourceStoreByUser(this.addElement).getDiskStore());
        }
        return null;
    }

    public DataBlock[] getSharedDataBlocks(String string) throws DSException, JRScheduleException, JRStopEngineException, OutOfSpaceException, IOException {
        if (this.getQueryFactory != null && this.getQueryFactory.containsKey(string)) {
            return (DataBlock[])this.getQueryFactory.get(string);
        }
        JetRptReportSet jetRptReportSet = this.SEDU.getReportSet();
        JetRptReport jetRptReport = jetRptReportSet.getReport(this.asList);
        ReportLogic reportLogic = ObjectLogicFactory.getReportLogic();
        BurstingSchema burstingSchema = reportLogic.getBurstingSchema(jetRptReport, string);
        String[] stringArray = burstingSchema.getSharedDataSetNames();
        if (stringArray == null) {
            return null;
        }
        DataBlock[] dataBlockArray = new DataBlock[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dataBlockArray[i] = this.getSharedDataBlock(stringArray[i]);
        }
        if (this.getQueryFactory == null) {
            this.getQueryFactory = new HashMap();
        }
        this.getQueryFactory.put(string, dataBlockArray);
        return dataBlockArray;
    }

    public DataBlockSet getNonBurstingDataBlockSet() {
        if (this.getBurstingSchemaQueue) {
            return null;
        }
        BurstingExecutor burstingExecutor = this.get[0];
        DataBlockSet dataBlockSet = burstingExecutor.getNonBurstingDataBlockSet();
        return dataBlockSet;
    }

    public void addNonBurstingResultListener(NonBurstingResultListener nonBurstingResultListener) {
        this.getJDataServiceByUser = nonBurstingResultListener;
    }

    private synchronized int addAll() {
        return ++this.exit;
    }

    private BurstingSchema[] addElement(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        BurstingSchema[] burstingSchemaArray = new BurstingSchema[stringArray.length];
        JetRptReportSet jetRptReportSet = this.SEDU.getReportSet();
        JetRptReport jetRptReport = jetRptReportSet.getReport(this.asList);
        ReportLogic reportLogic = ObjectLogicFactory.getReportLogic();
        for (int i = 0; i < stringArray.length; ++i) {
            burstingSchemaArray[i] = reportLogic.getBurstingSchema(jetRptReport, stringArray[i]);
        }
        return burstingSchemaArray;
    }

    private String[] asList(BurstingSchema[] burstingSchemaArray) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < burstingSchemaArray.length; ++i) {
            String[] stringArray = burstingSchemaArray[i].getBurstingDataSetNames();
            if (i == 0) {
                String[] stringArray2 = burstingSchemaArray[i].getSharedDataSetNames();
                vector.addAll(Arrays.asList(stringArray));
                vector.addAll(Arrays.asList(stringArray2));
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector2.contains(stringArray[j])) continue;
                vector2.addElement(stringArray[j]);
            }
        }
        vector.removeAll(vector2);
        return vector.toArray(new String[vector.size()]);
    }

    private ResultSet contains(String string) throws DSException, JRScheduleException, JRStopEngineException {
        JRawDataQuery jRawDataQuery = this.containsKey(string, null);
        if (jRawDataQuery == null) {
            return null;
        }
        this.getNonBurstingDataBlockSet.sendQuery((JQuery)jRawDataQuery);
        return this.getNonBurstingDataBlockSet.getDataResult(jRawDataQuery.getQueryId());
    }

    private JRawDataQuery containsKey(String string, ISortExpression iSortExpression) throws DSException, JRScheduleException {
        RawDataQueryCreator rawDataQueryCreator = this.SEDU.getRawDataQueryCreator(string);
        if (rawDataQueryCreator == null) {
            return null;
        }
        int n = this.addAll();
        JRawDataQuery jRawDataQuery = rawDataQueryCreator.createRawDataQuery(this.getNonBurstingDataBlockSet.getQueryFactory(), this.getNextBurstingDataBlockSet, iSortExpression);
        return jRawDataQuery;
    }
}

