/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.bursting;

import com.jinfonet.resstore.DiskStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import jet.dataengine.api.DataBlock;
import jet.server.intf.engine.EngineContext;
import jet.server.jrc.JRTaskManager;
import jet.server.log.ServiceLogger;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.bursting.BurstingTaskUtil;
import jet.server.schedule.bursting.SubBurstingTaskController;
import jet.server.schedule.bursting.SubBurstingTaskThread;
import jet.server.schedule.bursting.SubTaskControllerListener;
import jet.server.schedule.bursting.SubTaskThreadListener;
import jet.server.schedule.jrtasks.PublishRptTask;

public class SubBurstingTaskControllerImpl
implements SubBurstingTaskController,
SubTaskThreadListener {
    private EngineContext SEDU;
    private Properties addTaskThreadListener;
    private String append;
    private JRTaskManager clear;
    private boolean clone;
    private SubBurstingTaskThread[] containsKey;
    private Hashtable createSubTask = new Hashtable();
    private SubTaskControllerListener get;
    private StringBuffer getDiskStore = new StringBuffer();
    private boolean getInstance = false;
    private String getMessage = "";
    private boolean getResourceStoreByUser = false;
    private String[] getSharedDataBlockNumber = null;

    public SubBurstingTaskControllerImpl(EngineContext engineContext, Properties properties, JRTaskManager jRTaskManager, String[] stringArray, boolean bl) throws RemoteException {
        this.SEDU = engineContext;
        this.addTaskThreadListener = properties;
        this.clear = jRTaskManager;
        this.clone = bl;
        this.getSharedDataBlockNumber = stringArray;
        this.append = (String)properties.get("jrs.uid");
    }

    @Override
    public void createSubTasks() throws Exception {
        this.SEDU();
        for (int i = 0; i < this.containsKey.length; ++i) {
            Properties properties = (Properties)this.addTaskThreadListener.clone();
            properties.remove("jrs.is_bursting_task");
            properties.remove("jrs.task_id");
            PublishRptTask publishRptTask = BurstingTaskUtil.createSubTask(properties, this.clear, this.SEDU, this.clone, false);
            this.containsKey[i] = new SubBurstingTaskThread(publishRptTask);
        }
    }

    private void SEDU() {
        this.containsKey = new SubBurstingTaskThread[2];
    }

    @Override
    public void startSubTasks() {
        for (int i = 0; i < this.containsKey.length; ++i) {
            if (this.containsKey[i] == null) continue;
            this.containsKey[i].addTaskThreadListener(i, this);
            this.containsKey[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void subTaskFinished(int n, String string, boolean bl, String string2) {
        if (this.getResourceStoreByUser) {
            return;
        }
        boolean bl2 = false;
        if (string.length() != 0) {
            if (this.getDiskStore.length() > 0) {
                this.getDiskStore.append(",");
            }
            this.getDiskStore.append(string);
        }
        if (bl) {
            this.getInstance = true;
            this.getMessage = this.getMessage + "\r\n" + string2;
        }
        ServiceLogger.logDebug(6600207, new Object[]{new Integer(n), string, new Boolean(bl)}, 6);
        if (this.containsKey != null) {
            SubBurstingTaskThread[] subBurstingTaskThreadArray = this.containsKey;
            // MONITORENTER : this.containsKey
            this.containsKey[n] = null;
            for (int i = 0; i < this.containsKey.length; ++i) {
                if (this.containsKey[i] == null) continue;
                bl2 = true;
                break;
            }
            // MONITOREXIT : subBurstingTaskThreadArray
        }
        if (bl2) return;
        ServiceLogger.logDebug(5600208, 5);
        this.addTaskThreadListener();
        if (this.get == null) return;
        try {
            this.get.subTasksFinished(this.getDiskStore.length() > 0, this.getDiskStore.toString(), this.getInstance, this.getMessage);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(2600200, remoteException.getMessage(), 2);
            ServiceLogger.logError(remoteException, 3);
        }
        this.get = null;
    }

    private void addTaskThreadListener() {
        this.SEDU = null;
        if (this.addTaskThreadListener != null) {
            this.addTaskThreadListener.clear();
            this.addTaskThreadListener = null;
        }
        this.clear = null;
        this.containsKey = null;
        if (this.createSubTask != null) {
            this.createSubTask.clear();
            this.createSubTask = null;
        }
    }

    @Override
    public void addListener(SubTaskControllerListener subTaskControllerListener) throws RemoteException {
        this.get = subTaskControllerListener;
    }

    @Override
    public DataBlock[] getSharedData(String string) throws RemoteException, Exception {
        if (this.createSubTask.containsKey(string)) {
            return (DataBlock[])this.createSubTask.get(string);
        }
        DataBlock[] dataBlockArray = this.append(string);
        this.createSubTask.put(string, dataBlockArray);
        return dataBlockArray;
    }

    private DataBlock[] append(String string) throws RemoteException, Exception {
        DataBlock[] dataBlockArray = null;
        int n = this.SEDU.getSharedDataBlockNumber(string);
        ServiceLogger.logDebug(6600205, new Integer(n), 6);
        dataBlockArray = new DataBlock[n];
        for (int i = 0; i < n; ++i) {
            dataBlockArray[i] = this.clear(string, i);
            ServiceLogger.logDebug(6600206, new Integer(i), 6);
        }
        return dataBlockArray;
    }

    private DataBlock clear(String string, int n) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        String string2 = this.SEDU.getSharedDataSetName(string, n);
        if (string2 != null) {
            byte[] byArray;
            while ((byArray = this.SEDU.readSharedDataBlock(string, n, n2)).length != 0) {
                byteArrayOutputStream.write(byArray);
                n2 += byArray.length;
            }
            DataBlock dataBlock = new DataBlock(new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), string2, (DiskStore)JRServerResourceStoreFactory.getInstance().getResourceStoreByUser(this.append).getDiskStore());
            return dataBlock;
        }
        return null;
    }

    @Override
    public String[] getSelectedSchemas() {
        return this.getSharedDataBlockNumber;
    }

    @Override
    public void stop() throws RemoteException {
        for (int i = 0; i < this.containsKey.length; ++i) {
            if (this.containsKey[i] == null) continue;
            this.containsKey[i].stopExec();
            this.containsKey[i] = null;
        }
        this.getResourceStoreByUser = true;
        this.addTaskThreadListener();
    }
}

