/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.export.ExportAuxInfo;
import jet.export.mail.mail;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpUtil;
import jet.server.cluster.ClusterEnv;
import jet.server.jrserver.JROndemandReportRecord;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.ExportItem;
import jet.server.schedule.jrtasks.HtmlPipeFileNamesImpl;
import jet.server.schedule.jrtasks.ReportSheetRunner;
import jet.server.schedule.jrtasks.RunRptTask;
import jet.util.WildcardMatcher;

public class ViewRptTask
extends RunRptTask {
    protected String rstLoc = null;
    protected String rstNm = null;
    protected Properties sheetsRstNms = null;
    protected boolean isTimeoutSendEmail = false;
    protected String timeoutMailFrom = null;
    protected String timeoutMailto = null;
    protected String timeoutMailcc = null;
    protected String timeoutMailbcc = null;
    protected String timeoutSubject = null;
    protected String timeoutComment = null;
    protected boolean isTimeoutCompress = false;
    protected String tmpRst = null;
    private Date IsExportToMultiFiles = null;
    private boolean SEDU = false;
    private boolean TEMP_FILE_SUFF = false;
    private int add = 0;
    private String addElement = null;
    private String addExcelDir = null;
    private String addExcelName = null;
    private String addExportItem = null;
    private Hashtable[] addHtmDir = null;
    private int addHtmName = -1;
    private String addPdfDir = null;
    private String addPdfName = null;

    @Override
    protected void setAllowFFP() throws RemoteException {
        this.engineContext.setAllowFFP(this.rstType == 3 && !this.isNormalText);
    }

    public boolean isEnableArchivePolicy() {
        return this.TEMP_FILE_SUFF;
    }

    @Override
    protected synchronized void initEngine() throws Exception {
        super.initEngine();
        this.setHtmlPipeLine();
    }

    protected void setHtmlPipeLine() throws RemoteException {
        if (this.htmlParams == null || !ServerEnv.isPipeline()) {
            this.isHtmlPipeLine = false;
            return;
        }
        try {
            this.isHtmlPipeLine = !this.engineContext.hasPageSecurity() && !this.isDhtml && this.htmlParams.IsExportToMultiFiles() && (this.runningRptSheets.hasHtmlResult() || !this.hasCheckedSheets && this.rstType == 1);
        }
        catch (Exception exception) {
            this.isHtmlPipeLine = false;
        }
        ServiceLogger.logDebug(6600107, new Object[]{String.valueOf(this.isHtmlPipeLine), String.valueOf(this.engineContext.hasPageSecurity()), String.valueOf(this.isDhtml), String.valueOf(this.htmlParams.IsExportToMultiFiles())}, 6);
    }

    public String getRealDir(String string, boolean bl) throws Exception {
        boolean bl2 = this.isRealDir;
        boolean bl3 = this.isWillPublishToDisk;
        try {
            this.isWillPublishToDisk = true;
            String string2 = this.checkRealDir(string, bl);
            return string2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.isWillPublishToDisk = bl3;
        }
    }

    private String IsExportToMultiFiles(String string, String string2, String string3) throws IOException {
        return File.createTempFile(string2, string3, new File(string)).getName();
    }

    @Override
    public void init(Properties properties) throws Exception {
        String string;
        super.init(properties);
        String string2 = (String)properties.get("jrs.report_sheet_names");
        if (string2 != null) {
            this.sortedSheetNames = string2.split(";");
            if (this.sortedSheetNames.length > 0) {
                this.isExportOneFile = true;
                this.runningRptSheets.sortSheets(this.sortedSheetNames);
            }
        }
        this.isTimeoutSendEmail = CSUtil.getBoolean((String)properties.get("jrs.timeout_send_email"), false);
        this.timeoutMailFrom = (String)properties.get("jrs.mailfrom");
        if (this.timeoutMailFrom != null && this.timeoutMailFrom.trim().length() == 0) {
            this.timeoutMailFrom = null;
        }
        this.timeoutMailto = (String)properties.get("jrs.mailto");
        if (this.timeoutMailto != null && this.timeoutMailto.trim().length() == 0) {
            this.timeoutMailto = null;
        }
        this.timeoutMailcc = (String)properties.get("jrs.mailcc");
        if (this.timeoutMailcc != null && this.timeoutMailcc.trim().length() == 0) {
            this.timeoutMailcc = null;
        }
        this.timeoutMailbcc = (String)properties.get("jrs.mailbcc");
        if (this.timeoutMailbcc != null && this.timeoutMailbcc.trim().length() == 0) {
            this.timeoutMailbcc = null;
        }
        this.timeoutSubject = (String)properties.get("jrs.mailsubject");
        if (this.timeoutSubject != null && this.timeoutSubject.trim().length() == 0) {
            this.timeoutSubject = null;
        }
        this.timeoutComment = (String)properties.get("jrs.mailcomments");
        if (this.timeoutComment != null && this.timeoutComment.trim().length() == 0) {
            this.timeoutComment = null;
        }
        this.isTimeoutCompress = CSUtil.getBoolean((String)properties.get("jrs.mailcompress"), false);
        if (!ClusterEnv.isClusterEnabled()) {
            int n = CSUtil.parseInt(properties.getProperty("jrs.result_loca_type"), 1);
            boolean bl = n == 1;
            this.rstLoc = (String)properties.get("jrs.result_loca");
            if (this.rstLoc == null || this.rstLoc.trim().length() == 0) {
                this.rstLoc = this.getJRTaskManager().getResourceManager().getTempDir();
                bl = true;
            }
            this.rstLoc = this.getRealDir(this.rstLoc, bl);
        }
        if (this.rstLoc == null || this.rstLoc.trim().length() == 0) {
            this.rstLoc = this.getJRTaskManager().getResourceManager().getTempDir();
        }
        string = (string = (String)properties.get("jrs.result_file_name")) != null && string.trim().length() > 0 ? CSUtil.removeExtName(string) : null;
        this.rstType = CSUtil.getResultType((String)properties.get("jrs.result_type"), 0);
        if (this.rstType == 0 && CSUtil.getBoolean(properties.getProperty("jrs.to_rst_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 1 && CSUtil.getBoolean(properties.getProperty("jrs.to_html_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 2 && CSUtil.getBoolean(properties.getProperty("jrs.to_pdf_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 4 && CSUtil.getBoolean(properties.getProperty("jrs.to_excel_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 3 && CSUtil.getBoolean(properties.getProperty("jrs.to_text_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 6 && CSUtil.getBoolean(properties.getProperty("jrs.to_rtf_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 7 && CSUtil.getBoolean(properties.getProperty("jrs.to_xml_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 5 && CSUtil.getBoolean(properties.getProperty("jrs.to_ps_runLinkedReport"), false)) {
            this.isLinkReport = true;
        } else if (this.rstType == 0 && CSUtil.getBoolean(properties.getProperty("jrs.to_applet_runLinkedReport"), false)) {
            this.isLinkReport = true;
        }
        if (this.rstType == 8) {
            this.rstType = 1;
            this.isDhtml = true;
        }
        this.initViewParameters(this.rstType, properties);
        ExportItem exportItem = this.exportAdvisor.addExportItem(1, this.rstType);
        exportItem.setPrecision(this.getPrecision(this.rstType, properties.getProperty("jrs.result_precision")));
        exportItem.setRunLinkReport(this.isLinkReport);
        String string3 = ".xls";
        if (this.excelFormat == 1) {
            string3 = ".xlsx";
        }
        this.isRealDir = true;
        if (this.hasCheckedSheets && this.rstType != 0) {
            Enumeration enumeration = this.runningRptSheets.getAllReportSheets();
            if (enumeration != null) {
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    String string4;
                    String string5 = (String)enumeration.nextElement();
                    String string6 = SchdTools.getTempFilePrefix();
                    if (this.rstType == 2) {
                        string4 = string != null ? CSUtil.includeExtName(string, ".pdf") : this.IsExportToMultiFiles(this.rstLoc, string6, ".pdf");
                        this.runningRptSheets.addPdfName(string5, string4);
                        this.runningRptSheets.addRstNm(string5, string4);
                        if (n == 0) {
                            this.rstNm = string4;
                        }
                    } else if (this.rstType == 1) {
                        string4 = string != null ? CSUtil.includeExtName(string, ".html") : this.IsExportToMultiFiles(this.rstLoc, string6, ".html");
                        this.runningRptSheets.addHtmName(string5, string4);
                        this.runningRptSheets.addRstNm(string5, string4);
                        if (n == 0) {
                            this.rstNm = string4;
                        }
                    } else if (this.rstType == 5) {
                        string4 = string != null ? CSUtil.includeExtName(string, ".ps") : this.IsExportToMultiFiles(this.rstLoc, string6, ".ps");
                        this.runningRptSheets.addPsName(string5, string4);
                        this.runningRptSheets.addRstNm(string5, string4);
                        if (n == 0) {
                            this.rstNm = string4;
                        }
                    } else if (this.rstType == 6) {
                        string4 = string != null ? CSUtil.includeExtName(string, ".rtf") : this.IsExportToMultiFiles(this.rstLoc, string6, ".rtf");
                        this.runningRptSheets.addRtfName(string5, string4);
                        this.runningRptSheets.addRstNm(string5, string4);
                        if (n == 0) {
                            this.rstNm = string4;
                        }
                    } else if (this.rstType == 3) {
                        string4 = !this.isNormalText && this.isCsv ? ".csv" : ".txt";
                        String string7 = string != null ? CSUtil.includeExtName(string, string4) : this.IsExportToMultiFiles(this.rstLoc, string6, string4);
                        this.runningRptSheets.addTextName(string5, string7);
                        this.runningRptSheets.addRstNm(string5, string7);
                        if (n == 0) {
                            this.rstNm = string7;
                        }
                    } else if (this.rstType == 4) {
                        string4 = string != null ? CSUtil.includeExtName(string, string3) : this.IsExportToMultiFiles(this.rstLoc, string6, string3);
                        this.runningRptSheets.addExcelName(string5, string4);
                        this.runningRptSheets.addRstNm(string5, string4);
                        if (n == 0) {
                            this.rstNm = string4;
                        }
                    } else if (this.rstType == 7) {
                        string4 = string != null ? CSUtil.includeExtName(string, ".xml") : this.IsExportToMultiFiles(this.rstLoc, string6, ".xml");
                        this.runningRptSheets.addXmlName(string5, string4);
                        this.runningRptSheets.addRstNm(string5, string4);
                        if (n == 0) {
                            this.rstNm = string4;
                        }
                    }
                    this.SEDU(string5);
                    ++n;
                }
            }
        } else {
            String string8 = SchdTools.getTempFilePrefix();
            if (this.rstType == 1) {
                this.rstNm = string != null ? CSUtil.includeExtName(string, ".html") : this.IsExportToMultiFiles(this.rstLoc, string8, ".html");
            } else if (this.rstType == 0) {
                this.rstNm = string != null ? CSUtil.includeExtName(string, ".rst") : this.IsExportToMultiFiles(this.rstLoc, string8, ".rst");
            } else if (this.rstType == 2) {
                this.rstNm = string != null ? CSUtil.includeExtName(string, ".pdf") : this.IsExportToMultiFiles(this.rstLoc, string8, ".pdf");
            } else if (this.rstType == 3) {
                String string9 = !this.isNormalText && this.isCsv ? ".csv" : ".txt";
                this.rstNm = string != null ? CSUtil.includeExtName(string, string9) : this.IsExportToMultiFiles(this.rstLoc, string8, string9);
            } else {
                this.rstNm = this.rstType == 4 ? (string != null ? CSUtil.includeExtName(string, string3) : this.IsExportToMultiFiles(this.rstLoc, string8, string3)) : (this.rstType == 5 ? (string != null ? CSUtil.includeExtName(string, ".ps") : this.IsExportToMultiFiles(this.rstLoc, string8, ".ps")) : (this.rstType == 6 ? (string != null ? CSUtil.includeExtName(string, ".rtf") : this.IsExportToMultiFiles(this.rstLoc, string8, ".rtf")) : (this.rstType == 7 ? (string != null ? CSUtil.includeExtName(string, ".xml") : this.IsExportToMultiFiles(this.rstLoc, string8, ".xml")) : (string != null ? CSUtil.includeExtName(string, SchdTools.TEMP_FILE_SUFF) : this.IsExportToMultiFiles(this.rstLoc, string8, SchdTools.TEMP_FILE_SUFF)))));
            }
            this.SEDU(null);
        }
        this.setServerInfo(properties);
        this.addElement(properties);
    }

    @Override
    protected void initCurrentReportToDisk() {
        String string = SchdTools.getTempFilePrefix();
        if (this.rstType == 1) {
            this.runningRptSheets.addHtmDir(this.currentReport, this.htmDir);
            this.runningRptSheets.addHtmName(this.currentReport, this.htmName);
        } else if (this.rstType == 2) {
            this.runningRptSheets.addPdfDir(this.currentReport, this.pdfDir);
            this.runningRptSheets.addPdfName(this.currentReport, this.pdfName);
        } else if (this.rstType == 3) {
            this.runningRptSheets.addTextDir(this.currentReport, this.txtDir);
            this.runningRptSheets.addTextName(this.currentReport, this.txtName);
        } else if (this.rstType == 4) {
            this.runningRptSheets.addExcelDir(this.currentReport, this.xlsDir);
            this.runningRptSheets.addExcelName(this.currentReport, this.xlsName);
        } else if (this.rstType == 5) {
            this.runningRptSheets.addPsDir(this.currentReport, this.psDir);
            this.runningRptSheets.addPsName(this.currentReport, this.psName);
        } else if (this.rstType == 6) {
            this.runningRptSheets.addRtfDir(this.currentReport, this.rtfDir);
            this.runningRptSheets.addRtfName(this.currentReport, this.rtfName);
        } else if (this.rstType == 7) {
            this.runningRptSheets.addXmlDir(this.currentReport, this.xmlDir);
            this.runningRptSheets.addXmlName(this.currentReport, this.xmlName);
        }
    }

    @Override
    protected void exportToDisk() throws Exception {
        JROndemandReportRecord jROndemandReportRecord;
        if (this.rstType == 0) {
            if (this.engineContext.isPageAcl()) {
                this.appendError(JCliResource.getMessage("CS_MSG_141"));
            } else {
                this.exportToRst(true, this.zipResult);
                this.runningRptSheets.getResultFiles().add(this.rstf);
            }
        }
        if ((jROndemandReportRecord = (JROndemandReportRecord)HttpUtil.getHttpRptServer().getOndemandReportManager().getOndemandReportRecord(this.addPdfName)) != null) {
            jROndemandReportRecord.addResultFiles(this.runningRptSheets.getResultFiles());
        }
    }

    private void SEDU(String string) throws Exception {
        String string2;
        String string3 = this.getRealCat();
        String string4 = this.getRealRpt();
        String string5 = this.rstNm;
        if (string != null) {
            string5 = this.runningRptSheets.getPropOfSheet(string, "rstNm");
        }
        String string6 = null;
        if (string5 == null || string5.trim().length() == 0) {
            string5 = null;
            string6 = CSUtil.getNameWithoutExt(string4);
        }
        switch (this.rstType) {
            case 1: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", ".html");
                }
                if (string == null) {
                    this.htmDir = this.rstLoc;
                    this.htmName = string5;
                    break;
                }
                this.runningRptSheets.addHtmDir(string, this.rstLoc);
                this.runningRptSheets.addHtmName(string, string5);
                break;
            }
            case 2: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", ".pdf");
                }
                if (string == null) {
                    this.pdfDir = this.rstLoc;
                    this.pdfName = string5;
                    break;
                }
                this.runningRptSheets.addPropForSheet(string, "pdfDir", this.rstLoc);
                this.runningRptSheets.addPropForSheet(string, "pdfName", string5);
                break;
            }
            case 3: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", !this.isNormalText && this.isCsv ? ".csv" : ".txt");
                }
                if (string == null) {
                    this.txtDir = this.rstLoc;
                    this.txtName = string5;
                    break;
                }
                this.runningRptSheets.addTextDir(string, this.rstLoc);
                this.runningRptSheets.addTextName(string, string5);
                break;
            }
            case 4: {
                if (string5 == null) {
                    string2 = ".xls";
                    if (this.excelFormat == 1) {
                        string2 = ".xlsx";
                    }
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", string2);
                }
                if (string == null) {
                    this.xlsDir = this.rstLoc;
                    this.xlsName = string5;
                    break;
                }
                this.runningRptSheets.addExcelDir(string, this.rstLoc);
                this.runningRptSheets.addExcelName(string, string5);
                break;
            }
            case 5: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", ".ps");
                }
                if (string == null) {
                    this.psDir = this.rstLoc;
                    this.psName = string5;
                    break;
                }
                this.runningRptSheets.addPsDir(string, this.rstLoc);
                this.runningRptSheets.addPsName(string, string5);
                break;
            }
            case 6: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", ".rtf");
                }
                if (string == null) {
                    this.rtfDir = this.rstLoc;
                    this.rtfName = string5;
                    break;
                }
                this.runningRptSheets.addRtfDir(string, this.rstLoc);
                this.runningRptSheets.addRtfName(string, string5);
                break;
            }
            case 7: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", ".xml");
                }
                if (string == null) {
                    this.xmlDir = this.rstLoc;
                    this.xmlName = string5;
                    break;
                }
                this.runningRptSheets.addXmlDir(string, this.rstLoc);
                this.runningRptSheets.addXmlName(string, string5);
                break;
            }
            default: {
                if (string5 == null) {
                    string5 = this.IsExportToMultiFiles(this.rstLoc, string6 + "_", ".rst");
                }
                this.rstDir = this.rstLoc;
                this.rstName = string5;
            }
        }
        if (string5 == null) {
            throw new Exception(JCliResource.getMessage("CS_ERR_47"));
        }
        string2 = this.checkRealDir(this.rstLoc, this.isRealDir);
        if (string2 != null) {
            string2 = string2 + string5;
        }
        if (string != null) {
            this.runningRptSheets.addPropForSheet(string, "tmpRst", string2);
        } else {
            this.tmpRst = string2;
        }
    }

    public int getResultType() {
        return this.rstType;
    }

    public String getResultLoc() {
        return this.rstLoc;
    }

    public String getResultName() {
        return this.rstNm;
    }

    public String getResult() {
        String string = "";
        if (this.hasCheckedSheets && this.rstType != 0) {
            Enumeration enumeration = this.runningRptSheets.getAllReportSheets();
            if (enumeration != null && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = this.runningRptSheets.getPropOfSheet(string2, "tmpRst");
            }
        } else {
            string = this.tmpRst;
        }
        return string;
    }

    public String getHtmlResult() {
        String string = "";
        if (this.hasCheckedSheets && this.rstType != 0) {
            Enumeration enumeration = this.runningRptSheets.getAllReportSheets();
            if (enumeration != null && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = this.runningRptSheets.getPropOfSheet(string2, "tmpRst");
            }
        } else {
            string = this.tmpRst;
        }
        if (string.indexOf(".") > 0 && string.lastIndexOf(".html") > 0) {
            string = string.substring(0, string.lastIndexOf(".html"));
        }
        if (this.htmlParams.IsExportToMultiFiles()) {
            return string + "_1.html";
        }
        return string + ".html";
    }

    @Override
    protected void beforeRun() throws Exception {
        super.beforeRun();
    }

    protected void setFiles() throws Exception {
        String string = this.rstNm;
        String string2 = null;
        if (this.rstNm == null || this.rstNm.trim().length() == 0) {
            string = null;
            string2 = CSUtil.getNameWithoutExt(this.getRealRpt());
        }
        switch (this.rstType) {
            case 1: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", ".html");
                }
                this.htmDir = this.rstLoc;
                this.htmName = string;
                break;
            }
            case 2: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", ".pdf");
                }
                this.pdfDir = this.rstLoc;
                this.pdfName = string;
                break;
            }
            case 3: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", !this.isNormalText && this.isCsv ? ".csv" : ".txt");
                }
                this.txtDir = this.rstLoc;
                this.txtName = string;
                break;
            }
            case 4: {
                if (string == null) {
                    String string3 = ".xls";
                    if (this.excelFormat == 1) {
                        string3 = ".xlsx";
                    }
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", string3);
                }
                this.xlsDir = this.rstLoc;
                this.xlsName = string;
                break;
            }
            case 5: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", ".ps");
                }
                this.psDir = this.rstLoc;
                this.psName = string;
                break;
            }
            case 6: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", ".rtf");
                }
                this.rtfDir = this.rstLoc;
                this.rtfName = string;
                break;
            }
            case 7: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", ".xml");
                }
                this.xmlDir = this.rstLoc;
                this.xmlName = string;
                break;
            }
            default: {
                if (string == null) {
                    string = this.IsExportToMultiFiles(this.rstLoc, string2 + "_", ".rst");
                }
                this.rstDir = this.rstLoc;
                this.rstName = string;
            }
        }
        if (string == null) {
            throw new Exception(JCliResource.getMessage("CS_ERR_47"));
        }
        try {
            this.tmpRst = this.checkRealDir(this.rstLoc, this.isRealDir);
        }
        catch (Exception exception) {
            this.tmpRst = null;
        }
        if (this.tmpRst != null) {
            this.tmpRst = this.tmpRst + string;
        }
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (this.rstLoc != null) {
            properties2.put("jrs.result_loca", this.rstLoc);
        }
        properties2.put("jrs.result_type", String.valueOf(this.rstType));
        properties2.put("jrs.timeout_send_email", String.valueOf(this.isTimeoutSendEmail));
        if (this.isTimeoutSendEmail) {
            if (this.timeoutMailFrom != null) {
                properties2.put("jrs.mailfrom", this.timeoutMailFrom);
            }
            if (this.timeoutMailto != null) {
                properties2.put("jrs.mailto", this.timeoutMailto);
            }
            if (this.timeoutMailcc != null) {
                properties2.put("jrs.mailcc", this.timeoutMailcc);
            }
            if (this.timeoutMailbcc != null) {
                properties2.put("jrs.mailbcc", this.timeoutMailbcc);
            }
            if (this.timeoutSubject != null) {
                properties2.put("jrs.mailsubject", this.timeoutSubject);
            }
            if (this.timeoutComment != null) {
                properties2.put("jrs.mailcomments", this.timeoutComment);
            }
            properties2.put("jrs.mailcompress", String.valueOf(this.isTimeoutCompress));
        }
        return properties2;
    }

    @Override
    protected boolean isSupportToRST() {
        return false;
    }

    private Vector TEMP_FILE_SUFF() {
        Vector<String> vector = null;
        File file = new File(this.rstLoc);
        String[] stringArray = file.list((FilenameFilter)new WildcardMatcher(this.rstNm + "*", false));
        if (stringArray.length > 0) {
            vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(".") <= 0 || this.isHtmlPipeLine() && (stringArray[i].indexOf("css") >= 0 || stringArray[i].indexOf("tmp") >= 0)) continue;
                vector.addElement(this.rstLoc + stringArray[i]);
            }
        }
        return vector;
    }

    @Override
    public void sendEmail(boolean bl) throws Throwable {
        if (!bl && this.isHtmlPipeLine()) {
            return;
        }
        if (this.isTimeoutSendEmail) {
            mail mail2 = new mail(null, null, new ExportAuxInfo(this.getResourceStore().getDiskStore()));
            try {
                if (this.hasError()) {
                    this.timeoutSubject = JSvrResource.getMessage("TASK_FAIL_MAIL_SUBJECT", this.rpt);
                }
                if (this.timeoutMailFrom != null) {
                    mail2.send(this.timeoutMailFrom, this.timeoutMailto, this.timeoutMailcc, this.timeoutMailbcc, this.timeoutSubject, this.timeoutComment == null ? "" : this.timeoutComment, this.isTimeoutCompress, -1, this.hasError() ? null : this.TEMP_FILE_SUFF());
                } else {
                    mail2.send(this.timeoutMailto, this.timeoutMailcc, this.timeoutMailbcc, this.timeoutSubject, this.timeoutComment == null ? "" : this.timeoutComment, this.isTimeoutCompress, -1, this.hasError() ? null : this.TEMP_FILE_SUFF());
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    @Override
    public void exit(String string) {
        if (string != null) {
            this.getRunRptThread(string).exit();
            if (this.isPipeLineFinished()) {
                this.exit();
            }
        } else {
            this.exit();
        }
    }

    @Override
    public void stopReport(String string) {
        if (string != null) {
            this.getRunRptThread(string).stopReport();
        } else {
            this.stopReport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit() {
        Serializable serializable;
        ReportSheetRunner[] reportSheetRunnerArray;
        if (this.isHtmlPipeLine() && !this.isPipeLineFinished) {
            this.isPipeLineFinished = true;
            this.getJRTaskManager().removePipelineFilenames(this.htmName.substring(0, this.htmName.length() - ".html".length()));
            try {
                reportSheetRunnerArray = this.getFilenames();
                List list = (List)reportSheetRunnerArray.remove(-1);
                String string = this.reportSetEngine.getLastPage();
                HtmlPipeFileNamesImpl htmlPipeFileNames = new HtmlPipeFileNamesImpl(this.engineContext.isLocal(), this.getRunName(), this.getRunPort(), (HashMap)reportSheetRunnerArray, string);
                htmlPipeFileNames.setTempPaths(this.reportSetEngine.isSharedTemp(), this.reportSetEngine.getTempPath(), this.htmDir);
                serializable = (JROndemandReportRecord)HttpUtil.getHttpRptServer().getOndemandReportManager().getOndemandReportRecord(this.getOndemandID());
                if (list != null && serializable != null) {
                    ((JROndemandReportRecord)serializable).addResultFiles(list);
                }
                this.getJRTaskManager().addPipelineFilenames(this.htmName.substring(0, this.htmName.length() - ".html".length()), htmlPipeFileNames);
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
            finally {
                for (ReportSheetRunner reportSheetRunner : this.runRptLaunchers) {
                    reportSheetRunner.engineExit(false, false);
                    reportSheetRunner.free();
                }
            }
        }
        try {
            this.sendEmail(true);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        reportSheetRunnerArray = this.getHtmlResult();
        this.getJRTaskManager().completeOndemand(this.addPdfName);
        if (this.hasError()) {
            String string = this.getErrorMsg();
            this.getJRTaskManager().completeRslt(new File((String)reportSheetRunnerArray).getName(), string == null ? "" : string);
        } else {
            this.getJRTaskManager().completeRslt(new File((String)reportSheetRunnerArray).getName(), new Boolean(true));
        }
        this.getJRTaskManager().delToMonitorRunningReport(this.getId());
        this.getJRTaskManager().decRptTaskRef(this);
        this.addRunTimeValueToProperties(this.serverInfo.getTaskProperties());
        if (this.engineContext != null) {
            try {
                if (this.hasListener && this.taskListener != null) {
                    String string = this.engineContext.getLocalHost();
                    String string2 = this.engineContext.getLocalPort();
                    boolean bl = this.engineContext.isLocal();
                    serializable = this.serverInfo.getTaskProperties();
                    if (serializable == null) {
                        serializable = new Properties();
                    }
                    if (string != null) {
                        ((Properties)serializable).put("jrs.exec_host", string);
                    }
                    if (string2 != null) {
                        ((Properties)serializable).put("jrs.exec_port", string2);
                    }
                    ((Properties)serializable).put("jrs.is_local", bl + "");
                    this.taskListener.afterRun(this.serverInfo);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            try {
                this.engineExit();
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError((Throwable)((Object)rptServerException));
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
        }
        this.engineContext = null;
    }

    @Override
    protected void afterRun() throws RemoteException {
        if (!this.isHtmlPipeLine()) {
            super.afterRun();
        } else {
            this.getJRTaskManager().addRunningTaskToMonitor(this.getSequenceID(), this.getId(), "", "-1", -1L, 8);
        }
        this.addExcelDir();
    }

    @Override
    public void stopExec() {
        this.stopExec(false);
    }

    @Override
    public void stopExec(boolean bl) {
        if (this.isHtmlPipeLine() && this.runRptLaunchers[0].getReportEngine() != null) {
            try {
                this.runRptLaunchers[0].getReportEngine().filenamesExit();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        super.stopExec(bl);
    }

    public boolean isPipeLineFinished() {
        boolean bl = true;
        for (int i = 0; i < this.runRptLaunchers.length; ++i) {
            if (this.runRptLaunchers[i].isPipeLineFinished()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void addElement(Properties properties) {
        this.SEDU = CSUtil.getBoolean((String)properties.get("jrs.auto_archive"));
        if (this.SEDU) {
            String[] stringArray;
            this.TEMP_FILE_SUFF = CSUtil.getBoolean((String)properties.get("jrs.enable_archive_policy"), false);
            if (this.TEMP_FILE_SUFF) {
                this.addExcelName = (String)properties.get("jrs.archive_new_version");
            }
            this.addExportItem = (String)properties.get("jrs.maxversion");
            if (CSUtil.getBoolean((String)properties.get("jrs.need_expire"), false)) {
                this.addHtmName = CSUtil.parseInt((String)properties.get("jrs.auto_delete_method"), -1);
                if (this.addHtmName == 0) {
                    stringArray = new GregorianCalendar();
                    stringArray.add(5, CSUtil.parseInt((String)properties.get("jrs.expire_days")));
                    this.IsExportToMultiFiles = new Date(stringArray.getTime().getTime());
                } else if (this.addHtmName == 1) {
                    int n = CSUtil.parseInt((String)properties.get("jrs.auto_delete_year"), 1900) - 1900;
                    int n2 = CSUtil.parseInt((String)properties.get("jrs.auto_delete_month"), 1) - 1;
                    int n3 = CSUtil.parseInt((String)properties.get("jrs.auto_delete_date"), 0);
                    this.IsExportToMultiFiles = new Date(n, n2, n3);
                }
            }
            this.add = CSUtil.parseInt((String)properties.get("jrs.archive_location"), 0);
            stringArray = new String[]{null, null};
            if (this.add == 1) {
                String string = (String)properties.get("jrs.archive_my_destination");
                stringArray = CSUtil.getLogicalFolderAndName(string);
                this.addElement = stringArray[0];
                this.addExcelDir = stringArray[1];
            } else if (this.add == 2 || this.add == 3) {
                String string = null;
                string = this.add == 2 ? (String)properties.get("jrs.archive_public_destination") : (String)properties.get("jrs.archive_organization_destination");
                stringArray = CSUtil.getLogicalFolderAndName(string);
                this.addElement = stringArray[0];
                if (this.addElement == null || this.addElement.length() == 0) {
                    this.addElement = "/";
                }
                this.addExcelDir = stringArray[1];
                this.addHtmDir = (Hashtable[])properties.get("jrs.permission_values");
            }
            this.addPdfDir = (String)properties.get("jrs.archive_specified_destination");
        }
    }

    public Date getExpiredTime() {
        return this.IsExportToMultiFiles;
    }

    public int getCatVerNum() {
        return this.catVerNum;
    }

    public int getRptVerNum() {
        return this.rptVerNum;
    }

    public boolean getAutoArchive() {
        return this.SEDU;
    }

    public String getOndemandID() {
        return this.addPdfName;
    }

    public void setOndemandID(String string) {
        this.addPdfName = string;
    }

    public int getArchiveLocation() {
        return this.add;
    }

    public String getFolderPath() {
        return this.addElement;
    }

    public String getResourceName() {
        return this.addExcelDir;
    }

    public String getArchiveNewVersion() {
        return this.addExcelName;
    }

    public String getMaxVersion() {
        return this.addExportItem;
    }

    public Hashtable[] getPermissionValues() {
        return this.addHtmDir;
    }

    public int getAutoExpiredMethod() {
        return this.addHtmName;
    }

    public String getSpecifiedFolder() {
        return this.addPdfDir;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void addExcelDir() {
        boolean bl = this.getAutoArchive();
        if (bl) {
            Object object;
            String string = "";
            String string2 = "";
            Properties properties = new Properties();
            String string3 = null;
            int n = 0;
            String string4 = "";
            long l = 0L;
            int n2 = 0;
            string = this.getUid();
            n = this.getResultType();
            if (this.hasCheckedSheets) {
                object = new StringBuffer();
                if (n != 0) {
                    Enumeration enumeration = this.runningRptSheets.getAllReportSheets();
                    if (enumeration != null) {
                        int n3 = 0;
                        while (enumeration.hasMoreElements()) {
                            String string5 = (String)enumeration.nextElement();
                            switch (n) {
                                case 1: {
                                    string3 = this.runningRptSheets.getHtmFile(string5);
                                    string4 = ".html";
                                    break;
                                }
                                case 2: {
                                    string3 = this.runningRptSheets.getPdfFile(string5);
                                    string4 = ".pdf";
                                    break;
                                }
                                case 3: {
                                    string3 = this.runningRptSheets.getTextFile(string5);
                                    string4 = !this.isNormalText && this.isCsv ? ".csv" : ".txt";
                                    break;
                                }
                                case 4: {
                                    string3 = this.runningRptSheets.getExcelFile(string5);
                                    if (this.excelFormat == 1) {
                                        string4 = ".xlsx";
                                        break;
                                    }
                                    string4 = ".xls";
                                    break;
                                }
                                case 5: {
                                    string3 = this.runningRptSheets.getPsFile(string5);
                                    string4 = ".ps";
                                    break;
                                }
                                case 6: {
                                    string3 = this.runningRptSheets.getRtfFile(string5);
                                    string4 = ".rtf";
                                    break;
                                }
                                case 7: {
                                    string3 = this.runningRptSheets.getXmlFile(string5);
                                    string4 = ".xml";
                                }
                            }
                            string3 = CSUtil.removeExtName(string3);
                            string3 = this.taskManager.getResourceManager().getArchiveRstByRealPath(string3, string);
                            properties.put("jrs.report_sheet$" + string5, "true");
                            properties.put("SheetDisplayName:$" + string5, this.runningRptSheets.getReportSheetDisplayName(string5));
                            properties.put(string5, string3);
                            if (n3 == 0) {
                                JRResultFiles jRResultFiles = new JRResultFiles(this.runningRptSheets.getPropOfSheet(string5, "rstNm"), string4, 0L, 0L, 0L);
                                l = jRResultFiles.getResultFormats();
                                properties.put("jrs.result_type", String.valueOf(l));
                            }
                            ++n3;
                        }
                    }
                } else {
                    Object object2;
                    string3 = this.getRstFile();
                    string3 = CSUtil.removeExtName(string3);
                    string3 = this.taskManager.getResourceManager().getArchiveRstByRealPath(string3, string);
                    string4 = ".rst";
                    Enumeration enumeration = this.runningRptSheets.getAllReportSheets();
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        object2 = (String)enumeration.nextElement();
                        properties.put("jrs.report_sheet$" + (String)object2, "true");
                        properties.put("SheetDisplayName:$" + (String)object2, this.runningRptSheets.getReportSheetDisplayName((String)object2));
                        properties.put(object2, string3);
                    }
                    properties.put("jrs.rst_result", string3);
                    object2 = new JRResultFiles(string3, string4, 0L, 0L, 0L);
                    l = ((JRResultFiles)object2).getResultFormats();
                    properties.put("jrs.result_type", String.valueOf(l));
                }
                properties.put("jrs.result", ((StringBuffer)object).toString());
            } else {
                switch (n) {
                    case 1: {
                        string3 = this.getHtmlResult();
                        string4 = ".html";
                        break;
                    }
                    case 2: {
                        string3 = this.getPdfDir() + File.separator + this.getPdfName();
                        string4 = ".pdf";
                        break;
                    }
                    case 3: {
                        string3 = this.getTxtDir() + File.separator + this.getTxtName();
                        string4 = !this.isNormalText && this.isCsv ? ".csv" : ".txt";
                        break;
                    }
                    case 4: {
                        string3 = this.getExcelFile();
                        if (this.excelFormat == 1) {
                            string4 = ".xlsx";
                            break;
                        }
                        string4 = ".xls";
                        break;
                    }
                    case 5: {
                        string3 = this.getPsDir() + File.separator + this.getPsName();
                        string4 = ".ps";
                        break;
                    }
                    case 6: {
                        string3 = this.getRtfDir() + File.separator + this.getRtfName();
                        string4 = ".rtf";
                        break;
                    }
                    case 7: {
                        string3 = this.getResult();
                        string4 = ".xml";
                        break;
                    }
                    case 0: {
                        string3 = this.getRstFile();
                        string4 = ".rst";
                        break;
                    }
                    default: {
                        string3 = "";
                    }
                }
                object = new JRResultFiles(this.getResultName(), string4, 0L, 0L, 0L);
                l = ((JRResultFiles)object).getResultFormats();
                string3 = this.taskManager.getResourceManager().getArchiveRstByRealPath(string3, string);
                properties.put("jrs.result", string3);
                properties.put("jrs.result_type", String.valueOf(l));
            }
            try {
                properties.put("jrs.node_type", String.valueOf(1));
                properties.put("jrs.node_name", this.getResultName());
                properties.put("jrs.node_desc", "");
                if (this.getCatalog() != null) {
                    properties.put("jrs.catalog", this.getCatalog());
                }
                properties.put("jrs.report", this.getReport());
                if (this.getParamFile() != null) {
                    object = this.getParamFile();
                    object = this.taskManager.getResourceManager().getFileWithoutHistDir((String)object);
                    properties.put("jrs.param_file", object);
                }
                if ((object = this.getExpiredTime()) != null) {
                    properties.put("jrs.expired_time", object);
                    properties.put("jrs.auto_delete_method", String.valueOf(this.getAutoExpiredMethod()));
                }
                properties.put("jrs.cat_version", String.valueOf(this.getCatVerNum()));
                properties.put("jrs.rpt_version", String.valueOf(this.getRptVerNum()));
                properties.put("jrs.enable_archive_policy", String.valueOf(this.isEnableArchivePolicy()));
                if (this.getArchiveNewVersion() != null) {
                    properties.put("jrs.archive_new_version", this.getArchiveNewVersion());
                }
                if (this.getMaxVersion() != null) {
                    properties.put("jrs.maxversion", this.getMaxVersion());
                }
                if (this.getPermissionValues() != null) {
                    properties.put("jrs.permission_values", this.getPermissionValues());
                }
                if (this.getSpecifiedFolder() != null) {
                    properties.put("jrs.archive_specified_destination", this.getSpecifiedFolder());
                }
                string2 = this.getReport();
                n2 = this.getArchiveLocation();
                if (n2 == 0) {
                    this.taskManager.getResourceManager().addResultInReport(string, string2, properties);
                } else {
                    properties.put("jrs.node_name", this.getResourceName());
                    this.checkResultFolder(this.getFolderPath(), string);
                    this.taskManager.getResourceManager().addResource(string, this.getFolderPath(), properties);
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            this.deleteParamFile(false);
        } else {
            this.deleteParamFile(true);
        }
    }

    public void deleteParamFile(boolean bl) {
        File file;
        String string;
        if (bl && (string = this.getParamFile()) != null && string.length() != 0) {
            file = new File(string);
            file.delete();
        }
        if ((string = this.getDParamFile()) != null && string.length() != 0) {
            file = new File(string);
            file.delete();
        }
    }

    @Override
    void exportToDisk(ExportItem exportItem) throws Exception {
        this.isRealDir = true;
        if (this.rstType == 0) {
            if (this.engineContext.isPageAcl()) {
                this.appendError(JCliResource.getMessage("CS_MSG_141"));
            } else {
                this.exportToRst(true, this.zipResult);
                this.runningRptSheets.getResultFiles().add(this.rstf);
            }
        } else if (this.rstType == 2) {
            this.exportToPdf(this.runningRptSheets.getPdfDir(this.sheets[0]), this.runningRptSheets.getPdfName(this.sheets[0]), this.getPDFParameter(), false);
        } else if (this.rstType == 1) {
            this.exportToHtml(this.runningRptSheets.getHtmDir(this.sheets[0]), this.runningRptSheets.getHtmName(this.sheets[0]), this.getHtmlParameter(), false);
        } else if (this.rstType == 5) {
            this.exportToPs(this.runningRptSheets.getPsDir(this.sheets[0]), this.runningRptSheets.getPsName(this.sheets[0]), this.getPSParameter(), false);
        } else if (this.rstType == 6) {
            this.exportToRtf(this.runningRptSheets.getRtfDir(this.sheets[0]), this.runningRptSheets.getRtfName(this.sheets[0]), this.getRtfParameter(), false);
        } else if (this.rstType == 3) {
            this.exportToText(this.runningRptSheets.getTextDir(this.sheets[0]), this.runningRptSheets.getTextName(this.sheets[0]), this.getTextParameter(), false);
        } else if (this.rstType == 4) {
            this.exportToXls(this.runningRptSheets.getExcelDir(this.sheets[0]), this.runningRptSheets.getExcelName(this.sheets[0]), this.getExcelParameter(), false);
        } else if (this.rstType == 7) {
            this.exportToXml(this.runningRptSheets.getXmlDir(this.sheets[0]), this.runningRptSheets.getXmlName(this.sheets[0]), this.getXmlParameter(), false);
        }
        this.runningRptSheets.addResultFiles(this.reportSetEngine.getResultFiles());
    }

    @Override
    void exportToVersion(ExportItem exportItem) {
    }

    @Override
    void exportToFax(ExportItem exportItem) {
    }

    @Override
    void exportToPrint(ExportItem exportItem) {
    }

    @Override
    void exportToFTP(ExportItem exportItem) {
    }

    @Override
    void exportToMail(ExportItem exportItem) throws Exception {
    }
}

