/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.rmi.NotBoundException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import jet.JCliResource;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.PathInfo;
import jet.server.api.RemoteFileService;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.SendFileAuthorizorFactory;
import jet.server.api.http.TooManyTimesException;
import jet.server.intf.jrs.ExResourceManager;
import jet.server.intf.version.PlsResultManager;
import jet.server.intf.version.RemotePlsResultManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.version.PlsResultManagerRemoteImpl;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrserver.JRResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.UnavailableStorageException;
import jet.server.util.HtmlEncoder;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;

public class SendFileServlet
extends HttpServlet {
    private String C = null;
    private boolean HISTORY = false;
    private String SEDU = null;
    private String TEMP = null;
    private PlsResultManager append = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            String string = this.getInitParameter("isConvertedServletPath");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.HISTORY = true;
            }
            if ((string = this.getInitParameter("output_encoding")) != null && string.length() > 0) {
                try {
                    "1".getBytes(string);
                    this.SEDU = string;
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                    jet.server.log.ServiceLogger.logError(2680001, this.SEDU, 2);
                }
            }
            this.C = this.getInitParameter("auth_scheme");
            if (this.C != null) {
                this.C = this.C.trim();
                if (this.C.equalsIgnoreCase("Digest")) {
                    this.C = "Digest";
                } else if (this.C.equalsIgnoreCase("Basic")) {
                    this.C = "Basic";
                } else {
                    this.C = HttpUtil.getAuthScheme();
                    if (this.C == null) {
                        this.C = "Basic";
                        jet.server.log.ServiceLogger.logError(2680002, "Basic", 2);
                    }
                }
            } else {
                this.C = HttpUtil.getAuthScheme();
                if (this.C == null) {
                    this.C = "Basic";
                    jet.server.log.ServiceLogger.logError(2680002, "Basic", 2);
                }
            }
        }
        catch (ServletException servletException) {
            jet.server.log.ServiceLogger.logError(servletException);
        }
        catch (Throwable throwable) {
            jet.server.log.ServiceLogger.logError(throwable);
        }
        jet.server.log.ServiceLogger.logEvent(4680003, new Object[]{this.C, String.valueOf(this.HISTORY), "output_encoding", this.SEDU}, 4);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.action(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.action(httpServletRequest, httpServletResponse);
    }

    private boolean C(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpRptServer httpRptServer) throws Throwable {
        boolean bl = false;
        String string2 = string.toLowerCase();
        int n = string2.indexOf("/result/");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            PathInfo pathInfo = null;
            try {
                httpRptServer.getResourceManager().getPathInfo(HttpUtil.getUser(httpServletRequest), string3);
            }
            catch (RptServerException rptServerException) {
                pathInfo = null;
            }
            if (pathInfo != null && pathInfo.isReport()) {
                this.checkRealPath(httpServletRequest, httpServletResponse, string.substring(n + "/result/".length()), properties, httpRptServer);
                bl = true;
            }
        }
        return bl;
    }

    private synchronized void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        block39: {
            Object object;
            String string;
            Object object2;
            String string2;
            long l = System.currentTimeMillis();
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            if (httpRptServer == null) {
                HttpUtil.initEnv(System.getProperties());
                httpRptServer = HttpUtil.getHttpRptServer();
            }
            httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest, CSUtil.parseInt(httpServletRequest.getParameter("memberId"), -1));
            if (this.append == null) {
                if (HttpUtil.isRemoteServer()) {
                    string2 = System.getProperty("jrs.remote.host");
                    int n = CSUtil.parseInt(System.getProperty("jrs.remote.rmiport"), 1129);
                    try {
                        object2 = (RemotePlsResultManager)RemoteObjectFactory.getRemoteObject(string2, n, "PlsResultManager");
                        string = httpRptServer.getResourceManager().getHistDir();
                        this.append = new PlsResultManagerRemoteImpl((RemotePlsResultManager)object2, httpRptServer.getRemoteFileService(), string);
                    }
                    catch (NotBoundException notBoundException) {
                        ServiceLogger.logError(notBoundException);
                    }
                } else {
                    this.append = UserDataToolkit.getPlsResultManager();
                }
            }
            if ((string2 = httpServletRequest.getPathInfo()) != null && !string2.equals("/META-INF/services/javax.print.PrintServiceLookup")) {
                try {
                    httpRptServer.getHttpUserSessionManager().removeExpiredUserSessions(httpServletRequest);
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                }
            }
            try {
                object = httpRptServer.getHttpUserSessionManager().getUserSession(httpServletRequest);
                if (object != null) {
                    object.refreshLastAccessTime();
                }
            }
            catch (Throwable throwable) {
                jet.server.log.ServiceLogger.logError(throwable);
            }
            try {
                boolean bl;
                object = this.TEMP(httpServletRequest);
                object2 = HttpUtil.getParameters(httpServletRequest);
                string = (String)((Properties)object2).get("jrs.cmd");
                if (string != null) {
                    string = string.trim().toLowerCase();
                }
                jet.server.log.ServiceLogger.logEvent(6680004, new Object[]{string, object, object2}, 6);
                if (string != null && string.equalsIgnoreCase("jrs.wait_user")) {
                    if ((String)((Properties)object2).get("B2") != null) {
                        SendFileServlet.encode(httpServletRequest, httpServletResponse, JCliResource.getMessage("CS_MSG_151"));
                        return;
                    }
                    object = (String)((Properties)object2).get("path");
                }
                if ((String)((Properties)object2).get("left") != null) {
                    this.TEMP = (String)((Properties)object2).get("left");
                }
                if (!(bl = httpRptServer.getHttpUserSessionManager().checkLogin(httpServletRequest, httpServletResponse, httpRptServer.getResourceManager().getRealm(), (Properties)object2)) && !((String)object).startsWith("/help/")) {
                    httpRptServer.getHttpUserSessionManager().sendUnauthorizedResponse(httpServletRequest, httpServletResponse, this.C, httpRptServer.getResourceManager().getRealm());
                    return;
                }
                if (string != null && string.equalsIgnoreCase("jrs.wait_user")) {
                    SendFileServlet.encode(httpServletRequest, httpServletResponse, JCliResource.getMessage("CS_MSG_152"));
                    return;
                }
                if (string != null && string.length() > 0) {
                    UserSession userSession = httpRptServer.getHttpUserSessionManager().getUserSession(httpServletRequest);
                    if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(userSession.getRealm(), userSession.getUserID(), (String)object, string)) {
                        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_4") + (String)object);
                        return;
                    }
                    this.charAt(string, (Properties)object2, httpServletRequest, httpServletResponse, httpRptServer);
                    break block39;
                }
                if (HttpUtil.isRemoteServer()) {
                    this.currentTimeMillis(httpServletRequest, httpServletResponse, (String)object, (Properties)object2, httpRptServer);
                    if (((String)object).startsWith("/history/") && ((Properties)object2).get("jrs.result_type") != null) {
                        this.HISTORY(httpServletRequest, (Hashtable)object2);
                    }
                    return;
                }
                Object object3 = object;
                jet.server.log.ServiceLogger.logDebug(6680005, object, 6);
                File file = this.SEDU(httpServletRequest, httpServletResponse, (String)object3, (Properties)object2, httpRptServer);
                jet.server.log.ServiceLogger.logDebug(6680006, file, 6);
                if (file == null) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, HtmlEncoder.encode((String)object3) + " not found!");
                    return;
                }
                boolean bl2 = JRRptServer.hasPageSecurity(file.getPath());
                if (bl2) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                    return;
                }
                String string3 = ((String)object).toLowerCase();
                int n = string3.indexOf("/result/");
                if (n >= 0) {
                    string3 = ((String)object).substring(n + "/result/".length());
                }
                String string4 = file.getName();
                String string5 = "";
                n = string4.lastIndexOf(46);
                if (n > 0) {
                    string5 = string4.substring(n);
                }
                String string6 = httpRptServer.getResourceManager().getMIMEType(string5);
                jet.server.log.ServiceLogger.logDebug(6680007, string6, 6);
                httpServletResponse.setContentType(string6);
                try {
                    if (ServerUtil.isFileNotModified(file, httpServletRequest, httpServletResponse)) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                }
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentLength((int)file.length());
                if (ServerEnv.hasForce() && (string6.toLowerCase().endsWith("excel") && ServerEnv.isForceExcel() || string6.toLowerCase().endsWith("pdf") && ServerEnv.isForcePdf() || string6.toLowerCase().endsWith("rtf") && ServerEnv.isForceRtf() || string6.toLowerCase().endsWith("postscript") && ServerEnv.isForcePs() || string6.toLowerCase().endsWith("xml") && ServerEnv.isForceXml() || string6.toLowerCase().endsWith("plain") && ServerEnv.isForceText())) {
                    HttpUtil.handleFileNameByBrowserTypeForDownload(file.getName(), httpServletRequest, httpServletResponse);
                }
                HttpSession httpSession = httpServletRequest.getSession(false);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[8192];
                try {
                    int n2 = fileInputStream.read(byArray);
                    while (n2 >= 0) {
                        servletOutputStream.write(byArray, 0, n2);
                        n2 = fileInputStream.read(byArray);
                    }
                }
                catch (Throwable throwable) {
                    jet.server.log.ServiceLogger.logError(throwable);
                }
                fileInputStream.close();
                servletOutputStream.close();
                String string7 = httpSession == null ? null : httpSession.getId();
                jet.server.log.ServiceLogger.logAccessSuccessEvent(httpRptServer.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), string7, 5680012, file.getCanonicalPath(), 5);
            }
            catch (TooManyUsersException tooManyUsersException) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, tooManyUsersException.getMessage());
                jet.server.log.ServiceLogger.logError((Throwable)((Object)tooManyUsersException));
            }
            catch (TooManyTimesException tooManyTimesException) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, tooManyTimesException.getMessage());
                jet.server.log.ServiceLogger.logError((Throwable)((Object)tooManyTimesException));
            }
            catch (UnavailableStorageException unavailableStorageException) {
                SendFileServlet.encode(httpServletRequest, httpServletResponse, unavailableStorageException.getMessage());
            }
            catch (IOException iOException) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, iOException);
                jet.server.log.ServiceLogger.logError(iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, throwable);
                jet.server.log.ServiceLogger.logError(throwable);
            }
        }
    }

    private void HISTORY(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        String string = HttpUtil.getUser(httpServletRequest);
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.result");
        int n = CSUtil.parseInt((String)hashtable.get("jrs.rst_version"), -1);
        int n2 = CSUtil.parseInt((String)hashtable.get("jrs.result_type"), -1);
        String string4 = string2 != null ? string2 : string3;
        String string5 = (String)hashtable.get("jrs.report_sheet");
        ResourceManager resourceManager = HttpUtil.getHttpRptServer().getResourceManager();
        ExResourceManager exResourceManager = (ExResourceManager)resourceManager;
        try {
            exResourceManager.setResultVersionViewed(string, string4, n, string5, n2);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            jet.server.log.ServiceLogger.logError((Throwable)((Object)noPrivilegeException), 3);
        }
        catch (UnknownResource unknownResource) {
            jet.server.log.ServiceLogger.logError((Throwable)((Object)unknownResource), 3);
        }
    }

    private File SEDU(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties, HttpRptServer httpRptServer) throws UnavailableStorageException {
        String string2;
        Object object;
        Object object2;
        String string3;
        String string4 = string;
        String string5 = string.toLowerCase();
        int n = string5.indexOf("/result/");
        if (n >= 0) {
            string4 = string4.substring(n + "/result/".length());
        }
        if ((string3 = (String)properties.get("jrs.temp_file")) == null || string3.length() == 0) {
            string3 = (String)properties.get("jrs.hist_file");
            if (string3 == null || string3.length() == 0) {
                string3 = (String)properties.get("jrs.file");
                if (string3 == null || string3.length() == 0) {
                    string3 = (String)properties.get("file");
                    if (string3 != null && string3.length() >= 0) {
                        string = string3;
                    }
                } else {
                    string = string3;
                }
            } else {
                string = "/history/" + string3;
            }
        } else {
            string = "/result/" + string3;
        }
        if (string.startsWith("/result/")) {
            object2 = (String)properties.get("jrs.result_type");
            if (object2 != null) {
                this.HISTORY(httpServletRequest, properties);
            }
            if (!string.endsWith("chart.jar")) {
                object = HttpUtil.getTempResultKey(string4);
                if (!httpRptServer.getTempResultOwnerManager().isOwner(HttpUtil.getUser(httpServletRequest), (String)object)) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_45", string));
                    return null;
                }
                try {
                    StorageEnv.getStorage().get(Storage.StorageRoot.TEMP, string.substring("/result/".length()));
                }
                catch (UnavailableStorageException unavailableStorageException) {
                    throw unavailableStorageException;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (!((String)(object = httpRptServer.getResourceManager().getTempDir())).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object + string.substring(8);
        } else if (string.startsWith("/history/")) {
            boolean bl;
            block53: {
                string = string.substring("/history/".length());
                string = string.replace('/', File.separatorChar);
                object2 = httpRptServer.getResourceManager().getHistDir();
                if (!((String)object2).endsWith(File.separator)) {
                    object2 = (String)object2 + File.separator;
                }
                try {
                    StorageEnv.getStorage().get(Storage.StorageRoot.HISTORY, string);
                }
                catch (UnavailableStorageException unavailableStorageException) {
                    throw unavailableStorageException;
                }
                catch (Exception exception) {
                    if (!string.endsWith(".html") && !string.endsWith(".htm")) break block53;
                    String string6 = CSUtil.getExtName(string);
                    string2 = string.substring(0, string.length() - string6.length());
                    if (string2.endsWith("_1")) {
                        while (string2.endsWith("_1")) {
                            String string7 = WebSecurityUtil.validateSubPath((string2 = string2.substring(0, string2.length() - 2)) + string6);
                            if (!new File((String)object2, string7).exists()) continue;
                            string = string7;
                        }
                    }
                    String string8 = string2 + "_1" + string6;
                    if (!new File((String)object2, string8).exists()) break block53;
                    string = string8;
                }
            }
            object = (String)properties.get("jrs.result_type");
            if (object != null) {
                this.HISTORY(httpServletRequest, properties);
            }
            if (bl = JRRptServer.hasPageSecurity(string = (String)object2 + string)) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                return null;
            }
        } else if (string.startsWith("/help/")) {
            object2 = httpRptServer.getServerEnv().getHomePath();
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object2 + string.substring(1);
        } else if (string.startsWith("/lib/")) {
            object2 = httpRptServer.getServerEnv().getHomePath();
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object2 + string.substring(1);
        } else if (string.startsWith("/javascripts/")) {
            object2 = httpRptServer.getServerEnv().getHomePath();
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            string = string.replace('/', File.separatorChar);
            string = (String)object2 + string.substring(1);
        } else {
            if (string.startsWith("/report/") || string.startsWith("/catalog/")) {
                try {
                    object2 = string.substring(string.startsWith("/report/") ? 7 : 8);
                    string = httpRptServer.getResourceManager().getPathInfo(HttpUtil.getUser(httpServletRequest), (String)object2).getRealPath();
                    jet.server.log.ServiceLogger.logDebug(6680008, new Object[]{object2, string}, 6);
                }
                catch (RptServerException rptServerException) {
                    jet.server.log.ServiceLogger.logError((Throwable)((Object)rptServerException));
                    return null;
                }
            }
            if (string.startsWith("/realm/")) {
                object2 = httpRptServer.getServerEnv().getHomePath();
                if (!((String)object2).endsWith(File.separator)) {
                    object2 = (String)object2 + File.separator;
                }
                object = string.substring(7);
                string = HttpUtil.getRealmDir() + (String)object;
            } else if (string.startsWith("/folderTree/")) {
                object2 = httpServletRequest.getParameter("xmlFile");
                string = HttpUtil.decodeEsc((String)object2);
            } else if (string == null) {
                try {
                    string = httpRptServer.getResourceManager().getPathInfo(HttpUtil.getUser(httpServletRequest), httpServletRequest.getPathInfo()).getRealPath();
                }
                catch (RptServerException rptServerException) {
                    jet.server.log.ServiceLogger.logError((Throwable)((Object)rptServerException));
                    return null;
                }
            }
        }
        jet.server.log.ServiceLogger.logDebug(6680009, string, 6);
        object2 = jet.server.api.SendFileAuthorizorFactory.getInstance();
        if (object2 != null) {
            if (!object2.isAuthorized(HttpUtil.getUser(httpServletRequest), string, httpRptServer)) {
                jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
                return null;
            }
            jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
        } else {
            object = SendFileAuthorizorFactory.getInstance();
            if (!object.isAuthorized(HttpUtil.getUser(httpServletRequest), string, httpRptServer)) {
                jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
                return null;
            }
            jet.server.log.ServiceLogger.logDebug(6680010, new Object[]{string, HttpUtil.getUser(httpServletRequest)}, 6);
        }
        object = new File(string);
        if (!((File)object).exists() || ((File)object).isDirectory()) {
            String string9 = ((File)object).getName();
            if (string9.equalsIgnoreCase("chart.jar") && ((File)(object = new File(string2 = httpRptServer.getServerEnv().getHomePath() + "lib" + File.separator, string9))).exists()) {
                return object;
            }
            return null;
        }
        return object;
    }

    private String TEMP(HttpServletRequest httpServletRequest) throws IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.length() == 0) {
            string = "/";
        } else if (this.HISTORY) {
            string = HttpUtil.decodeEsc(string);
        }
        if (string.toLowerCase().indexOf("<script>") != -1 || string.toLowerCase().indexOf("%3cscript%3e") != -1 || string.toLowerCase().indexOf("javascript:") != -1 || string.toLowerCase().indexOf("vbscript:") != -1) {
            string = "/";
        }
        return string;
    }

    private JRStringBufferPrintWriter append(HttpServletResponse httpServletResponse) throws IOException {
        return new JRStringBufferPrintWriter(httpServletResponse, (OutputStream)httpServletResponse.getOutputStream(), this.SEDU);
    }

    private void charAt(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpRptServer httpRptServer) throws Throwable {
        if (string.equalsIgnoreCase("jrs.get_temp_result")) {
            this.checkRealPath(httpServletRequest, httpServletResponse, (String)properties.get("jrs.file"), properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.remove_temp_result")) {
            this.close(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.get_ver_rst")) {
            this.containsKey(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.exp_rst")) {
            this.responseExportResult(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.open_pipeline_html")) {
            this.responseOpenPipeLineHtml(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.logout")) {
            this.checkLogin(httpServletRequest, httpServletResponse, properties, httpRptServer);
        } else if (string.equalsIgnoreCase("jrs.open_pagelevelsecurity_html")) {
            this.responseOpenPlsHtml(httpServletRequest, httpServletResponse, properties, httpRptServer);
        }
    }

    public void responseOpenPipeLineHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws Throwable {
        int n = CSUtil.parseInt((String)properties.get("pgnum"), -1);
        String string = this.delete(httpServletRequest, true);
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        String string3 = httpRptServer.getFilenames(string2, n);
        string = string + string3;
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.append(httpServletResponse);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setStatus(301);
        String string4 = WebSecurityUtil.validateResponseHeader(string);
        httpServletResponse.setHeader("Location", string4);
        httpServletResponse.setHeader("Content-Location", string4);
        jRStringBufferPrintWriter.println("<html><head><title>" + JSvrResource.getMessage("SLT_PG_125") + "</title>");
        jRStringBufferPrintWriter.println("</head><body><H1>" + JSvrResource.getMessage("SLT_PG_125") + "</H1>");
        jRStringBufferPrintWriter.println(JSvrResource.getMessage("SLT_PG_126") + ":");
        jRStringBufferPrintWriter.println("<a href=\"" + string + "\">" + string + "</a></body></html>");
        jRStringBufferPrintWriter.close();
    }

    public void responseOpenPlsHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws Throwable {
        int n;
        if (properties.containsKey("jrs.rst_version")) {
            this.HISTORY(httpServletRequest, properties);
        }
        String string = httpServletRequest.getPathInfo();
        String string2 = string.substring("/history/".length());
        int n2 = CSUtil.parseInt((String)properties.get("op"), 1);
        int n3 = CSUtil.parseInt(properties.getProperty("pg"), 1);
        int n4 = 0;
        if (n2 == 4) {
            n4 = CSUtil.parseInt(properties.getProperty("pypg"), 1);
        }
        if (n2 == 1) {
            n3 = 1;
        } else if (n2 == 2) {
            n3 = -1;
        }
        String string3 = httpRptServer.getResourceManager().getMIMEType(".html");
        jet.server.log.ServiceLogger.logDebug(6680007, string3, 6);
        httpServletResponse.setContentType(string3);
        httpServletResponse.setStatus(200);
        String string4 = HttpUtil.getUser(httpServletRequest);
        InputStream inputStream = this.append.getHtmlPage(string4, string2, n3);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > -1) {
            servletOutputStream.write(byArray, 0, n);
        }
        servletOutputStream.close();
    }

    private void checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, HttpRptServer httpRptServer) throws Exception {
        this.logout(httpServletRequest, httpServletResponse, hashtable, httpRptServer);
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_53"));
    }

    private void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, HttpRptServer httpRptServer) throws Exception {
        httpRptServer.getHttpUserSessionManager().logout(httpServletRequest);
    }

    private void checkRealPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Hashtable hashtable, HttpRptServer httpRptServer) throws Exception {
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        if (string == null) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_43"));
            return;
        }
        boolean bl = string.toLowerCase().endsWith(".html");
        boolean bl2 = false;
        if (!string.trim().equalsIgnoreCase("chart.jar")) {
            object = string;
            if (!APIUtil.getBoolean((String)hashtable.get("jrs.check_fullname"), false)) {
                object = HttpUtil.getTempResultKey(string);
            }
            if (!httpRptServer.getTempResultOwnerManager().isOwner(HttpUtil.getUser(httpServletRequest), (String)object)) {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_45", string));
                return;
            }
        } else {
            bl2 = true;
        }
        string = WebSecurityUtil.validateSubPath(string);
        object = new File(httpRptServer.getResourceManager().getTempDir() + string);
        String string6 = (String)hashtable.get("jrs.html_temp_dir");
        if (string6 != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string6 + File.separator + string);
        }
        if ((string5 = (String)hashtable.get("jrs.pdf_temp_dir")) != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string5 + File.separator + string);
        }
        if ((string4 = (String)hashtable.get("jrs.rtf_temp_dir")) != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string4 + File.separator + string);
        }
        if ((string3 = (String)hashtable.get("jrs.xml_temp_dir")) != null) {
            object = new File(httpRptServer.getResourceManager().getTempDir() + string3 + File.separator + string);
        }
        if (!bl2) {
            try {
                string2 = StorageEnv.getStorage().map(Storage.StorageRoot.TEMP.getRootPath()).getCanonicalPath();
                String string7 = ((File)object).getCanonicalPath();
                if (string7.startsWith(string2)) {
                    String string8 = string7.substring(string2.length());
                    StorageEnv.getStorage().get(Storage.StorageRoot.TEMP, string8);
                }
            }
            catch (UnavailableStorageException unavailableStorageException) {
                SendFileServlet.encode(httpServletRequest, httpServletResponse, unavailableStorageException.getMessage());
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            httpServletResponse.setContentType("text/html");
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, (File)object);
            return;
        }
        if (!((File)object).exists()) {
            if (bl2) {
                string2 = httpRptServer.getServerEnv().getHomePath() + "lib" + File.separator;
                object = new File(string2, string);
                if (!((File)object).exists()) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string));
                    return;
                }
            } else {
                HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string));
                return;
            }
        }
        if (HttpUtil.isJRClient(httpServletRequest, hashtable)) {
            HttpUtil.processPartialRequest(httpServletRequest, httpServletResponse, (File)object, hashtable);
        } else {
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, (File)object);
        }
    }

    private void close(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws IOException {
        String string = (String)properties.get("jrs.file");
        httpRptServer.getTempResultOwnerManager().removeOwner(HttpUtil.getUser(httpServletRequest), HttpUtil.getTempResultKey(string));
        String string2 = WebSecurityUtil.validateSubPath((String)properties.get("jrs.html_temp_dir"));
        String string3 = WebSecurityUtil.validateSubPath((String)properties.get("jrs.pdf_temp_dir"));
        String string4 = WebSecurityUtil.validateSubPath((String)properties.get("jrs.rtf_temp_dir"));
        String string5 = WebSecurityUtil.validateSubPath((String)properties.get("jrs.xml_temp_dir"));
        if (string != null) {
            try {
                File file;
                if (string2 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string2 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string2);
                    file.delete();
                }
                if (string3 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string3 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string3);
                    file.delete();
                }
                if (string4 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string4 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string4);
                    file.delete();
                }
                if (string5 != null) {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir() + string5 + File.separator, string);
                    file = new File(httpRptServer.getResourceManager().getTempDir() + string5);
                    file.delete();
                } else {
                    SchdTools.deleteFile(httpRptServer.getResourceManager().getTempDir(), string);
                }
            }
            catch (Throwable throwable) {
                jet.server.log.ServiceLogger.logError(throwable);
            }
        }
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 200, "OK!");
    }

    public void responseExportResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties, HttpRptServer httpRptServer) throws Throwable {
        String string;
        Object object;
        File file = null;
        String string2 = HttpUtil.getUser(httpServletRequest);
        String string3 = (String)properties.get("jrs.file");
        if (string3 != null) {
            file = WebSecurityUtil.validateFilePath(string3);
        } else {
            string3 = WebSecurityUtil.validateSubPath((String)properties.get("jrs.temp_file"));
            if (string3 != null) {
                String string4 = string3;
                if (!APIUtil.getBoolean((String)properties.get("jrs.check_fullname"), false)) {
                    string4 = HttpUtil.getTempResultKey(string3);
                }
                if (!httpRptServer.getTempResultOwnerManager().isOwner(string2, string4)) {
                    HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_56", string3));
                    return;
                }
                file = new File(httpRptServer.getResourceManager().getTempDir() + string3);
            } else {
                string3 = (String)properties.get("jrs.hist_file");
                if (string3 != null) {
                    boolean bl = JRRptServer.hasPageSecurity(string3);
                    if (bl) {
                        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                        return;
                    }
                    object = httpRptServer.getResourceManager().getHistDir();
                    file = object != null && string3.startsWith((String)object) ? WebSecurityUtil.validateFilePath(string3) : WebSecurityUtil.validateFilePath((String)object + string3);
                }
            }
        }
        if (file == null || !file.exists()) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, HttpUtil.getBase(httpServletRequest, true));
            return;
        }
        string3 = HttpUtil.getUser(httpServletRequest);
        if (string3 != null) {
            properties.put("jrs.uid", string3);
        }
        if ((string = httpServletRequest.getRemoteHost()) != null) {
            properties.put("jrs.remote_host", string);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        object = httpRptServer.exportResult(string2, file.getCanonicalPath(), properties);
        if (object != null) {
            int n;
            int n2;
            Vector vector;
            string3 = object.getRSTFilename();
            if (string3 != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = object.getHTMLFilenameList()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            if ((vector = object.getPDFFilename()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            if ((string3 = object.getTEXTFilename()) != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = object.getExcelFilename()) != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = object.getPSFilename()) != null) {
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = object.getRTFFilenameList()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            if ((vector = object.getXMLFilenameList()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    httpRptServer.getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.append(httpServletResponse);
            String string5 = object.toHttpQueryString();
            jRStringBufferPrintWriter.println(string5);
            jRStringBufferPrintWriter.close();
            jet.server.log.ServiceLogger.logAccessSuccessEvent(httpRptServer.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), SendFileServlet.decodeEsc(httpServletRequest), 6680013, string5, 6);
            return;
        }
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 406, httpServletRequest.getRequestURI());
    }

    private void containsKey(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, HttpRptServer httpRptServer) throws IOException {
        String string = (String)hashtable.get("jrs.file");
        if (string == null) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 406, "The result file was not specified!");
            return;
        }
        JRResourceManager jRResourceManager = (JRResourceManager)httpRptServer.getResourceManager();
        try {
            string = jRResourceManager.checkRealPath(string);
        }
        catch (Exception exception) {
            jet.server.log.ServiceLogger.logError(exception);
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, string + " not found!");
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 404, string + " not found!");
            return;
        }
        boolean bl = JRRptServer.hasPageSecurity(file.getPath());
        if (bl) {
            HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
            return;
        }
        if (hashtable.containsKey("jrs.rst_version")) {
            hashtable.put("jrs.report_sheet", "jrs.rst_result");
            hashtable.put("jrs.result_type", String.valueOf(0));
            this.HISTORY(httpServletRequest, hashtable);
        }
        HttpUtil.sendFile(httpServletRequest, httpServletResponse, file);
    }

    private void currentTimeMillis(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties, HttpRptServer httpRptServer) throws IOException {
        block19: {
            String string2;
            String string3 = string;
            RemoteFileService remoteFileService = httpRptServer.getRemoteFileService();
            if (httpServletRequest.getPathInfo() != null) {
                String string4;
                if (string3.startsWith("/result/")) {
                    String string5;
                    string4 = (String)properties.get("jrs.result_type");
                    if (string4 != null) {
                        this.HISTORY(httpServletRequest, properties);
                    }
                    if (!(string5 = httpRptServer.getResourceManager().getTempDir()).endsWith(File.separator)) {
                        string5 = string5 + File.separator;
                    }
                    string3 = string3.replace('/', File.separatorChar);
                    string3 = string5 + string3.substring(8);
                } else if (string3.startsWith("/history/")) {
                    string4 = httpRptServer.getResourceManager().getHistDir();
                    if (!string4.endsWith(File.separator)) {
                        string4 = string4 + File.separator;
                    }
                    string3 = string3.replace('/', File.separatorChar);
                    string3 = string3.replace(File.separatorChar, remoteFileService.getRemoteFileSeparator().charAt(0));
                    string3 = string4 + string3.substring(9);
                    boolean bl = JRRptServer.hasPageSecurity(string3);
                    if (bl) {
                        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"));
                    }
                } else if (string3.startsWith("/folderTree/")) {
                    string3 = httpServletRequest.getParameter("xmlFile");
                }
                string2 = string3;
            } else {
                try {
                    string2 = this.SEDU(httpServletRequest, httpServletResponse, string3, properties, httpRptServer).getPath();
                }
                catch (UnavailableStorageException unavailableStorageException) {
                    SendFileServlet.encode(httpServletRequest, httpServletResponse, unavailableStorageException.getMessage());
                    return;
                }
            }
            string2 = string2.replace(File.separatorChar, remoteFileService.getRemoteFileSeparator().charAt(0));
            try {
                String string6;
                long l = 0L;
                byte[] byArray = new byte[65536];
                InputStream inputStream = null;
                l = remoteFileService.length(string2);
                inputStream = remoteFileService.readFile(string2);
                String string7 = null;
                int n = string2.lastIndexOf(46);
                if (n > 0) {
                    string6 = string2.substring(n).toLowerCase();
                    string7 = HttpUtil.getHttpRptServer().getResourceManager().getMIMEType(string6);
                    if (string7 == null || string7.trim().length() == 0) {
                        string7 = "application/octet-stream";
                    }
                }
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType(string7);
                httpServletResponse.setContentLength((int)l);
                httpServletResponse.setHeader("Cache-Control", "max-age=1");
                httpServletResponse.setDateHeader("Last-Modified", System.currentTimeMillis());
                string6 = httpServletResponse.getOutputStream();
                int n2 = inputStream.read(byArray, 0, 65536);
                while (n2 >= 0) {
                    if (n2 > 0) {
                        ((OutputStream)((Object)string6)).write(byArray, 0, n2);
                    }
                    n2 = inputStream.read(byArray, 0, 65536);
                }
                inputStream.close();
                ((OutputStream)((Object)string6)).flush();
                ((OutputStream)((Object)string6)).close();
            }
            catch (Exception exception) {
                if (exception.getCause() == null || exception.getCause() instanceof SocketException) break block19;
                jet.server.log.ServiceLogger.logError(exception);
            }
        }
    }

    private static String decodeEsc(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        return httpSession.getId();
    }

    public void generateWaitInQueue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setStatus(200);
        String string = "jrs.wait_user";
        String string2 = JCliResource.getMessage("CS_MSG_147");
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.append(httpServletResponse);
        String string3 = this.TEMP(httpServletRequest);
        httpServletResponse.setContentType("text/html");
        this.deleteFile(httpServletRequest, jRStringBufferPrintWriter, string2);
        jRStringBufferPrintWriter.println("<font face=\"Arial\"><small>");
        jRStringBufferPrintWriter.println("<form method=\"POST\" action=\"\\servlet\\sendfile\\\">");
        jRStringBufferPrintWriter.println("<table style=\"font-family:Arial;font-size:10pt;\" border=\"0\" width=\"100%\">");
        jRStringBufferPrintWriter.println("<tr bgcolor=\"#000000\"><td align=\"left\"><b><font color=\"#ECECEC\">" + string2 + "</b></td></tr>");
        jRStringBufferPrintWriter.println("</table>");
        jRStringBufferPrintWriter.print("<input type=hidden name=jrs.cmd value=\"" + string + "\">");
        jRStringBufferPrintWriter.print("<input type=hidden name=path value=\"" + string3 + "\">");
        jRStringBufferPrintWriter.print("<input type=hidden name=\"isWait\" value=\"true\">");
        jRStringBufferPrintWriter.println("<p><input type=\"submit\" value=\"Yes\" name=\"Submit_Btn\">");
        jRStringBufferPrintWriter.println("<input type=\"submit\" value=\"No\" name=\"B2\"></p>");
        jRStringBufferPrintWriter.println("</form>");
        jRStringBufferPrintWriter.println("</small></font>");
        jRStringBufferPrintWriter.println("</body>");
        jRStringBufferPrintWriter.println("</html>");
        jRStringBufferPrintWriter.close();
    }

    private String delete(HttpServletRequest httpServletRequest, boolean bl) throws Exception {
        return bl ? HttpUtil.getQueryBase(httpServletRequest, !this.HISTORY) : HttpUtil.getQueryBaseNoPath(httpServletRequest, !this.HISTORY);
    }

    private void deleteFile(HttpServletRequest httpServletRequest, JRStringBufferPrintWriter jRStringBufferPrintWriter, String string) throws Exception {
        this.elementAt(httpServletRequest, jRStringBufferPrintWriter, string);
    }

    private void elementAt(HttpServletRequest httpServletRequest, JRStringBufferPrintWriter jRStringBufferPrintWriter, String string) throws Exception {
        jRStringBufferPrintWriter.println("<html>");
        jRStringBufferPrintWriter.println("<head>");
        jRStringBufferPrintWriter.println("<title>" + string + "</title>");
        jRStringBufferPrintWriter.println("</head>");
        if (this.TEMP == null) {
            jRStringBufferPrintWriter.println("<body >");
        } else {
            jRStringBufferPrintWriter.println("<body onunload=parent.leftframe.location=\"" + this.TEMP + "\">");
        }
    }

    private static void encode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2 = string == null ? "" : string;
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("JRS-MESSAGE", CSUtil.replWithEsc(string2));
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType("text/html");
            servletOutputStream.println("<html>");
            servletOutputStream.println("<head>");
            servletOutputStream.println("<title>" + JSvrResource.getMessage("SLT_ERR_66") + "</title>");
            servletOutputStream.println("</head>");
            servletOutputStream.println("<body>");
            servletOutputStream.write(string2.getBytes());
            servletOutputStream.println();
            servletOutputStream.println("</body>");
            servletOutputStream.println("</html>");
        }
        catch (Throwable throwable) {
            jet.server.log.ServiceLogger.logError(throwable);
        }
    }
}

