/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.acl.Permission;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.cs.api.CompletedPublishRecord;
import jet.cs.api.CompletedResultRecord;
import jet.cs.util.APIUtil;
import jet.lc.logic.LCLogicFactory;
import jet.report.JReportUtil;
import jet.server.ServerEnv;
import jet.server.api.CompletedTaskRecord;
import jet.server.api.Permissions;
import jet.server.api.ReportInfo;
import jet.server.api.ReportSheetInfo;
import jet.server.api.SecurityWebAdaptor;
import jet.server.api.TaskSuccessInfo;
import jet.server.api.VersionRecord;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.api.cluster.ClusterService;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpUtil;
import jet.server.api.nls.FontNLSEntry;
import jet.server.api.nls.FormatNLSEntry;
import jet.server.api.nls.NLSEntry;
import jet.server.api.nls.TextNLSEntry;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManager;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.intf.jrs.CustomizeControlManager;
import jet.server.jrc.resource.nls.GlobalNLSRecord;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRResourceManager;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.log.ServiceLogger;
import jet.server.servlets.JRServlet;
import jet.server.servlets.OperationBase;
import jet.server.util.RefResource;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;

public class ViewerOperation4
extends OperationBase {
    String deployNodeExists;
    String deployNoPrivilege;
    String deployUnknownResource;
    boolean isDeployMutilCat;

    public ViewerOperation4(JRServlet jRServlet) {
        super(jRServlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseDeploy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = null;
        this.deployNodeExists = null;
        this.deployNoPrivilege = null;
        this.deployUnknownResource = null;
        this.isDeployMutilCat = false;
        String string2 = this.jrservlet.getUser(httpServletRequest);
        if (HttpUtil.isSecure() && !this.jrservlet.getHttpRptServer().getUserSessionManager().getAuthenticator().checkPrivilege(this.jrservlet.getRealm(), string2, "jrs.privilege_publish_report")) {
            throw new Exception("The user " + string2 + " have no publish privilege");
        }
        String string3 = (String)hashtable.get("isAutoConverting");
        boolean bl = false;
        if (string3 != null && string3.equals("true")) {
            bl = true;
        }
        String string4 = (String)hashtable.get("jrs.deploy_key");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.is_deploy_locally"), false);
        String string5 = null;
        if (string4 != null && !bl2) {
            string5 = (String)APIUtil.getTempValueFromHt(string4);
        }
        if (bl2) {
            string5 = (String)hashtable.get("jrs.deploy_from_file");
        }
        if (string5 != null) {
            string5 = HttpUtil.decodeEsc(string5);
        }
        string5 = WebSecurityUtil.validateFilePathStr(string5);
        try {
            String[] stringArray;
            String string6;
            string2 = this.jrservlet.getUser(httpServletRequest);
            Vector vector = null;
            Vector vector2 = null;
            Vector vector3 = null;
            if (string2 != null && !string2.equals("")) {
                vector = this.jrservlet.getHttpRptServer().getResourceManager().getReferUsers(string2);
                vector2 = this.jrservlet.getHttpRptServer().getResourceManager().getReferRoles(string2);
                vector3 = this.jrservlet.getHttpRptServer().getResourceManager().getReferGroups(string2);
            }
            if ((string6 = (String)hashtable.get("jrs.path")) != null) {
                string6 = HttpUtil.decodeEsc(string6);
            }
            String string7 = (String)hashtable.get("FileSeparator");
            String string8 = (String)hashtable.get("jrs.is_advance_deploy");
            if (string8 != null && string8.equalsIgnoreCase("true")) {
                string = this.P_DELETE(vector, vector2, vector3, hashtable, string6, string2, string7, string5, string7, bl);
            } else if (string8 != null && string8.equalsIgnoreCase("false")) {
                string = this.P_EXECUTE(vector, vector2, vector3, hashtable, string6, string2, string5, string7, bl);
            } else {
                int n = CSUtil.parseInt((String)hashtable.get("jrs.deploy_type"), 3);
                if (string5 == null && n != 2) {
                    throw new Exception("Deploy from file is null");
                }
                boolean bl3 = false;
                if (n == 1 || n == 0 || n == 4) {
                    bl3 = true;
                }
                if (n == 2 || n == 3) {
                    stringArray = (String)hashtable.get("jrs.node_prop$" + string7);
                    Properties properties = CSUtil.parseQuery((String)stringArray);
                    Hashtable[] hashtableArray = new Hashtable[3];
                    if (APIUtil.getBoolean((String)((Hashtable)properties).get("jrs.define_permission"), false)) {
                        hashtableArray = this.getPropPermission(properties);
                    }
                    String string9 = (String)((Hashtable)properties).get("jrs.node_name");
                    String string10 = this.jrservlet.getHttpRptServer().getResourceManager().createFolder(string2, string6, string9, properties, hashtableArray);
                    if (string10 == null) {
                        throw new Exception("Create folder failed");
                    }
                    ((Hashtable)properties).clear();
                    hashtable.remove("jrs.node_prop$" + string7);
                    string6 = this.I(string6, string9, "/");
                }
                if (n == 2) {
                    httpServletResponse.setStatus(200);
                    return;
                }
                stringArray = new File(string5);
                string = this.IRT_FONT(vector, vector2, vector3, hashtable, string6, string2, string7, (File)stringArray, string7, bl3, bl);
            }
            if (string8 == null || string8.equalsIgnoreCase("true")) {
                this.IRT_STYLEGROUP(hashtable, string6, bl2, string2, vector, vector2, vector3);
            }
            httpServletResponse.setHeader("isLive", Boolean.toString(ReportEnv.isLive()));
            httpServletResponse.setStatus(200);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
            if (string != null && string.indexOf("LR") != -1) {
                httpServletResponse.setHeader("hasDeployLive", "true");
                string = string.substring(string.indexOf("LR") + 3);
                Vector<String> vector4 = new Vector<String>();
                stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    vector4.add(stringArray[i]);
                }
                objectOutputStream.writeObject(vector4);
            }
            httpServletResponse.setHeader("isDeployMutilCat", Boolean.toString(this.isDeployMutilCat));
            if (this.deployNodeExists != null) {
                throw new NodeExistsException("Deploy nodes all ready exist: " + this.deployNodeExists);
            }
            if (this.deployNoPrivilege != null) {
                throw new NoPrivilegeException("No privilege: " + this.deployNoPrivilege);
            }
            if (this.deployUnknownResource != null) {
                throw new UnknownResource("Deploy nodes are unkown resource: " + this.deployUnknownResource);
            }
            objectOutputStream.close();
        }
        finally {
            if (string4 != null) {
                APIUtil.removeTempValueInHt(string4);
            }
            if (!bl2 && string5 != null) {
                APIUtil.deleteDirectory(WebSecurityUtil.validateFilePathStr(string5));
            }
        }
    }

    private String I(String string, String string2, String string3) {
        if (string.endsWith(string3)) {
            return string + string2;
        }
        return string + string3 + string2;
    }

    public void responseGetCatRefFilesInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String string = WebSecurityUtil.validateFilePathStr(HttpUtil.decodeEsc((String)hashtable.get("jrs.node_real_path")));
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        Vector vector = RefResource.getCatRefFiles(string);
        Hashtable hashtable2 = new Hashtable();
        Vector<String[]> vector2 = new Vector<String[]>();
        String[] stringArray = new String[4];
        File file = new File(string);
        if (file.exists()) {
            stringArray[0] = file.getName();
            stringArray[1] = string;
            stringArray[2] = String.valueOf((int)Math.ceil((float)file.length() / 1024.0f)) + " KB";
            stringArray[3] = String.valueOf(file.lastModified());
            vector2.add(stringArray);
            hashtable2.put("catalogInfos", vector2);
        }
        if (vector != null) {
            vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                String string3;
                String string4 = (String)vector.elementAt(i);
                File file2 = new File(string2, string4);
                stringArray = new String[4];
                if (file2.exists()) {
                    string3 = file2.getCanonicalPath();
                    if (string3 == null || string3.equals(string)) continue;
                    stringArray[0] = file2.getName();
                    stringArray[1] = string3;
                    stringArray[2] = String.valueOf((int)Math.ceil((float)file2.length() / 1024.0f)) + " KB";
                    stringArray[3] = String.valueOf(file2.lastModified());
                    vector2.add(stringArray);
                    continue;
                }
                file2 = new File(string4);
                if (!file2.exists() || (string3 = file2.getCanonicalPath()) == null || string3.equals(string)) continue;
                stringArray[0] = file2.getName();
                stringArray[1] = string3;
                stringArray[2] = String.valueOf((int)Math.ceil((float)file2.length() / 1024.0f)) + " KB";
                stringArray[3] = String.valueOf(file2.lastModified());
                vector2.add(stringArray);
            }
            if (vector2.size() > 0) {
                hashtable2.put("catReferInfos", vector2);
            }
        }
        objectOutputStream.writeObject(hashtable2);
        objectOutputStream.close();
    }

    public void responseGetLCRefFilesInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.responseGetRefFilesInfo(httpServletRequest, httpServletResponse, hashtable, true);
    }

    public void responseGetRptRefFilesInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.responseGetRefFilesInfo(httpServletRequest, httpServletResponse, hashtable, false);
    }

    public void responseGetRefFilesInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, boolean bl) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String string = WebSecurityUtil.validateFilePathStr(HttpUtil.decodeEsc((String)hashtable.get("jrs.node_real_path")));
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        Hashtable hashtable2 = new Hashtable();
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = new String[4];
        File file = new File(string);
        if (file.exists()) {
            stringArray[0] = file.getName();
            stringArray[1] = string;
            stringArray[2] = String.valueOf((int)Math.ceil((float)file.length() / 1024.0f)) + " KB";
            stringArray[3] = String.valueOf(file.lastModified());
            vector.add(stringArray);
            hashtable2.put("reportInfos", vector);
        }
        vector = new Vector();
        Vector<String[]> vector2 = new Vector<String[]>();
        Vector<String[]> vector3 = new Vector<String[]>();
        Vector<String[]> vector4 = new Vector<String[]>();
        if (bl) {
            List list = LCLogicFactory.getLCObjectLogic().getInternalResource(file);
            List list2 = null;
            for (int i = 0; i < list.size(); ++i) {
                list2 = (List)list.get(i);
                if (list2 == null) continue;
                int n = list2.size();
                for (int j = 0; j < n; ++j) {
                    String string3 = (String)list2.get(j);
                    stringArray = new String[4];
                    File file2 = new File(string2, string3);
                    if (!file2.exists()) {
                        file2 = new File(string3);
                    }
                    if (!file2.exists()) continue;
                    stringArray[0] = file2.getName();
                    stringArray[1] = file2.getCanonicalPath();
                    stringArray[2] = String.valueOf((int)Math.ceil((float)file2.length() / 1024.0f)) + " KB";
                    stringArray[3] = String.valueOf(file2.lastModified());
                    if (i == 6) {
                        if (vector2.contains(string3)) continue;
                        vector2.addElement(stringArray);
                        continue;
                    }
                    if (i == 7) {
                        if (vector3.contains(string3)) continue;
                        vector3.addElement(stringArray);
                        continue;
                    }
                    if (i == 8) {
                        if (vector4.contains(string3)) continue;
                        vector4.addElement(stringArray);
                        continue;
                    }
                    vector.add(stringArray);
                }
                if (i == JReportUtil.IRT_FONT && vector2.size() > 0) {
                    hashtable2.put("rptReferFontInfos", vector2);
                    continue;
                }
                if (i == JReportUtil.IRT_STYLEGROUP && vector3.size() > 0) {
                    hashtable2.put("rptReferStyleInfos", vector3);
                    continue;
                }
                if (i != JReportUtil.IRT_GMAPGEO || vector4.size() <= 0) continue;
                hashtable2.put("rptReferGoogleInfos", vector4);
            }
            if (vector.size() > 0) {
                hashtable2.put("rptReferInfos", vector);
            }
        } else {
            Vector[] vectorArray = RefResource.getRptFiles(string);
            if (vectorArray != null) {
                for (int i = 0; i < vectorArray.length; ++i) {
                    Vector vector5 = vectorArray[i];
                    if (vector5 == null) continue;
                    for (int j = 0; j < vector5.size(); ++j) {
                        String string4 = (String)vector5.elementAt(j);
                        stringArray = new String[4];
                        File file3 = new File(string2, string4);
                        if (!file3.exists()) {
                            file3 = new File(string4);
                        }
                        if (!file3.exists()) continue;
                        stringArray[0] = file3.getName();
                        stringArray[1] = file3.getCanonicalPath();
                        stringArray[2] = String.valueOf((int)Math.ceil((float)file3.length() / 1024.0f)) + " KB";
                        stringArray[3] = String.valueOf(file3.lastModified());
                        if (i == JReportUtil.IRT_FONT) {
                            vector2.add(stringArray);
                            continue;
                        }
                        if (i == JReportUtil.IRT_STYLEGROUP) {
                            vector3.add(stringArray);
                            continue;
                        }
                        if (i == JReportUtil.IRT_GMAPGEO) {
                            if (vector4.contains(string4)) continue;
                            vector4.addElement(stringArray);
                            continue;
                        }
                        vector.add(stringArray);
                    }
                    if (i == JReportUtil.IRT_FONT && vector2.size() > 0) {
                        hashtable2.put("rptReferFontInfos", vector2);
                        continue;
                    }
                    if (i == JReportUtil.IRT_STYLEGROUP && vector3.size() > 0) {
                        hashtable2.put("rptReferStyleInfos", vector3);
                        continue;
                    }
                    if (i != JReportUtil.IRT_GMAPGEO || vector4.size() <= 0) continue;
                    hashtable2.put("rptReferGoogleInfos", vector4);
                }
                if (vector.size() > 0) {
                    hashtable2.put("rptReferInfos", vector);
                }
            }
        }
        objectOutputStream.writeObject(hashtable2);
        objectOutputStream.close();
    }

    public void responseGetDownloadFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        if (string != null) {
            File file = new File(string);
            HttpUtil.sendFile(httpServletRequest, httpServletResponse, file);
        }
    }

    public void responseDownloadCustomzeControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        PropsTable propsTable;
        byte[] byArray;
        String string = (String)hashtable.get("jrs.file");
        if (string != null && (byArray = (propsTable = GlobalDataService.getInstance().getPropsTable()).queryBytes("Customized Control", string)) != null) {
            HttpUtil.sendBytes(httpServletRequest, httpServletResponse, byArray, string);
        }
    }

    public void responseGetCustomzeControlNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        JRResourceManager jRResourceManager = (JRResourceManager)this.jrservlet.getHttpRptServer().getResourceManager();
        CustomizeControlManager customizeControlManager = jRResourceManager.getCustomizeControlManager();
        List list = customizeControlManager.getAllCustomizeControlNames();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        if (list.size() > 0) {
            for (String string : list) {
                jRStringBufferPrintWriter.println(string);
            }
        } else {
            jRStringBufferPrintWriter.println();
        }
        jRStringBufferPrintWriter.close();
    }

    private String IRT_FONT(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, String string, String string2, String string3, File file, String string4, boolean bl, boolean bl2) {
        String string5 = null;
        File[] fileArray = file.listFiles();
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.is_deploy_locally"), false);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!CSUtil.isCatalogFile(fileArray[i].getName())) continue;
                File file2 = fileArray[i];
                fileArray[i] = fileArray[0];
                fileArray[0] = file2;
                break;
            }
            for (File file3 : fileArray) {
                String string6 = this.I(string3, file3.getName(), string4);
                String string7 = CSUtil.replWithEsc(string6);
                String string8 = file3.getPath();
                String string9 = (String)hashtable.get("jrs.node_prop$" + string7);
                if (string9 != null) {
                    string9 = HttpUtil.decodeEsc(string9);
                }
                if (string9 == null) continue;
                Properties properties = CSUtil.parseQuery(string9);
                Hashtable[] hashtableArray = new Hashtable[3];
                if (APIUtil.getBoolean((String)((Hashtable)properties).get("jrs.define_permission"), false)) {
                    try {
                        hashtableArray = this.getPropPermission(properties);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                String string10 = string8.substring(string8.lastIndexOf(File.separator) + 1);
                try {
                    String string11;
                    if (file3.isDirectory()) {
                        String string12;
                        String string13 = (String)((Hashtable)properties).get("jrs.node_name");
                        if (string13 != null) {
                            string13 = HttpUtil.decodeEsc(string13);
                        }
                        string11 = this.jrservlet.getHttpRptServer().getResourceManager().createFolder(string2, string, string13, properties, hashtableArray);
                        if (!bl && (string12 = this.IRT_FONT(vector, vector2, vector3, hashtable, this.I(string, string13, "/"), string2, string6, file3, string4, bl, bl2)) != null) {
                            string5 = string5 == null ? string12 : string5 + "," + string12.substring(string12.indexOf("LR") + 3);
                        }
                    } else {
                        if (bl3) {
                            int n = CSUtil.parseInt((String)((Hashtable)properties).get("jrs.node_type"), 0);
                            string11 = (String)((Hashtable)properties).get("Catalog_New_Path");
                            if (n == 2 && string11 != null && string11.trim().length() != 0) {
                                string8 = string11;
                            }
                        }
                        ((Hashtable)properties).put("jrs.deploy_from_file", string8);
                        if (!ReportEnv.isLive() && RefResource.isLiveReport(string8)) {
                            string5 = string5 == null ? "LR:" + string10 : string5 + "," + string10;
                        } else {
                            VersionRecord versionRecord = this.jrservlet.getHttpRptServer().getResourceManager().addResource(string2, string, bl2, properties, hashtableArray);
                        }
                    }
                }
                catch (NodeExistsException nodeExistsException) {
                    ServiceLogger.logError(nodeExistsException.toString());
                    if (CSUtil.isCatalogFile(string10)) {
                        this.isDeployMutilCat = true;
                    } else {
                        this.deployNodeExists = this.deployNodeExists == null ? string10 : this.deployNodeExists + "," + string10;
                    }
                }
                catch (NoPrivilegeException noPrivilegeException) {
                    ServiceLogger.logError(noPrivilegeException.toString());
                    this.deployNoPrivilege = this.deployNoPrivilege == null ? string10 : this.deployNoPrivilege + "," + string10;
                }
                catch (UnknownResource unknownResource) {
                    ServiceLogger.logError(unknownResource.toString());
                    this.deployUnknownResource = this.deployUnknownResource == null ? string10 : this.deployUnknownResource + "," + string10;
                }
                hashtable.remove("jrs.node_prop$" + string7);
                ((Hashtable)properties).clear();
            }
        }
        return string5;
    }

    private Hashtable[] IRT_GMAPGEO(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable) {
        Vector<Permission> vector4;
        String string;
        String string2;
        int n;
        Hashtable[] hashtableArray = null;
        hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                string2 = (String)vector.elementAt(n);
                string = "";
                vector4 = new Vector<Permission>();
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "read"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "read");
                    vector4.addElement(Permissions.P_READ);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "write"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "write");
                    vector4.addElement(Permissions.P_WRITE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "delete"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "delete");
                    vector4.addElement(Permissions.P_DELETE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "visible"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "visible");
                    vector4.addElement(Permissions.P_VISIBLE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "execute"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "execute");
                    vector4.addElement(Permissions.P_EXECUTE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "schedule"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "schedule");
                    vector4.addElement(Permissions.P_SCHEDULE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string2 + "." + "grant"), false)) {
                    hashtable.remove("jrs.user_permission$" + string2 + "." + "grant");
                    vector4.addElement(Permissions.P_GRANT);
                }
                if (vector4.size() == 0) continue;
                hashtableArray[0].put(string2, vector4);
            }
        }
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                string2 = (String)vector2.elementAt(n);
                string = "";
                vector4 = new Vector();
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "read"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "read");
                    vector4.addElement(Permissions.P_READ);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "write"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "write");
                    vector4.addElement(Permissions.P_WRITE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "delete"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "delete");
                    vector4.addElement(Permissions.P_DELETE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "visible"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "visible");
                    vector4.addElement(Permissions.P_VISIBLE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "execute"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "execute");
                    vector4.addElement(Permissions.P_EXECUTE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "schedule"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "schedule");
                    vector4.addElement(Permissions.P_SCHEDULE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string2 + "." + "grant"), false)) {
                    hashtable.remove("jrs.role_permission$" + string2 + "." + "grant");
                    vector4.addElement(Permissions.P_GRANT);
                }
                if (vector4.size() == 0) continue;
                hashtableArray[1].put(string2, vector4);
            }
        }
        if (vector3 != null) {
            for (n = 0; n < vector3.size(); ++n) {
                string2 = (String)vector3.elementAt(n);
                string = "";
                vector4 = new Vector();
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "read"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "read");
                    vector4.addElement(Permissions.P_READ);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "write"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "write");
                    vector4.addElement(Permissions.P_WRITE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "delete"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "delete");
                    vector4.addElement(Permissions.P_DELETE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "visible"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "visible");
                    vector4.addElement(Permissions.P_VISIBLE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "execute"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "execute");
                    vector4.addElement(Permissions.P_EXECUTE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "schedule"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "schedule");
                    vector4.addElement(Permissions.P_SCHEDULE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "grant"), false)) {
                    hashtable.remove("jrs.group_permission$" + string2 + "." + "grant");
                    vector4.addElement(Permissions.P_GRANT);
                }
                if (vector4.size() == 0) continue;
                hashtableArray[2].put(string2, vector4);
            }
        }
        return hashtableArray;
    }

    public void responseLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        httpServletResponse.setStatus(200);
    }

    public void responseGetRealPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.jrservlet.getUser(httpServletRequest);
        if (this.jrservlet.getHttpRptServer().getResourceManager().isAdminUser(string)) {
            String string2 = (String)hashtable.get("jrs.node_name");
            int n = CSUtil.parseInt((String)hashtable.get("jrs.version_number"), 0);
            int n2 = CSUtil.parseInt((String)hashtable.get("jrs.node_type"), 0);
            String string3 = null;
            switch (n2) {
                case 0: {
                    string3 = this.jrservlet.getHttpRptServer().getResourceManager().getReportVersion(string, string2, n).getRealPath();
                    break;
                }
                case 1: {
                    string3 = this.jrservlet.getHttpRptServer().getResourceManager().getResultVersion(string, string2, n).getRealPath();
                    break;
                }
                case 2: {
                    string3 = this.jrservlet.getHttpRptServer().getResourceManager().getResultDocVersion(string, string2, n).getRealPath();
                    break;
                }
                case 4: {
                    string3 = this.jrservlet.getHttpRptServer().getResourceManager().getCatalogVersion(string, string2, n).getRealPath();
                }
            }
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
            jRStringBufferPrintWriter.println(string3);
            jRStringBufferPrintWriter.close();
        }
    }

    public void responseCheckPrivilege(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.user");
        String string2 = (String)hashtable.get("jrs.permission_values");
        if (string == null || string.equals("")) {
            string = this.jrservlet.getUser(httpServletRequest);
        }
        boolean bl = false;
        bl = !HttpUtil.isSecure() ? true : this.jrservlet.getHttpRptServer().getUserSessionManager().getAuthenticator().checkPrivilege(this.jrservlet.getRealm(), string, string2);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseGetLatestVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.path");
        if (string != null) {
            string = HttpUtil.decodeEsc(string);
        }
        int n = this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(n));
        jRStringBufferPrintWriter.close();
    }

    private void IRT_STYLEGROUP(Hashtable hashtable, String string, boolean bl, String string2, Vector vector, Vector vector2, Vector vector3) throws Exception {
        if (!bl && hashtable != null) {
            int n;
            Vector<String> vector4 = new Vector<String>();
            Enumeration enumeration = hashtable.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith("jrs.node_prop$")) continue;
                    vector4.add(string3);
                }
            }
            if ((n = vector4.size()) > 0) {
                class TmpComparator
                implements Comparator {
                    TmpComparator() {
                    }

                    public int compare(Object object, Object object2) {
                        return ((String)object).length() - ((String)object2).length();
                    }
                }
                Collections.sort(vector4, new TmpComparator());
                for (int i = 0; i < n; ++i) {
                    String string4 = (String)vector4.get(i);
                    String string5 = (String)hashtable.get(string4);
                    Properties properties = CSUtil.parseQuery(string5);
                    Hashtable[] hashtableArray = null;
                    hashtableArray = APIUtil.getBoolean((String)((Hashtable)properties).get("jrs.define_permission"), false) ? this.getPropPermission(properties) : new Hashtable[3];
                    string = (String)((Hashtable)properties).get("jrs.path");
                    if (string != null && string.trim().length() > 0) {
                        String string6 = (String)((Hashtable)properties).get("jrs.node_name");
                        String string7 = this.jrservlet.getHttpRptServer().getResourceManager().createFolder(string2, string, string6, properties, hashtableArray);
                    }
                    ((Hashtable)properties).clear();
                    hashtable.remove(string4);
                }
            }
        }
    }

    private String P_DELETE(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, String string, String string2, String string3, String string4, String string5, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string6 = null;
        boolean bl2 = APIUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files_and_subfolders"), false);
        boolean bl3 = APIUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files"), false);
        if (!(string3 != null && !string3.equalsIgnoreCase(string5) || bl3 || bl2)) {
            object3 = (String)hashtable.get("jrs.node_prop$" + string5);
            object2 = CSUtil.parseQuery((String)object3);
            Hashtable[] hashtableArray = null;
            hashtableArray = APIUtil.getBoolean((String)((Hashtable)object2).get("jrs.define_permission"), false) ? this.getPropPermission((Hashtable)object2) : new Hashtable[3];
            String string7 = (String)((Hashtable)object2).get("jrs.node_name");
            object = this.jrservlet.getHttpRptServer().getResourceManager().createFolder(string2, string, string7, (Hashtable)object2, hashtableArray);
            if (object == null) {
                throw new Exception("Create folder failed");
            }
            ((Hashtable)object2).clear();
            string = this.I(string, string7, "/");
        }
        if (string3 == null) {
            string3 = string5;
        }
        object3 = WebSecurityUtil.validateFilePath(string4);
        object2 = null;
        if (object3 != null) {
            object2 = ((File)object3).listFiles();
        }
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.is_deploy_locally"), false);
        if (object2 != null) {
            for (int i = 0; i < ((Object)object2).length; ++i) {
                String string8;
                object = object2[i];
                String string9 = string8 = this.I(string3, ((File)object).getName(), string5);
                String string10 = ((File)object).getPath();
                String string11 = (String)hashtable.get("jrs.node_prop$" + string9);
                if (string11 == null) continue;
                Properties properties = CSUtil.parseQuery(string11);
                Hashtable[] hashtableArray = new Hashtable[3];
                if (APIUtil.getBoolean((String)((Hashtable)properties).get("jrs.define_permission"), false)) {
                    hashtableArray = this.getPropPermission(properties);
                }
                String string12 = string10.substring(string10.lastIndexOf(File.separator) + 1);
                try {
                    String string13;
                    if (((File)object).isDirectory()) {
                        String string14 = (String)((Hashtable)properties).get("jrs.node_name");
                        string13 = this.jrservlet.getHttpRptServer().getResourceManager().createFolder(string2, string, string14, properties, hashtableArray);
                        String string15 = this.P_DELETE(vector, vector2, vector3, hashtable, this.I(string, string14, string5), string2, string8, string10, string5, bl);
                        if (string15 != null && string15.indexOf("LR") != -1) {
                            string6 = string6 == null ? string15 : string6 + "," + string15.substring(string15.indexOf("LR") + 3);
                        }
                    } else {
                        if (bl4) {
                            int n = CSUtil.parseInt((String)((Hashtable)properties).get("jrs.node_type"), 0);
                            string13 = (String)((Hashtable)properties).get("Catalog_New_Path");
                            if (n == 2 && string13 != null && string13.trim().length() != 0) {
                                string10 = string13;
                            }
                        }
                        ((Hashtable)properties).put("jrs.deploy_from_file", string10);
                        if (!ReportEnv.isLive() && RefResource.isLiveReport(string10)) {
                            string6 = string6 == null ? "LR:" + string12 : string6 + "," + string12;
                        } else {
                            VersionRecord versionRecord = this.jrservlet.getHttpRptServer().getResourceManager().addResource(string2, string, bl, properties, hashtableArray);
                        }
                    }
                }
                catch (NodeExistsException nodeExistsException) {
                    ServiceLogger.logError(nodeExistsException.toString());
                    if (CSUtil.isCatalogFile(string12)) {
                        this.isDeployMutilCat = true;
                    } else {
                        this.deployNodeExists = this.deployNodeExists == null ? string12 : this.deployNodeExists + "," + string12;
                    }
                }
                catch (NoPrivilegeException noPrivilegeException) {
                    ServiceLogger.logError(noPrivilegeException.toString());
                    this.deployNoPrivilege = this.deployNoPrivilege == null ? string12 : this.deployNoPrivilege + "," + string12;
                }
                catch (UnknownResource unknownResource) {
                    ServiceLogger.logError(unknownResource.toString());
                    this.deployUnknownResource = this.deployUnknownResource == null ? string12 : this.deployUnknownResource + "," + string12;
                }
                hashtable.remove("jrs.node_prop$" + string8);
                ((Hashtable)properties).clear();
            }
        }
        return string6;
    }

    private String P_EXECUTE(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, String string, String string2, String string3, String string4, boolean bl) throws Exception {
        String string5 = null;
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.is_deploy_locally"), false);
        int n = CSUtil.parseInt((String)hashtable.get("jrs.node_type"), 0);
        boolean bl3 = APIUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false);
        boolean bl4 = APIUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files_and_subfolders"), false);
        boolean bl5 = APIUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files"), false);
        Hashtable hashtable2 = hashtable;
        Hashtable[] hashtableArray = new Hashtable[3];
        if (APIUtil.getBoolean((String)hashtable2.get("jrs.define_permission"), false)) {
            hashtableArray = this.getPropPermission(hashtable2);
        }
        if (n == 2 || n == 0) {
            String string6 = (String)hashtable2.get("jrs.deploy_from_file");
            if (string6 != null && !bl2) {
                int n2 = string6.lastIndexOf(string4);
                string6 = string6.substring(++n2);
                string6 = this.I(string3, string6, File.separator);
                hashtable2.put("jrs.deploy_from_file", string6);
            }
            if (!ReportEnv.isLive() && RefResource.isLiveReport((String)hashtable2.get("jrs.deploy_from_file"))) {
                string5 = "LR:" + string6.substring(string6.lastIndexOf(File.separator) + 1);
            } else {
                VersionRecord versionRecord = this.jrservlet.getHttpRptServer().getResourceManager().addResource(string2, string, bl, hashtable2, hashtableArray);
                if (versionRecord == null) {
                    throw new Exception("Deploy resource failed.");
                }
            }
        } else if (n == 3) {
            String string7 = null;
            String string8 = (String)hashtable2.get("jrs.node_name");
            if (!bl4 || !bl5 || bl3) {
                string7 = this.jrservlet.getHttpRptServer().getResourceManager().createFolder(string2, string, string8, hashtable2, hashtableArray);
            }
            if (bl3 || bl4 || bl5) {
                String string9 = null;
                string9 = bl4 || bl5 ? string : (string != null && string.equals("/") ? string + string8 : string + "/" + string8);
                string5 = this.jrservlet.getHttpRptServer().getResourceManager().addResourcesToFolder(string2, string9, string3, !bl5, bl, hashtable2, hashtableArray);
            }
        }
        return string5;
    }

    public void responseCanExportDhtmlResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.report");
        String string2 = (String)hashtable.get("jrs.catalog");
        int n = CSUtil.parseInt((String)hashtable.get("jrs.rpt_version"), -1);
        int n2 = CSUtil.parseInt((String)hashtable.get("jrs.cat_version"), -1);
        boolean bl = this.jrservlet.getHttpRptServer().getReportInfo(this.jrservlet.getUser(httpServletRequest), string2, n2, string, n).canExportDHTMLResult();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseGetCompletedDetailInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.id");
        CompletedTaskRecord completedTaskRecord = this.jrservlet.getHttpRptServer().getCompletedTaskTable().getCompletedTaskRecord(string);
        TaskSuccessInfo taskSuccessInfo = completedTaskRecord.getSuccessInfo();
        Hashtable hashtable2 = taskSuccessInfo.getPublishRecords();
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                String string2 = (String)enumeration.nextElement();
                Vector vector = (Vector)hashtable2.get(string2);
                if (vector != null) {
                    hashtable3.put("jrs.report_sheet", string2);
                    hashtable3.put("count", String.valueOf(vector.size()));
                    for (int i = 0; i < vector.size(); ++i) {
                        CompletedPublishRecord completedPublishRecord = (CompletedPublishRecord)vector.get(i);
                        hashtable3.put("type" + i, completedPublishRecord.getType());
                        Vector vector2 = completedPublishRecord.getResults() == null ? new Vector() : completedPublishRecord.getResults();
                        hashtable3.put("rCounts" + i, String.valueOf(vector2.size()));
                        for (int j = 0; j < vector2.size(); ++j) {
                            CompletedResultRecord completedResultRecord = (CompletedResultRecord)vector2.get(j);
                            hashtable3.put("rType_" + i + "_" + j, completedResultRecord.getType());
                            hashtable3.put("rStatus_" + i + "_" + j, String.valueOf(completedResultRecord.getStatus()));
                            hashtable3.put("rDetail_" + i + "_" + j, completedResultRecord.getDetail());
                        }
                    }
                }
                jRStringBufferPrintWriter.println(CSUtil.makeNoHeadQuery(hashtable3));
            }
        } else {
            jRStringBufferPrintWriter.println("count=0");
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseGetEnableDisplayPermissions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean[] blArray = new boolean[]{this.jrservlet.getHttpRptServer().getAdminService().getConfigService().getConfigurationAdvanced().isEnableDispalyRolePermissionUI(), this.jrservlet.getHttpRptServer().getAdminService().getConfigService().getConfigurationAdvanced().isEnableDispalyUserPermissionUI(), this.jrservlet.getHttpRptServer().getAdminService().getConfigService().getConfigurationAdvanced().isEnableDispalyGroupPermissionUI()};
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        int n = 0;
        for (n = 0; n < 3; ++n) {
            jRStringBufferPrintWriter.println(String.valueOf(blArray[n]));
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseGetInheritPermissions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = (String)hashtable.get("jrs.path");
        int n = CSUtil.parseInt((String)hashtable.get("jrs.version_number"));
        boolean bl = true;
        Hashtable[] hashtableArray = this.jrservlet.getHttpRptServer().getResourceManager().getInheritedPermissions(string, string2, n);
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        if (hashtableArray != null) {
            if (hashtableArray[0] != null) {
                hashtable2.put("jrs.user_permission", hashtableArray[0]);
            }
            if (hashtableArray[1] != null) {
                hashtable2.put("jrs.role_permission", hashtableArray[1]);
            }
            if (hashtableArray[2] != null) {
                hashtable2.put("jrs.group_permission", hashtableArray[2]);
            }
        }
        objectOutputStream.writeObject(hashtable2);
        objectOutputStream.close();
    }

    public void responseGetPermissions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = (String)hashtable.get("jrs.path");
        int n = CSUtil.parseInt((String)hashtable.get("jrs.version_number"));
        boolean bl = true;
        Hashtable[] hashtableArray = this.jrservlet.getHttpRptServer().getResourceManager().getPermissions(string, string2, n);
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        if (hashtableArray != null) {
            if (hashtableArray[0] != null) {
                hashtable2.put("jrs.user_permission", hashtableArray[0]);
            }
            if (hashtableArray[1] != null) {
                hashtable2.put("jrs.role_permission", hashtableArray[1]);
            }
            if (hashtableArray[2] != null) {
                hashtable2.put("jrs.group_permission", hashtableArray[2]);
            }
        }
        objectOutputStream.writeObject(hashtable2);
        objectOutputStream.close();
    }

    public void responseExportScripts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        int n = CSUtil.parseInt((String)hashtable.get("COUNT"));
        int n2 = 0;
        String[] stringArray = new String[n];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2] = (String)hashtable.get(String.valueOf(n2));
        }
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = this.jrservlet.getHttpRptServer().exportScripts(string, stringArray);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        jRStringBufferPrintWriter.println(string2);
        jRStringBufferPrintWriter.close();
    }

    public void responseGetParseImportScripts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        String string = (String)hashtable.get("jrs.import_schedule_scripts");
        Properties[] propertiesArray = this.jrservlet.getHttpRptServer().parseScripts(string);
        int n = propertiesArray.length;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("COUNT", String.valueOf(n));
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            hashtable2.put(String.valueOf(n2), CSUtil.makeQuery(propertiesArray[n2]));
        }
        httpServletResponse.setContentType("text/plain");
        objectOutputStream.writeObject(hashtable2);
        objectOutputStream.close();
    }

    public void responseSubmitTasks(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object[] objectArray;
        Object object;
        int n = CSUtil.parseInt((String)hashtable.get("COUNT"));
        Properties[] propertiesArray = new Properties[n];
        if (hashtable != null) {
            object = hashtable.keys();
            objectArray = (Object[])object.nextElement();
            for (int i = 0; i < n; ++i) {
                propertiesArray[i] = CSUtil.parseQuery((String)hashtable.get(String.valueOf(i)));
            }
        }
        object = this.jrservlet.getUser(httpServletRequest);
        objectArray = this.jrservlet.getHttpRptServer().submitScheduledTasks((String)object, propertiesArray);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        int n2 = 0;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            jRStringBufferPrintWriter.println(String.valueOf(objectArray[n2]));
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseSecurityAdaptor(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        SecurityWebAdaptor securityWebAdaptor = this.jrservlet.getHttpRptServer().getSecurityWebAdaptor();
        boolean[] blArray = new boolean[3];
        blArray[1] = securityWebAdaptor.isEditing(11);
        blArray[0] = securityWebAdaptor.isEditing(12);
        blArray[2] = securityWebAdaptor.isEditing(13);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        int n = 0;
        for (n = 0; n < 3; ++n) {
            jRStringBufferPrintWriter.println(String.valueOf(blArray[n]));
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseGetAllConditionTriggersName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws IOException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        TriggerManager triggerManager = this.jrservlet.getHttpRptServer().getTriggerManager();
        Iterator iterator = triggerManager.iterator();
        while (iterator.hasNext()) {
            object = (Trigger)iterator.next();
            stringBuffer.append(object.getName()).append(";");
        }
        object = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        ((JRStringBufferPrintWriter)object).println(stringBuffer.toString());
        ((JRStringBufferPrintWriter)object).close();
    }

    public void responseCreateConditionTrigger(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        TriggerManager triggerManager = this.jrservlet.getHttpRptServer().getTriggerManager();
        String string = (String)hashtable.get("TriggerName");
        String string2 = (String)hashtable.get("TriggerDescription");
        if (triggerManager.contains(string)) {
            throw new Exception("Trigger name already exists.");
        }
        triggerManager.createTrigger(string, string2);
    }

    public void responseIsEnableDynamicResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl = this.jrservlet.getHttpRptServer().getServerEnv().getWebPageOptions().isEnableDynamicResource();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseGetMediaTray(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        Hashtable hashtable2 = this.jrservlet.getHttpRptServer().getMediaTray();
        objectOutputStream.writeObject(hashtable2);
        objectOutputStream.close();
    }

    public void responseGetPaperList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String[] stringArray = this.jrservlet.getHttpRptServer().getPaperList();
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]).append(";");
        }
        jRStringBufferPrintWriter.println(stringBuffer.toString());
        jRStringBufferPrintWriter.close();
    }

    public void responseIsEnableDuration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl = this.jrservlet.getHttpRptServer().getServerEnv().getWebPageOptions().isEnableTaskDuration();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsOnlyContainBurstRpt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        int n;
        String string = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.catalog");
        String string4 = (String)hashtable.get("jrs.user");
        ReportInfo reportInfo = this.jrservlet.getHttpRptServer().getReportInfo(string4, string3, string2);
        Vector vector = reportInfo.getReportSheetInfos();
        boolean bl = false;
        int n2 = vector.size();
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            ReportSheetInfo reportSheetInfo = (ReportSheetInfo)vector.get(n);
            blArray[n] = reportSheetInfo.isBurstingReport();
        }
        for (n = 0; n < n2; ++n) {
            boolean bl2 = bl = !blArray[n];
            if (bl) break;
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(!bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsNoBurstRpt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.catalog");
        String string4 = (String)hashtable.get("jrs.user");
        String string5 = (String)hashtable.get("jrs.cat_version");
        String string6 = (String)hashtable.get("jrs.rpt_version");
        int n = string5 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string6);
        ReportInfo reportInfo = this.jrservlet.getHttpRptServer().getReportInfo(string4, string3, n, string2, n2);
        Vector vector = reportInfo.getReportSheetInfos();
        boolean bl = true;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            ReportSheetInfo reportSheetInfo = (ReportSheetInfo)vector.get(i);
            if (!reportSheetInfo.isBurstingReport()) continue;
            bl = false;
            break;
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseCurrentRptIsBursting(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.catalog");
        String string4 = (String)hashtable.get("jrs.user");
        ReportInfo reportInfo = this.jrservlet.getHttpRptServer().getReportInfo(string4, string3, string2);
        ReportSheetInfo reportSheetInfo = reportInfo.getCurrentReportSheet();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(reportSheetInfo.isBurstingReport()));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsSplitPDF(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ConfigurationMail configurationMail = this.jrservlet.getHttpRptServer().getAdminService().getConfigService().getConfigurationMail();
        boolean bl = configurationMail.getSplitBy() == 0 && configurationMail.getMaxMailSize() > 0 || configurationMail.getSplitBy() == 1 && configurationMail.getMaxMailPage() > 0;
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsPromptTaskQueueFull(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = this.jrservlet.getHttpRptServer().getServerEnv().getWebPageOptions().isPromptTaskQueueFull();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsTaskQueueFull(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = ServerEnv.getOndemandTaskInitPriority();
        String string = "false";
        ClusterService clusterService = this.jrservlet.getHttpRptServer().getClusterService();
        if (clusterService != null) {
            if (clusterService.isTaskQueueFull(n)) {
                string = "true";
            }
        } else if (HttpUtil.getHttpRptServer().isTaskQueueFull(n)) {
            string = "true";
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(string));
        jRStringBufferPrintWriter.close();
    }

    public void responseGetGlobalNLS(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("locale");
        Locale locale = ServerUtil.getLocale(string);
        Properties properties = new Properties();
        List list = UserDataToolkit.getNLSManager().getGlobalNLS(locale);
        for (NLSEntry nLSEntry : list) {
            NLSEntry nLSEntry2;
            GlobalNLSRecord globalNLSRecord = null;
            if (nLSEntry instanceof TextNLSEntry) {
                nLSEntry2 = (TextNLSEntry)nLSEntry;
                globalNLSRecord = new GlobalNLSRecord(GlobalNLSRecord.getTypeIntValue(((TextNLSEntry)nLSEntry2).getType()), ((TextNLSEntry)nLSEntry2).getKeyText(), ((TextNLSEntry)nLSEntry2).getValueText());
            } else if (nLSEntry instanceof FormatNLSEntry) {
                nLSEntry2 = (FormatNLSEntry)nLSEntry;
                globalNLSRecord = new GlobalNLSRecord(((FormatNLSEntry)nLSEntry2).getKeyFormat(), ((FormatNLSEntry)nLSEntry2).getValueFormat());
            } else {
                nLSEntry2 = (FontNLSEntry)nLSEntry;
                globalNLSRecord = new GlobalNLSRecord(((FontNLSEntry)nLSEntry2).getOrginalFace(), ((FontNLSEntry)nLSEntry2).getOrginalSize(), ((FontNLSEntry)nLSEntry2).getTargetFace(), ((FontNLSEntry)nLSEntry2).getTargetSize(), ((FontNLSEntry)nLSEntry2).isRelative());
            }
            properties.setProperty(globalNLSRecord.getPropKey(), globalNLSRecord.getPropValue());
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        objectOutputStream.writeObject(properties);
        objectOutputStream.close();
    }

    public void responseGetMailConfigInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Properties properties = new Properties();
        ConfigurationMail configurationMail = this.jrservlet.getHttpRptServer().getAdminService().getConfigService().getConfigurationMail();
        properties.setProperty("jrs.mailfrom", configurationMail.getMailBox());
        properties.setProperty("jrs.smtp_authentication", String.valueOf(configurationMail.getAuthentication()));
        properties.setProperty("jrs.smtp_SSL", String.valueOf(configurationMail.getSSL()));
        properties.setProperty("jrs.mailcompress", String.valueOf(configurationMail.getEnableCompress()));
        properties.setProperty("jrs.mailformat", String.valueOf(configurationMail.getDefaultMailFormat()));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        objectOutputStream.writeObject(properties);
        objectOutputStream.close();
    }

    public void responseIsClusterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = ServerEnv.isClusterEnabled();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsDashboardEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = ServerEnv.isEnabledDashboard();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsMultiTenancyEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = ServerEnv.isEnableMultipleOrganization();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsVAEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl = ServerEnv.isEnabledVA();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(bl));
        jRStringBufferPrintWriter.close();
    }

    public void responseIsCheckSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(String.valueOf(ServerEnv.needSecurity()));
        jRStringBufferPrintWriter.close();
    }
}

