/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.RptServer;
import jet.server.api.http.HttpUtil;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.db.core.DatabaseImpl;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.storage.Storage;
import jet.server.storage.StorageException;
import jet.server.storage.impl.PATH;
import jet.server.storage.impl.StorageImpl;
import jet.server.storage.impl.StorageWrapper;

public class StorageEnv
implements Serializable {
    private static DatabaseImpl $SwitchMap$jet$server$storage$Storage$StorageRoot;
    private static Storage HISTORY;
    public static final int MESSAGE_TIMEOUT = 0;
    private static final ThreadLocal SEDU;
    private static StorageEnv STORAGE_ENV_MAP;
    private static final HashMap Z;
    private static ClusterMap append;
    private final int memberId;
    private final Map rootInfos;

    private StorageEnv(int n, Map map) {
        this.memberId = n;
        this.rootInfos = map;
    }

    public static void init(DatabaseImpl databaseImpl) throws StorageException {
        $SwitchMap$jet$server$storage$Storage$StorageRoot = databaseImpl;
        STORAGE_ENV_MAP = new StorageEnv(ClusterEnv.getMemberID(), new HashMap());
        Z.put(ClusterEnv.getMemberID(), STORAGE_ENV_MAP);
        StorageEnv.$SwitchMap$jet$server$storage$Storage$StorageRoot();
        try {
            HISTORY = new StorageImpl(databaseImpl);
            if (ServerEnv.isClusterEnabled() || ServerEnv.isRMIServerEnable() || ServerEnv.isRMIMonitorEnable()) {
                RemoteObjectFactory.registerRpcHandler(StorageWrapper.handlerName, HISTORY);
            }
            append = MapFactory.getMap(MapAttr.STORAGE_ENV_MAP);
            append.put((Object)ClusterEnv.getMemberID(), StorageEnv.STORAGE_ENV_MAP.rootInfos);
        }
        catch (Exception exception) {
            throw new StorageException("Storage init failed.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getStorage() throws StorageException {
        if (HISTORY != null) {
            return HISTORY;
        }
        if (!HttpUtil.isRemoteServer()) {
            throw new StorageException("Storage not inited.");
        }
        Class<StorageEnv> clazz = StorageEnv.class;
        synchronized (StorageEnv.class) {
            try {
                String string = System.getProperty("jrs.remote.host");
                int n = CSUtil.parseInt(System.getProperty("jrs.remote.rmiport"));
                HISTORY = new StorageWrapper(RemoteObjectFactory.getRpcDispatcher(string, n));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new StorageException("Storage init failed.", (Throwable)exception);
            }
            return HISTORY;
        }
    }

    public static Storage getStorage(RptServer rptServer) throws StorageException {
        if (rptServer.isClusterEnable() && !(rptServer instanceof JRRptServer)) {
            int n = CSUtil.parseInt(rptServer.getClusterService().getLocalMember().getPort());
            try {
                return new StorageWrapper(RemoteObjectFactory.getRpcDispatcher(rptServer.getClusterService().getLocalMember().getHost(), n));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new StorageException("Storage init failed.", (Throwable)exception);
            }
        }
        return StorageEnv.getStorage();
    }

    public static void close() {
        if (HISTORY != null && HISTORY instanceof StorageImpl) {
            ((StorageImpl)HISTORY).close();
        }
        $SwitchMap$jet$server$storage$Storage$StorageRoot = null;
        HISTORY = null;
    }

    public static boolean isSharedDisk(Storage.StorageRoot storageRoot) {
        return false;
    }

    public static int getCopies(Storage.StorageRoot storageRoot) {
        switch (storageRoot) {
            case HISTORY: {
                return ServerEnv.getStorageCopyNumber("cluster.storage.history.copy_number");
            }
            case REALM: {
                return ServerEnv.getStorageCopyNumber("cluster.storage.realm.copy_number");
            }
            case CRD_CACHE: {
                return ServerEnv.getStorageCopyNumber("cluster.storage.crd.result.copy_number");
            }
            case FONT: 
            case STYLE: 
            case GISINFO: {
                return 0;
            }
        }
        return 1;
    }

    private static void $SwitchMap$jet$server$storage$Storage$StorageRoot() throws StorageException {
        block11: for (Storage.StorageRoot storageRoot : Storage.StorageRoot.values()) {
            StorageRootInfo storageRootInfo = new StorageRootInfo();
            storageRootInfo.copies = 1;
            storageRootInfo.isSharedDisk = false;
            StorageEnv.STORAGE_ENV_MAP.rootInfos.put(storageRoot, storageRootInfo);
            switch (storageRoot) {
                case HISTORY: {
                    storageRootInfo.copies = ServerEnv.getStorageCopyNumber("cluster.storage.history.copy_number");
                    storageRootInfo.isSharedDisk = ServerEnv.isSharedHistDir();
                    if (ServerEnv.isSharedHistDir()) {
                        storageRootInfo.setDiskDir(ServerEnv.getSharedHistDir());
                        continue block11;
                    }
                    if (System.getProperty("history_dir") != null) {
                        storageRootInfo.setDiskDir(System.getProperty("history_dir"));
                        continue block11;
                    }
                    storageRootInfo.setDiskDir(ServerEnv.getReportHome() + "history");
                    continue block11;
                }
                case REALM: {
                    storageRootInfo.copies = ServerEnv.getStorageCopyNumber("cluster.storage.realm.copy_number");
                    String string = ServerEnv.getShareRealmDirectory();
                    storageRootInfo.isSharedDisk = string != null && string.length() > 0;
                    storageRootInfo.setDiskDir(ServerEnv.realmsPath);
                    continue block11;
                }
                case PROPERTIES: {
                    String string = ServerEnv.getSharePropertyDirectory();
                    storageRootInfo.isSharedDisk = string != null && string.length() > 0;
                    storageRootInfo.setDiskDir(ServerEnv.propertiesPath);
                    continue block11;
                }
                case JREPORTS: {
                    String string = ServerEnv.getClusterResourceRoot();
                    storageRootInfo.isSharedDisk = string != null && string.length() > 0;
                    storageRootInfo.setDiskDir(ServerEnv.getResourceRoot());
                    continue block11;
                }
                case TEMP: {
                    storageRootInfo.isSharedDisk = ServerEnv.isSharedTempDir();
                    storageRootInfo.setDiskDir(ServerEnv.isSharedTempDir() ? ServerEnv.getSharedTempDir() : ServerEnv.getReportHome() + "temp");
                    continue block11;
                }
                case FONT: {
                    storageRootInfo.copies = 0;
                    storageRootInfo.setDiskDir(ServerEnv.getFontPath());
                    continue block11;
                }
                case STYLE: {
                    storageRootInfo.copies = 0;
                    storageRootInfo.setDiskDir(ServerEnv.getReportHome() + ServerEnv.getStyleFolder());
                    continue block11;
                }
                case GISINFO: {
                    storageRootInfo.copies = 0;
                    storageRootInfo.setDiskDir(ServerEnv.getGisinfoPath());
                    continue block11;
                }
                case CRD_CACHE: {
                    storageRootInfo.copies = ServerEnv.getStorageCopyNumber("cluster.storage.crd.result.copy_number");
                    storageRootInfo.setDiskDir(ServerEnv.getReportHome() + "cache");
                    continue block11;
                }
                default: {
                    storageRootInfo.setDiskDir(ServerEnv.getReportHome() + storageRoot.toString().toLowerCase());
                }
            }
        }
        ServiceLogger.logDebug(4670129, new Object[]{ServerEnv.isClusterEnabled(), StorageEnv.STORAGE_ENV_MAP.rootInfos}, 4);
    }

    public static void setThreadMember(int n) {
        SEDU.set(n);
    }

    public static int getThreadMember() {
        Integer n = (Integer)SEDU.get();
        if (n != null) {
            return n;
        }
        return -1;
    }

    public static StorageEnv localEnv() {
        return STORAGE_ENV_MAP;
    }

    public static StorageEnv getStorageEnv(int n) {
        Map map;
        StorageEnv storageEnv = (StorageEnv)Z.get(n);
        if (storageEnv == null && (map = (Map)append.get(n)) != null) {
            storageEnv = new StorageEnv(n, map);
            Z.put(n, storageEnv);
        }
        return storageEnv == null ? STORAGE_ENV_MAP : storageEnv;
    }

    public int getMemberId() {
        return this.memberId;
    }

    public boolean isLocalEnv() {
        return this.memberId == ClusterEnv.getMemberID();
    }

    public String getDiskDir(Storage.StorageRoot storageRoot) {
        return ((StorageRootInfo)this.rootInfos.get((Object)storageRoot)).getDiskDir();
    }

    public String getFileSeprator() {
        return ((StorageRootInfo)this.rootInfos.get((Object)Storage.StorageRoot.HISTORY)).getFileSeprator();
    }

    public String abstractStoragePath(Storage.StorageRoot storageRoot, String string, int n) {
        String string2 = ((StorageRootInfo)this.rootInfos.get((Object)storageRoot)).getDiskDir();
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
            string = storageRoot.getRootPath() + PATH.normalizePath(string);
        } else if (!(string = PATH.normalizePath(string)).startsWith(storageRoot.getRootPath())) {
            string = storageRoot.getRootPath() + string;
        }
        string = PATH.trimPath(string, n);
        return string;
    }

    public String relativeStoragePath(Storage.StorageRoot storageRoot, String string, int n) {
        String string2 = ((StorageRootInfo)this.rootInfos.get((Object)storageRoot)).getDiskDir();
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
        } else if ((string = PATH.normalizePath(string)).startsWith(storageRoot.getRootPath())) {
            string = string.substring(storageRoot.getRootPath().length());
        }
        string = PATH.trimPath(string, n);
        return string;
    }

    public String relativeDiskPath(Storage.StorageRoot storageRoot, String string) {
        String string2 = string;
        String string3 = ((StorageRootInfo)this.rootInfos.get((Object)storageRoot)).getDiskDir();
        if (string2.startsWith(string3)) {
            string2 = string2.substring(string3.length());
        }
        return string2;
    }

    static {
        SEDU = new ThreadLocal();
        Z = new HashMap();
    }

    static class StorageRootInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String diskDir;
        private final String fileSeprator = File.separator;
        int copies;
        boolean isSharedDisk;

        StorageRootInfo() {
        }

        void setDiskDir(String string) {
            File file = new File(string);
            try {
                this.diskDir = file.getCanonicalPath();
                if (!this.diskDir.endsWith(this.fileSeprator)) {
                    this.diskDir = this.diskDir + this.fileSeprator;
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }

        public String getDiskDir() {
            return this.diskDir;
        }

        public String getFileSeprator() {
            return this.fileSeprator;
        }

        public String toString() {
            return this.diskDir + "(" + this.copies + ":" + this.isSharedDisk + ")";
        }
    }
}

