/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jet.server.log.ServiceLogger;
import jet.server.ui.Combobox;
import jet.server.util.ServerUtil;

public class MultiCombobox
extends Combobox {
    protected List<String> values;
    protected List<String[]> selectedValueList;
    protected boolean isAllowAll;

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue() {
        if (this.values == null && this.isAllowAll) {
            return super.getValue();
        }
        String string = "";
        if (this.values != null) {
            for (String string2 : this.values) {
                string = string + "[" + string2 + "]";
            }
        }
        return string;
    }

    @Override
    public String encodeValue() {
        String string = this.getValue();
        if (string != null) {
            return ServerUtil.encodeUrl(this.getValue());
        }
        return "";
    }

    public void setValues(List<String> list) {
        boolean bl = false;
        if (list != null) {
            for (String string : list) {
                if (!string.equals("\u0007")) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.values = null;
                this.value = "\u0007";
            } else {
                this.values = list;
            }
        } else {
            this.values = list;
        }
    }

    @Override
    public String getDisplayValue() {
        String string = "";
        if (this.values == null) {
            string = this.displayValue;
        } else {
            List<String[]> list = this.getSelectedValueList();
            for (String[] stringArray : list) {
                String string2 = "";
                boolean bl = false;
                if (bl) {
                    string = string + string2 + ",";
                    continue;
                }
                string = string + stringArray[1] + ",";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    @Override
    public String getNLSValue() {
        String string = "";
        if (this.values == null) {
            string = this.nlsValue;
        } else {
            List<String[]> list = this.getSelectedValueList();
            for (String[] stringArray : list) {
                String string2 = "";
                boolean bl = false;
                if (bl) {
                    string = string + string2 + ",";
                    continue;
                }
                string = string + stringArray[2] + ",";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    @Override
    public String getTipsValue() {
        String string = "";
        if (this.values == null) {
            string = this.displayValue;
        } else {
            List<String[]> list = this.getSelectedValueList();
            for (String[] stringArray : list) {
                string = string + stringArray[1] + ",";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public List<String[]> getSelectedValueList() {
        if (this.selectedValueList == null) {
            this.selectedValueList = new LinkedList<String[]>();
            if (this.values != null) {
                for (String string : this.values) {
                    Object[] objectArray2;
                    boolean bl = false;
                    for (Object[] objectArray2 : this.dropDownList) {
                        if (!string.equals(objectArray2[0])) continue;
                        this.selectedValueList.add((String[])objectArray2);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    Object object = null;
                    Object[] objectArray3 = objectArray2 = null == this.hItems ? null : (String[])this.hItems.get(string);
                    if (null == objectArray2) {
                        ServiceLogger.logDebug("MultiCombobox::getSelectedValueList: value" + string + ", item=" + Arrays.toString(objectArray2), 4);
                    } else {
                        object = objectArray2[3];
                    }
                    this.selectedValueList.add(new String[]{string, string, null == object ? string : object});
                }
            }
        }
        return this.selectedValueList;
    }

    public List<String[]> encodeSelectedValueList() {
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        List<String[]> list = this.getSelectedValueList();
        for (String[] stringArray : list) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = i == 0 ? ServerUtil.encodeUrl(stringArray[i]) : stringArray[i];
            }
            linkedList.add(stringArray2);
        }
        return linkedList;
    }

    public MultiCombobox(String string, String string2) {
        super(string, string2);
    }

    public MultiCombobox(String string, List<String> list) {
        super(string, null);
        this.setValues(list);
    }

    public boolean isAllowAll() {
        return this.isAllowAll;
    }

    public void setAllowAll(boolean bl) {
        this.isAllowAll = bl;
    }

    public boolean hasDateExpression() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isTime() {
        return false;
    }
}

