/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.userman.AclImpl;
import jet.server.userman.GroupImpl;
import jet.server.userman.PermissionImpl;
import jet.server.userman.Realm;
import jet.server.userman.Resource;
import jet.server.userman.User;
import jet.server.userman.UserDataToolkit;
import jet.server.userman.UserImpl;

public final class SharedPasswordRealm
extends Realm {
    private Vector I = new Vector();

    public SharedPasswordRealm(String string) {
        super(string);
        if (string.trim().length() == 0) {
            return;
        }
        String string2 = ServerEnv.realmsPath + string + File.separator;
        this.realmDir = new File(string2);
    }

    public void addPermission(Permission permission) {
        if (!this.I.contains(permission)) {
            this.I.addElement(permission);
        }
    }

    public synchronized void removeUser(String string) throws NoSuchUserException, BadRealmException {
        if (this.isUserExist(string)) {
            UserImpl userImpl = (UserImpl)this.users.get(string);
            this.users.remove(string);
            return;
        }
        throw new NoSuchUserException(string);
    }

    public void removePermission(Permission permission) {
        if (this.I.contains(permission)) {
            this.I.removeElement(permission);
        }
    }

    public Permission getPermission(String string) {
        for (int i = 0; i < this.I.size(); ++i) {
            PermissionImpl permissionImpl = (PermissionImpl)this.I.elementAt(i);
            if (!permissionImpl.getName().equalsIgnoreCase(string)) continue;
            return permissionImpl;
        }
        return null;
    }

    public Enumeration permissions() {
        return this.I.elements();
    }

    public synchronized void createUser(String string, String string2) throws InUseException, BadRealmException {
        if (string == null) {
            return;
        }
        try {
            UserImpl userImpl = (UserImpl)this.getUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            if (this.isGroupExist(this.name)) {
                return;
            }
            UserImpl userImpl = new UserImpl(string, string2);
            userImpl.setRealm(this);
            String string3 = this.realmDir.getPath() + File.separator + string + File.separator;
            userImpl.setHomePath(string3);
            this.users.put(string, userImpl);
            return;
        }
        throw new InUseException(string);
    }

    public synchronized void changePassword(String string, String string2) throws NoSuchUserException, BadRealmException {
        User user = this.getUser(string);
        user.setAuthInfo(string2);
    }

    @Override
    public synchronized void deleteUser(String string) throws NoSuchUserException, BadRealmException, InUseException {
        if (this.isUserExist(string)) {
            UserImpl userImpl = (UserImpl)this.users.get(string);
            this.verifyNotInPolicies(userImpl);
            this.users.remove(string);
            return;
        }
        throw new NoSuchUserException(string);
    }

    @Override
    public synchronized Enumeration getUserNames() throws BadRealmException {
        return this.users.keys();
    }

    public synchronized Enumeration getUsers() throws BadRealmException {
        return this.users.elements();
    }

    @Override
    public synchronized User getUser(String string) throws NoSuchUserException, BadRealmException {
        User user = (User)this.users.get(string);
        if (user != null) {
            return user;
        }
        throw new NoSuchUserException(string);
    }

    public synchronized boolean isUserExist(String string) {
        if (string == null) {
            return false;
        }
        return this.users.containsKey(string);
    }

    public synchronized void save() {
        Object object;
        Object object2;
        Object object3;
        try {
            UserDataToolkit.saveRealmProperties(this.getProperties(), this.name);
        }
        catch (Exception exception) {
            ServiceLogger.logError("Save realm " + this.name + " failed!");
            exception.printStackTrace();
        }
        try {
            object3 = this.getUsers();
            while (object3.hasMoreElements()) {
                object2 = (UserImpl)object3.nextElement();
                ((UserImpl)object2).save();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError("Save users failed!");
            exception.printStackTrace();
        }
        object3 = ServerEnv.realmsPath + this.name + File.separator;
        try {
            object2 = this.getGroups();
            while (object2.hasMoreElements()) {
                object = (GroupImpl)object2.nextElement();
                ((GroupImpl)object).save((String)object3 + ((GroupImpl)object).getName() + ".grp");
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError("Save groups failed!");
            exception.printStackTrace();
        }
        try {
            object2 = this.getAcls();
            while (object2.hasMoreElements()) {
                object = (AclImpl)object2.nextElement();
                ((AclImpl)object).save((String)object3 + ((AclImpl)object).getName() + ".acl");
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError("Save ACL failed!");
            exception.printStackTrace();
        }
        try {
            object2 = this.getResourceProperties();
            ((ExProperties)object2).save((String)object3 + "protection.properties", "");
        }
        catch (Exception exception) {
            ServiceLogger.logError("Save protection failed!");
            exception.printStackTrace();
        }
    }

    public synchronized EncodeExProperties getProperties() throws IOException, BadRealmException {
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        String string = ServerEnv.realmsPath + this.name + File.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        encodeExProperties.setProperty("name", this.name);
        encodeExProperties.setProperty("dir", string + " ");
        encodeExProperties.setProperty("scheme", this.scheme);
        return encodeExProperties;
    }

    public synchronized EncodeExProperties getResourceProperties() throws IOException, BadRealmException {
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        encodeExProperties.setProperty("count", this.resources.size());
        int n = 0;
        Enumeration enumeration = this.getResources();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            resource.save(encodeExProperties, "" + n++);
        }
        return encodeExProperties;
    }

    public synchronized void load(String string) {
        Serializable serializable;
        String string2 = null;
        try {
            serializable = new EncodeExProperties();
            ((ExProperties)serializable).load(new File(string));
            this.name = ((Properties)serializable).getProperty("name", "");
            string2 = ServerEnv.realmsPath + this.name + File.separator;
            this.realmDir = new File(string2);
            if (!this.realmDir.exists()) {
                return;
            }
            this.scheme = ((ExProperties)serializable).getProperty("scheme", 0);
        }
        catch (IOException iOException) {
            return;
        }
        serializable = new File(string2);
        String[] stringArray = ((File)serializable).list();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (new File(string2 + stringArray[i]).isDirectory()) {
                object = new UserImpl("xxx _ yyy", "");
                ((UserImpl)object).setRealm(this);
                if (!((UserImpl)object).load(string2 + stringArray[i])) continue;
                this.users.put(((UserImpl)object).getName(), object);
                continue;
            }
            if (stringArray[i].toLowerCase().endsWith(".grp")) {
                object = (GroupImpl)GroupImpl.load(string2 + stringArray[i]);
                if (object == null) continue;
                ((GroupImpl)object).setRealmName(this);
                this.groups.put(((GroupImpl)object).getName(), object);
                continue;
            }
            try {
                if (stringArray[i].toLowerCase().endsWith(".acl")) {
                    object = new AclImpl("");
                    ((AclImpl)object).setRealmName(this.name);
                    if (!((AclImpl)object).load(string2 + stringArray[i])) continue;
                    this.acls.put(((AclImpl)object).getName(), object);
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (!stringArray[i].equalsIgnoreCase("protection.properties") && !stringArray[i].equalsIgnoreCase("protec~1.pro")) continue;
                object = new EncodeExProperties();
                ((ExProperties)object).load(string2 + stringArray[i]);
                int n = ((ExProperties)object).getProperty("count", 0);
                for (int j = 0; j < n; ++j) {
                    Resource resource = new Resource(this);
                    resource.load((EncodeExProperties)object, "" + j);
                    this.resources.put(resource.getName(), resource);
                }
                continue;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        UserDataToolkit.compatibleChack(this);
    }

    public synchronized void loadOld(String string, String string2) {
        Serializable serializable;
        String string3 = null;
        try {
            serializable = new EncodeExProperties();
            ((ExProperties)serializable).load(new File(string2));
            this.name = ((Properties)serializable).getProperty("name", "");
            string3 = string + this.name + File.separator;
            this.realmDir = new File(string3);
            if (!this.realmDir.exists()) {
                return;
            }
            this.scheme = ((ExProperties)serializable).getProperty("scheme", 0);
        }
        catch (IOException iOException) {
            return;
        }
        serializable = new File(string3);
        String[] stringArray = ((File)serializable).list();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (new File(string3 + stringArray[i]).isDirectory()) {
                object = new UserImpl("xxx _ yyy", "");
                ((UserImpl)object).setRealm(this);
                if (!((UserImpl)object).load(string3 + stringArray[i])) continue;
                this.users.put(((UserImpl)object).getName(), object);
                continue;
            }
            if (stringArray[i].toLowerCase().endsWith(".grp")) {
                object = (GroupImpl)GroupImpl.load(string3 + stringArray[i]);
                if (object == null) continue;
                ((GroupImpl)object).setRealmName(this);
                this.groups.put(((GroupImpl)object).getName(), object);
                continue;
            }
            try {
                if (stringArray[i].toLowerCase().endsWith(".acl")) {
                    object = new AclImpl("");
                    ((AclImpl)object).setRealmName(this.name);
                    if (!((AclImpl)object).load(string3 + stringArray[i])) continue;
                    this.acls.put(((AclImpl)object).getName(), object);
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (!stringArray[i].equalsIgnoreCase("protection.properties") && !stringArray[i].equalsIgnoreCase("protec~1.pro")) continue;
                object = new EncodeExProperties();
                ((ExProperties)object).load(string3 + stringArray[i]);
                int n = ((ExProperties)object).getProperty("count", 0);
                for (int j = 0; j < n; ++j) {
                    Resource resource = new Resource(this);
                    resource.load((EncodeExProperties)object, "" + j);
                    this.resources.put(resource.getName(), resource);
                }
                continue;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        UserDataToolkit.compatibleChack(this);
    }
}

