/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman.ldap;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.security.Role;
import jet.server.log.ServiceLogger;
import jet.server.userman.AclEntryImpl;
import jet.server.userman.AclImpl;
import jet.server.userman.GroupImpl;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.User;
import jet.server.userman.UserDataToolkit;
import jet.server.userman.UserImpl;
import jet.server.userman.ldap.LdapConnection;
import jet.server.userman.ldap.LdapEnvironments;

public class LdapToolkit {
    public static boolean bIsImport = false;
    public static boolean bCanGetPw = false;
    private static LdapEnvironments SEDU = null;
    private static LdapConnection addElement = null;
    private static Vector addMember = new Vector();
    private static Vector append = new Vector();

    public static LdapConnection getConnection() {
        return addElement;
    }

    public static LdapEnvironments getEnvironments() {
        return SEDU;
    }

    public static void runAtServerRestart(String string) {
        LdapToolkit.runAtServerStart();
    }

    public static void runAtServerStart() {
        SEDU = new LdapEnvironments();
        if (!LdapToolkit.isLdapEnable()) {
            return;
        }
        addElement = new LdapConnection(SEDU);
        if (addElement.getLdapContext() == null) {
            ServiceLogger.logError("Ldap Server Connection Error!");
            return;
        }
        ServiceLogger.logDebug(4630089, new Date(System.currentTimeMillis()), 4);
    }

    public static void refreshLdapSettings() {
        if (SEDU == null) {
            SEDU = new LdapEnvironments();
        }
        SEDU.refresh();
        addElement = new LdapConnection(SEDU);
    }

    public static boolean isLdapEnable() {
        String string = LdapEnvironments.getProperty("ldaprealm.enable_ldap_support");
        return string.equalsIgnoreCase("true");
    }

    public static boolean processLdapUserWhenAuthenticate(boolean bl, String string, String string2, String string3) {
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = LdapToolkit.checkLdapUser(string2, string3);
        bl2 = bl3 || bl;
        try {
            UserImpl userImpl = (UserImpl)Realm.get(string).getUser(string2);
            if (!bCanGetPw && userImpl.getLdapFlag() && !bl3 && string3.equalsIgnoreCase("")) {
                bl2 = false;
            }
            if (((UserImpl)Realm.get(string).getUser(string2)).getLdapFlag()) {
                if (!LdapEnvironments.getProperty("ldaprealm.authentication").equalsIgnoreCase("none") && string3.equalsIgnoreCase("")) {
                    return false;
                }
            }
            if (!bl) {
                return false;
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        if (bl2 && bl3) {
            LdapToolkit.putLdapUserToRealm(string2, string3, string);
            LdapToolkit.putLdapUserToItsGroup(string, string2);
        }
        return bl2;
    }

    public static Enumeration checkSynchronization(Realm realm, boolean bl) throws BadRealmException {
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        enumeration = addElement.getGroupNames();
        enumeration2 = addElement.getUserNames();
        boolean bl2 = enumeration2 == null;
        boolean bl3 = enumeration == null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        if (!bl3) {
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
        }
        if (!bl2) {
            while (enumeration2.hasMoreElements()) {
                vector2.addElement((String)enumeration2.nextElement());
            }
        }
        boolean bl4 = false;
        Vector<String> vector3 = new Vector<String>();
        Enumeration enumeration3 = realm.getAcls();
        while (enumeration3.hasMoreElements()) {
            AclImpl aclImpl = (AclImpl)enumeration3.nextElement();
            Enumeration enumeration4 = aclImpl.entries();
            while (enumeration4.hasMoreElements()) {
                String string;
                bl4 = true;
                AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration4.nextElement();
                String string2 = aclEntryImpl.getNotExistInRealmPrincipalName();
                if (string2 == null) continue;
                if (!bl2) {
                    for (n = 0; n < vector2.size(); ++n) {
                        string = (String)vector2.get(n);
                        if (!string.equalsIgnoreCase(string2)) continue;
                        bl4 = false;
                        break;
                    }
                }
                if (!bl3) {
                    for (n = 0; n < vector.size(); ++n) {
                        string = (String)vector.get(n);
                        if (!string.equalsIgnoreCase(string2)) continue;
                        bl4 = false;
                        break;
                    }
                }
                if (!bl4) continue;
                try {
                    if (bl) {
                        aclImpl.removeEntry(null, aclEntryImpl);
                    }
                    vector3.addElement(aclImpl.getName() + "(ACL);" + aclEntryImpl.getNotExistInRealmPrincipalName());
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException);
                }
            }
            if (!bl) continue;
            try {
                UserDataToolkit.saveAclProperties(aclImpl);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
        return vector3.elements();
    }

    public static boolean isConnectionOK() {
        return LdapConnection.reconnect(SEDU);
    }

    public static boolean isConnectionOK(LdapEnvironments ldapEnvironments) {
        return LdapConnection.reconnect(ldapEnvironments);
    }

    public static void putLdapUserToRealm(String string, String string2, String string3) {
    }

    public static void putLdapUserToItsGroup(String string, String string2) {
        if (string2.equalsIgnoreCase("admin") || string2.equalsIgnoreCase("guest")) {
            return;
        }
        Vector[] vectorArray = addElement.getGroups();
        if (vectorArray == null) {
            return;
        }
        try {
            Realm realm = Realm.get(string);
            User user = realm.getUser(string2);
            ((UserImpl)user).setLdapFlag(true);
            for (int i = 0; i < vectorArray[0].size(); ++i) {
                GroupImpl groupImpl = (GroupImpl)vectorArray[0].get(i);
                if (!groupImpl.isMember(user)) continue;
                try {
                    realm.getGroup(groupImpl.getName()).addMember((Principal)user);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    continue;
                }
                return;
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
    }

    public static void putLdapUsersToRealm(String string) {
        addMember = addElement.getUsers();
        try {
            SharedPasswordRealm sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string);
            if (addMember == null) {
                return;
            }
            for (int i = 0; i < addMember.size(); ++i) {
                UserImpl userImpl = (UserImpl)addMember.get(i);
                UserImpl userImpl2 = null;
                String string2 = userImpl.getName();
                if (string2 == null) continue;
                if (sharedPasswordRealm.isGroupExist(string2)) {
                    ServiceLogger.logError("Already existed a group named: " + string2 + " in JREntServer, LDAP user \"" + string2 + "\" cannot be imported!");
                    continue;
                }
                String string3 = (String)userImpl.getAuthInfo();
                if (sharedPasswordRealm.isUserExist(string2)) {
                    if (string2.equalsIgnoreCase("admin") || !string2.equalsIgnoreCase("guest")) continue;
                    continue;
                }
                sharedPasswordRealm.createUser(string2, string3);
                userImpl2 = (UserImpl)sharedPasswordRealm.getUser(string2);
                userImpl2.setEmail(userImpl.getEmail());
                userImpl2.setFullname(userImpl.getFullname());
                userImpl2.setLdapFlag(true);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        catch (InUseException inUseException) {
            ServiceLogger.logError((Throwable)((Object)inUseException));
        }
    }

    public static Enumeration getUserNames() {
        return addElement.getUserNames();
    }

    public static User getUser(String string) {
        return null;
    }

    public static boolean checkLdapUser(String string, String string2) {
        if (!LdapToolkit.isLdapEnable()) {
            return false;
        }
        return LdapConnection.isValidLdapUser(string, string2);
    }

    public static boolean isExistLdapUser(String string) {
        return LdapConnection.isExistLdapUser(string);
    }

    public static void saveUsers(Vector vector, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            jet.server.intf.security.User user = (jet.server.intf.security.User)enumeration.nextElement();
        }
    }

    public static void saveRoles(Vector[] vectorArray, boolean bl) {
        for (int i = 0; i < vectorArray[0].size(); ++i) {
            Role role = (Role)vectorArray[0].elementAt(i);
            Vector vector = ((Vector[])vectorArray[1].elementAt(i))[0];
        }
    }

    public static void saveUser(UserImpl userImpl, SharedPasswordRealm sharedPasswordRealm) {
        try {
            userImpl.setLdapFlag(false);
            UserDataToolkit.saveUserProperties(userImpl);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public static Vector listExsitedUsers(String string) throws BadRealmException {
        Vector<jet.server.intf.security.User> vector = new Vector<jet.server.intf.security.User>();
        if (addElement == null) {
            return null;
        }
        Vector vector2 = addElement.getUsers();
        if (vector2 == null) {
            return null;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        AdminService adminService = httpRptServer.getAdminService();
        SecurityAdminService securityAdminService = adminService.getSecurityAdminService();
        Enumeration enumeration = null;
        try {
            enumeration = securityAdminService.getAllUserNames(string);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
            return null;
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
            return null;
        }
        jet.server.intf.security.User user = null;
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.equals("admin") || string2.equals("guest")) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                user = (jet.server.intf.security.User)vector2.get(i);
                if (!user.getName().equalsIgnoreCase(string2)) continue;
                vector.addElement(user);
            }
        }
        return vector;
    }

    public static Vector listExsitedGroups(String string) throws BadRealmException {
        Vector<Role> vector = new Vector<Role>();
        if (addElement == null) {
            return null;
        }
        Vector[] vectorArray = addElement.getGroups();
        if (vectorArray == null) {
            return null;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        AdminService adminService = httpRptServer.getAdminService();
        SecurityAdminService securityAdminService = adminService.getSecurityAdminService();
        Vector vector2 = null;
        try {
            vector2 = securityAdminService.getAllRoles(string, "administrators");
        }
        catch (NoSuchRealmException noSuchRealmException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
            return null;
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
            return null;
        }
        Enumeration enumeration = vector2.elements();
        Role role = null;
        Role role2 = null;
        while (enumeration.hasMoreElements()) {
            role2 = (Role)enumeration.nextElement();
            if (role2.getName().equals("administrators") || role2.getName().equals("everyone")) continue;
            for (int i = 0; i < vectorArray[0].size(); ++i) {
                role = (Role)vectorArray[0].get(i);
                if (!role.getName().equalsIgnoreCase(role2.getName())) continue;
                vector.addElement(role2);
            }
        }
        return vector;
    }

    public static Vector getUsers() {
        if (addElement == null && (addElement = new LdapConnection(SEDU = new LdapEnvironments())) == null) {
            return null;
        }
        return addElement.getUsers();
    }

    public static Vector[] getGroups() {
        if (addElement == null && (addElement = new LdapConnection(SEDU = new LdapEnvironments())) == null) {
            return null;
        }
        return addElement.getGroups();
    }

    public static Vector getLDAPGroups() {
        Vector[] vectorArray = addElement.getGroups();
        if (vectorArray == null) {
            return null;
        }
        return vectorArray[0];
    }

    public static Vector listEncryptedUser(Vector vector) {
        Vector<jet.server.intf.security.User> vector2 = null;
        if (vector == null) {
            return vector2;
        }
        for (int i = 0; i < vector.size(); ++i) {
            jet.server.intf.security.User user = (jet.server.intf.security.User)vector.elementAt(i);
            String string = user.getPassword();
            if (!string.startsWith("{")) continue;
            if (vector2 == null) {
                vector2 = new Vector<jet.server.intf.security.User>();
            }
            vector2.addElement(user);
        }
        return vector2;
    }

    public static GroupImpl processGroupWhenSave(GroupImpl groupImpl) {
        if (bIsImport) {
            return groupImpl;
        }
        GroupImpl groupImpl2 = new GroupImpl(groupImpl.getName());
        groupImpl2.setDescription(groupImpl.getDescription());
        groupImpl2.setRealmName(groupImpl.getRealmName());
        UserImpl userImpl = null;
        GroupImpl groupImpl3 = null;
        if (groupImpl.getLdapFlag()) {
            return null;
        }
        Enumeration enumeration = groupImpl.members();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            if (principal instanceof User) {
                userImpl = (UserImpl)principal;
                if (userImpl.getLdapFlag()) continue;
                groupImpl2.addMember(userImpl);
                continue;
            }
            if (!(principal instanceof Group) || (groupImpl3 = (GroupImpl)((Object)principal)).getLdapFlag()) continue;
            groupImpl2.addMember((Principal)((Object)groupImpl3));
        }
        return groupImpl2;
    }
}

