/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jet.server.util.Resource;

public abstract class AbstractResource
implements Resource {
    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException iOException) {
            try {
                InputStream inputStream = this.getInputStream();
                inputStream.close();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    @Override
    public Resource createRelative(String string) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    @Override
    public String getFilename() throws IllegalStateException {
        throw new IllegalStateException(this.getDescription() + " does not carry a filename");
    }

    @Override
    public abstract String getDescription();

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Resource && ((Resource)object).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }
}

