/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jet.bean.JREngine;
import jet.dataengine.api.expression.ConditionException;
import jet.export.xml.LoadXSDException;
import jet.jetc.ReadFailureException;
import jet.rptservice.api.ISecurityProvider;
import jet.server.api.RptServerException;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.DynamicSecurityManager;
import jet.server.api.admin.security.DynamicSecurity;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.universe.dynamicsecurity.DynamicSecurityTool;
import org.xml.sax.SAXException;

public abstract class BVUtils {
    public static File getSecurityFile(String string, String string2, String string3) throws RptServerException {
        ServiceLogger.trace("BVUtils.getSecurityFile: userID=%s, catalogPath=%s, securityFileName=%s", string, string2, string3);
        File file = null;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        DynamicSecurity dynamicSecurity = null;
        if (string2 != null && string2.trim().length() > 0) {
            if (string3 != null && string3.trim().length() > 0) {
                dynamicSecurity = dynamicSecurityManager.getDynamicSecurity(string2, string3, string);
            } else {
                List<DynamicSecurity> list = dynamicSecurityManager.getDynamicSecurities(string2, string);
                if (list != null && list.size() > 0) {
                    for (DynamicSecurity dynamicSecurity2 : list) {
                        if (!dynamicSecurity2.isDefault()) continue;
                        dynamicSecurity = dynamicSecurity2;
                        break;
                    }
                }
            }
        }
        if (dynamicSecurity != null) {
            file = dynamicSecurity.getSecurityFile();
        }
        ServiceLogger.trace("BVUtils.getSecurityFile: dynamicSecurity=%s, return=%s", dynamicSecurity, file);
        return file;
    }

    public static ISecurityProvider makeSecurityProvider(String string, String string2, String string3) throws ReadFailureException, LoadXSDException, ParserConfigurationException, SAXException, IOException, RptServerException, ConditionException {
        return BVUtils.makeSecurityProvider(BVUtils.getSecurityFile(string, string2, string3));
    }

    public static ISecurityProvider makeSecurityProvider(File file) throws ReadFailureException, LoadXSDException, ParserConfigurationException, SAXException, IOException, ConditionException {
        if (file == null) {
            return null;
        }
        return DynamicSecurityTool.loadDynamicSecurity((File)file);
    }

    public static void setSecurityProviderToEngine(String string, String string2, String string3, JREngine jREngine) throws ReadFailureException, LoadXSDException, RptServerException, ParserConfigurationException, SAXException, IOException, ConditionException {
        ISecurityProvider iSecurityProvider = BVUtils.makeSecurityProvider(string, string2, string3);
        if (iSecurityProvider != null) {
            jREngine.setSecurityProvider(iSecurityProvider);
        }
    }
}

