/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import com.jinfonet.web.UserInfoImpl;
import com.jinfonet.web.beans.DataSourceDef;
import com.jinfonet.web.beans.JCollection;
import com.jinfonet.web.beans.KVMapDef;
import com.jinfonet.web.beans.ResourceDef;
import com.jinfonet.web.beans.ResourceExt;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jet.JCliResource;
import jet.bean.JREngine;
import jet.connect.DbDateTime;
import jet.connect.DbValue;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.formula.fArray;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.formula.formulaExecutor.ExternalInfoProvider;
import jet.formula.formulaExecutor.FormulaContainerImpl;
import jet.parameter.UserInput;
import jet.rptservice.api.ParameterEnv;
import jet.rptservice.api.ParameterEnvAdapter;
import jet.server.api.ParamInfo;
import jet.server.api.ParameterManager;
import jet.server.api.ParameterRecorder;
import jet.server.api.ReportInfo;
import jet.server.api.ReportSheetInfo;
import jet.server.api.RptServerException;
import jet.server.api.exception.GenerateParameterException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.paramlist.ParamValue;
import jet.server.api.paramlist.ReportParamList;
import jet.server.jrc.param.InvalidParamsException;
import jet.server.jrc.param.ParamDescsUtil;
import jet.server.jrserver.JRParamInfo;
import jet.server.log.ServiceLogger;
import jet.server.util.Json;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import jet.server.util.StringUtils;
import jet.util.ParameterValueDesc;

public abstract class ParamUtil {
    public static Map evalExpressionValues(Map map) {
        try {
            return ParamUtil.evalExpressionValues(map, false);
        }
        catch (InvalidParameterException invalidParameterException) {
            ServiceLogger.logError(invalidParameterException, 2);
            return map;
        }
    }

    public static Map evalExpressionValues(Map map, boolean bl) throws InvalidParameterException {
        Map<Object, Object> map2 = null;
        if (map instanceof Properties) {
            map2 = (Properties)((Properties)map).clone();
        } else if (map instanceof HashMap) {
            map2 = (HashMap)((HashMap)map).clone();
        } else if (map instanceof Hashtable) {
            map2 = (Hashtable)((Hashtable)map).clone();
        }
        if (map2 == null) {
            return map;
        }
        for (String string : map2.keySet()) {
            String string2;
            if (!string.startsWith("jrs.param.exp$")) continue;
            String string3 = "jrs.param$" + string.substring("jrs.param.exp$".length());
            Object v = map.get(string3);
            String string4 = ParamUtil.getExpression(map, string);
            if (v != null && v.toString().trim().length() > 0) {
                string2 = JCliResource.getMessage("CS_ERR_90", new Object[]{string4, v});
                if (!bl) continue;
                throw new InvalidParameterException(string2);
            }
            string2 = "jrs.param.pattern$" + string.substring("jrs.param.exp$".length());
            String string5 = (String)map.get(string2);
            try {
                String string6 = ParamUtil.evalExpressionValue(string4, string5);
                if (string6 == null) continue;
                map.put(string3, string6);
                map.remove(string);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                if (!bl) continue;
                throw new InvalidParameterException(parseFormulaFailedException.getMessage());
            }
            catch (ExecFormulaFailedException execFormulaFailedException) {
                if (!bl) continue;
                throw new InvalidParameterException(execFormulaFailedException.getMessage());
            }
        }
        return map2;
    }

    public static boolean parseExpression(String string) throws ParseFormulaFailedException {
        ServiceLogger.logDebug("ParamUtil:parseExpression... [exp = " + string + "]", 6);
        FormulaContainerImpl formulaContainerImpl = new FormulaContainerImpl();
        if (string.startsWith("{") && string.endsWith("}")) {
            try {
                Map map = Json.fromJson(Map.class, new StringReader(string));
                if (map.containsKey("exp") || map.containsKey("selectedDate")) {
                    string = (String)map.get("exp");
                }
            }
            catch (Json.JsonException jsonException) {
                ServiceLogger.logError(jsonException, 3);
            }
        }
        boolean bl = false;
        if (string.indexOf("(") > 0 && string.indexOf(")") > 0) {
            bl = formulaContainerImpl.parseFormulaByExp(string);
        }
        ServiceLogger.logDebug("ParamUtil:parseExpression success! isExpr = " + bl, 6);
        return bl;
    }

    public static String getFormulaExpr(String string) throws ParseFormulaFailedException {
        if (string.startsWith("{") && string.endsWith("}")) {
            Map map = Json.fromJson(Map.class, new StringReader(string));
            string = (String)map.get("exp");
        }
        return string;
    }

    public static String evalExpressionValue(String string, String string2) throws ParseFormulaFailedException, ExecFormulaFailedException {
        return ParamUtil.evalExpressionValue(string, string2, null);
    }

    public static String evalExpressionValue(String string, String string2, Locale locale) throws ParseFormulaFailedException, ExecFormulaFailedException {
        ServiceLogger.logDebug("ParamUtil:evalExpressionValue... [exp = " + string + ", pattern = " + string2 + ", locale = " + locale + "]", 6);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
            DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
            dateFormatSymbols.setZoneStrings(new String[0][0]);
            simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            simpleDateFormat.parse(string);
            return string;
        }
        catch (Throwable throwable) {
            DbValue dbValue = ParamUtil.evalExpressionValue(string);
            String string3 = null;
            if (dbValue != null) {
                if (!dbValue.isNull() && string2 != null && string2.trim().length() > 0 && dbValue instanceof DbDateTime) {
                    if (locale != null) {
                        Date date = ((DbDateTime)dbValue).toUtilDate();
                        string3 = new SimpleDateFormat(string2, locale).format(date);
                    } else {
                        string3 = ((DbDateTime)dbValue).toFormatString(string2);
                    }
                } else {
                    string3 = dbValue.toString();
                }
            }
            ServiceLogger.logDebug("ParamUtil:evalExpressionValue success! ret = " + string3, 6);
            return string3;
        }
    }

    public static DbValue evalExpressionValue(String string) throws ParseFormulaFailedException, ExecFormulaFailedException {
        return ParamUtil.evalExpressionValue(string, 0L);
    }

    public static DbValue evalExpressionValue(String string, final long l) throws ParseFormulaFailedException, ExecFormulaFailedException {
        ServiceLogger.logDebug("ParamUtil:evalExpressionValue... [exp = " + string + ", timeLine = " + l + "]", 6);
        DbValue dbValue = null;
        if (string != null && string.trim().length() > 0) {
            Object object;
            final HashMap hashMap = new HashMap();
            if (string.startsWith("{") && string.endsWith("}")) {
                object = Json.fromJson(string);
                string = (String)object.get("exp");
                object.remove("exp");
                hashMap.putAll(object);
            }
            object = new FormulaContainerImpl();
            boolean bl = false;
            bl = object.parseFormulaByExp(string);
            if (bl) {
                dbValue = object.executeFormulaByExp(string, new ExternalInfoProvider(){

                    public Date getSelectedDate() {
                        String string = (String)hashMap.get("selectedDate");
                        if (string != null && string.trim().length() > 0) {
                            try {
                                return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse(string);
                            }
                            catch (ParseException parseException) {
                                try {
                                    return new SimpleDateFormat("MM/dd/yyyy").parse(string);
                                }
                                catch (ParseException parseException2) {
                                    ServiceLogger.logError(parseException2, 2);
                                }
                            }
                        }
                        return null;
                    }

                    public Timestamp getTimeBaseLine() {
                        return l == 0L ? new Timestamp(System.currentTimeMillis()) : new Timestamp(l);
                    }
                });
            }
        }
        ServiceLogger.logDebug("ParamUtil:evalExpressionValue success! ret(DbValue) = " + dbValue, 6);
        return dbValue;
    }

    public static String getExpression(Map map, String string) {
        if (map == null || string == null) {
            return null;
        }
        if (string.startsWith("jrs.param.exp$")) {
            return (String)map.get(string);
        }
        return null;
    }

    public static UserInput[] makeUserInput(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        UserInput[] userInputArray = new UserInputImpl[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            userInputArray[i] = new UserInputImpl(stringArray[i]);
        }
        return userInputArray;
    }

    public static String[] evalExpressionValue(UserInput[] userInputArray, String string, long l) throws ParseFormulaFailedException, ExecFormulaFailedException {
        String[] stringArray = new String[userInputArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ParamUtil.evalExpressionValue(userInputArray[i], string, l);
        }
        return stringArray;
    }

    public static String evalExpressionValue(final UserInput userInput, String string, final long l) throws ParseFormulaFailedException, ExecFormulaFailedException {
        String string2;
        ServiceLogger.logDebug("ParamUtil:evalExpressionValue... [input = " + userInput + ", pattern = " + string + ", timeLine = " + l + "]", 6);
        String string3 = string2 = userInput.getUserInput();
        if (string2 != null && string2.trim().length() > 0) {
            if (userInput.isExpression()) {
                DbValue dbValue = new FormulaContainerImpl().executeFormulaByExp(string2, new ExternalInfoProvider(){

                    public Date getSelectedDate() {
                        return userInput.getSelectedDate();
                    }

                    public Timestamp getTimeBaseLine() {
                        return l == 0L ? null : new Timestamp(l);
                    }
                });
                if (dbValue != null) {
                    string3 = !dbValue.isNull() && string != null && string.trim().length() > 0 && dbValue instanceof DbDateTime ? ((DbDateTime)dbValue).toFormatString(string) : dbValue.toString();
                }
            } else {
                string3 = string2;
            }
        }
        ServiceLogger.logDebug("ParamUtil:evalExpressionValue... ret = " + string3, 6);
        return string3;
    }

    public static ParameterValueDesc makeParamValueDesc(final UserInput userInput, final long l, final Locale locale, final TimeZone timeZone) {
        ServiceLogger.logDebug("ParamUtil:makeParamValueDesc. [UserInput = " + userInput + ", timeLine = " + l + "]", 6);
        return new ParameterValueDesc(){

            public UserInput[] getUserInputValue() {
                return new UserInput[]{userInput};
            }

            public Timestamp getTimeBaseline() {
                return new Timestamp(l);
            }

            public Locale getLocale() {
                return locale;
            }

            public TimeZone getTimeZone() {
                return timeZone;
            }
        };
    }

    public static ParameterValueDesc makeParamValueDesc(final UserInput[] userInputArray, final long l, final Locale locale, final TimeZone timeZone) {
        StringBuffer stringBuffer = new StringBuffer();
        if (userInputArray != null) {
            for (UserInput userInput : userInputArray) {
                stringBuffer.append(userInput).append(" , ");
            }
        }
        ServiceLogger.logDebug("ParamUtil:makeParamValueDesc. UserInput(s) = [" + stringBuffer + "], timeLine = " + l, 6);
        return new ParameterValueDesc(){

            public UserInput[] getUserInputValue() {
                return userInputArray;
            }

            public Timestamp getTimeBaseline() {
                return new Timestamp(l);
            }

            public Locale getLocale() {
                return locale;
            }

            public TimeZone getTimeZone() {
                return timeZone;
            }
        };
    }

    public static Map filterParamProp(Map<Object, Object> map) throws GenerateParameterException {
        Object object;
        String string;
        Map.Entry<Object, Object> entry2;
        Properties properties = new Properties();
        if (map == null) {
            return properties;
        }
        for (Map.Entry<Object, Object> entry2 : map.entrySet()) {
            if (!(entry2.getKey() instanceof String)) continue;
            string = (String)entry2.getKey();
            object = entry2.getValue();
            if (string.startsWith("jrs.param$")) {
                properties.put(string, object);
                continue;
            }
            if (!string.startsWith("jrs.param.exp$") && !string.startsWith("jrs.param.pattern$")) continue;
            properties.put(string, object);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.keySet());
        entry2 = arrayList.iterator();
        while (entry2.hasNext()) {
            string = (String)entry2.next();
            if (string.startsWith("jrs.param$")) {
                object = "jrs.param$";
            } else if (string.startsWith("jrs.param.exp$")) {
                object = "jrs.param.exp$";
            } else {
                if (!string.startsWith("jrs.param.pattern$")) continue;
                object = "jrs.param.pattern$";
            }
            Object object2 = properties.remove(string);
            if (object2 == null) continue;
            String string2 = object + string.substring(((String)object).length()).toLowerCase();
            properties.put(string2, object2);
        }
        return properties;
    }

    public static Object evalParamValue(ParamDesc paramDesc, Map map, Map map2) throws InvalidParameterException {
        ServiceLogger.logDebug("ParamUtil:evalParamValue... paramName=" + (paramDesc == null ? null : paramDesc.getName()), 6);
        String string = (String)map2.get("jrs.data_source_name");
        String string2 = (String)map2.get("jrs.query_name");
        String string3 = "";
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0) {
            string3 = ParamUtil.SEDU(string, string2).toLowerCase();
        }
        if (paramDesc != null) {
            boolean bl;
            Object object;
            String string4 = paramDesc.getName().toLowerCase();
            String string5 = "jrs.param$" + string3 + string4;
            Object object2 = map.get(string5);
            if (paramDesc.isMultipleValue()) {
                if (object2 instanceof String) {
                    object2 = new String[]{(String)object2};
                }
            } else if (object2 instanceof String[]) {
                object = (String[])object2;
                Object v = object2 = ((String[])object).length > 0 ? object[0] : null;
            }
            if (ParamUtil.isDateTime(paramDesc)) {
                object = (String)map.get("jrs.param.exp$" + string3 + string4);
                if (object != null && object2 == null) {
                    object2 = object;
                }
                if (object2 instanceof String) {
                    object2 = ParamUtil.makeUserInput((String)object2)[0];
                } else if (object2 instanceof String[]) {
                    object2 = ParamUtil.makeUserInput((String[])object2);
                }
            }
            if (object2 == null) {
                return null;
            }
            boolean bl2 = bl = paramDesc.getPrompt().endsWith("*") || paramDesc.isRequired();
            if (bl && ParamUtil.isEmptyParamValue(object2)) {
                String string6 = JCliResource.getMessage("CS_ERR_91", paramDesc.getName());
                throw new InvalidParameterException(string6);
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                StringBuffer stringBuffer = new StringBuffer();
                if (object2 instanceof UserInput[]) {
                    for (UserInput userInput : (UserInput[])object2) {
                        stringBuffer.append(userInput).append(" , ");
                    }
                } else if (object2 instanceof String[]) {
                    for (String string7 : (String[])object2) {
                        stringBuffer.append(string7).append(" , ");
                    }
                } else {
                    stringBuffer.append(object2);
                }
                ServiceLogger.logDebug("ParamUtil:evalParamValue success! paramValue = " + stringBuffer, 6);
            }
            return object2;
        }
        return null;
    }

    public static boolean isDateTime(ParamDesc paramDesc) {
        String string = paramDesc.getType();
        return string.equals("Date") || string.equals("DateTime") || string.equals("Time");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkRange(ParamDesc paramDesc, Object object, Locale locale, long l) throws InvalidParameterException, ExecFormulaFailedException, ParseFormulaFailedException {
        boolean bl = false;
        boolean bl2 = paramDesc.isAllSelected();
        try {
            String[] stringArray;
            paramDesc.setAllSelected(false);
            if (ParamUtil.isDateTime(paramDesc) && (object instanceof UserInput || object instanceof UserInput[])) {
                if (paramDesc.isMultipleValue()) {
                    UserInput[] userInputArray = (UserInput[])object;
                    if (ParamUtil.isEmptyParamValue(userInputArray)) {
                        throw new InvalidParameterException(JCliResource.getMessage("CS_ERR_84"));
                    }
                    if (userInputArray.length == 1 && "\u0007".equals(userInputArray[0].getUserInput())) {
                        if (!paramDesc.isAllowAll()) {
                            throw new InvalidParameterException(JCliResource.getMessage("CS_ERR_85"));
                        }
                    } else {
                        paramDesc.setValue(userInputArray, new Timestamp(l), locale);
                    }
                } else {
                    UserInput userInput = (UserInput)object;
                    paramDesc.setValue(userInput, new Timestamp(l), locale);
                }
            } else if (paramDesc.isMultipleValue()) {
                String[] stringArray2 = (String[])object;
                if (ParamUtil.isEmptyParamValue(stringArray2)) {
                    throw new InvalidParameterException(JCliResource.getMessage("CS_ERR_86"));
                }
                if (stringArray2.length == 1 && "\u0007".equals(stringArray2[0])) {
                    if (!paramDesc.isAllowAll()) {
                        ServiceLogger.logDebug("JRParameterManager::checkRange--InvalidParameterValue '" + paramDesc.getName() + "' does not allow the <ALL> value.", 6);
                        throw new InvalidParameterException(JCliResource.getMessage("CS_ERR_87"));
                    }
                } else {
                    Object[] objectArray = paramDesc.detectInvalidValues(stringArray2, locale);
                    if (objectArray != null && objectArray.length > 0) {
                        List<String> list = Arrays.asList(objectArray);
                        if (paramDesc.getWhenOutOfRange() == 3) {
                            ServiceLogger.logDebug("JRParameterManager::checkRange--InvalidParameterValue '" + paramDesc.getName() + "', " + Arrays.toString(objectArray) + " are invalid values.", 6);
                            throw new InvalidParameterException(JCliResource.getMessage("CS_ERR_88", list));
                        }
                        if (paramDesc.getWhenOutOfRange() == 2) {
                            bl = true;
                        }
                    }
                }
            } else if (object != null && ((String)object).length() > 0 && !paramDesc.IsParameters() && !paramDesc.getType().equals("Boolean") && (stringArray = paramDesc.detectInvalidValues(new String[]{(String)object}, locale)) != null && stringArray.length > 0) {
                if (paramDesc.getWhenOutOfRange() == 3) {
                    ServiceLogger.logDebug(6600257, new Object[]{paramDesc.getName(), object}, 6);
                    throw new InvalidParameterException(JCliResource.getMessage("CS_ERR_89", object));
                }
                if (paramDesc.getWhenOutOfRange() == 2) {
                    bl = true;
                }
            }
        }
        finally {
            paramDesc.setAllSelected(bl2);
        }
        return bl;
    }

    public static void setParamValue(ParamDesc paramDesc, Object object, Locale locale, long l) throws InvalidParameterException, ExecFormulaFailedException, ParseFormulaFailedException {
        if (object == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof UserInput[]) {
            for (UserInput userInput : (UserInput[])object) {
                stringBuffer.append(userInput).append(" , ");
            }
        } else if (object instanceof String[]) {
            for (String string : (String[])object) {
                stringBuffer.append(string).append(" , ");
            }
        } else {
            stringBuffer.append(object);
        }
        ServiceLogger.logDebug("ParamUtil:setParamValue... paramName=" + (paramDesc == null ? null : paramDesc.getName()) + ", value = " + stringBuffer + ", locale = " + locale + ", timeBaseLine = " + l, 6);
        if (paramDesc != null) {
            paramDesc.setAllSelected(false);
            if (paramDesc.isMultipleValue()) {
                if (object instanceof UserInput) {
                    object = new UserInput[]{(UserInput)object};
                }
                if (object instanceof String) {
                    object = new String[]{(String)object};
                }
                if (object instanceof UserInput[]) {
                    UserInput[] userInputArray = (UserInput[])object;
                    if (userInputArray.length == 1 && "\u0007".equals(userInputArray[0].getUserInput())) {
                        paramDesc.setAllSelected(true);
                    } else {
                        paramDesc.setValue(userInputArray, new Timestamp(l), locale);
                    }
                } else {
                    String[] stringArray = (String[])object;
                    if (stringArray.length == 1 && "\u0007".equals(stringArray[0])) {
                        paramDesc.setAllSelected(true);
                    } else {
                        paramDesc.setValue(stringArray, locale);
                    }
                }
            } else {
                if (object instanceof UserInput[]) {
                    UserInput[] userInputArray = (UserInput[])object;
                    object = userInputArray.length > 0 ? userInputArray[0] : "";
                }
                if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    object = stringArray.length > 0 ? stringArray[0] : "";
                }
                if (object instanceof UserInput) {
                    paramDesc.setValue((UserInput)object, new Timestamp(l), locale);
                } else {
                    paramDesc.setValue((String)object, locale);
                }
            }
            ServiceLogger.logDebug("ParamUtil:setParamValue success! paramName=" + (paramDesc == null ? null : paramDesc.getName()) + ", paramValue = " + paramDesc.getValue(), 6);
        }
    }

    public static boolean isChangedParamValue(ParamDesc paramDesc, Object object, Locale locale, long l) {
        Object object2;
        if (paramDesc.isMultipleValue()) {
            String[] stringArray;
            Object object3;
            String[] stringArray2 = null;
            if (object instanceof UserInput[]) {
                object3 = paramDesc.getFormat();
                if (object3 == null || ((String)object3).trim().length() == 0) {
                    object3 = paramDesc.getDefaultDateFormat(locale);
                }
                try {
                    stringArray2 = ParamUtil.evalExpressionValue((UserInput[])object, (String)object3, l);
                }
                catch (ExecFormulaFailedException execFormulaFailedException) {
                    ServiceLogger.logError(execFormulaFailedException, 2);
                }
                catch (ParseFormulaFailedException parseFormulaFailedException) {
                    ServiceLogger.logError(parseFormulaFailedException, 2);
                }
            } else {
                stringArray2 = object instanceof String ? new String[]{(String)object} : (String[])object;
            }
            Object object4 = object3 = stringArray2 != null ? Arrays.asList(stringArray2) : new ArrayList();
            if (paramDesc.isAllSelected()) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "\u0007";
            } else {
                stringArray = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), locale);
            }
            String[] stringArray4 = stringArray;
            List<Object> list = stringArray4 != null ? Arrays.asList(stringArray4) : new ArrayList();
            return !object3.containsAll(list) || !list.containsAll((Collection<?>)object3);
        }
        String string = null;
        if (object instanceof UserInput) {
            object2 = paramDesc.getFormat();
            if (object2 == null || object2.trim().length() == 0) {
                object2 = paramDesc.getDefaultDateFormat(locale);
            }
            try {
                string = ParamUtil.evalExpressionValue((UserInput)object, (String)object2, l);
            }
            catch (ExecFormulaFailedException execFormulaFailedException) {
                ServiceLogger.logError(execFormulaFailedException, 2);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                ServiceLogger.logError(parseFormulaFailedException, 2);
            }
        } else if (object instanceof String[]) {
            object2 = (String[])object;
            if (((String[])object2).length > 0) {
                string = object2[0];
            }
        } else {
            string = (String)object;
        }
        object2 = paramDesc.getDisplayValue(paramDesc.getValue(), locale);
        return string != null && !string.equals(object2);
    }

    public static void putRuntimeParamValue(Map map, ParamDesc paramDesc, Locale locale) {
        if (map == null) {
            return;
        }
        ServiceLogger.logDebug("ParamUtil:putRuntimeParamValue. paramName=" + (paramDesc == null ? null : paramDesc.getName()) + ", paramValue = " + (paramDesc == null ? null : paramDesc.getValue()) + ", locale = " + locale, 6);
        String string = null;
        String string2 = null;
        String string3 = "";
        if (map != null) {
            string = (String)map.get("jrs.data_source_name");
            string2 = (String)map.get("jrs.query_name");
        }
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0) {
            string3 = ParamUtil.SEDU(string, string2);
        }
        String string4 = "jrs.param.runtime$" + string3 + paramDesc.getName();
        String[] stringArray = null;
        if (paramDesc.isMultipleValue()) {
            String[] stringArray2;
            if (paramDesc.isAllSelected()) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = "\u0007";
            } else {
                stringArray2 = paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), locale);
            }
            stringArray = stringArray2;
        } else {
            stringArray = paramDesc.getDisplayValue(paramDesc.getValue(), locale);
        }
        if (stringArray != null) {
            map.put(string4, stringArray);
        } else {
            map.remove(string4);
        }
    }

    public static long getTimeBaseLine(Map map) {
        String string;
        long l = 0L;
        if (map != null && (string = (String)map.get("jrs.time_base_line")) != null && string.trim().length() > 0) {
            l = Long.parseLong(string);
        }
        return l;
    }

    public static ParamDesc[] changeParamValue(ParameterEnv parameterEnv, ParamDesc paramDesc, Object object, long l, Locale locale, TimeZone timeZone) throws InvalidParameterException {
        Object object2;
        ServiceLogger.logDebug("ParamUtil:changeParamValue... paramName=" + (paramDesc == null ? null : paramDesc.getName()) + ", paramValue = " + object + ", timeLine = " + l, 6);
        ParamDesc[] paramDescArray = null;
        if (object instanceof String[]) {
            object2 = (String[])object;
            paramDescArray = parameterEnv.paramValueChanged(paramDesc.getName(), (String[])object2);
        } else if (object instanceof String) {
            paramDescArray = parameterEnv.paramValueChanged(paramDesc.getName(), (String)object);
        } else if (object instanceof UserInput[]) {
            object2 = (UserInput[])object;
            paramDescArray = parameterEnv.paramValueChanged(paramDesc.getName(), ParamUtil.makeParamValueDesc((UserInput[])object2, l, locale, timeZone));
        } else if (object instanceof UserInput) {
            object2 = (UserInput)object;
            paramDescArray = parameterEnv.paramValueChanged(paramDesc.getName(), ParamUtil.makeParamValueDesc((UserInput)object2, l, locale, timeZone));
        }
        object2 = ParamDescsUtil.getReferedBy(paramDesc);
        if (object2 != null) {
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                ParamDesc paramDesc2 = (ParamDesc)((Vector)object2).get(i);
                if (paramDesc2.isMultipleValue() && paramDesc2.isAllowAll()) {
                    paramDesc2.setAllSelected(true);
                    continue;
                }
                boolean bl = paramDesc2.needLoadValueList();
                paramDesc2.getValues();
                if (!bl || paramDesc2.needLoadValueList()) continue;
                paramDesc2.setDefaultIndex(0);
            }
        }
        ServiceLogger.logDebug("ParamUtil:changeParamValue success! ParamDesc(s) size is " + (paramDescArray == null ? 0 : paramDescArray.length), 6);
        return paramDescArray;
    }

    public static boolean isEmptyParamValue(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).length() == 0;
        }
        if (object instanceof String[]) {
            return ((String[])object).length == 0;
        }
        if (object instanceof UserInput) {
            return ((UserInput)object).getUserInput().trim().length() == 0;
        }
        if (object instanceof UserInput[]) {
            return ((UserInput[])object).length == 0;
        }
        return true;
    }

    public static String toStringParamValue(Object object) {
        String string = "";
        if (object instanceof String[]) {
            string = Arrays.asList((String[])object).toString();
        } else if (object instanceof String) {
            string = "" + object;
        } else if (object instanceof UserInput[]) {
            for (UserInput userInput : (UserInput[])object) {
                object = userInput.toString() + ",";
            }
        } else if (object instanceof UserInput) {
            string = object.toString();
        }
        return string;
    }

    public static String toExpr(UserInput userInput) {
        if (userInput == null) {
            return "";
        }
        if (!userInput.isExpression()) {
            return userInput.getUserInput();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("\"exp\" : ").append(Json.toJson(userInput.getUserInput()));
        if (userInput.getSelectedDate() != null) {
            stringBuffer.append(",\"").append("selectedDate").append("\" : \"").append(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(userInput.getSelectedDate())).append("\"");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static List<ParamInfo> IsParameters(ReportInfo reportInfo, int n) {
        List<ParamInfo> list = null;
        try {
            Vector vector = reportInfo.getReportSheetInfos(n);
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            for (ReportSheetInfo reportSheetInfo : vector) {
                if (reportSheetInfo.isBurstingReport()) {
                    vector3.add(reportSheetInfo.getName());
                    continue;
                }
                vector2.add(reportSheetInfo.getName());
            }
            list = reportInfo.getParamInfos(vector2, new Properties());
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return list;
    }

    public static String validateParam(ParamDesc paramDesc, String string, Locale locale) {
        try {
            CharSequence charSequence;
            String string2 = null;
            String string3 = "";
            if (paramDesc != null) {
                charSequence = string;
                if (ParamUtil.isDateTime(paramDesc)) {
                    UserInput userInput = ParamUtil.makeUserInput(string)[0];
                    if (userInput.isExpression()) {
                        string2 = ParamUtil.toExpr(userInput);
                    }
                    charSequence = userInput;
                }
                ParamUtil.setParamValue(paramDesc, charSequence, locale, 0L);
            } else {
                string3 = "Parameter not existed!";
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("{\"success\":true");
            if (string2 != null) {
                ((StringBuffer)charSequence).append(",\"expr\":" + Json.toJson(string2));
            }
            ((StringBuffer)charSequence).append(",\"customMsg\":" + Json.toJson(string3));
            ((StringBuffer)charSequence).append("}");
            return ((StringBuffer)charSequence).toString();
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            String string4 = "";
            if (throwable != null) {
                string4 = throwable.getMessage();
                if (string4 == null) {
                    ServiceLogger.logError(throwable);
                    string4 = "" + throwable;
                }
            } else {
                string4 = "" + throwable;
            }
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string4));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public static String validateParam(HttpServletRequest httpServletRequest) {
        try {
            Object object;
            Object object2;
            Object object3;
            String string;
            Cloneable cloneable;
            String string2;
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
            String string3 = HttpUtil.getUser(httpServletRequest);
            String string4 = HttpUtil.decodeEsc(httpServletRequest.getParameter("jrs.catalog"));
            String string5 = httpServletRequest.getParameter("selcat");
            if (string5 == null || string5.trim().length() == 0) {
                string5 = httpServletRequest.getParameter("jrs.cat_version");
            }
            if (string5 == null && string4 != null) {
                string5 = httpRptServer.getResourceManager().getPathInfo(string3, string4).getLatestVersionNumber() + "";
            }
            List<ParamInfo> list = null;
            String string6 = HttpUtil.decodeEsc(httpServletRequest.getParameter("jrs.report"));
            String string7 = httpServletRequest.getParameter("selrpt");
            if (string7 == null || string7.trim().length() == 0) {
                string7 = httpServletRequest.getParameter("jrs.rpt_version");
            }
            if (string7 == null && string6 != null) {
                string7 = httpRptServer.getResourceManager().getPathInfo(string3, string6).getLatestVersionNumber() + "";
            }
            Properties properties = new Properties();
            ReportInfo reportInfo = null;
            if (string6 != null) {
                reportInfo = httpRptServer.getReportInfo(string3, string4, APIUtil.parseInt(string5), string6, APIUtil.parseInt(string7), properties);
            }
            if ((string2 = httpServletRequest.getParameter("jrs.rpt_language")) == null && reportInfo != null && (cloneable = reportInfo.getAvailableLanguages()) != null && ((Vector)cloneable).size() > 0) {
                string2 = (String)((Vector)cloneable).elementAt(0);
            }
            cloneable = null;
            if (string2 != null && string2.length() > 0) {
                cloneable = ServerUtil.getLocale(string2);
            }
            if (reportInfo != null) {
                list = ParamUtil.IsParameters(reportInfo, 2);
            }
            if ((string = httpServletRequest.getParameter("paramName")) != null && string.startsWith("jrs.param$")) {
                string = string.substring("jrs.param$".length());
            }
            if (list == null) {
                object3 = HttpUtil.getParameters(httpServletRequest);
                object2 = httpServletRequest.getParameter("dsName");
                String string8 = httpServletRequest.getParameter("qryName");
                if (object2 != null && ((String)object2).trim().length() > 0 && string8 != null && string8.trim().length() > 0) {
                    string = string.substring(ParamUtil.SEDU((String)object2, string8).length());
                    object = httpRptServer.getCatalogInfo(string3, string4, APIUtil.parseInt(string5));
                    ParameterManager parameterManager = object.getParameterManager((String)object2, new String[]{string8});
                    try {
                        ((Properties)object3).put("jrs.data_source_name", object2);
                        ((Properties)object3).put("jrs.query_name", string8);
                        list = parameterManager.getAllParametersWithChanging((Map)object3);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            object3 = httpServletRequest.getParameter("paramValue");
            object2 = null;
            if (list != null) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    object = list.get(i);
                    if (!object.getName().equals(string)) continue;
                    object2 = object;
                    break;
                }
            }
            if (cloneable != null) {
                object2.setLocale((Locale)cloneable);
            }
            return object2.validateValue((String)object3);
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            String string = "";
            if (throwable != null) {
                string = throwable.getMessage();
                if (string == null) {
                    ServiceLogger.logError(throwable);
                    string = "" + throwable;
                }
            } else {
                string = "" + throwable;
            }
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    private static String SEDU(String string, String string2) {
        return string + "$" + string2 + "$";
    }

    public static String toString(List<? extends ParamInfo> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (list != null) {
            for (ParamInfo paramInfo : list) {
                stringBuffer.append("\n").append(ParamUtil.toString(paramInfo));
            }
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public static String toString(ParamInfo paramInfo) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("name:").append(paramInfo.getName());
        stringBuffer.append(", type:").append(paramInfo.getType());
        boolean bl = false;
        if (paramInfo instanceof JRParamInfo) {
            object = (JRParamInfo)paramInfo;
            bl = ((JRParamInfo)object).getParamDesc().isAllSelected();
            stringBuffer.append(", isAllSelected:").append(bl);
        }
        if (!bl) {
            stringBuffer.append(", defaultValue:").append(paramInfo.getDefaultValue());
        }
        stringBuffer.append(", locale:").append(paramInfo.getLocale());
        if (!ServerUtil.isEmpty(paramInfo.getUserFormat())) {
            stringBuffer.append(", userFormat:").append(paramInfo.getUserFormat());
        }
        if (!ServerUtil.isEmpty(paramInfo.getNextLevel())) {
            stringBuffer.append(", nextLevel:").append(paramInfo.getNextLevel());
        }
        if (!ServerUtil.isEmpty(paramInfo.getPreviousLevel())) {
            stringBuffer.append(", previousLevel:").append(paramInfo.getPreviousLevel());
        }
        if (!ServerUtil.isEmpty(paramInfo.getPrompt())) {
            stringBuffer.append(", prompty:").append(paramInfo.getPrompt());
        }
        stringBuffer.append(", wenOutOfRange:").append(paramInfo.getWhenOutOfRange());
        object = paramInfo.getReferedBy();
        if (!ServerUtil.isEmpty((List)object)) {
            stringBuffer.append(", referedBy(" + object.size() + "):").append(StringUtil.toString((List)object));
        }
        if (!ServerUtil.isEmpty((List)(object = paramInfo.getValueOptions()))) {
            stringBuffer.append(", valueOptions(" + object.size() + "):").append(StringUtil.toString((List)object));
        }
        if (!ServerUtil.isEmpty((List)(object = paramInfo.getDisplayValues()))) {
            stringBuffer.append(", displayValues(" + object.size() + "):").append(StringUtil.toString((List)object));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static List<ReportParamList> getAutoReportParamLists(String string, Map map) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        String string2 = (String)map.get("jrs.report");
        ServiceLogger.trace("ParamListManager:ParamUtil:getAutoReportParamLists (reportPath=%s, userName=%s)", string2, string);
        List<ReportParamList> list = httpRptServer.getParameterRecorder().getReportParamLists(string, string2, (byte)1);
        return list;
    }

    public static List<ReportParamList> getManualReportParamLists(String string, Map map) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        String string2 = (String)map.get("jrs.report");
        ServiceLogger.trace("ParamListManager:ParamUtil:getManualReportParamLists (reportPath=%s, userName=%s)", string2, string);
        return httpRptServer.getParameterRecorder().getReportParamLists(string, string2, (byte)0);
    }

    private static List<ParamInfo> URLDecode(String string, Map map, HttpRptServer httpRptServer) {
        List<ParamInfo> list = null;
        try {
            Object object2;
            String string2 = HttpUtil.decodeEsc((String)map.get("jrs.catalog"));
            String string3 = (String)map.get("selcat");
            if (string3 == null || string3.trim().length() == 0) {
                string3 = (String)map.get("jrs.cat_version");
            }
            if (string3 == null && string2 != null) {
                string3 = httpRptServer.getResourceManager().getPathInfo(string, string2).getLatestVersionNumber() + "";
            }
            String string4 = (String)map.get("jrs.report");
            String string5 = (String)map.get("selrpt");
            if (string5 == null || string5.trim().length() == 0) {
                string5 = (String)map.get("jrs.rpt_version");
            }
            if (string5 == null && string4 != null) {
                string5 = httpRptServer.getResourceManager().getPathInfo(string, string4).getLatestVersionNumber() + "";
            }
            Properties properties = new Properties();
            for (Object object2 : map.keySet()) {
                properties.put(object2, map.get(object2));
            }
            object2 = null;
            if (string4 != null) {
                object2 = httpRptServer.getReportInfo(string, string2, APIUtil.parseInt(string3), string4, APIUtil.parseInt(string5), properties);
            }
            if (object2 != null) {
                Vector<String> vector = ServerUtil.parseSheetNames(map);
                if (vector.size() == 0) {
                    Vector vector2 = object2.getReportSheetInfos(2);
                    Vector<String> vector3 = new Vector<String>();
                    Vector<String> vector4 = new Vector<String>();
                    for (ReportSheetInfo reportSheetInfo : vector2) {
                        if (reportSheetInfo.isBurstingReport()) {
                            vector4.add(reportSheetInfo.getName());
                            continue;
                        }
                        vector3.add(reportSheetInfo.getName());
                    }
                    if (vector3.isEmpty()) {
                        if (!vector4.isEmpty()) {
                            vector.add((String)vector4.get(0));
                        }
                    } else {
                        vector = vector3;
                    }
                }
                list = object2.getOriginalParamInfos(vector, map);
            }
        }
        catch (Exception exception) {
            ServiceLogger.error("ParamUtil:getParamInfos error! %s", exception);
        }
        return list;
    }

    private static Locale add(Map map) {
        String string = (String)map.get("jrs.rpt_language");
        String string2 = (String)map.get("jrs.rpt_country");
        String string3 = (String)map.get("jrs.rpt_variant");
        Locale locale = null;
        if (string != null && string.trim().length() > 0) {
            locale = string2 != null && string2.trim().length() > 0 ? ServerUtil.getLocale(string, string2, string3) : ServerUtil.getLocale(string);
        } else if (string2 != null && string2.trim().length() > 0) {
            locale = ServerUtil.getLocale(string2);
        }
        return locale;
    }

    private static ReportParamList addParamValue(String string, byte by, Map map, HttpRptServer httpRptServer) {
        String string2 = (String)map.get("jrs.report");
        Locale locale = ParamUtil.add(map);
        List<ParamInfo> list = ParamUtil.URLDecode(string, map, httpRptServer);
        ServiceLogger.trace("ParamListManager:ParamUtil:buildReportParamList (reportPath=%s, reportParamListType=%s, locale=%s, paramInfos.size=%s, userName=%s)", string2, by, locale, list == null ? 0 : list.size(), string);
        if (list == null) {
            return null;
        }
        ReportParamList reportParamList = new ReportParamList(string2, by);
        if (locale != null) {
            reportParamList.set("locale", locale.toString());
        }
        for (ParamInfo paramInfo : list) {
            Object object;
            int n;
            Object object2;
            Object object3;
            boolean bl;
            paramInfo.setLocale(locale);
            String string3 = paramInfo.getName();
            String string4 = paramInfo.getType();
            String[] stringArray = null;
            String[] stringArray2 = null;
            Object object4 = map.get("jrs.param$" + string3);
            if (object4 == null) {
                if (by != -1) continue;
                object4 = paramInfo.isMultiple() && paramInfo.isAllowAll() ? "\u0007" : paramInfo.getDefaultValue();
            }
            if (object4 instanceof String[]) {
                bl = false;
                object3 = ParamUtil.makeUserInput((String[])object4);
                if (object3 != null) {
                    object2 = object3;
                    n = ((UserInput[])object2).length;
                    for (int i = 0; i < n && !(bl = (object = object2[i]).isExpression()); ++i) {
                    }
                }
                if (!bl) {
                    paramInfo.setValue((String[])object4);
                }
                stringArray = (String[])object4;
            } else {
                bl = false;
                object3 = ParamUtil.makeUserInput((String)object4);
                if (object3 != null) {
                    object2 = object3;
                    int n2 = ((UserInput[])object2).length;
                    for (int i = 0; i < n2 && !(bl = (object = object2[i]).isExpression()); ++i) {
                    }
                }
                if (!bl) {
                    paramInfo.setValue((String)object4);
                }
                stringArray = new String[]{(String)object4};
            }
            Vector vector = paramInfo.getValueOptions();
            object3 = paramInfo.getDisplayValues();
            object2 = new HashMap();
            for (n = vector.size() - 1; n >= 0; --n) {
                String string5 = (String)vector.elementAt(n);
                object = string5;
                if (!((Vector)object3).isEmpty() && ((Vector)object3).size() > n) {
                    object = (String)((Vector)object3).elementAt(n);
                }
                object2.put(string5, object);
            }
            stringArray2 = new String[stringArray.length];
            for (n = stringArray.length - 1; n >= 0; --n) {
                String string6 = stringArray[n];
                stringArray2[n] = "\u0007".equals(string6) && paramInfo.isMultiple() && paramInfo.isAllowAll() ? "<All>" : (String)object2.get(string6);
            }
            ParamValue paramValue = new ParamValue(string3, string4, stringArray, stringArray2);
            String string7 = paramInfo.getUserFormat();
            if ((string7 == null || string7.trim().length() == 0) && (string4.equalsIgnoreCase("datetime") || string4.equalsIgnoreCase("date") || string4.equalsIgnoreCase("time"))) {
                string7 = paramInfo.getDefaultDateFormat();
            }
            if (string7 != null && string7.trim().length() > 0) {
                paramValue.set("pattern", string7);
            }
            reportParamList.addParamValue(paramValue);
        }
        return reportParamList;
    }

    public static boolean saveManualReportParamList(String string, Map map) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        Properties properties = httpRptServer.getUserPreferenceManager().getUserPreference(string);
        boolean bl = APIUtil.getBoolean(properties.getProperty("jrs.enable_save_used_parameter_values")) && !APIUtil.getBoolean(properties.getProperty("jrs.isAuto_save_used_parameter_values"));
        ServiceLogger.trace("ParamListManager:ParamUtil:saveManualReportParamList... (isSupportManualSaveParameter=%s, userName=%s)", bl, string);
        if (bl) {
            ReportParamList reportParamList = ParamUtil.addParamValue(string, (byte)0, map, httpRptServer);
            String string2 = (String)map.get("jrs.saved_param_list_name");
            reportParamList.setName(string2);
            ServiceLogger.trace("ParamListManager:ParamUtil:saveManualReportParamList: save manual saved parameter value list. (reportParamList=%s)", reportParamList);
            if (reportParamList != null) {
                return httpRptServer.getParameterRecorder().saveReportParamList(string, reportParamList);
            }
        } else {
            ServiceLogger.error("ParamListManager:ParamUtil:saveManualReportParamList failed! dont support manual saved parameter.", bl, string);
        }
        return false;
    }

    public static boolean deleteReportParamList(String string, Map map) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        String string2 = (String)map.get("jrs.report");
        byte by = 0;
        String string3 = null;
        Object v = map.get("jrs.saved_param_list_type");
        if (v != null && v.toString().trim().length() > 0) {
            try {
                by = Byte.parseByte(v.toString());
                string3 = (String)map.get("jrs.saved_param_list_name");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ServiceLogger.trace("ParamListManager:ParamUtil:deleteReportParamList (reportPath=%s, reportParamListType=%s, reportParamListName=%s, userName=%s)", string2, v, string3, string);
        return httpRptServer.getParameterRecorder().deleteReportParamList(string, string2, string3, by);
    }

    public static ReportParamList getReportParamList(String string, Map map) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ParameterRecorder parameterRecorder = httpRptServer.getParameterRecorder();
        ReportParamList reportParamList = null;
        String string2 = (String)map.get("jrs.report");
        byte by = 0;
        String string3 = null;
        Object v = map.get("jrs.saved_param_list_type");
        if (v != null && v.toString().trim().length() > 0) {
            try {
                by = Byte.parseByte(v.toString());
                string3 = (String)map.get("jrs.saved_param_list_name");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ServiceLogger.trace("ParamListManager:ParamUtil:getReportParamList... (reportPath=%s, reportParamListType=%s, reportParamListName=%s, userName=%s)", string2, v, string3, string);
        if (by == 2 && (reportParamList = parameterRecorder.getDefaultReportParamList(string, string2)) == null) {
            by = -1;
        }
        if (by == -1) {
            Properties properties = new Properties();
            for (String string4 : map.keySet()) {
                if (string4.startsWith("jrs.param$")) continue;
                properties.put(string4, map.get(string4));
            }
            reportParamList = ParamUtil.addParamValue(string, (byte)-1, properties, httpRptServer);
        }
        if (reportParamList == null && string3 != null && string3.trim().length() > 0) {
            reportParamList = parameterRecorder.getReportParamList(string, string2, string3, by);
        }
        ServiceLogger.trace("ParamListManager:ParamUtil:getReportParamList end. (reportParamList=%s)", reportParamList);
        return reportParamList;
    }

    public static void processReportParamSetting(String string, Map map) throws RptServerException {
        boolean bl;
        Serializable serializable;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ParameterRecorder parameterRecorder = httpRptServer.getParameterRecorder();
        String string2 = (String)map.get("jrs.report");
        String string3 = (String)map.get("jrs.dont_show_param_page");
        String string4 = (String)map.get("jrs.save_as_default");
        ServiceLogger.trace("ParamListManager:ParamUtil:processReportParamSetting... (reportPath=%s, dontShowParamPage=%s, saveAsDefalut=%s, userName=%s)", string2, string3, string4, string);
        if ("true".equalsIgnoreCase(string4)) {
            serializable = ParamUtil.addParamValue(string, (byte)2, map, httpRptServer);
            ServiceLogger.trace("ParamListManager:ParamUtil:processReportParamSetting: save user defined defalut. (defaultParamList=%s)", serializable);
            parameterRecorder.saveReportParamList(string, (ReportParamList)serializable);
        }
        if ("true".equalsIgnoreCase(string3) || "false".equalsIgnoreCase(string3)) {
            ServiceLogger.trace("ParamListManager:ParamUtil:processReportParamSetting: set don't show parameter page. (dontShowParamPage=%s)", string3);
            parameterRecorder.setDontShowParamPage(string, string2, Boolean.parseBoolean(string3));
        }
        boolean bl2 = bl = APIUtil.getBoolean(((Properties)(serializable = httpRptServer.getUserPreferenceManager().getUserPreference(string))).getProperty("jrs.enable_save_used_parameter_values")) && APIUtil.getBoolean(((Properties)serializable).getProperty("jrs.isAuto_save_used_parameter_values"));
        if (bl) {
            ReportParamList reportParamList = ParamUtil.addParamValue(string, (byte)1, map, httpRptServer);
            ServiceLogger.trace("ParamListManager:ParamUtil:processReportParamSetting: save auto saved parameter value list.(autoParamList=%s)", reportParamList);
            parameterRecorder.saveReportParamList(string, reportParamList);
        }
    }

    public static Object[] resetParamValues(String string, String string2, Map map) {
        String string3;
        Object[] objectArray = new Object[2];
        String string4 = (String)map.get("jrs.report");
        ReportParamList reportParamList = ParamUtil.getReportParamList(string, map);
        objectArray[0] = reportParamList != null ? (byte)reportParamList.getType() : (byte)-1;
        ServiceLogger.trace("ParamListManager:ParamUtil:resetParamValues...(reportPath=%s, reportParamList=%s)", string4, reportParamList);
        boolean bl = false;
        String string5 = string3 = string2 == null || string2.trim().length() == 0 ? "jrs.param$" : string2;
        if (reportParamList != null) {
            Object object;
            List<ParamInfo> list;
            Object object2;
            if (reportParamList.isDefault() || reportParamList.isBuildin()) {
                object2 = HttpUtil.getHttpRptServer();
                list = ParamUtil.URLDecode(string, map, (HttpRptServer)object2);
                if (list == null || list.size() > reportParamList.sizeOfParamValues()) {
                    bl = true;
                    ServiceLogger.trace("ParamListManager:ParamUtil:resetParamValues failed! parameters size not match.(reportPath=%s, paramInfos.size=%s, paramValues.size=%s)", string4, list == null ? 0 : list.size(), reportParamList.sizeOfParamValues());
                }
                if (!bl) {
                    for (ParamInfo object3 : list) {
                        object = reportParamList.getParamValue(object3.getName());
                        if (object == null) {
                            bl = true;
                            ServiceLogger.trace("ParamListManager:ParamUtil:resetParamValues failed! user defined default value don't existed(paramName=%s)", object3.getName());
                            break;
                        }
                        if (!object3.getType().equals(((ParamValue)object).getType())) {
                            bl = true;
                            ServiceLogger.trace("ParamListManager:ParamUtil:resetParamValues failed! parameter type not match.(reportPath=%s, paramInfo.type=%s, paramValue.type=%s)", string4, object3.getType(), ((ParamValue)object).getType());
                            break;
                        }
                        if (!map.containsKey(string3 + object3.getName())) continue;
                        bl = true;
                        ServiceLogger.trace("ParamListManager:ParamUtil:resetParamValues failed! parameter value has been specified.(reportPath=%s, paramInfo.name=%s)", string4, object3.getName());
                        break;
                    }
                }
            }
            if (!bl && (object2 = reportParamList.getParamValues()) != null) {
                list = object2.iterator();
                while (list.hasNext()) {
                    ParamValue paramValue = (ParamValue)list.next();
                    String[] stringArray = paramValue.getValue();
                    object = paramValue.getName();
                    if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].length() == 0) continue;
                    if (stringArray.length == 1) {
                        if (stringArray[0].equals("\u0007")) {
                            map.put("_isMultiple_" + string2 + (String)object, true);
                        }
                    } else if (stringArray.length > 1) {
                        map.put("_isMultiple_" + string2 + (String)object, true);
                    }
                    map.put(string3 + (String)object, stringArray);
                }
            }
        }
        ServiceLogger.trace("ParamListManager:ParamUtil:resetParamValues end! (reportPath=%s)", string4);
        objectArray[1] = !bl;
        return objectArray;
    }

    public static boolean isDontShowParamPage(String string, Map map) throws RptServerException {
        String string2;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ParameterRecorder parameterRecorder = httpRptServer.getParameterRecorder();
        boolean bl = parameterRecorder.isDontShowParamPage(string, string2 = (String)map.get("jrs.report"));
        if (bl) {
            ReportParamList reportParamList = parameterRecorder.getDefaultReportParamList(string, string2);
            ServiceLogger.trace("ParamListManager:ParamUtil:isDontShowParamPage...(reportPath=%s, dontShowParamPage=%s, userDefinedDefaultParamList=%s)", string2, bl, reportParamList);
            if (reportParamList != null) {
                List<ParamInfo> list = ParamUtil.URLDecode(string, map, httpRptServer);
                if (list == null || list.size() > reportParamList.sizeOfParamValues()) {
                    bl = false;
                    ServiceLogger.trace("ParamListManager:ParamUtil:isDontShowParamPage false! parameters size gather than user defined default.", new Object[0]);
                }
                if (bl) {
                    for (ParamInfo paramInfo : list) {
                        ParamValue paramValue = reportParamList.getParamValue(paramInfo.getName());
                        if (paramValue == null) {
                            bl = false;
                            ServiceLogger.trace("ParamListManager:ParamUtil:isDontShowParamPage false! user defined default value don't existed(paramName=%s)", paramInfo.getName());
                            break;
                        }
                        if (paramInfo.getType().equals(paramValue.getType())) continue;
                        bl = false;
                        ServiceLogger.trace("ParamListManager:ParamUtil:isDontShowParamPage false! parameter type not match.(paramName=%s, paramInfo.type=%s, paramValue.type=%s)", paramInfo.getName(), paramInfo.getType(), paramValue.getType());
                        break;
                    }
                }
            }
        }
        ServiceLogger.trace("ParamListManager:ParamUtil:isDontShowParamPage end! (reportPath=%s, dontShowParamPage=%s)", string2, bl);
        return bl;
    }

    public static String replaceWithSessionParameter(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray;
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("SessionParameter:ParamUtil:replaceWithSessionParameter... (key=%s)", string);
        }
        Properties properties = new Properties();
        ParamUtil.replaceWithSessionParameter(httpServletRequest.getSession(), properties);
        Object object = properties.get(string);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[] && (stringArray = (String[])object).length > 0) {
            return stringArray[0];
        }
        return httpServletRequest.getParameter(string);
    }

    private static DataSourceDef addResource(Map map) {
        String string = (String)map.get("jrs.jdbc_url");
        String string2 = (String)map.get("jrs.db_user");
        String string3 = (String)map.get("jrs.db_pswd");
        String string4 = (String)map.get("jrs.jdbc_driver");
        DataSourceDef dataSourceDef = null;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            dataSourceDef = new DataSourceDef("", string2, string3, string, string4);
        }
        KVMapDef kVMapDef = new KVMapDef();
        if (map.get("jrs.db_refresh_support_info") != null) {
            kVMapDef.put((Object)"refresh_support_info", (Object)((String)map.get("jrs.db_refresh_support_info")));
        }
        if (map.get("jrs.db_quote_character") != null) {
            kVMapDef.put((Object)"quote_character", (Object)((String)map.get("jrs.db_quote_character")));
        }
        if (map.get("jrs.db_extra_characters") != null) {
            kVMapDef.put((Object)"extra_characters", (Object)((String)map.get("jrs.db_extra_characters")));
        }
        if (map.get("jrs.db_date_format") != null) {
            kVMapDef.put((Object)"date_format", (Object)((String)map.get("jrs.db_date_format")));
        }
        if (map.get("jrs.db_datetime_format") != null) {
            kVMapDef.put((Object)"datetime_format", (Object)((String)map.get("jrs.db_datetime_format")));
        }
        if (map.get("jrs.db_time_format") != null) {
            kVMapDef.put((Object)"time_format", (Object)((String)map.get("jrs.db_time_format")));
        }
        if (map.get("jrs.db_transaction_readonly") != null) {
            kVMapDef.put((Object)"transaction_readonly", (Object)((String)map.get("jrs.db_transaction_readonly")));
        }
        if (map.get("jrs.db_transaction_mode") != null) {
            kVMapDef.put((Object)"transaction_mode", (Object)((String)map.get("jrs.db_transaction_mode")));
        }
        if (map.get("jrs.db_char_to_be_replaced") != null) {
            kVMapDef.put((Object)"char_to_be_replaced", (Object)((String)map.get("jrs.db_char_to_be_replaced")));
        }
        if (map.get("jrs.db_char_replaced_by") != null) {
            kVMapDef.put((Object)"char_replaced_by", (Object)((String)map.get("jrs.db_char_replaced_by")));
        }
        if (map.get("jrs.db_name_pattern") != null) {
            kVMapDef.put((Object)"name_pattern", (Object)((String)map.get("jrs.db_name_pattern")));
        }
        if (kVMapDef.size() > 0) {
            if (dataSourceDef == null) {
                dataSourceDef = new DataSourceDef("", null, -1);
            }
            dataSourceDef.setDbMetaInfo(kVMapDef);
        }
        return dataSourceDef;
    }

    public static void replaceWithSessionParameter(HttpSession httpSession, Map map) {
        Map map2 = ParamUtil.getSessionParameters(httpSession, map);
        if (map2 != null) {
            map.putAll(map2);
        }
    }

    public static Map getSessionParameters(HttpSession httpSession, Map map) {
        Object object = httpSession.getAttribute("JReport_running_parameter");
        if (object instanceof String) {
            return ParamUtil.convertToMap((String)object, map);
        }
        return new HashMap();
    }

    public static Map convertToMap(String string, Map map) {
        if (string == null) {
            return null;
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("SessionParameter:ParamUtil:convertToMap: ...(sessionURL=%s, requestParameters=%s)", string, StringUtil.toString(map));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map map2 = ParamUtil.convertToMap(string);
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        StringBuffer stringBuffer = null;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            boolean bl = false;
            if (string3.indexOf("=") > -1) {
                bl = true;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string3);
            } else {
                if (!bl) {
                    stringBuffer.append("&");
                }
                stringBuffer.append(string3);
            }
            if (!bl) continue;
            int n = stringBuffer.indexOf("=");
            String string4 = stringBuffer.substring(0, n);
            String string5 = stringBuffer.substring(n + 1);
            try {
                string4 = StringUtil.URLDecode(string4);
            }
            catch (Throwable throwable) {
                ServiceLogger.error(throwable, "SessionParameter:ParamUtil:convertToMap: decode error! (key=%s)", string4);
            }
            try {
                string5 = StringUtil.URLDecode(string5);
            }
            catch (Throwable throwable) {
                ServiceLogger.error(throwable, "SessionParameter:ParamUtil:convertToMap: decode error! (val=%s)", string5);
            }
            Object v = hashMap.get(string4);
            String string6 = null;
            if (string4.startsWith("jrs.param$") && (string6 = (String)map2.get("_isMultiple_" + string4)) == null) {
                string6 = map != null ? (String)map.get("_isMultiple_" + string4) : "true";
            }
            if (string6 != null && string6.trim().length() > 0) {
                if (v == null) {
                    hashMap.put(string4, new String[]{string5});
                } else {
                    hashMap.put(string4, StringUtils.addStringToArray((String[])v, string5));
                }
            } else if (v == null) {
                hashMap.put(string4, string5);
            } else {
                ServiceLogger.trace("SessionParameter:ParamUtil:convertToMap: existed(%s=%s), ignore(%s=%s)", string4, v, string4, string5);
            }
            stringBuffer = null;
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("SessionParameter:ParamUtil:convertToMap: parsed session URL! (sessionProperties=%s)", StringUtil.toString(hashMap));
            ServiceLogger.trace("SessionParameter:ParamUtil:convertToMap: end! (requestParameters=%s)", StringUtil.toString(map));
        }
        return hashMap;
    }

    public static Map convertToMap(String string) {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("SessionParameter:ParamUtil:: end! (urlString=%s)", string);
        }
        if (string == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string instanceof String) {
            String string2 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            StringBuffer stringBuffer = null;
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                boolean bl = false;
                if (string3.indexOf("=") > -1) {
                    bl = true;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string3);
                } else {
                    if (!bl) {
                        stringBuffer.append("&");
                    }
                    stringBuffer.append(string3);
                }
                if (!bl) continue;
                int n = stringBuffer.indexOf("=");
                String string4 = stringBuffer.substring(0, n);
                String string5 = stringBuffer.substring(n + 1);
                try {
                    string4 = StringUtil.URLDecode(string4);
                }
                catch (Throwable throwable) {
                    ServiceLogger.error(throwable, "SessionParameter:ParamUtil:: decode error! (key=%s)", string4);
                }
                try {
                    string5 = StringUtil.URLDecode(string5);
                }
                catch (Throwable throwable) {
                    ServiceLogger.error(throwable, "SessionParameter:ParamUtil:: decode error! (val=%s)", string5);
                }
                boolean bl2 = false;
                if (string4.startsWith("jrs.param$")) {
                    bl2 = true;
                }
                Object v = hashMap.get(string4);
                if (bl2) {
                    if (v == null) {
                        hashMap.put(string4, new String[]{string5});
                    } else {
                        hashMap.put(string4, StringUtils.addStringToArray((String[])v, string5));
                    }
                } else if (v == null) {
                    hashMap.put(string4, string5);
                } else {
                    ServiceLogger.trace("SessionParameter:ParamUtil:: existed(%s=%s), ignore(%s=%s)", string4, v, string4, string5);
                }
                stringBuffer = null;
            }
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("SessionParameter:ParamUtil:: parsed session URL! (sessionProperties=%s)", StringUtil.toString(hashMap));
        }
        return hashMap;
    }

    public static void removeSessionParameter(HttpSession httpSession, Map map) {
        Map map2 = ParamUtil.getSessionParameters(httpSession, map);
        if (map2 != null) {
            for (Object k : map2.keySet()) {
                map.remove(k);
                if (!ServiceLogger.isLoggable(4, 6)) continue;
                ServiceLogger.trace("SessionParameter:ParamUtil:removeSessionParameter: key = %s", k);
            }
        }
    }

    public static Map convertJRStoJRD(String string) {
        Object object;
        Object object2;
        String string22;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string == null) {
            return hashMap;
        }
        Map map = ParamUtil.convertToMap(string);
        String string10 = (String)map.get("jrs.catalog");
        String string11 = (String)map.get("jrs.cat_version");
        ResourceDef resourceDef = null;
        if (string10 != null || string11 != null) {
            resourceDef = new ResourceDef(string10, APIUtil.parseInt(string11, -1), false, new int[0]);
            hashMap.put("jrd_catalog", resourceDef);
        }
        String string12 = (String)map.get("jrs.report");
        String string13 = (String)map.get("jrs.rpt_version");
        ResourceDef resourceDef2 = null;
        if (string12 != null || string13 != null) {
            resourceDef2 = new ResourceDef(string12, APIUtil.parseInt(string13, -1), false, new int[0]);
            hashMap.put("jrd_report", resourceDef2);
        }
        if ((string9 = (String)map.get("jrd_viewType")) != null) {
            hashMap.put("jrd_viewType", string9);
        }
        UserInfoImpl userInfoImpl = new UserInfoImpl(null);
        String string14 = (String)map.get("jrs.dhtml_resolution");
        if (string14 != null) {
            try {
                userInfoImpl.setProperty("resolution", APIUtil.parseInt(string14));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string15 = (String)map.get("jrs.rpt_language");
        String string16 = (String)map.get("jrs.rpt_country");
        String string17 = (String)map.get("jrs.rpt_variant");
        if (string15 != null || string16 != null) {
            userInfoImpl.setLocale(string15, string16);
        }
        if ((string8 = (String)map.get("jrs.rpt_encoding")) != null) {
            userInfoImpl.setEncoding(string8);
        }
        if ((string7 = (String)map.get("jrs.style_group")) != null) {
            userInfoImpl.setProperty("style", string7);
        }
        if ((string6 = (String)map.get("jrs.from_encoding")) != null) {
            userInfoImpl.setProperty("bCEncoding", string6);
        }
        if ((string5 = (String)map.get("jrs.to_encoding")) != null) {
            userInfoImpl.setProperty("aCEncoding", string5);
        }
        if ((string4 = (String)map.get("jrs.profile")) != null) {
            userInfoImpl.setProperty("profile", string4);
        }
        if ((string3 = (String)map.get("jrs.enable_nls")) != null) {
            userInfoImpl.setProperty("enableNLS", APIUtil.getBoolean(string3));
        }
        hashMap.put("jrd_userinfo", userInfoImpl);
        JCollection jCollection = new JCollection();
        DataSourceDef dataSourceDef = ParamUtil.addResource(map);
        if (dataSourceDef != null) {
            jCollection.add(dataSourceDef);
        }
        for (String string22 : map.keySet()) {
            if (!string22.startsWith("jrs.dynamic_connection$")) continue;
            String string18 = "jrs.dynamic_connection$QAZPLM$";
            if (string22.startsWith(string18)) {
                object2 = ServerUtil.parseDataSourceConnectionName(string22.substring("jrs.dynamic_connection$".length()));
                String string19 = object2[0];
                object = object2[1];
                jCollection.add(new DataSourceDef(string19, (String)map.get(string22), 8));
                continue;
            }
            jCollection.add(new DataSourceDef(string22.substring("jrs.dynamic_connection$".length()), (String)map.get(string22), 8));
        }
        if (jCollection.size() > 0) {
            hashMap.put("jrd_datasources", jCollection);
        }
        string22 = new KVMapDef();
        for (String string19 : map.keySet()) {
            if (string19.startsWith("jrs.param$") && !string19.endsWith("_isd") && !string19.endsWith("_uf")) {
                object = (String[])map.get(string19);
                object2 = string19.substring("jrs.param$".length());
                string22.put(object2, object);
                continue;
            }
            if (!string19.startsWith("jrs.param.exp$") || (object2 = map.get(object = "jrs.param$" + string19.substring("jrs.param.exp$".length()))) != null) continue;
            String string20 = ServerUtil.getExpression(map, string19);
            String string21 = "jrs.param.pattern$" + string19.substring("jrs.param.exp$".length());
            String string22 = (String)map.get(string21);
            try {
                Object object3 = ServerUtil.evalExpressionValue(string20, string22);
                if (object3 == null) continue;
                string22.put((Object)((String)object).substring("jrs.param$".length()), (Object)object3.toString());
            }
            catch (ExecFormulaFailedException execFormulaFailedException) {
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {}
        }
        hashMap.put("jrd_param$", string22);
        return hashMap;
    }

    public static String makeDHTMLUrl(Map map, String string, boolean bl, boolean bl2, JCollection jCollection) throws ExecFormulaFailedException, ParseFormulaFailedException {
        String string2;
        Object object;
        Object object22;
        Object object3;
        Object object42;
        String string3;
        String string42;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11 = (String)map.get("jrs.catalog");
        String string12 = (String)map.get("jrs.cat_version");
        long l = APIUtil.parseLong((String)map.get("catalog_last_modified"));
        ResourceDef resourceDef = null;
        if (string11 != null || string12 != null) {
            resourceDef = new ResourceDef(string11, APIUtil.parseInt(string12, -1), false, new int[0]);
        }
        if (resourceDef != null) {
            resourceDef.setLastModify(l);
        }
        String string13 = (String)map.get("jrs.report");
        String string14 = (String)map.get("jrs.rpt_version");
        long l2 = APIUtil.parseLong((String)map.get("report_last_modified"));
        ResourceDef resourceDef2 = null;
        if (string13 != null || string14 != null) {
            resourceDef2 = new ResourceDef(string13, APIUtil.parseInt(string14, -1), false, new int[0]);
        }
        if (resourceDef2 != null) {
            resourceDef2.setLastModify(l2);
        }
        UserInfoImpl userInfoImpl = new UserInfoImpl(string);
        String string15 = (String)map.get("jrs.engine_id");
        if (string15 != null) {
            userInfoImpl.setProperty("engine_id", string15);
        }
        if ((string10 = (String)map.get("jrs.dhtml_resolution")) != null) {
            try {
                userInfoImpl.setProperty("resolution", APIUtil.parseInt(string10));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string16 = (String)map.get("jrs.rpt_language");
        String string17 = (String)map.get("jrs.rpt_country");
        String string18 = (String)map.get("jrs.rpt_variant");
        if (string16 != null || string17 != null) {
            userInfoImpl.setLocale(string16, string17);
        }
        if (string16 != null) {
            userInfoImpl.setProperty("rpt_lang", string16);
        }
        if (string17 != null) {
            userInfoImpl.setProperty("rpt_country", string17);
        }
        if ((string9 = (String)map.get("jrs.rpt_encoding")) != null) {
            userInfoImpl.setEncoding(string9);
            userInfoImpl.setProperty("rpt_encoding", string9);
        }
        boolean bl3 = CSUtil.getBoolean((String)map.get("jrs.has_style"), false);
        String string19 = (String)map.get("jrs.style_group");
        if (bl3 && string19 != null) {
            userInfoImpl.setProperty("style", string19);
        }
        if ((string8 = (String)map.get("jrs.from_encoding")) != null) {
            userInfoImpl.setProperty("bCEncoding", string8);
        }
        if ((string7 = (String)map.get("jrs.to_encoding")) != null) {
            userInfoImpl.setProperty("aCEncoding", string7);
        }
        if ((string6 = (String)map.get("jrs.profile")) != null) {
            userInfoImpl.setProperty("profile", string6);
        }
        if ((string5 = (String)map.get("jrs.enable_nls")) != null) {
            userInfoImpl.setProperty("enableNLS", APIUtil.getBoolean(string5));
        }
        if (jCollection == null) {
            jCollection = new JCollection();
        }
        String string20 = userInfoImpl.toString();
        DataSourceDef dataSourceDef = ParamUtil.addResource(map);
        if (dataSourceDef != null) {
            jCollection.add(dataSourceDef);
        }
        for (String string42 : map.keySet()) {
            if (!string42.startsWith("jrs.dynamic_connection$")) continue;
            string3 = "jrs.dynamic_connection$QAZPLM$";
            if (string42.startsWith(string3)) {
                object42 = ServerUtil.parseDataSourceConnectionName(string42.substring("jrs.dynamic_connection$".length()));
                object3 = object42[0];
                String string21 = object42[1];
                jCollection.add(new DataSourceDef((String)object3, (String)map.get(string42), 8));
                continue;
            }
            jCollection.add(new DataSourceDef(string42.substring("jrs.dynamic_connection$".length()), (String)map.get(string42), 8));
        }
        string42 = null;
        if (jCollection != null && jCollection.size() > 0) {
            string42 = jCollection.toString();
        }
        string3 = (String)map.get("jrd_viewType");
        object3 = new KVMapDef();
        for (Object object42 : map.keySet()) {
            String string22;
            String string23;
            Object object5;
            Object object6;
            if (((String)object42).startsWith("jrs.param$") && !((String)object42).endsWith("_isd") && !((String)object42).endsWith("_uf")) {
                object6 = ((String)object42).substring("jrs.param$".length());
                object22 = (String)map.get("_isMultiple_" + (String)object42);
                if (object22 != null) {
                    object = (String[])map.get(object42);
                    object3.put(object6, object);
                    for (int i = 0; i < ((Object)object).length; ++i) {
                    }
                    continue;
                }
                object = (String)map.get(object42);
                if (object == null || ((String)object).trim() == null) continue;
                object3.put(object6, object);
                continue;
            }
            if (!((String)object42).startsWith("jrs.param.exp$") || (object22 = map.get(object6 = "jrs.param$" + ((String)object42).substring("jrs.param.exp$".length()))) != null || (object5 = ServerUtil.evalExpressionValue((String)(object = ServerUtil.getExpression(map, (String)object42)), string23 = (String)map.get(string22 = "jrs.param.pattern$" + ((String)object42).substring("jrs.param.exp$".length())))) == null) continue;
            object3.put((Object)((String)object6).substring("jrs.param$".length()), (Object)object5.toString());
        }
        object42 = new StringBuffer();
        for (Object object22 : map.keySet()) {
            if (!(object22 instanceof String) || !((String)object22).startsWith("jrd_") || (object = map.get(object22)) == null) continue;
            ((StringBuffer)object42).append(object22 + "=" + HttpUtil.encodeEsc(object.toString())).append("&");
        }
        object22 = "../webreport/studio/entry/run.jsp?" + object42;
        if (bl) {
            object = new ResourceExt();
            ((ResourceExt)object).addResource(new ResourceDef(string13, APIUtil.parseInt(string14, -1), false, null));
            ((ResourceExt)object).setAttribute("active", 0);
            String string24 = (String)map.get("jrd_dashboard_mode");
            object22 = "../dashboard/app/entry/run.jsp?" + object42 + "jrd_resext=" + HttpUtil.encodeEsc(((ResourceExt)object).toString()) + "&jrd_dashboard_mode=" + HttpUtil.encodeEsc(string24) + "&";
        }
        if (bl2) {
            object = new ResourceExt();
            ((ResourceExt)object).addResource(new ResourceDef(string13, APIUtil.parseInt(string14, -1), false, null));
            ((ResourceExt)object).setAttribute("active", 0);
            object22 = "../webos/app/designer/run.jsp?" + object42 + "jrd_resext=" + HttpUtil.encodeEsc(((ResourceExt)object).toString()) + "&";
        }
        object22 = object22 + "jrs.param_page=true&";
        if (resourceDef != null) {
            object22 = object22 + "jrd_catalog=" + HttpUtil.encodeEsc(resourceDef.toString()) + "&";
        }
        if (resourceDef2 != null) {
            object22 = object22 + "jrd_report=" + HttpUtil.encodeEsc(resourceDef2.toString()) + "&";
        }
        if (string3 != null) {
            object22 = object22 + "jrd_viewType=" + HttpUtil.encodeEsc(string3) + "&";
        }
        if (string20 != null && string20.trim().length() > 0) {
            object22 = object22 + "jrd_userinfo=" + HttpUtil.encodeEsc(string20) + "&";
        }
        if (string42 != null && string42.trim().length() > 0) {
            object22 = object22 + "jrd_datasources=" + HttpUtil.encodeEsc(string42) + "&";
        }
        if ((object = object3.toString()) != null && ((String)object).trim().length() > 0) {
            object22 = object22 + "jrd_param$=" + HttpUtil.encodeEsc((String)object) + "&";
        }
        if ((string2 = (String)map.get("jrs.security_file_name")) != null) {
            object22 = object22 + "jrs.security_file_name=" + HttpUtil.encodeEsc(string2) + "&";
        }
        return object22;
    }

    private static Properties addStringToArray(Map<Object, Object> map) throws GenerateParameterException {
        Properties properties = new Properties();
        ArrayList<Object> arrayList = new ArrayList<Object>(map.keySet());
        for (String string : arrayList) {
            String string2;
            if (string.startsWith("jrs.param$")) {
                string2 = "jrs.param$";
            } else if (string.startsWith("jrs.param.exp$")) {
                string2 = "jrs.param.exp$";
            } else {
                if (!string.startsWith("jrs.param.pattern$")) continue;
                string2 = "jrs.param.pattern$";
            }
            Object object = properties.remove(string);
            if (object == null) continue;
            String string3 = string2 + string.substring(string2.length()).toLowerCase();
            properties.put(string3, object);
        }
        return properties;
    }

    public static Vector<ParamDesc> makeParamDescs(Locale locale, Properties properties, JREngine jREngine) throws InvalidParameterException, Exception {
        try {
            ParameterEnvAdapter parameterEnvAdapter = jREngine.getParameterEnvAdapter();
            ParamDescsUtil paramDescsUtil = new ParamDescsUtil(new ArrayList(parameterEnvAdapter.getAllParameters(false).values()));
            long l = System.currentTimeMillis();
            InvalidParamsException invalidParamsException = null;
            Vector vector = paramDescsUtil.getParams();
            for (ParamDesc paramDesc : vector) {
                try {
                    Object object = ParamUtil.evalParamValue(paramDesc, properties, properties);
                    ParamUtil.setParamValue(paramDesc, object, locale, l);
                }
                catch (InvalidParameterException invalidParameterException) {
                    String string = paramDesc.getPrompt();
                    string = string == null || string.length() == 0 ? paramDesc.getName() : string;
                    String string2 = "Parameter \"" + string + "\", ";
                    invalidParamsException = new InvalidParamsException(invalidParamsException, string2 + invalidParameterException.getMessage());
                }
            }
            if (invalidParamsException != null) {
                throw invalidParamsException;
            }
            return vector;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    private static class UserInputImpl
    implements UserInput {
        private boolean SEDU = false;
        private String append = "";
        private Date containsKey = null;

        UserInputImpl(String string) {
            ServiceLogger.logDebug("ParamUtil:new UserInput... expr = " + string, 6);
            if (string != null) {
                if (string.startsWith("{") && string.endsWith("}")) {
                    Map map = this.SEDU(string);
                    if (map != null && (map.containsKey("selectedDate") || map.containsKey("exp"))) {
                        String string2 = (String)map.get("selectedDate");
                        if (string2 != null && string2.trim().length() > 0) {
                            try {
                                this.containsKey = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse(string2);
                            }
                            catch (ParseException parseException) {
                                try {
                                    this.containsKey = new SimpleDateFormat("MM/dd/yyyy").parse(string2);
                                }
                                catch (ParseException parseException2) {
                                    ServiceLogger.logError(parseException2, 2);
                                }
                            }
                        }
                        this.append = (String)map.get("exp");
                        this.SEDU = true;
                    } else {
                        this.append = string;
                        this.SEDU = false;
                    }
                } else {
                    this.append = string;
                }
                if (this.append == null) {
                    this.append = "";
                }
                try {
                    if (this.append.indexOf(40) > -1 && this.append.indexOf(41) > -1) {
                        this.SEDU = new FormulaContainerImpl().parseFormulaByExp(this.append);
                    }
                }
                catch (ParseFormulaFailedException parseFormulaFailedException) {
                    // empty catch block
                }
            }
            ServiceLogger.logDebug("ParamUtil:new UserInput success! ret = " + this, 6);
        }

        private Map SEDU(String string) {
            try {
                return Json.fromJson(string);
            }
            catch (Json.JsonException jsonException) {
                ServiceLogger.logError(jsonException, 3);
                return null;
            }
        }

        public boolean isExpression() {
            return this.SEDU;
        }

        public String getUserInput() {
            return this.append;
        }

        public String getExpressionName() {
            return this.append;
        }

        public Date getSelectedDate() {
            return this.containsKey;
        }

        public String toString() {
            return new StringBuffer().append("{userInput : ").append(this.append).append(", isExpr : ").append(this.SEDU).append(", selectedDate : ").append(this.containsKey).toString();
        }
    }
}

