/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import jet.server.log.ServiceLogger;
import jet.server.util.FormData;
import jet.server.util.MultiPartFormData;
import jet.server.util.WebSecurityUtil;
import jet.server.util.ZipTools;

public class UploadFileUtil {
    private static final String SEDU = ".zip";
    private static final String add = ".tar";
    private static final String append = ".jar";
    private static final String close = ".tgz";
    private static final String delete = ".tar.gz";
    private static final String destroy = ".tar.zip";
    private static final String elementAt = ".gzip";
    private static final String endsWith = ".gz";

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string, boolean bl) throws IOException {
        Properties properties = new Properties();
        MultiPartFormData multiPartFormData = UploadFileUtil.SEDU(httpServletRequest, string);
        if (multiPartFormData != null) {
            Vector vector = UploadFileUtil.append(multiPartFormData);
            properties = UploadFileUtil.close(multiPartFormData);
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    if (bl) {
                        if ((string2 = UploadFileUtil.delete(string2)) == null) continue;
                        properties.put("jrs.deploy_from_file", string2);
                        properties.put("jrs.folder_with_contents", "true");
                        continue;
                    }
                    properties.put("jrs.upload_file", string2);
                }
            }
            UploadFileUtil.exists(multiPartFormData, httpServletRequest);
        }
        return properties;
    }

    public static Properties uploadSkinFile(HttpServletRequest httpServletRequest, String string) throws IOException {
        MultiPartFormData multiPartFormData;
        Properties properties = new Properties();
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((multiPartFormData = UploadFileUtil.SEDU(httpServletRequest, string)) != null) {
            Vector vector = UploadFileUtil.append(multiPartFormData);
            properties = UploadFileUtil.close(multiPartFormData);
            String string2 = null;
            string2 = properties.getProperty("skin_waitting_page");
            if (string2 != null) {
                string2 = "skin" + File.separator + string2;
            } else {
                string2 = properties.getProperty("skin_waitting_statue");
                if (string2 != null) {
                    string2 = "images" + File.separator + string2;
                }
            }
            if (string2 != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string3 = (String)vector.elementAt(i);
                    File file = new File(string3);
                    if (!file.exists()) continue;
                    File file2 = WebSecurityUtil.validateFilePath(string + string2);
                    if (file2.exists()) {
                        file2.delete();
                    }
                    file.renameTo(file2);
                }
            }
            UploadFileUtil.exists(multiPartFormData, httpServletRequest);
        }
        return properties;
    }

    public static Properties getUploadFileProperties(HttpServletRequest httpServletRequest, String string) throws IOException {
        return UploadFileUtil.getUploadFileProperties(httpServletRequest, string, true);
    }

    private static MultiPartFormData SEDU(HttpServletRequest httpServletRequest, String string) throws IOException {
        String string2 = string;
        String string3 = httpServletRequest.getContentType();
        int n = string3.indexOf("multipart/form-data");
        String string4 = string3.substring(n);
        if ((n = string4.indexOf("boundary=")) >= 0) {
            String string5 = string4.substring(n + 9);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            string2 = UploadFileUtil.add(string2);
            MultiPartFormData multiPartFormData = new MultiPartFormData((InputStream)servletInputStream, string2, string5);
            return multiPartFormData;
        }
        return null;
    }

    private static String add(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private static Vector append(MultiPartFormData multiPartFormData) {
        Vector vector = multiPartFormData.getUploadedFiles();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                FormData formData = (FormData)vector.elementAt(i);
                vector2.add(formData.getFilename());
            }
        }
        return vector2;
    }

    private static Properties close(MultiPartFormData multiPartFormData) {
        Properties properties = new Properties();
        Vector vector = multiPartFormData.getOtherFormData();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                FormData formData = (FormData)vector.elementAt(i);
                if (formData.getName() == null || formData.getName().length() <= 0 || formData.getContent() == null) continue;
                properties.put(formData.getName(), formData.getContent());
            }
        }
        return properties;
    }

    private static String delete(String string) {
        String string2 = string;
        if (UploadFileUtil.destroy(string2)) {
            string2 = UploadFileUtil.elementAt(string2);
            File file = new File(string2);
            file.mkdir();
            try {
                ZipTools.unzip(string, string2 + File.separator, true);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return null;
            }
            UploadFileUtil.endsWith(string);
            return string2;
        }
        return null;
    }

    private static boolean destroy(String string) {
        if (string.endsWith(SEDU)) {
            return true;
        }
        if (string.endsWith(add)) {
            return true;
        }
        if (string.endsWith(append)) {
            return true;
        }
        if (string.endsWith(close)) {
            return true;
        }
        if (string.endsWith(delete)) {
            return true;
        }
        if (string.endsWith(destroy)) {
            return true;
        }
        return string.endsWith(elementAt) || string.endsWith(endsWith);
    }

    private static String elementAt(String string) {
        String string2 = string;
        string2 = string2.endsWith(delete) ? string2.substring(0, string2.length() - delete.length()) : (string2.endsWith(destroy) ? string2.substring(0, string2.length() - destroy.length()) : (string2.endsWith(elementAt) ? string2.substring(0, string2.length() - elementAt.length()) : (string2.endsWith(endsWith) ? string2.substring(0, string2.length() - endsWith.length()) : string2.substring(0, string2.length() - SEDU.length()))));
        return string2;
    }

    private static void endsWith(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    private static void exists(MultiPartFormData multiPartFormData, HttpServletRequest httpServletRequest) throws IOException {
        multiPartFormData.destroy();
        httpServletRequest.getInputStream().close();
    }
}

