/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import jet.server.log.ServiceLogger;

public class WebSecurityUtil {
    private static String[] SEDU;
    private static DecimalFormat append;
    private static final Map<Character, String> endsWith;
    private static final Map<Character, String> equals;
    private static final Map<Character, String> equalsIgnoreCase;

    private static String SEDU(String string, Map<Character, String> map) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            String string2 = map.get(Character.valueOf(c));
            if (string2 == null) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String escapeHTML(String string) {
        return WebSecurityUtil.SEDU(string, endsWith);
    }

    public static String escapeHTML(String string, boolean bl) {
        String string2 = WebSecurityUtil.escapeHTML(string);
        if (bl && string2.length() == 0) {
            return "&nbsp;";
        }
        return string2;
    }

    public static String escapeHTML(Object object) {
        String string = object == null ? null : object.toString();
        return WebSecurityUtil.escapeHTML(string);
    }

    public static String escapeHTMLAttribute(String string) {
        return WebSecurityUtil.SEDU(string, equals);
    }

    public static String escapeHTMLAttribute(Object object) {
        String string = object == null ? null : object.toString();
        return WebSecurityUtil.escapeHTMLAttribute(string);
    }

    public static String escapeJavaScript(String string) {
        return WebSecurityUtil.SEDU(string, equalsIgnoreCase);
    }

    public static String escapeJavaScript(Object object) {
        String string = object == null ? null : object.toString();
        return WebSecurityUtil.escapeJavaScript(string);
    }

    public static String validateResponseHeader(String string) {
        String string2 = string;
        for (int i = 0; i < SEDU.length; ++i) {
            string2 = WebSecurityUtil.append(string2, SEDU[i]);
        }
        return string2;
    }

    private static String append(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        String string3 = string;
        do {
            if ((n2 = string3.indexOf(string2, n)) != -1) {
                stringBuffer.append(string3.substring(n, n2));
                n = n2 + string2.length();
                continue;
            }
            stringBuffer.append(string3.substring(n));
        } while (n2 != -1);
        return stringBuffer.toString();
    }

    public static String validateNumber(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        append.parse(string);
        return string;
    }

    public static String validateBoolean(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        if (!string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
            throw new ParseException(string, 0);
        }
        return string;
    }

    public static Class validateReflectClass(String string, String[] stringArray, Class[] classArray) {
        if (null == string) {
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                try {
                    return Class.forName(string);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
        }
        if (classArray != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                return null;
            }
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                for (int j = 0; j < classArray.length; ++j) {
                    if (!classArray2[i].equals(classArray[j])) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    public static String validateFileName(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("[\\\\/:*?<>|\"\r\n]", "").replaceAll("\\.{2,}", "");
        return string;
    }

    public static String validateSubPath(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("[:*?<>|\"\r\n]", "").replaceAll("\\.{2,}", "").replaceAll("\\\\{2,}", "\\\\").replaceAll("/{2,}", "/");
        return string;
    }

    public static String validateFilePathStr(String string) {
        File file = WebSecurityUtil.validateFilePath(string);
        return file == null ? null : file.getPath();
    }

    public static File validateFilePath(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return WebSecurityUtil.validateFilePath(new File(string));
    }

    public static File validateFilePath(String string, String string2) {
        return WebSecurityUtil.validateFilePath(new File(string, string2));
    }

    public static File validateFilePath(File file, String string) {
        return WebSecurityUtil.validateFilePath(new File(file, string));
    }

    public static File validateFilePath(File file) {
        String[] stringArray = null;
        String string = System.getProperty("jreport.server.file.blacklist");
        if (string != null) {
            stringArray = string.split(File.pathSeparator);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.trim().length() == 0) continue;
                File file2 = new File(string2);
                for (File file3 = file; file3 != null; file3 = file3.getParentFile()) {
                    if (!file3.equals(file2)) continue;
                    return null;
                }
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var4_7;
        SEDU = new String[]{"\n", "\r", "%0a", "%0d", "%0A", "%0D"};
        append = new DecimalFormat();
        endsWith = new HashMap<Character, String>();
        endsWith.put(Character.valueOf('&'), "&amp;");
        endsWith.put(Character.valueOf('<'), "&lt;");
        endsWith.put(Character.valueOf('>'), "&gt;");
        endsWith.put(Character.valueOf('\"'), "&quot;");
        endsWith.put(Character.valueOf('\''), "&#x27;");
        endsWith.put(Character.valueOf('/'), "&#x2F;");
        String string = "&<>\"'/";
        equals = new HashMap<Character, String>();
        for (char n : string.toCharArray()) {
            String string2 = String.format("&#x%02X;", n);
            equals.put(Character.valueOf(n), string2);
        }
        Object object = "\\'\"<>\r\n";
        equalsIgnoreCase = new HashMap<Character, String>();
        char[] cArray = ((String)object).toCharArray();
        int n = cArray.length;
        boolean bl = false;
        while (var4_7 < n) {
            char c = cArray[var4_7];
            String string3 = String.format("\\x%02X", c);
            equalsIgnoreCase.put(Character.valueOf(c), string3);
            ++var4_7;
        }
    }
}

