/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipArchive {
    public static final String MODE_WRITE = "w";
    public static final String MODE_READ = "r";
    private ZipOutputStream SEDU;
    private ZipFile add;
    private ArrayList append = new ArrayList();
    private StringBuffer close = new StringBuffer();
    private byte[] closeEntry = new byte[2048];

    public boolean open(String string, String string2) throws IOException {
        String string3 = string2.toLowerCase();
        if (MODE_WRITE.equals(string3)) {
            File file;
            File file2 = new File(string);
            if (!file2.exists() && (file = file2.getParentFile()) != null) {
                file.mkdirs();
            }
            this.SEDU = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        } else if (MODE_READ.equals(string3)) {
            this.add = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = this.add.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                this.append.add(zipEntry.getName());
            }
        }
        return true;
    }

    public void close() throws IOException {
        if (this.SEDU != null) {
            this.SEDU.close();
            this.SEDU = null;
        }
        if (this.add != null) {
            this.add.close();
            this.add = null;
        }
    }

    public int compress(String string, String string2, boolean bl) throws IOException {
        if (this.SEDU == null) {
            throw new IOException("The zip file has not been opened.");
        }
        if (string2 == null || string2.trim().length() == 0 || string2.equals("/")) {
            return this.SEDU(new File(string), "", bl);
        }
        return this.SEDU(new File(string), string2, bl);
    }

    public int expand(String string, String string2, boolean bl) throws IOException {
        if (this.add == null) {
            throw new IOException("The zip file has not been opened.");
        }
        if (string == null || string.trim().length() == 0 || string.equals("/")) {
            int n = 0;
            Iterator iterator = this.append.iterator();
            while (iterator.hasNext()) {
                n += this.add(this.add.getEntry((String)iterator.next()), string2, true);
                iterator = this.append.iterator();
            }
            return n;
        }
        return this.add(this.add.getEntry(string), string2, bl);
    }

    private int SEDU(File file, String string, boolean bl) throws IOException {
        int n = 0;
        if (!file.exists()) {
            return n;
        }
        String string2 = string = string == null ? "" : string;
        if (file.isDirectory()) {
            this.close.delete(0, this.close.length());
            this.close.append(string).append(file.getName()).append("/");
            String string3 = null;
            if (bl) {
                string3 = this.close.toString();
                this.SEDU.putNextEntry(new ZipEntry(string3));
                this.SEDU.closeEntry();
            }
            File[] fileArray = file.listFiles();
            int n2 = fileArray.length;
            for (int i = 0; i < n2; ++i) {
                n += this.SEDU(fileArray[i], string3, true);
            }
        } else {
            this.close.delete(0, this.close.length());
            this.close.append(string).append(file.getName());
            String string4 = this.close.toString();
            this.SEDU.putNextEntry(new ZipEntry(string4));
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, MODE_READ);
            int n3 = -1;
            while ((n3 = randomAccessFile.read(this.closeEntry)) >= 0) {
                this.SEDU.write(this.closeEntry, 0, n3);
                n += n3;
            }
            this.SEDU.closeEntry();
            randomAccessFile.close();
        }
        return n;
    }

    private int add(ZipEntry zipEntry, String string, boolean bl) throws IOException {
        String string2;
        int n = 0;
        if (zipEntry == null) {
            return n;
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(string2 = file.getAbsolutePath()).endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        String string3 = zipEntry.getName();
        if (zipEntry.isDirectory()) {
            String string4;
            int n2 = (string4 = string3.substring(0, string3.length() - 1)).lastIndexOf("/");
            string4 = string4.substring(n2 == -1 ? 0 : n2 + 1);
            String string5 = string2;
            if (bl) {
                string5 = string5 + string4;
                new File(string5).mkdir();
            }
            this.append.remove(string3);
            Iterator iterator = this.append(string3);
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                n += this.expand(string4, string5, true);
                iterator = this.append(string3);
            }
        } else {
            int n3 = string3.lastIndexOf("/");
            String string6 = string2 + string3.substring(n3 == -1 ? 0 : n3 + 1);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.add.getInputStream(zipEntry));
            FileOutputStream fileOutputStream = new FileOutputStream(string6);
            int n4 = -1;
            while ((n4 = bufferedInputStream.read(this.closeEntry)) >= 0) {
                fileOutputStream.write(this.closeEntry, 0, n4);
                n += n4;
            }
            fileOutputStream.close();
            bufferedInputStream.close();
            this.append.remove(string3);
        }
        return n;
    }

    private Iterator append(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.append) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.iterator();
    }
}

