/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.nls;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import jet.server.log.ServiceLogger;
import jet.server.util.nls.NlsClientResource;

public class NlsDateUtil {
    private Locale SEDU = null;
    private TimeZone append = null;

    public NlsDateUtil() {
        this.SEDU = Locale.getDefault();
        this.append = TimeZone.getDefault();
    }

    public NlsDateUtil(Locale locale) {
        this.SEDU = locale;
    }

    public NlsDateUtil(TimeZone timeZone) {
        this.append = timeZone;
    }

    public NlsDateUtil(Locale locale, TimeZone timeZone) {
        this.SEDU = locale;
        this.append = timeZone;
    }

    public NlsDateUtil(HttpServletRequest httpServletRequest) {
        NlsClientResource nlsClientResource = new NlsClientResource(httpServletRequest);
        this.append = nlsClientResource.getTimeZone();
        this.SEDU = nlsClientResource.getLocale();
    }

    public String getDate() {
        return this.SEDU(true, null);
    }

    public String getDate(Date date) {
        return this.SEDU(true, date);
    }

    public String getDate(long l) {
        Date date = new Date(l);
        return this.SEDU(true, date);
    }

    public String getDateTime() {
        return this.SEDU(false, null);
    }

    public String getDateTime(Date date) {
        return this.SEDU(false, date);
    }

    public String getDateTime(long l) {
        Date date = new Date(l);
        return this.SEDU(false, date);
    }

    private String SEDU(boolean bl, Date date) {
        String string = null;
        if (this.SEDU != null) {
            DateFormat dateFormat = DateFormat.getDateInstance(2, this.SEDU);
            DateFormat dateFormat2 = DateFormat.getDateTimeInstance(2, 2, this.SEDU);
            if (this.append != null) {
                dateFormat.setTimeZone(this.append);
                dateFormat2.setTimeZone(this.append);
            }
            string = bl ? (date == null ? dateFormat.format(new Date()) : dateFormat.format(date)) : (date == null ? dateFormat2.format(new Date()) : dateFormat2.format(date));
        }
        return string;
    }

    public String getDateFormat() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2, this.SEDU);
        if (this.append != null) {
            simpleDateFormat.setTimeZone(this.append);
        }
        String string = simpleDateFormat.toPattern();
        return string;
    }

    public String getDateTimeFormat() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, this.SEDU);
        if (this.append != null) {
            simpleDateFormat.setTimeZone(this.append);
        }
        return simpleDateFormat.toPattern();
    }

    public static final String parseDateToJson(String string, String string2, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
            DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
            dateFormatSymbols.setZoneStrings(new String[0][0]);
            if (!locale.getCountry().equals("JP") && !locale.getVariant().equals("JP")) {
                simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
            }
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            date = simpleDateFormat.parse(string);
        }
        catch (Throwable throwable) {
            ServiceLogger.logDebug(String.format("ParamUtil: parseDateToJson: failed! %s", throwable), 6);
            return null;
        }
        return NlsDateUtil.formatDateToJson(date, string2, locale);
    }

    public static final String formatDateToJson(String string, String string2, Locale locale) {
        Date date = new Date(Long.parseLong(string));
        return NlsDateUtil.formatDateToJson(date, string2, locale);
    }

    public static final String formatDateToJson(Date date, String string, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (string == null || string.trim().length() == 0) {
            string = "MM/dd/yyyy HH:mm:ss";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (date != null) {
            stringBuffer.append("\"formatDate\":\"").append(new SimpleDateFormat(string, locale).format(date).replace("\"", "\\\"")).append("\"");
            stringBuffer.append(", \"year\":\"").append(new SimpleDateFormat("yyyy", locale).format(date)).append("\"");
            stringBuffer.append(", \"month\":\"").append(new SimpleDateFormat("MM", locale).format(date)).append("\"");
            stringBuffer.append(", \"day\":\"").append(new SimpleDateFormat("dd", locale).format(date)).append("\"");
            stringBuffer.append(", \"time\":").append(date.getTime());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

