/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.ui;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.util.ui.AliasNode;
import jet.server.util.ui.AliasTreeXMLWriter;

public class AliasTree
implements Serializable {
    private AliasNodeImpl root = null;
    private Hashtable nodeTable = new Hashtable();
    private String treeId = "";
    private String treeName = "";
    private int level = 0;

    public AliasTree() {
    }

    public AliasTree(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.root = new AliasNodeImpl(string3, string4, string5, string6, string7);
        this.treeId = string;
        this.treeName = string2;
        String string8 = this.root.getAliasPath();
        this.root.setParent("Root");
        if (!this.nodeTable.containsValue(this.root)) {
            this.addNodeToHT(string8, this.root);
        }
    }

    public AliasNode addChild(String string, String string2, String string3, String string4, String string5) {
        AliasNode aliasNode = this.root.addChild(string, string2, string3, string4, string5);
        return aliasNode;
    }

    public AliasNode getRoot() {
        return this.root;
    }

    public void addNodeToHT(String string, AliasNode aliasNode) {
        this.nodeTable.put(string, aliasNode);
    }

    public AliasNode getNode(String string) {
        if (this.nodeTable.containsKey(string)) {
            return (AliasNode)this.nodeTable.get(string);
        }
        return null;
    }

    public AliasNode addChildToParentNode(String string, String string2, String string3, String string4, String string5, String string6) {
        AliasNode aliasNode = this.getNode(string);
        if (aliasNode == null) {
            return null;
        }
        AliasNode aliasNode2 = aliasNode.addChild(string2, string3, string4, string5, string6);
        return aliasNode2;
    }

    public boolean removeNode(String string, String string2) {
        AliasNode aliasNode = this.getNode(string);
        if (aliasNode == null) {
            return false;
        }
        boolean bl = aliasNode.removeChild(string2);
        return bl;
    }

    public boolean rename(String string, String string2) {
        AliasNode aliasNode = this.getNode(string);
        if (aliasNode == null) {
            return false;
        }
        aliasNode.rename(string2);
        return true;
    }

    public boolean toXML(String string) {
        AliasTreeXMLWriter aliasTreeXMLWriter = new AliasTreeXMLWriter(this, string);
        boolean bl = aliasTreeXMLWriter.writeXml();
        return bl;
    }

    public boolean toXML(OutputStream outputStream) {
        AliasTreeXMLWriter aliasTreeXMLWriter = new AliasTreeXMLWriter(this, null);
        return aliasTreeXMLWriter.writeXml(outputStream);
    }

    public String getTreeId() {
        return this.treeId;
    }

    private final class AliasNodeImpl
    implements AliasNode {
        private String SEDU = "";
        private String access$000 = "";
        private String add = "";
        private String contains = "";
        private String containsKey = "";
        private String get = "";
        private int getAliasPath = 0;
        Vector childrenIdList = new Vector();

        public AliasNodeImpl() {
        }

        public AliasNodeImpl(String string, String string2, String string3, String string4, String string5) {
            this.SEDU = string;
            this.access$000 = string2;
            this.contains = string3;
            this.containsKey = string4;
            this.get = string5;
        }

        private boolean SEDU(AliasNode aliasNode) {
            String string = aliasNode.getAliasPath();
            if (!AliasTree.this.nodeTable.containsKey(string) && !this.childrenIdList.contains(string)) {
                aliasNode.setLevel(this.getAliasPath + 1);
                aliasNode.setParent(this.SEDU);
                AliasTree.this.nodeTable.put(string, aliasNode);
                this.childrenIdList.add(string);
                return true;
            }
            return false;
        }

        @Override
        public AliasNode addChild(String string, String string2, String string3, String string4, String string5) {
            AliasNodeImpl aliasNodeImpl = new AliasNodeImpl(string, string2, string3, string4, string5);
            if (this.SEDU(aliasNodeImpl)) {
                return aliasNodeImpl;
            }
            return null;
        }

        @Override
        public AliasNode getChild(String string) {
            if (AliasTree.this.nodeTable.containsKey(string)) {
                return (AliasNode)AliasTree.this.nodeTable.get(string);
            }
            return null;
        }

        @Override
        public Vector getChildren() {
            Vector<AliasNode> vector = new Vector<AliasNode>();
            if (this.childrenIdList.size() > 0) {
                for (int i = 0; i < this.childrenIdList.size(); ++i) {
                    AliasNode aliasNode = (AliasNode)AliasTree.this.nodeTable.get(this.childrenIdList.get(i));
                    vector.add(aliasNode);
                }
                return vector;
            }
            return null;
        }

        @Override
        public String getResType() {
            return this.containsKey;
        }

        @Override
        public String getAliasName() {
            return this.access$000;
        }

        @Override
        public String getAliasParent() {
            return this.add;
        }

        @Override
        public boolean removeChild(String string) {
            if (!AliasTree.this.nodeTable.containsKey(string)) {
                return false;
            }
            Object v = AliasTree.this.nodeTable.get(string);
            AliasTree.this.nodeTable.remove(v);
            if (!this.childrenIdList.contains(string)) {
                return false;
            }
            this.childrenIdList.remove(string);
            return true;
        }

        @Override
        public void rename(String string) {
            this.access$000 = string;
        }

        @Override
        public String getAliasPath() {
            return this.SEDU;
        }

        @Override
        public int getLevel() {
            return this.getAliasPath;
        }

        @Override
        public void setLevel(int n) {
            this.getAliasPath = n;
        }

        @Override
        public void setParent(String string) {
            this.add = string;
        }

        @Override
        public void setHiddenFlag(String string) {
            this.get = string;
        }

        @Override
        public String getHiddenFlag() {
            return this.get;
        }

        @Override
        public String getResPath() {
            return this.contains;
        }

        @Override
        public void setResPath(String string) {
            this.contains = string;
        }
    }
}

