/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.api.http.HttpUtil;
import jet.server.intf.security.Comparator;
import jet.server.jrc.security.Sorter;
import jet.server.log.ServiceLogger;
import jet.server.util.XMLWriter;
import jet.server.util.ui.AliasNode;
import jet.server.util.ui.AliasNodeComparator;
import jet.server.util.ui.AliasTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AliasTreeXMLWriter {
    String outputDir = "";
    AliasTree tree = null;
    private Document SEDU;

    public AliasTreeXMLWriter() {
    }

    public AliasTreeXMLWriter(AliasTree aliasTree, String string) {
        this.tree = aliasTree;
        this.outputDir = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.SEDU = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException);
        }
    }

    public boolean writeXml(OutputStream outputStream) {
        this.SEDU();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            XMLWriter.print(this.SEDU, stringBuffer, 0);
            outputStream.write(stringBuffer.toString().getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean writeXml() {
        this.SEDU();
        try {
            XMLWriter.write(this.SEDU, this.outputDir);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void SEDU() {
        AliasNode aliasNode = this.tree.getRoot();
        String string = aliasNode.getAliasName();
        String string2 = HttpUtil.encodeEsc(aliasNode.getAliasPath());
        String string3 = aliasNode.getResPath();
        String string4 = aliasNode.getResType();
        String string5 = aliasNode.getHiddenFlag();
        String string6 = String.valueOf(aliasNode.getLevel());
        Element element = this.SEDU.createElement("root");
        element.setAttribute("aliasPath", string2);
        element.setAttribute("aliasName", string);
        element.setAttribute("resPath", string3);
        element.setAttribute("resType", string4);
        element.setAttribute("hidden", string5);
        element.setAttribute("level", string6);
        this.SEDU.appendChild(element);
        Vector vector = aliasNode.getChildren();
        if (vector != null) {
            AliasNodeComparator aliasNodeComparator = new AliasNodeComparator();
            Sorter.sort(vector, (Comparator)aliasNodeComparator);
        }
        if (vector != null) {
            for (AliasNode aliasNode2 : vector) {
                this.writeXmlNode(element, aliasNode2);
            }
        }
    }

    public void writeXmlNode(Element element, AliasNode aliasNode) {
        Vector<String> vector = new Vector<String>();
        String string = aliasNode.getAliasName();
        String string2 = HttpUtil.encodeEsc(aliasNode.getAliasPath());
        String string3 = aliasNode.getResPath();
        String string4 = aliasNode.getResType();
        String string5 = aliasNode.getHiddenFlag();
        String string6 = String.valueOf(aliasNode.getLevel());
        vector.add(string2);
        vector.add(string);
        vector.add(string3);
        vector.add(string4);
        vector.add(string5);
        vector.add(string6);
        Element element2 = this.SEDU.createElement("node");
        element2.setAttribute("aliasPath", string2);
        element2.setAttribute("aliasName", string);
        element2.setAttribute("resPath", string3);
        element2.setAttribute("resType", string4);
        element2.setAttribute("hidden", string5);
        element2.setAttribute("level", string6);
        element.appendChild(element2);
        Vector vector2 = aliasNode.getChildren();
        if (vector2 != null) {
            AliasNodeComparator aliasNodeComparator = new AliasNodeComparator();
            Sorter.sort(vector2, (Comparator)aliasNodeComparator);
            for (AliasNode aliasNode2 : vector2) {
                this.writeXmlNode(element2, aliasNode2);
            }
        }
    }
}

