/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.ExporterExt;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.service.Logger;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import jet.JDException;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.JRObjectResult;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptObject;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSectionPageFooter;
import jet.report.JetRptSectionPageHeader;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableDetail;
import jet.reportset.JetRptReport;
import jet.web.dhtml.DHTMLRptSheet;
import jet.web.dhtml.ExportRuntimeInfo;
import jet.web.dhtml.RptToolkit;

public class DHTMLExporter {
    private ExporterExt SEDU;

    public DHTMLExporter() {
    }

    public DHTMLExporter(ExporterExt exporterExt) {
        this.SEDU = exporterExt;
    }

    public byte[] exportReport(Communicator communicator, DSPage dSPage, DHTMLRptSheet dHTMLRptSheet, Map map) throws JDException {
        if (this.SEDU == null) {
            this.SEDU = new ExporterExt(new ExportRuntimeInfo(communicator, dSPage, dHTMLRptSheet, map));
        }
        byte[] byArray = null;
        try {
            byArray = this.SEDU.export();
        }
        catch (WRException wRException) {
            Logger.logE(wRException);
        }
        catch (Exception exception) {
            Logger.logE(new WRException(0xFF0001, (Throwable)exception, new String[0]));
        }
        return byArray;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.SEDU.getRuntimeInfo();
    }

    public void destroy() {
        if (this.SEDU != null) {
            this.SEDU.destroy();
        }
    }

    public void publishCss(DHTMLRptSheet dHTMLRptSheet, Writer writer) throws JDException, IOException {
        RenderBuffer renderBuffer = new RenderBuffer();
        this.SEDU.generateCSS(renderBuffer);
        writer.write(renderBuffer.toString());
    }

    public String getGridImage(int n, Color color) throws JDException {
        return this.getRuntimeInfo().getGridImage(n, color);
    }

    public static JRObjectResult getRealObject(JRObjectResult jRObjectResult) {
        return ExportHelper.getRealObject(jRObjectResult);
    }

    public static int getToDetailOP(JetRptObject jetRptObject, boolean bl) {
        JetRptObject jetRptObject2 = jetRptObject;
        while (!(jetRptObject2 instanceof JetRptReport)) {
            if ((jetRptObject2 = (JetRptObject)jetRptObject2.getParent()) instanceof JetRptDetailPanel || jetRptObject2 instanceof JetRptTableDetail) {
                return 0;
            }
            if (jetRptObject2 instanceof JetRptSectionPageHeader || jetRptObject2 instanceof JetRptSectionPageFooter) {
                return 0;
            }
            if (jetRptObject2 instanceof JetRptCTCrossTab) {
                return 0;
            }
            if (jetRptObject2 instanceof JetRptSectionObject && bl) {
                if (RptToolkit.isHDS(jetRptObject2)) {
                    return 0;
                }
                return 104;
            }
            if (!(jetRptObject2 instanceof JetRptNewTable)) continue;
            return 0;
        }
        return 0;
    }
}

